// device/bluetooth/public/mojom/device.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  UUIDSpec as bluetooth_mojom_UUIDSpec,
  UUID as bluetooth_mojom_UUID
} from './uuid.mojom-webui.js';





export const PropertySpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum Property {

  MIN_VALUE = 0,
  MAX_VALUE = 8192,
  NONE = 0,
  BROADCAST = 1,
  READ = 2,
  WRITE_WITHOUT_RESPONSE = 4,
  WRITE = 8,
  NOTIFY = 16,
  INDICATE = 32,
  AUTHENTICATED_SIGNED_WRITES = 64,
  EXTENDED_PROPERTIES = 128,
  RELIABLE_WRITE = 256,
  WRITABLE_AUXILIARIES = 512,
  READ_ENCRYPTED = 1024,
  WRITE_ENCRYPTED = 2048,
  READ_ENCRYPTED_AUTHENTICATED = 4096,
  WRITE_ENCRYPTED_AUTHENTICATED = 8192,
}

export const GattResultSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum GattResult {

  MIN_VALUE = 0,
  MAX_VALUE = 11,
  SUCCESS = 0,
  UNKNOWN = 1,
  FAILED = 2,
  IN_PROGRESS = 3,
  INVALID_LENGTH = 4,
  NOT_PERMITTED = 5,
  NOT_AUTHORIZED = 6,
  NOT_PAIRED = 7,
  NOT_SUPPORTED = 8,
  SERVICE_NOT_FOUND = 9,
  CHARACTERISTIC_NOT_FOUND = 10,
  DESCRIPTOR_NOT_FOUND = 11,
}



export type DevicePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<DevicePendingReceiver>;

export class DevicePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Device> {

  handle: mojo.internal.interfaceSupport.Endpoint<DevicePendingReceiver>;
  constructor(handle: MojoHandle|DevicePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'bluetooth.mojom.Device',
        scope);
  }
}

export interface DeviceInterface {
  disconnect(): void;
  getInfo(): Promise<{
        info: (DeviceInfo | null), }>;
  getServices(): Promise<{
        services: ServiceInfo[], }>;
  getCharacteristics(serviceId: string): Promise<{
        characteristics: (CharacteristicInfo[] | null), }>;
  readValueForCharacteristic(serviceId: string, characteristicId: string): Promise<{
        result: GattResult,
        value: (number[] | null), }>;
  writeValueForCharacteristic(serviceId: string, characteristicId: string, value: number[]): Promise<{
        result: GattResult, }>;
  getDescriptors(serviceId: string, characteristicId: string): Promise<{
        descriptors: (DescriptorInfo[] | null), }>;
  readValueForDescriptor(serviceId: string, characteristicId: string, descriptorId: string): Promise<{
        result: GattResult,
        value: (number[] | null), }>;
  writeValueForDescriptor(serviceId: string, characteristicId: string, descriptorId: string, value: number[]): Promise<{
        result: GattResult, }>;
}

export class DeviceRemote implements DeviceInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<DevicePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<DevicePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|DevicePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DevicePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  disconnect(): void {
    this.proxy.sendMessage(
        0,
        Device_Disconnect_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  getInfo(): Promise<{
        info: (DeviceInfo | null), }> {
    return this.proxy.sendMessage(
        1,
        Device_GetInfo_ParamsSpec.$,
        Device_GetInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getServices(): Promise<{
        services: ServiceInfo[], }> {
    return this.proxy.sendMessage(
        2,
        Device_GetServices_ParamsSpec.$,
        Device_GetServices_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getCharacteristics(
      serviceId: string): Promise<{
        characteristics: (CharacteristicInfo[] | null), }> {
    return this.proxy.sendMessage(
        3,
        Device_GetCharacteristics_ParamsSpec.$,
        Device_GetCharacteristics_ResponseParamsSpec.$,
        [
          serviceId
        ],
        false);
  }

  readValueForCharacteristic(
      serviceId: string,
      characteristicId: string): Promise<{
        result: GattResult,
        value: (number[] | null), }> {
    return this.proxy.sendMessage(
        4,
        Device_ReadValueForCharacteristic_ParamsSpec.$,
        Device_ReadValueForCharacteristic_ResponseParamsSpec.$,
        [
          serviceId,
          characteristicId
        ],
        false);
  }

  writeValueForCharacteristic(
      serviceId: string,
      characteristicId: string,
      value: number[]): Promise<{
        result: GattResult, }> {
    return this.proxy.sendMessage(
        5,
        Device_WriteValueForCharacteristic_ParamsSpec.$,
        Device_WriteValueForCharacteristic_ResponseParamsSpec.$,
        [
          serviceId,
          characteristicId,
          value
        ],
        false);
  }

  getDescriptors(
      serviceId: string,
      characteristicId: string): Promise<{
        descriptors: (DescriptorInfo[] | null), }> {
    return this.proxy.sendMessage(
        6,
        Device_GetDescriptors_ParamsSpec.$,
        Device_GetDescriptors_ResponseParamsSpec.$,
        [
          serviceId,
          characteristicId
        ],
        false);
  }

  readValueForDescriptor(
      serviceId: string,
      characteristicId: string,
      descriptorId: string): Promise<{
        result: GattResult,
        value: (number[] | null), }> {
    return this.proxy.sendMessage(
        7,
        Device_ReadValueForDescriptor_ParamsSpec.$,
        Device_ReadValueForDescriptor_ResponseParamsSpec.$,
        [
          serviceId,
          characteristicId,
          descriptorId
        ],
        false);
  }

  writeValueForDescriptor(
      serviceId: string,
      characteristicId: string,
      descriptorId: string,
      value: number[]): Promise<{
        result: GattResult, }> {
    return this.proxy.sendMessage(
        8,
        Device_WriteValueForDescriptor_ParamsSpec.$,
        Device_WriteValueForDescriptor_ResponseParamsSpec.$,
        [
          serviceId,
          characteristicId,
          descriptorId,
          value
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Device
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DeviceReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    DeviceRemote, DevicePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    DeviceRemote, DevicePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: DeviceInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DeviceRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Device_Disconnect_ParamsSpec.$,
        null,
        impl.disconnect.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Device_GetInfo_ParamsSpec.$,
        Device_GetInfo_ResponseParamsSpec.$,
        impl.getInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Device_GetServices_ParamsSpec.$,
        Device_GetServices_ResponseParamsSpec.$,
        impl.getServices.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        Device_GetCharacteristics_ParamsSpec.$,
        Device_GetCharacteristics_ResponseParamsSpec.$,
        impl.getCharacteristics.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        Device_ReadValueForCharacteristic_ParamsSpec.$,
        Device_ReadValueForCharacteristic_ResponseParamsSpec.$,
        impl.readValueForCharacteristic.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        Device_WriteValueForCharacteristic_ParamsSpec.$,
        Device_WriteValueForCharacteristic_ResponseParamsSpec.$,
        impl.writeValueForCharacteristic.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        Device_GetDescriptors_ParamsSpec.$,
        Device_GetDescriptors_ResponseParamsSpec.$,
        impl.getDescriptors.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        Device_ReadValueForDescriptor_ParamsSpec.$,
        Device_ReadValueForDescriptor_ResponseParamsSpec.$,
        impl.readValueForDescriptor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        Device_WriteValueForDescriptor_ParamsSpec.$,
        Device_WriteValueForDescriptor_ResponseParamsSpec.$,
        impl.writeValueForDescriptor.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Device {
  static get $interfaceName(): string {
    return "bluetooth.mojom.Device";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): DeviceRemote {
    let remote = new DeviceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Device
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DeviceCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    DeviceRemote, DevicePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    DeviceRemote, DevicePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  disconnect: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getInfo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getServices: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getCharacteristics: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  readValueForCharacteristic: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  writeValueForCharacteristic: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getDescriptors: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  readValueForDescriptor: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  writeValueForDescriptor: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DeviceRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.disconnect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Device_Disconnect_ParamsSpec.$,
        null,
        this.disconnect.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Device_GetInfo_ParamsSpec.$,
        Device_GetInfo_ResponseParamsSpec.$,
        this.getInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getServices =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Device_GetServices_ParamsSpec.$,
        Device_GetServices_ResponseParamsSpec.$,
        this.getServices.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getCharacteristics =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        Device_GetCharacteristics_ParamsSpec.$,
        Device_GetCharacteristics_ResponseParamsSpec.$,
        this.getCharacteristics.createReceiverHandler(true /* expectsResponse */),
        false);
    this.readValueForCharacteristic =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        Device_ReadValueForCharacteristic_ParamsSpec.$,
        Device_ReadValueForCharacteristic_ResponseParamsSpec.$,
        this.readValueForCharacteristic.createReceiverHandler(true /* expectsResponse */),
        false);
    this.writeValueForCharacteristic =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        Device_WriteValueForCharacteristic_ParamsSpec.$,
        Device_WriteValueForCharacteristic_ResponseParamsSpec.$,
        this.writeValueForCharacteristic.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getDescriptors =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        Device_GetDescriptors_ParamsSpec.$,
        Device_GetDescriptors_ResponseParamsSpec.$,
        this.getDescriptors.createReceiverHandler(true /* expectsResponse */),
        false);
    this.readValueForDescriptor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        Device_ReadValueForDescriptor_ParamsSpec.$,
        Device_ReadValueForDescriptor_ResponseParamsSpec.$,
        this.readValueForDescriptor.createReceiverHandler(true /* expectsResponse */),
        false);
    this.writeValueForDescriptor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        Device_WriteValueForDescriptor_ParamsSpec.$,
        Device_WriteValueForDescriptor_ResponseParamsSpec.$,
        this.writeValueForDescriptor.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const RSSIWrapperSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DeviceInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ServiceInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CharacteristicInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DescriptorInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Device_Disconnect_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Device_GetInfo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Device_GetInfo_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Device_GetServices_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Device_GetServices_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Device_GetCharacteristics_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Device_GetCharacteristics_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Device_ReadValueForCharacteristic_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Device_ReadValueForCharacteristic_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Device_WriteValueForCharacteristic_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Device_WriteValueForCharacteristic_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Device_GetDescriptors_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Device_GetDescriptors_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Device_ReadValueForDescriptor_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Device_ReadValueForDescriptor_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Device_WriteValueForDescriptor_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Device_WriteValueForDescriptor_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface RSSIWrapperMojoType {
  value: number;
}


export type RSSIWrapper = RSSIWrapperMojoType;
mojo.internal.Struct<RSSIWrapperMojoType>(
    RSSIWrapperSpec.$,
    'RSSIWrapper',
    [
      mojo.internal.StructField<RSSIWrapperMojoType, number>(
        'value', 0,
        0,
        mojo.internal.Int8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface DeviceInfoMojoType {
  name: (string | null);
  nameForDisplay: string;
  address: string;
  isGattConnected: boolean;
  rssi: (RSSIWrapper | null);
  serviceUuids: bluetooth_mojom_UUID[];
  manufacturerDataMap: {[key: number]: number[]};
  serviceDataMap: Map<bluetooth_mojom_UUID, number[]>;
}


export type DeviceInfo = DeviceInfoMojoType;
mojo.internal.Struct<DeviceInfoMojoType>(
    DeviceInfoSpec.$,
    'DeviceInfo',
    [
      mojo.internal.StructField<DeviceInfoMojoType, string>(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DeviceInfoMojoType, string>(
        'nameForDisplay', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DeviceInfoMojoType, string>(
        'address', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DeviceInfoMojoType, boolean>(
        'isGattConnected', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DeviceInfoMojoType, RSSIWrapper>(
        'rssi', 32,
        0,
        RSSIWrapperSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DeviceInfoMojoType, bluetooth_mojom_UUID[]>(
        'serviceUuids', 40,
        0,
        mojo.internal.Array(bluetooth_mojom_UUIDSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DeviceInfoMojoType, {[key: number]: number[]}>(
        'manufacturerDataMap', 48,
        0,
        mojo.internal.Map(mojo.internal.Uint16, mojo.internal.Array(mojo.internal.Uint8, false), false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DeviceInfoMojoType, Map<bluetooth_mojom_UUID, number[]>>(
        'serviceDataMap', 56,
        0,
        mojo.internal.Map(bluetooth_mojom_UUIDSpec.$, mojo.internal.Array(mojo.internal.Uint8, false), false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 72],]);





export interface ServiceInfoMojoType {
  id: string;
  uuid: bluetooth_mojom_UUID;
  isPrimary: boolean;
}


export type ServiceInfo = ServiceInfoMojoType;
mojo.internal.Struct<ServiceInfoMojoType>(
    ServiceInfoSpec.$,
    'ServiceInfo',
    [
      mojo.internal.StructField<ServiceInfoMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ServiceInfoMojoType, bluetooth_mojom_UUID>(
        'uuid', 8,
        0,
        bluetooth_mojom_UUIDSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ServiceInfoMojoType, boolean>(
        'isPrimary', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface CharacteristicInfoMojoType {
  id: string;
  uuid: bluetooth_mojom_UUID;
  properties: number;
  permissions: number;
  lastKnownValue: number[];
}


export type CharacteristicInfo = CharacteristicInfoMojoType;
mojo.internal.Struct<CharacteristicInfoMojoType>(
    CharacteristicInfoSpec.$,
    'CharacteristicInfo',
    [
      mojo.internal.StructField<CharacteristicInfoMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CharacteristicInfoMojoType, bluetooth_mojom_UUID>(
        'uuid', 8,
        0,
        bluetooth_mojom_UUIDSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CharacteristicInfoMojoType, number>(
        'properties', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CharacteristicInfoMojoType, number>(
        'permissions', 20,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CharacteristicInfoMojoType, number[]>(
        'lastKnownValue', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface DescriptorInfoMojoType {
  id: string;
  uuid: bluetooth_mojom_UUID;
  lastKnownValue: number[];
}


export type DescriptorInfo = DescriptorInfoMojoType;
mojo.internal.Struct<DescriptorInfoMojoType>(
    DescriptorInfoSpec.$,
    'DescriptorInfo',
    [
      mojo.internal.StructField<DescriptorInfoMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DescriptorInfoMojoType, bluetooth_mojom_UUID>(
        'uuid', 8,
        0,
        bluetooth_mojom_UUIDSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DescriptorInfoMojoType, number[]>(
        'lastKnownValue', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface Device_Disconnect_ParamsMojoType {
}


export type Device_Disconnect_Params = Device_Disconnect_ParamsMojoType;
mojo.internal.Struct<Device_Disconnect_ParamsMojoType>(
    Device_Disconnect_ParamsSpec.$,
    'Device_Disconnect_Params',
    [
    ],
    [[0, 8],]);





export interface Device_GetInfo_ParamsMojoType {
}


export type Device_GetInfo_Params = Device_GetInfo_ParamsMojoType;
mojo.internal.Struct<Device_GetInfo_ParamsMojoType>(
    Device_GetInfo_ParamsSpec.$,
    'Device_GetInfo_Params',
    [
    ],
    [[0, 8],]);





export interface Device_GetInfo_ResponseParamsMojoType {
  info: (DeviceInfo | null);
}


export type Device_GetInfo_ResponseParams = Device_GetInfo_ResponseParamsMojoType;
mojo.internal.Struct<Device_GetInfo_ResponseParamsMojoType>(
    Device_GetInfo_ResponseParamsSpec.$,
    'Device_GetInfo_ResponseParams',
    [
      mojo.internal.StructField<Device_GetInfo_ResponseParamsMojoType, DeviceInfo>(
        'info', 0,
        0,
        DeviceInfoSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Device_GetServices_ParamsMojoType {
}


export type Device_GetServices_Params = Device_GetServices_ParamsMojoType;
mojo.internal.Struct<Device_GetServices_ParamsMojoType>(
    Device_GetServices_ParamsSpec.$,
    'Device_GetServices_Params',
    [
    ],
    [[0, 8],]);





export interface Device_GetServices_ResponseParamsMojoType {
  services: ServiceInfo[];
}


export type Device_GetServices_ResponseParams = Device_GetServices_ResponseParamsMojoType;
mojo.internal.Struct<Device_GetServices_ResponseParamsMojoType>(
    Device_GetServices_ResponseParamsSpec.$,
    'Device_GetServices_ResponseParams',
    [
      mojo.internal.StructField<Device_GetServices_ResponseParamsMojoType, ServiceInfo[]>(
        'services', 0,
        0,
        mojo.internal.Array(ServiceInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Device_GetCharacteristics_ParamsMojoType {
  serviceId: string;
}


export type Device_GetCharacteristics_Params = Device_GetCharacteristics_ParamsMojoType;
mojo.internal.Struct<Device_GetCharacteristics_ParamsMojoType>(
    Device_GetCharacteristics_ParamsSpec.$,
    'Device_GetCharacteristics_Params',
    [
      mojo.internal.StructField<Device_GetCharacteristics_ParamsMojoType, string>(
        'serviceId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Device_GetCharacteristics_ResponseParamsMojoType {
  characteristics: (CharacteristicInfo[] | null);
}


export type Device_GetCharacteristics_ResponseParams = Device_GetCharacteristics_ResponseParamsMojoType;
mojo.internal.Struct<Device_GetCharacteristics_ResponseParamsMojoType>(
    Device_GetCharacteristics_ResponseParamsSpec.$,
    'Device_GetCharacteristics_ResponseParams',
    [
      mojo.internal.StructField<Device_GetCharacteristics_ResponseParamsMojoType, CharacteristicInfo[]>(
        'characteristics', 0,
        0,
        mojo.internal.Array(CharacteristicInfoSpec.$, false),
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Device_ReadValueForCharacteristic_ParamsMojoType {
  serviceId: string;
  characteristicId: string;
}


export type Device_ReadValueForCharacteristic_Params = Device_ReadValueForCharacteristic_ParamsMojoType;
mojo.internal.Struct<Device_ReadValueForCharacteristic_ParamsMojoType>(
    Device_ReadValueForCharacteristic_ParamsSpec.$,
    'Device_ReadValueForCharacteristic_Params',
    [
      mojo.internal.StructField<Device_ReadValueForCharacteristic_ParamsMojoType, string>(
        'serviceId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Device_ReadValueForCharacteristic_ParamsMojoType, string>(
        'characteristicId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface Device_ReadValueForCharacteristic_ResponseParamsMojoType {
  result: GattResult;
  value: (number[] | null);
}


export type Device_ReadValueForCharacteristic_ResponseParams = Device_ReadValueForCharacteristic_ResponseParamsMojoType;
mojo.internal.Struct<Device_ReadValueForCharacteristic_ResponseParamsMojoType>(
    Device_ReadValueForCharacteristic_ResponseParamsSpec.$,
    'Device_ReadValueForCharacteristic_ResponseParams',
    [
      mojo.internal.StructField<Device_ReadValueForCharacteristic_ResponseParamsMojoType, GattResult>(
        'result', 0,
        0,
        GattResultSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Device_ReadValueForCharacteristic_ResponseParamsMojoType, number[]>(
        'value', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface Device_WriteValueForCharacteristic_ParamsMojoType {
  serviceId: string;
  characteristicId: string;
  value: number[];
}


export type Device_WriteValueForCharacteristic_Params = Device_WriteValueForCharacteristic_ParamsMojoType;
mojo.internal.Struct<Device_WriteValueForCharacteristic_ParamsMojoType>(
    Device_WriteValueForCharacteristic_ParamsSpec.$,
    'Device_WriteValueForCharacteristic_Params',
    [
      mojo.internal.StructField<Device_WriteValueForCharacteristic_ParamsMojoType, string>(
        'serviceId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Device_WriteValueForCharacteristic_ParamsMojoType, string>(
        'characteristicId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Device_WriteValueForCharacteristic_ParamsMojoType, number[]>(
        'value', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface Device_WriteValueForCharacteristic_ResponseParamsMojoType {
  result: GattResult;
}


export type Device_WriteValueForCharacteristic_ResponseParams = Device_WriteValueForCharacteristic_ResponseParamsMojoType;
mojo.internal.Struct<Device_WriteValueForCharacteristic_ResponseParamsMojoType>(
    Device_WriteValueForCharacteristic_ResponseParamsSpec.$,
    'Device_WriteValueForCharacteristic_ResponseParams',
    [
      mojo.internal.StructField<Device_WriteValueForCharacteristic_ResponseParamsMojoType, GattResult>(
        'result', 0,
        0,
        GattResultSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Device_GetDescriptors_ParamsMojoType {
  serviceId: string;
  characteristicId: string;
}


export type Device_GetDescriptors_Params = Device_GetDescriptors_ParamsMojoType;
mojo.internal.Struct<Device_GetDescriptors_ParamsMojoType>(
    Device_GetDescriptors_ParamsSpec.$,
    'Device_GetDescriptors_Params',
    [
      mojo.internal.StructField<Device_GetDescriptors_ParamsMojoType, string>(
        'serviceId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Device_GetDescriptors_ParamsMojoType, string>(
        'characteristicId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface Device_GetDescriptors_ResponseParamsMojoType {
  descriptors: (DescriptorInfo[] | null);
}


export type Device_GetDescriptors_ResponseParams = Device_GetDescriptors_ResponseParamsMojoType;
mojo.internal.Struct<Device_GetDescriptors_ResponseParamsMojoType>(
    Device_GetDescriptors_ResponseParamsSpec.$,
    'Device_GetDescriptors_ResponseParams',
    [
      mojo.internal.StructField<Device_GetDescriptors_ResponseParamsMojoType, DescriptorInfo[]>(
        'descriptors', 0,
        0,
        mojo.internal.Array(DescriptorInfoSpec.$, false),
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Device_ReadValueForDescriptor_ParamsMojoType {
  serviceId: string;
  characteristicId: string;
  descriptorId: string;
}


export type Device_ReadValueForDescriptor_Params = Device_ReadValueForDescriptor_ParamsMojoType;
mojo.internal.Struct<Device_ReadValueForDescriptor_ParamsMojoType>(
    Device_ReadValueForDescriptor_ParamsSpec.$,
    'Device_ReadValueForDescriptor_Params',
    [
      mojo.internal.StructField<Device_ReadValueForDescriptor_ParamsMojoType, string>(
        'serviceId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Device_ReadValueForDescriptor_ParamsMojoType, string>(
        'characteristicId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Device_ReadValueForDescriptor_ParamsMojoType, string>(
        'descriptorId', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface Device_ReadValueForDescriptor_ResponseParamsMojoType {
  result: GattResult;
  value: (number[] | null);
}


export type Device_ReadValueForDescriptor_ResponseParams = Device_ReadValueForDescriptor_ResponseParamsMojoType;
mojo.internal.Struct<Device_ReadValueForDescriptor_ResponseParamsMojoType>(
    Device_ReadValueForDescriptor_ResponseParamsSpec.$,
    'Device_ReadValueForDescriptor_ResponseParams',
    [
      mojo.internal.StructField<Device_ReadValueForDescriptor_ResponseParamsMojoType, GattResult>(
        'result', 0,
        0,
        GattResultSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Device_ReadValueForDescriptor_ResponseParamsMojoType, number[]>(
        'value', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface Device_WriteValueForDescriptor_ParamsMojoType {
  serviceId: string;
  characteristicId: string;
  descriptorId: string;
  value: number[];
}


export type Device_WriteValueForDescriptor_Params = Device_WriteValueForDescriptor_ParamsMojoType;
mojo.internal.Struct<Device_WriteValueForDescriptor_ParamsMojoType>(
    Device_WriteValueForDescriptor_ParamsSpec.$,
    'Device_WriteValueForDescriptor_Params',
    [
      mojo.internal.StructField<Device_WriteValueForDescriptor_ParamsMojoType, string>(
        'serviceId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Device_WriteValueForDescriptor_ParamsMojoType, string>(
        'characteristicId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Device_WriteValueForDescriptor_ParamsMojoType, string>(
        'descriptorId', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Device_WriteValueForDescriptor_ParamsMojoType, number[]>(
        'value', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface Device_WriteValueForDescriptor_ResponseParamsMojoType {
  result: GattResult;
}


export type Device_WriteValueForDescriptor_ResponseParams = Device_WriteValueForDescriptor_ResponseParamsMojoType;
mojo.internal.Struct<Device_WriteValueForDescriptor_ResponseParamsMojoType>(
    Device_WriteValueForDescriptor_ResponseParamsSpec.$,
    'Device_WriteValueForDescriptor_ResponseParams',
    [
      mojo.internal.StructField<Device_WriteValueForDescriptor_ResponseParamsMojoType, GattResult>(
        'result', 0,
        0,
        GattResultSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



