// content/services/auction_worklet/public/mojom/auction_worklet_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_AUCTION_WORKLET_SERVICE_MOJOM_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_AUCTION_WORKLET_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/services/auction_worklet/public/mojom/auction_worklet_service.mojom-features.h"  // IWYU pragma: export
#include "content/services/auction_worklet/public/mojom/auction_worklet_service.mojom-shared.h"  // IWYU pragma: export
#include "content/services/auction_worklet/public/mojom/auction_worklet_service.mojom-forward.h"  // IWYU pragma: export
#include "content/services/auction_worklet/public/mojom/bidder_worklet.mojom-forward.h"
#include "content/services/auction_worklet/public/mojom/in_progress_auction_download.mojom-forward.h"
#include "content/services/auction_worklet/public/mojom/seller_worklet.mojom-forward.h"
#include "content/services/auction_worklet/public/mojom/auction_network_events_handler.mojom-forward.h"
#include "content/services/auction_worklet/public/mojom/auction_shared_storage_host.mojom-forward.h"
#include "content/services/auction_worklet/public/mojom/trusted_signals_cache.mojom-forward.h"
#include "sandbox/policy/mojom/sandbox.mojom-forward.h"
#include "services/network/public/mojom/url_loader_factory.mojom-forward.h"
#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-forward.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/common/content_export.h"




namespace auction_worklet::mojom {

class LoadSellerWorkletClientProxy;

template <typename ImplRefTraits>
class LoadSellerWorkletClientStub;

class LoadSellerWorkletClientRequestValidator;


class CONTENT_EXPORT LoadSellerWorkletClient
    : public LoadSellerWorkletClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "auction_worklet.mojom.LoadSellerWorkletClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LoadSellerWorkletClientInterfaceBase;
  using Proxy_ = LoadSellerWorkletClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = LoadSellerWorkletClientStub<ImplRefTraits>;

  using RequestValidator_ = LoadSellerWorkletClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSellerWorkletLoadedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SellerWorkletLoaded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LoadSellerWorkletClient() = default;

  virtual void SellerWorkletLoaded(bool trusted_signals_url_allowed) = 0;
};

class AuctionWorkletServiceProxy;

template <typename ImplRefTraits>
class AuctionWorkletServiceStub;

class AuctionWorkletServiceRequestValidator;


class CONTENT_EXPORT AuctionWorkletService
    : public AuctionWorkletServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "auction_worklet.mojom.AuctionWorkletService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kServiceWithJit;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AuctionWorkletServiceInterfaceBase;
  using Proxy_ = AuctionWorkletServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = AuctionWorkletServiceStub<ImplRefTraits>;

  using RequestValidator_ = AuctionWorkletServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetTrustedSignalsCacheMinVersion = 0,
    kLoadBidderWorkletMinVersion = 0,
    kLoadSellerWorkletMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetTrustedSignalsCache_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LoadBidderWorklet_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LoadSellerWorklet_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AuctionWorkletService() = default;

  virtual void SetTrustedSignalsCache(::mojo::PendingRemote<::auction_worklet::mojom::TrustedSignalsCache> trusted_signals_cache) = 0;

  virtual void LoadBidderWorklet(::mojo::PendingReceiver<::auction_worklet::mojom::BidderWorklet> bidder_worklet, std::vector<::mojo::PendingRemote<::auction_worklet::mojom::AuctionSharedStorageHost>> shared_storage_hosts, bool pause_for_debugger_on_start, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> url_loader_factory, ::mojo::PendingRemote<::auction_worklet::mojom::AuctionNetworkEventsHandler> auction_network_events_handler, ::auction_worklet::mojom::InProgressAuctionDownloadPtr script_source_load, ::auction_worklet::mojom::InProgressAuctionDownloadPtr wasm_helper_load, const std::optional<::GURL>& trusted_bidding_signals_url, const std::string& trusted_bidding_signals_slot_size_param, const ::url::Origin& top_window_origin, AuctionWorkletPermissionsPolicyStatePtr permissions_policy_state, std::optional<uint16_t> experiment_group_id, TrustedSignalsPublicKeyPtr public_key) = 0;

  virtual void LoadSellerWorklet(::mojo::PendingReceiver<::auction_worklet::mojom::SellerWorklet> seller_worklet, std::vector<::mojo::PendingRemote<::auction_worklet::mojom::AuctionSharedStorageHost>> shared_storage_hosts, bool pause_for_debugger_on_start, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> url_loader_factory, ::mojo::PendingRemote<::auction_worklet::mojom::AuctionNetworkEventsHandler> auction_network_events_handler, ::auction_worklet::mojom::InProgressAuctionDownloadPtr script_source_load, const std::optional<::GURL>& trusted_scoring_signals_url, const ::url::Origin& top_window_origin, AuctionWorkletPermissionsPolicyStatePtr permissions_policy_state, std::optional<uint16_t> experiment_group_id, std::optional<bool> send_creative_scanning_metadata, TrustedSignalsPublicKeyPtr public_key, ::mojo::PendingRemote<LoadSellerWorkletClient> load_seller_worklet_client) = 0;
};



class CONTENT_EXPORT LoadSellerWorkletClientProxy
    : public LoadSellerWorkletClient {
 public:
  using InterfaceType = LoadSellerWorkletClient;

  explicit LoadSellerWorkletClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SellerWorkletLoaded(bool trusted_signals_url_allowed) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT AuctionWorkletServiceProxy
    : public AuctionWorkletService {
 public:
  using InterfaceType = AuctionWorkletService;

  explicit AuctionWorkletServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetTrustedSignalsCache(::mojo::PendingRemote<::auction_worklet::mojom::TrustedSignalsCache> trusted_signals_cache) final;
  
  void LoadBidderWorklet(::mojo::PendingReceiver<::auction_worklet::mojom::BidderWorklet> bidder_worklet, std::vector<::mojo::PendingRemote<::auction_worklet::mojom::AuctionSharedStorageHost>> shared_storage_hosts, bool pause_for_debugger_on_start, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> url_loader_factory, ::mojo::PendingRemote<::auction_worklet::mojom::AuctionNetworkEventsHandler> auction_network_events_handler, ::auction_worklet::mojom::InProgressAuctionDownloadPtr script_source_load, ::auction_worklet::mojom::InProgressAuctionDownloadPtr wasm_helper_load, const std::optional<::GURL>& trusted_bidding_signals_url, const std::string& trusted_bidding_signals_slot_size_param, const ::url::Origin& top_window_origin, AuctionWorkletPermissionsPolicyStatePtr permissions_policy_state, std::optional<uint16_t> experiment_group_id, TrustedSignalsPublicKeyPtr public_key) final;
  
  void LoadSellerWorklet(::mojo::PendingReceiver<::auction_worklet::mojom::SellerWorklet> seller_worklet, std::vector<::mojo::PendingRemote<::auction_worklet::mojom::AuctionSharedStorageHost>> shared_storage_hosts, bool pause_for_debugger_on_start, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> url_loader_factory, ::mojo::PendingRemote<::auction_worklet::mojom::AuctionNetworkEventsHandler> auction_network_events_handler, ::auction_worklet::mojom::InProgressAuctionDownloadPtr script_source_load, const std::optional<::GURL>& trusted_scoring_signals_url, const ::url::Origin& top_window_origin, AuctionWorkletPermissionsPolicyStatePtr permissions_policy_state, std::optional<uint16_t> experiment_group_id, std::optional<bool> send_creative_scanning_metadata, TrustedSignalsPublicKeyPtr public_key, ::mojo::PendingRemote<LoadSellerWorkletClient> load_seller_worklet_client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT LoadSellerWorkletClientStubDispatch {
 public:
  static bool Accept(LoadSellerWorkletClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LoadSellerWorkletClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LoadSellerWorkletClient>>
class LoadSellerWorkletClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LoadSellerWorkletClientStub() = default;
  ~LoadSellerWorkletClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LoadSellerWorkletClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LoadSellerWorkletClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT AuctionWorkletServiceStubDispatch {
 public:
  static bool Accept(AuctionWorkletService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AuctionWorkletService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AuctionWorkletService>>
class AuctionWorkletServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AuctionWorkletServiceStub() = default;
  ~AuctionWorkletServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AuctionWorkletServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AuctionWorkletServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT LoadSellerWorkletClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT AuctionWorkletServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class CONTENT_EXPORT AuctionWorkletPermissionsPolicyState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AuctionWorkletPermissionsPolicyState, T>::value>;
  using DataView = AuctionWorkletPermissionsPolicyStateDataView;
  using Data_ = internal::AuctionWorkletPermissionsPolicyState_Data;

  template <typename... Args>
  static AuctionWorkletPermissionsPolicyStatePtr New(Args&&... args) {
    return AuctionWorkletPermissionsPolicyStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AuctionWorkletPermissionsPolicyStatePtr From(const U& u) {
    return mojo::TypeConverter<AuctionWorkletPermissionsPolicyStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AuctionWorkletPermissionsPolicyState>::Convert(*this);
  }


  AuctionWorkletPermissionsPolicyState();

  AuctionWorkletPermissionsPolicyState(
      bool private_aggregation_allowed,
      bool shared_storage_allowed);


  ~AuctionWorkletPermissionsPolicyState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AuctionWorkletPermissionsPolicyStatePtr>
  AuctionWorkletPermissionsPolicyStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AuctionWorkletPermissionsPolicyState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AuctionWorkletPermissionsPolicyState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AuctionWorkletPermissionsPolicyState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AuctionWorkletPermissionsPolicyState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AuctionWorkletPermissionsPolicyState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AuctionWorkletPermissionsPolicyState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AuctionWorkletPermissionsPolicyState_UnserializedMessageContext<
            UserType, AuctionWorkletPermissionsPolicyState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AuctionWorkletPermissionsPolicyState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AuctionWorkletPermissionsPolicyState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AuctionWorkletPermissionsPolicyState_UnserializedMessageContext<
            UserType, AuctionWorkletPermissionsPolicyState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AuctionWorkletPermissionsPolicyState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool private_aggregation_allowed;
  
  bool shared_storage_allowed;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AuctionWorkletPermissionsPolicyState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AuctionWorkletPermissionsPolicyState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AuctionWorkletPermissionsPolicyState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AuctionWorkletPermissionsPolicyState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT TrustedSignalsPublicKey {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TrustedSignalsPublicKey, T>::value>;
  using DataView = TrustedSignalsPublicKeyDataView;
  using Data_ = internal::TrustedSignalsPublicKey_Data;

  template <typename... Args>
  static TrustedSignalsPublicKeyPtr New(Args&&... args) {
    return TrustedSignalsPublicKeyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TrustedSignalsPublicKeyPtr From(const U& u) {
    return mojo::TypeConverter<TrustedSignalsPublicKeyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TrustedSignalsPublicKey>::Convert(*this);
  }


  TrustedSignalsPublicKey();

  TrustedSignalsPublicKey(
      const std::string& key,
      uint8_t id);


  ~TrustedSignalsPublicKey();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TrustedSignalsPublicKeyPtr>
  TrustedSignalsPublicKeyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TrustedSignalsPublicKey::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TrustedSignalsPublicKey::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TrustedSignalsPublicKey::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrustedSignalsPublicKey::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrustedSignalsPublicKey::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TrustedSignalsPublicKey::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TrustedSignalsPublicKey_UnserializedMessageContext<
            UserType, TrustedSignalsPublicKey::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TrustedSignalsPublicKey::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TrustedSignalsPublicKey::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TrustedSignalsPublicKey_UnserializedMessageContext<
            UserType, TrustedSignalsPublicKey::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TrustedSignalsPublicKey::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string key;
  
  uint8_t id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TrustedSignalsPublicKey::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TrustedSignalsPublicKey::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TrustedSignalsPublicKey::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TrustedSignalsPublicKey::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class CONTENT_EXPORT BrowserSignals {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BrowserSignals, T>::value>;
  using DataView = BrowserSignalsDataView;
  using Data_ = internal::BrowserSignals_Data;

  template <typename... Args>
  static BrowserSignalsPtr New(Args&&... args) {
    return BrowserSignalsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BrowserSignalsPtr From(const U& u) {
    return mojo::TypeConverter<BrowserSignalsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BrowserSignals>::Convert(*this);
  }


  BrowserSignals();

  BrowserSignals(
      const ::url::Origin& top_frame_origin,
      const ::url::Origin& seller);


  ~BrowserSignals();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BrowserSignalsPtr>
  BrowserSignalsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BrowserSignals::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BrowserSignals::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BrowserSignals::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BrowserSignals::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BrowserSignals::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BrowserSignals::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BrowserSignals_UnserializedMessageContext<
            UserType, BrowserSignals::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BrowserSignals::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BrowserSignals::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BrowserSignals_UnserializedMessageContext<
            UserType, BrowserSignals::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BrowserSignals::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::url::Origin top_frame_origin;
  
  ::url::Origin seller;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BrowserSignals::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BrowserSignals::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BrowserSignals::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BrowserSignals::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}



template <typename StructPtrType>
BrowserSignalsPtr BrowserSignals::Clone() const {
  return New(
      mojo::Clone(top_frame_origin),
      mojo::Clone(seller)
  );
}

template <typename T, BrowserSignals::EnableIfSame<T>*>
bool BrowserSignals::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->top_frame_origin, other_struct.top_frame_origin))
    return false;
  if (!mojo::Equals(this->seller, other_struct.seller))
    return false;
  return true;
}

template <typename T, BrowserSignals::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.top_frame_origin < rhs.top_frame_origin)
    return true;
  if (rhs.top_frame_origin < lhs.top_frame_origin)
    return false;
  if (lhs.seller < rhs.seller)
    return true;
  if (rhs.seller < lhs.seller)
    return false;
  return false;
}
template <typename StructPtrType>
AuctionWorkletPermissionsPolicyStatePtr AuctionWorkletPermissionsPolicyState::Clone() const {
  return New(
      mojo::Clone(private_aggregation_allowed),
      mojo::Clone(shared_storage_allowed)
  );
}

template <typename T, AuctionWorkletPermissionsPolicyState::EnableIfSame<T>*>
bool AuctionWorkletPermissionsPolicyState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->private_aggregation_allowed, other_struct.private_aggregation_allowed))
    return false;
  if (!mojo::Equals(this->shared_storage_allowed, other_struct.shared_storage_allowed))
    return false;
  return true;
}

template <typename T, AuctionWorkletPermissionsPolicyState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.private_aggregation_allowed < rhs.private_aggregation_allowed)
    return true;
  if (rhs.private_aggregation_allowed < lhs.private_aggregation_allowed)
    return false;
  if (lhs.shared_storage_allowed < rhs.shared_storage_allowed)
    return true;
  if (rhs.shared_storage_allowed < lhs.shared_storage_allowed)
    return false;
  return false;
}
template <typename StructPtrType>
TrustedSignalsPublicKeyPtr TrustedSignalsPublicKey::Clone() const {
  return New(
      mojo::Clone(key),
      mojo::Clone(id)
  );
}

template <typename T, TrustedSignalsPublicKey::EnableIfSame<T>*>
bool TrustedSignalsPublicKey::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->key, other_struct.key))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  return true;
}

template <typename T, TrustedSignalsPublicKey::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.key < rhs.key)
    return true;
  if (rhs.key < lhs.key)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  return false;
}


}  // auction_worklet::mojom

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::auction_worklet::mojom::BrowserSignals::DataView,
                                         ::auction_worklet::mojom::BrowserSignalsPtr> {
  static bool IsNull(const ::auction_worklet::mojom::BrowserSignalsPtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::BrowserSignalsPtr* output) { output->reset(); }

  static const decltype(::auction_worklet::mojom::BrowserSignals::top_frame_origin)& top_frame_origin(
      const ::auction_worklet::mojom::BrowserSignalsPtr& input) {
    return input->top_frame_origin;
  }

  static const decltype(::auction_worklet::mojom::BrowserSignals::seller)& seller(
      const ::auction_worklet::mojom::BrowserSignalsPtr& input) {
    return input->seller;
  }

  static bool Read(::auction_worklet::mojom::BrowserSignals::DataView input, ::auction_worklet::mojom::BrowserSignalsPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::auction_worklet::mojom::AuctionWorkletPermissionsPolicyState::DataView,
                                         ::auction_worklet::mojom::AuctionWorkletPermissionsPolicyStatePtr> {
  static bool IsNull(const ::auction_worklet::mojom::AuctionWorkletPermissionsPolicyStatePtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::AuctionWorkletPermissionsPolicyStatePtr* output) { output->reset(); }

  static decltype(::auction_worklet::mojom::AuctionWorkletPermissionsPolicyState::private_aggregation_allowed) private_aggregation_allowed(
      const ::auction_worklet::mojom::AuctionWorkletPermissionsPolicyStatePtr& input) {
    return input->private_aggregation_allowed;
  }

  static decltype(::auction_worklet::mojom::AuctionWorkletPermissionsPolicyState::shared_storage_allowed) shared_storage_allowed(
      const ::auction_worklet::mojom::AuctionWorkletPermissionsPolicyStatePtr& input) {
    return input->shared_storage_allowed;
  }

  static bool Read(::auction_worklet::mojom::AuctionWorkletPermissionsPolicyState::DataView input, ::auction_worklet::mojom::AuctionWorkletPermissionsPolicyStatePtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::auction_worklet::mojom::TrustedSignalsPublicKey::DataView,
                                         ::auction_worklet::mojom::TrustedSignalsPublicKeyPtr> {
  static bool IsNull(const ::auction_worklet::mojom::TrustedSignalsPublicKeyPtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::TrustedSignalsPublicKeyPtr* output) { output->reset(); }

  static const decltype(::auction_worklet::mojom::TrustedSignalsPublicKey::key)& key(
      const ::auction_worklet::mojom::TrustedSignalsPublicKeyPtr& input) {
    return input->key;
  }

  static decltype(::auction_worklet::mojom::TrustedSignalsPublicKey::id) id(
      const ::auction_worklet::mojom::TrustedSignalsPublicKeyPtr& input) {
    return input->id;
  }

  static bool Read(::auction_worklet::mojom::TrustedSignalsPublicKey::DataView input, ::auction_worklet::mojom::TrustedSignalsPublicKeyPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_AUCTION_WORKLET_SERVICE_MOJOM_H_