// content/services/auction_worklet/public/mojom/auction_worklet_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/services/auction_worklet/public/mojom/auction_worklet_service.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/services/auction_worklet/public/mojom/auction_worklet_service.mojom-params-data.h"
namespace auction_worklet {
namespace mojom {

namespace internal {


// static
bool BrowserSignals_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BrowserSignals_Data* object =
      static_cast<const BrowserSignals_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->top_frame_origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->top_frame_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->seller, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->seller, validation_context))
    return false;

  return true;
}

BrowserSignals_Data::BrowserSignals_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuctionWorkletPermissionsPolicyState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AuctionWorkletPermissionsPolicyState_Data* object =
      static_cast<const AuctionWorkletPermissionsPolicyState_Data*>(data);

  return true;
}

AuctionWorkletPermissionsPolicyState_Data::AuctionWorkletPermissionsPolicyState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TrustedSignalsPublicKey_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TrustedSignalsPublicKey_Data* object =
      static_cast<const TrustedSignalsPublicKey_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->key, validation_context,
                                         &key_validate_params)) {
    return false;
  }

  return true;
}

TrustedSignalsPublicKey_Data::TrustedSignalsPublicKey_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LoadSellerWorkletClient_SellerWorkletLoaded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LoadSellerWorkletClient_SellerWorkletLoaded_Params_Data* object =
      static_cast<const LoadSellerWorkletClient_SellerWorkletLoaded_Params_Data*>(data);

  return true;
}

LoadSellerWorkletClient_SellerWorkletLoaded_Params_Data::LoadSellerWorkletClient_SellerWorkletLoaded_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuctionWorkletService_SetTrustedSignalsCache_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AuctionWorkletService_SetTrustedSignalsCache_Params_Data* object =
      static_cast<const AuctionWorkletService_SetTrustedSignalsCache_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->trusted_signals_cache, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->trusted_signals_cache,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AuctionWorkletService_SetTrustedSignalsCache_Params_Data::AuctionWorkletService_SetTrustedSignalsCache_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuctionWorkletService_LoadBidderWorklet_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 96, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AuctionWorkletService_LoadBidderWorklet_Params_Data* object =
      static_cast<const AuctionWorkletService_LoadBidderWorklet_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->bidder_worklet, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->bidder_worklet,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->shared_storage_hosts, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& shared_storage_hosts_validate_params =
      mojo::internal::GetArrayValidator<0, true, nullptr>();
  if (!mojo::internal::ValidateContainer(object->shared_storage_hosts, validation_context,
                                         &shared_storage_hosts_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->url_loader_factory, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->url_loader_factory,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->auction_network_events_handler, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->auction_network_events_handler,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->script_source_load, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->script_source_load, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->wasm_helper_load, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->trusted_bidding_signals_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->trusted_bidding_signals_slot_size_param, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& trusted_bidding_signals_slot_size_param_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->trusted_bidding_signals_slot_size_param, validation_context,
                                         &trusted_bidding_signals_slot_size_param_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->top_window_origin, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->top_window_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->permissions_policy_state, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->permissions_policy_state, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->public_key, validation_context))
    return false;

  return true;
}

AuctionWorkletService_LoadBidderWorklet_Params_Data::AuctionWorkletService_LoadBidderWorklet_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuctionWorkletService_LoadSellerWorklet_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 88, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AuctionWorkletService_LoadSellerWorklet_Params_Data* object =
      static_cast<const AuctionWorkletService_LoadSellerWorklet_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->seller_worklet, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->seller_worklet,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->shared_storage_hosts, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& shared_storage_hosts_validate_params =
      mojo::internal::GetArrayValidator<0, true, nullptr>();
  if (!mojo::internal::ValidateContainer(object->shared_storage_hosts, validation_context,
                                         &shared_storage_hosts_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->url_loader_factory, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->url_loader_factory,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->auction_network_events_handler, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->auction_network_events_handler,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->script_source_load, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->script_source_load, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->trusted_scoring_signals_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->top_window_origin, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->top_window_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->permissions_policy_state, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->permissions_policy_state, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->public_key, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->load_seller_worklet_client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AuctionWorkletService_LoadSellerWorklet_Params_Data::AuctionWorkletService_LoadSellerWorklet_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace auction_worklet