// content/services/auction_worklet/public/mojom/auction_network_events_handler.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/services/auction_worklet/public/mojom/auction_network_events_handler.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/services/auction_worklet/public/mojom/auction_network_events_handler.mojom-params-data.h"
#include "content/services/auction_worklet/public/mojom/auction_network_events_handler.mojom-shared-message-ids.h"

#include "content/services/auction_worklet/public/mojom/auction_network_events_handler.mojom-import-headers.h"
#include "content/services/auction_worklet/public/mojom/auction_network_events_handler.mojom-test-utils.h"
#include "net/cert/cert_verify_result.h"
#include "services/network/public/mojom/cookie_access_observer.mojom.h"
#include "services/network/public/mojom/device_bound_sessions.mojom.h"
#include "services/network/public/mojom/devtools_observer.mojom.h"
#include "services/network/public/mojom/trust_token_access_observer.mojom.h"


namespace auction_worklet::mojom {
// The declaration includes the definition on other builds.

AuctionNetworkEventsHandler::IPCStableHashFunction AuctionNetworkEventsHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AuctionNetworkEventsHandler>(message.name())) {
    case messages::AuctionNetworkEventsHandler::kOnNetworkSendRequest: {
      return &AuctionNetworkEventsHandler::OnNetworkSendRequest_Sym::IPCStableHash;
    }
    case messages::AuctionNetworkEventsHandler::kOnNetworkResponseReceived: {
      return &AuctionNetworkEventsHandler::OnNetworkResponseReceived_Sym::IPCStableHash;
    }
    case messages::AuctionNetworkEventsHandler::kOnNetworkRequestComplete: {
      return &AuctionNetworkEventsHandler::OnNetworkRequestComplete_Sym::IPCStableHash;
    }
    case messages::AuctionNetworkEventsHandler::kClone: {
      return &AuctionNetworkEventsHandler::Clone_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AuctionNetworkEventsHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AuctionNetworkEventsHandler>(message.name())) {
      case messages::AuctionNetworkEventsHandler::kOnNetworkSendRequest:
            return "Receive auction_worklet::mojom::AuctionNetworkEventsHandler::OnNetworkSendRequest";
      case messages::AuctionNetworkEventsHandler::kOnNetworkResponseReceived:
            return "Receive auction_worklet::mojom::AuctionNetworkEventsHandler::OnNetworkResponseReceived";
      case messages::AuctionNetworkEventsHandler::kOnNetworkRequestComplete:
            return "Receive auction_worklet::mojom::AuctionNetworkEventsHandler::OnNetworkRequestComplete";
      case messages::AuctionNetworkEventsHandler::kClone:
            return "Receive auction_worklet::mojom::AuctionNetworkEventsHandler::Clone";
    }
  } else {
    switch (static_cast<messages::AuctionNetworkEventsHandler>(message.name())) {
      case messages::AuctionNetworkEventsHandler::kOnNetworkSendRequest:
            return "Receive reply auction_worklet::mojom::AuctionNetworkEventsHandler::OnNetworkSendRequest";
      case messages::AuctionNetworkEventsHandler::kOnNetworkResponseReceived:
            return "Receive reply auction_worklet::mojom::AuctionNetworkEventsHandler::OnNetworkResponseReceived";
      case messages::AuctionNetworkEventsHandler::kOnNetworkRequestComplete:
            return "Receive reply auction_worklet::mojom::AuctionNetworkEventsHandler::OnNetworkRequestComplete";
      case messages::AuctionNetworkEventsHandler::kClone:
            return "Receive reply auction_worklet::mojom::AuctionNetworkEventsHandler::Clone";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AuctionNetworkEventsHandler::OnNetworkSendRequest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x44b44d1e;  // IPCStableHash for auction_worklet::mojom::AuctionNetworkEventsHandler::OnNetworkSendRequest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AuctionNetworkEventsHandler::OnNetworkResponseReceived_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5c3896a3;  // IPCStableHash for auction_worklet::mojom::AuctionNetworkEventsHandler::OnNetworkResponseReceived
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AuctionNetworkEventsHandler::OnNetworkRequestComplete_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2277190b;  // IPCStableHash for auction_worklet::mojom::AuctionNetworkEventsHandler::OnNetworkRequestComplete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AuctionNetworkEventsHandler::Clone_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x50e3345f;  // IPCStableHash for auction_worklet::mojom::AuctionNetworkEventsHandler::Clone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AuctionNetworkEventsHandlerProxy::AuctionNetworkEventsHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AuctionNetworkEventsHandlerProxy::OnNetworkSendRequest(
    const ::network::ResourceRequest& in_request, ::base::TimeTicks in_timestamp) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send auction_worklet::mojom::AuctionNetworkEventsHandler::OnNetworkSendRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type const ::network::ResourceRequest&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timestamp"), in_timestamp,
                        "<value of type ::base::TimeTicks>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AuctionNetworkEventsHandler::kOnNetworkSendRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::AuctionNetworkEventsHandler_OnNetworkSendRequest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::URLRequestDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request in AuctionNetworkEventsHandler.OnNetworkSendRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->timestamp)::BaseType> timestamp_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
    in_timestamp,
    timestamp_fragment);

  params->timestamp.Set(
      timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->timestamp.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null timestamp in AuctionNetworkEventsHandler.OnNetworkSendRequest request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AuctionNetworkEventsHandler::Name_);
  message.set_method_name("OnNetworkSendRequest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AuctionNetworkEventsHandlerProxy::OnNetworkResponseReceived(
    const std::string& in_request_id, const std::string& in_loader_id, const ::GURL& in_request_url, ::network::mojom::URLResponseHeadPtr in_headers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send auction_worklet::mojom::AuctionNetworkEventsHandler::OnNetworkResponseReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("loader_id"), in_loader_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_url"), in_request_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("headers"), in_headers,
                        "<value of type ::network::mojom::URLResponseHeadPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AuctionNetworkEventsHandler::kOnNetworkResponseReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::AuctionNetworkEventsHandler_OnNetworkResponseReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request_id)::BaseType> request_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_request_id,
    request_id_fragment);

  params->request_id.Set(
      request_id_fragment.is_null() ? nullptr : request_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request_id in AuctionNetworkEventsHandler.OnNetworkResponseReceived request");
  mojo::internal::MessageFragment<
      typename decltype(params->loader_id)::BaseType> loader_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_loader_id,
    loader_id_fragment);

  params->loader_id.Set(
      loader_id_fragment.is_null() ? nullptr : loader_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->loader_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null loader_id in AuctionNetworkEventsHandler.OnNetworkResponseReceived request");
  mojo::internal::MessageFragment<
      typename decltype(params->request_url)::BaseType> request_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_request_url,
    request_url_fragment);

  params->request_url.Set(
      request_url_fragment.is_null() ? nullptr : request_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request_url in AuctionNetworkEventsHandler.OnNetworkResponseReceived request");
  mojo::internal::MessageFragment<
      typename decltype(params->headers)::BaseType> headers_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView>(
    in_headers,
    headers_fragment);

  params->headers.Set(
      headers_fragment.is_null() ? nullptr : headers_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->headers.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null headers in AuctionNetworkEventsHandler.OnNetworkResponseReceived request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AuctionNetworkEventsHandler::Name_);
  message.set_method_name("OnNetworkResponseReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AuctionNetworkEventsHandlerProxy::OnNetworkRequestComplete(
    const std::string& in_request_id, const ::network::URLLoaderCompletionStatus& in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send auction_worklet::mojom::AuctionNetworkEventsHandler::OnNetworkRequestComplete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type const ::network::URLLoaderCompletionStatus&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AuctionNetworkEventsHandler::kOnNetworkRequestComplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::AuctionNetworkEventsHandler_OnNetworkRequestComplete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request_id)::BaseType> request_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_request_id,
    request_id_fragment);

  params->request_id.Set(
      request_id_fragment.is_null() ? nullptr : request_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request_id in AuctionNetworkEventsHandler.OnNetworkRequestComplete request");
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::URLLoaderCompletionStatusDataView>(
    in_status,
    status_fragment);

  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->status.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null status in AuctionNetworkEventsHandler.OnNetworkRequestComplete request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AuctionNetworkEventsHandler::Name_);
  message.set_method_name("OnNetworkRequestComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AuctionNetworkEventsHandlerProxy::Clone(
    ::mojo::PendingReceiver<AuctionNetworkEventsHandler> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send auction_worklet::mojom::AuctionNetworkEventsHandler::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<AuctionNetworkEventsHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AuctionNetworkEventsHandler::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::auction_worklet::mojom::internal::AuctionNetworkEventsHandler_Clone_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::auction_worklet::mojom::AuctionNetworkEventsHandlerInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in AuctionNetworkEventsHandler.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AuctionNetworkEventsHandler::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AuctionNetworkEventsHandlerStubDispatch::Accept(
    AuctionNetworkEventsHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AuctionNetworkEventsHandler>(message->header()->name)) {
    case messages::AuctionNetworkEventsHandler::kOnNetworkSendRequest: {
      DCHECK(message->is_serialized());
      internal::AuctionNetworkEventsHandler_OnNetworkSendRequest_Params_Data* params =
          reinterpret_cast<internal::AuctionNetworkEventsHandler_OnNetworkSendRequest_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AuctionNetworkEventsHandler.0
      bool success = true;
      ::network::ResourceRequest p_request{};
      ::base::TimeTicks p_timestamp{};
      AuctionNetworkEventsHandler_OnNetworkSendRequest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (success && !input_data_view.ReadTimestamp(&p_timestamp))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AuctionNetworkEventsHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNetworkSendRequest(        
        p_request, 
        std::move(p_timestamp));
      return true;
    }
    case messages::AuctionNetworkEventsHandler::kOnNetworkResponseReceived: {
      DCHECK(message->is_serialized());
      internal::AuctionNetworkEventsHandler_OnNetworkResponseReceived_Params_Data* params =
          reinterpret_cast<internal::AuctionNetworkEventsHandler_OnNetworkResponseReceived_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AuctionNetworkEventsHandler.1
      bool success = true;
      std::string p_request_id{};
      std::string p_loader_id{};
      ::GURL p_request_url{};
      ::network::mojom::URLResponseHeadPtr p_headers{};
      AuctionNetworkEventsHandler_OnNetworkResponseReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequestId(&p_request_id))
        success = false;
      if (success && !input_data_view.ReadLoaderId(&p_loader_id))
        success = false;
      if (success && !input_data_view.ReadRequestUrl(&p_request_url))
        success = false;
      if (success && !input_data_view.ReadHeaders(&p_headers))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AuctionNetworkEventsHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNetworkResponseReceived(        
        std::move(p_request_id), 
        std::move(p_loader_id), 
        std::move(p_request_url), 
        std::move(p_headers));
      return true;
    }
    case messages::AuctionNetworkEventsHandler::kOnNetworkRequestComplete: {
      DCHECK(message->is_serialized());
      internal::AuctionNetworkEventsHandler_OnNetworkRequestComplete_Params_Data* params =
          reinterpret_cast<internal::AuctionNetworkEventsHandler_OnNetworkRequestComplete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AuctionNetworkEventsHandler.2
      bool success = true;
      std::string p_request_id{};
      ::network::URLLoaderCompletionStatus p_status{};
      AuctionNetworkEventsHandler_OnNetworkRequestComplete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequestId(&p_request_id))
        success = false;
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AuctionNetworkEventsHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNetworkRequestComplete(        
        std::move(p_request_id), 
        std::move(p_status));
      return true;
    }
    case messages::AuctionNetworkEventsHandler::kClone: {
      DCHECK(message->is_serialized());
      internal::AuctionNetworkEventsHandler_Clone_Params_Data* params =
          reinterpret_cast<internal::AuctionNetworkEventsHandler_Clone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AuctionNetworkEventsHandler.3
      bool success = true;
      ::mojo::PendingReceiver<AuctionNetworkEventsHandler> p_receiver{};
      AuctionNetworkEventsHandler_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AuctionNetworkEventsHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool AuctionNetworkEventsHandlerStubDispatch::AcceptWithResponder(
    AuctionNetworkEventsHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AuctionNetworkEventsHandler>(message->header()->name)) {
    case messages::AuctionNetworkEventsHandler::kOnNetworkSendRequest: {
      break;
    }
    case messages::AuctionNetworkEventsHandler::kOnNetworkResponseReceived: {
      break;
    }
    case messages::AuctionNetworkEventsHandler::kOnNetworkRequestComplete: {
      break;
    }
    case messages::AuctionNetworkEventsHandler::kClone: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAuctionNetworkEventsHandlerValidationInfo[] = {
    { &internal::AuctionNetworkEventsHandler_OnNetworkSendRequest_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AuctionNetworkEventsHandler_OnNetworkResponseReceived_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AuctionNetworkEventsHandler_OnNetworkRequestComplete_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AuctionNetworkEventsHandler_Clone_Params_Data::Validate,
     nullptr /* no response */},
};

bool AuctionNetworkEventsHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::auction_worklet::mojom::AuctionNetworkEventsHandler::Name_,
    kAuctionNetworkEventsHandlerValidationInfo);
}



}  // auction_worklet::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace auction_worklet::mojom {


void AuctionNetworkEventsHandlerInterceptorForTesting::OnNetworkSendRequest(const ::network::ResourceRequest& request, ::base::TimeTicks timestamp) {
  GetForwardingInterface()->OnNetworkSendRequest(
    request, 
    std::move(timestamp)
    );
}
void AuctionNetworkEventsHandlerInterceptorForTesting::OnNetworkResponseReceived(const std::string& request_id, const std::string& loader_id, const ::GURL& request_url, ::network::mojom::URLResponseHeadPtr headers) {
  GetForwardingInterface()->OnNetworkResponseReceived(
    std::move(request_id)
    , 
    std::move(loader_id)
    , 
    std::move(request_url)
    , 
    std::move(headers)
    );
}
void AuctionNetworkEventsHandlerInterceptorForTesting::OnNetworkRequestComplete(const std::string& request_id, const ::network::URLLoaderCompletionStatus& status) {
  GetForwardingInterface()->OnNetworkRequestComplete(
    std::move(request_id)
    , 
    std::move(status)
    );
}
void AuctionNetworkEventsHandlerInterceptorForTesting::Clone(::mojo::PendingReceiver<AuctionNetworkEventsHandler> receiver) {
  GetForwardingInterface()->Clone(
    std::move(receiver)
    );
}
AuctionNetworkEventsHandlerAsyncWaiter::AuctionNetworkEventsHandlerAsyncWaiter(
    AuctionNetworkEventsHandler* proxy) : proxy_(proxy) {}

AuctionNetworkEventsHandlerAsyncWaiter::~AuctionNetworkEventsHandlerAsyncWaiter() = default;







}  // auction_worklet::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif