// content/public/common/resource_usage_reporter.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('content.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
content.mojom.ResourceUsageReporterPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        content.mojom.ResourceUsageReporter.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { content.mojom.ResourceUsageReporterInterface }
 */
content.mojom.ResourceUsageReporterRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!content.mojom.ResourceUsageReporterPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          content.mojom.ResourceUsageReporterPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!content.mojom.ResourceUsageReporterPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        data: !content.mojom.ResourceUsageData,
   *  }>}
   */

  getUsageData() {
    return this.proxy.sendMessage(
        0,
        content.mojom.ResourceUsageReporter_GetUsageData_ParamsSpec.$,
        content.mojom.ResourceUsageReporter_GetUsageData_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ResourceUsageReporter
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
content.mojom.ResourceUsageReporterReceiver = class {
  /**
   * @param {!content.mojom.ResourceUsageReporterInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!content.mojom.ResourceUsageReporterRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        content.mojom.ResourceUsageReporterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!content.mojom.ResourceUsageReporterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        content.mojom.ResourceUsageReporter_GetUsageData_ParamsSpec.$,
        content.mojom.ResourceUsageReporter_GetUsageData_ResponseParamsSpec.$,
        impl.getUsageData.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
content.mojom.ResourceUsageReporter = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "content.mojom.ResourceUsageReporter";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!content.mojom.ResourceUsageReporterRemote}
   * @export
   */
  static getRemote() {
    let remote = new content.mojom.ResourceUsageReporterRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ResourceUsageReporter
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
content.mojom.ResourceUsageReporterCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      content.mojom.ResourceUsageReporterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!content.mojom.ResourceUsageReporterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getUsageData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        content.mojom.ResourceUsageReporter_GetUsageData_ParamsSpec.$,
        content.mojom.ResourceUsageReporter_GetUsageData_ResponseParamsSpec.$,
        this.getUsageData.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.ResourceTypeStatSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.ResourceTypeStatsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.ResourceUsageDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.ResourceUsageReporter_GetUsageData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
content.mojom.ResourceUsageReporter_GetUsageData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    content.mojom.ResourceTypeStatSpec.$,
    'ResourceTypeStat',
    [
      mojo.internal.StructField(
        'count', 0,
        0,
        mojo.internal.Uint64,
        BigInt('0'),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'size', 8,
        0,
        mojo.internal.Uint64,
        BigInt('0'),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'liveSize', 16,
        0,
        mojo.internal.Uint64,
        BigInt('0'),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'decodedSize', 24,
        0,
        mojo.internal.Uint64,
        BigInt('0'),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
content.mojom.ResourceTypeStat = class {
  constructor() {
    /** @export { !bigint } */
    this.count;
    /** @export { !bigint } */
    this.size;
    /** @export { !bigint } */
    this.liveSize;
    /** @export { !bigint } */
    this.decodedSize;
  }
};



mojo.internal.Struct(
    content.mojom.ResourceTypeStatsSpec.$,
    'ResourceTypeStats',
    [
      mojo.internal.StructField(
        'images', 0,
        0,
        content.mojom.ResourceTypeStatSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cssStyleSheets', 8,
        0,
        content.mojom.ResourceTypeStatSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scripts', 16,
        0,
        content.mojom.ResourceTypeStatSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'xslStyleSheets', 24,
        0,
        content.mojom.ResourceTypeStatSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fonts', 32,
        0,
        content.mojom.ResourceTypeStatSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'other', 40,
        0,
        content.mojom.ResourceTypeStatSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
content.mojom.ResourceTypeStats = class {
  constructor() {
    /** @export { !content.mojom.ResourceTypeStat } */
    this.images;
    /** @export { !content.mojom.ResourceTypeStat } */
    this.cssStyleSheets;
    /** @export { !content.mojom.ResourceTypeStat } */
    this.scripts;
    /** @export { !content.mojom.ResourceTypeStat } */
    this.xslStyleSheets;
    /** @export { !content.mojom.ResourceTypeStat } */
    this.fonts;
    /** @export { !content.mojom.ResourceTypeStat } */
    this.other;
  }
};



mojo.internal.Struct(
    content.mojom.ResourceUsageDataSpec.$,
    'ResourceUsageData',
    [
      mojo.internal.StructField(
        'reportsV8Stats', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'v8BytesAllocated', 8,
        0,
        mojo.internal.Uint64,
        BigInt('0'),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'v8BytesUsed', 16,
        0,
        mojo.internal.Uint64,
        BigInt('0'),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'webCacheStats', 24,
        0,
        content.mojom.ResourceTypeStatsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
content.mojom.ResourceUsageData = class {
  constructor() {
    /** @export { !boolean } */
    this.reportsV8Stats;
    /** @export { !bigint } */
    this.v8BytesAllocated;
    /** @export { !bigint } */
    this.v8BytesUsed;
    /** @export { (content.mojom.ResourceTypeStats|undefined) } */
    this.webCacheStats;
  }
};



mojo.internal.Struct(
    content.mojom.ResourceUsageReporter_GetUsageData_ParamsSpec.$,
    'ResourceUsageReporter_GetUsageData_Params',
    [
    ],
    [[0, 8],]);





/** @record */
content.mojom.ResourceUsageReporter_GetUsageData_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    content.mojom.ResourceUsageReporter_GetUsageData_ResponseParamsSpec.$,
    'ResourceUsageReporter_GetUsageData_ResponseParams',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        content.mojom.ResourceUsageDataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
content.mojom.ResourceUsageReporter_GetUsageData_ResponseParams = class {
  constructor() {
    /** @export { !content.mojom.ResourceUsageData } */
    this.data;
  }
};

