// content/common/render_widget_host_ns_view.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_RENDER_WIDGET_HOST_NS_VIEW_MOJOM_TEST_UTILS_H_
#define CONTENT_COMMON_RENDER_WIDGET_HOST_NS_VIEW_MOJOM_TEST_UTILS_H_

#include "content/common/render_widget_host_ns_view.mojom.h"
#include "content/common/content_export.h"


namespace remote_cocoa::mojom {


class CONTENT_EXPORT PopupMenuRunnerInterceptorForTesting : public PopupMenuRunner {
  virtual PopupMenuRunner* GetForwardingInterface() = 0;
  void Hide() override;
};
class CONTENT_EXPORT PopupMenuRunnerAsyncWaiter {
 public:
  explicit PopupMenuRunnerAsyncWaiter(PopupMenuRunner* proxy);

  PopupMenuRunnerAsyncWaiter(const PopupMenuRunnerAsyncWaiter&) = delete;
  PopupMenuRunnerAsyncWaiter& operator=(const PopupMenuRunnerAsyncWaiter&) = delete;

  ~PopupMenuRunnerAsyncWaiter();

 private:
  PopupMenuRunner* const proxy_;
};


class CONTENT_EXPORT RenderWidgetHostNSViewInterceptorForTesting : public RenderWidgetHostNSView {
  virtual RenderWidgetHostNSView* GetForwardingInterface() = 0;
  void InitAsPopup(const ::gfx::Rect& content_rect, uint64_t popup_parent_ns_view_id) override;
  void SetParentWebContentsNSView(uint64_t parent_ns_view_id) override;
  void DisableDisplay() override;
  void MakeFirstResponder() override;
  void SetBounds(const ::gfx::Rect& rect) override;
  void SetCALayerParams(const ::gfx::CALayerParams& ca_layer_params) override;
  void SetBackgroundColor(uint32_t color) override;
  void SetVisible(bool visible) override;
  void SetTooltipText(const ::std::u16string& display_text) override;
  void SetTextInputState(::ui::TextInputType text_input_type, uint32_t flags) override;
  void SetTextSelection(const ::std::u16string& text, uint64_t offset, const ::gfx::Range& range) override;
  void SetCompositionRangeInfo(const ::gfx::Range& range) override;
  void CancelComposition() override;
  void SetShowingContextMenu(bool showing) override;
  void DisplayCursor(const ::ui::Cursor& cursor) override;
  void SetCursorLocked(bool locked) override;
  void SetCursorLockedUnacceleratedMovement(bool unaccelerated_movement) override;
  void ShowDictionaryOverlayForSelection() override;
  void ShowDictionaryOverlay(::ui::mojom::AttributedStringPtr attributed_string, const ::gfx::Point& baseline_point) override;
  void LockKeyboard(const std::optional<std::vector<uint32_t>>& dom_codes) override;
  void UnlockKeyboard() override;
  void ShowSharingServicePicker(const std::string& title, const std::string& text, const ::GURL& url, const std::vector<std::string>& file_paths, ShowSharingServicePickerCallback callback) override;
  void Destroy() override;
  void GestureScrollEventAck(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, bool consumed) override;
  void DidOverscroll(::blink::mojom::DidOverscrollParamsPtr params) override;
  void DisplayPopupMenu(PopupMenuPtr menu, DisplayPopupMenuCallback callback) override;
};
class CONTENT_EXPORT RenderWidgetHostNSViewAsyncWaiter {
 public:
  explicit RenderWidgetHostNSViewAsyncWaiter(RenderWidgetHostNSView* proxy);

  RenderWidgetHostNSViewAsyncWaiter(const RenderWidgetHostNSViewAsyncWaiter&) = delete;
  RenderWidgetHostNSViewAsyncWaiter& operator=(const RenderWidgetHostNSViewAsyncWaiter&) = delete;

  ~RenderWidgetHostNSViewAsyncWaiter();
  void ShowSharingServicePicker(
      const std::string& title, const std::string& text, const ::GURL& url, const std::vector<std::string>& file_paths, ::blink::mojom::ShareError* out_error);
  ::blink::mojom::ShareError ShowSharingServicePicker(const std::string& title, const std::string& text, const ::GURL& url, const std::vector<std::string>& file_paths);
  void DisplayPopupMenu(
      PopupMenuPtr menu, std::optional<uint32_t>* out_selected_item);
  std::optional<uint32_t> DisplayPopupMenu(PopupMenuPtr menu);

 private:
  RenderWidgetHostNSView* const proxy_;
};


class CONTENT_EXPORT RenderWidgetHostNSViewHostInterceptorForTesting : public RenderWidgetHostNSViewHost {
  virtual RenderWidgetHostNSViewHost* GetForwardingInterface() = 0;
  void SyncIsWidgetForMainFrame(SyncIsWidgetForMainFrameCallback callback) override;
  void RequestShutdown() override;
  void OnFirstResponderChanged(bool is_first_responder) override;
  void OnWindowIsKeyChanged(bool is_key) override;
  void OnBoundsInWindowChanged(const ::gfx::Rect& view_bounds_in_window_dip, bool attached_to_window) override;
  void OnWindowFrameInScreenChanged(const ::gfx::Rect& window_frame_in_screen_dip) override;
  void OnScreenInfosChanged(const ::display::ScreenInfos& screen_infos) override;
  void BeginKeyboardEvent() override;
  void EndKeyboardEvent() override;
  void ForwardKeyboardEventWithCommands(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, const std::vector<uint8_t>& native_event_data, bool skip_if_unhandled, std::vector<::blink::mojom::EditCommandPtr> commands) override;
  void RouteOrProcessMouseEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) override;
  void RouteOrProcessTouchEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) override;
  void RouteOrProcessWheelEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) override;
  void ForwardMouseEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) override;
  void ForwardWheelEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) override;
  void PinchEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, bool is_synthetically_injected) override;
  void SmartMagnifyEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) override;
  void ImeSetComposition(const ::std::u16string& text, const std::vector<::ui::ImeTextSpan>& ime_text_spans, const ::gfx::Range& replacement_range, int32_t selection_start, int32_t selection_end) override;
  void ImeCommitText(const ::std::u16string& text, const ::gfx::Range& replacement_range) override;
  void ImeFinishComposingText() override;
  void ImeCancelCompositionFromCocoa() override;
  void LookUpDictionaryOverlayAtPoint(const ::gfx::PointF& root_point) override;
  void LookUpDictionaryOverlayFromRange(const ::gfx::Range& range) override;
  void SyncGetCharacterIndexAtPoint(const ::gfx::PointF& root_point, SyncGetCharacterIndexAtPointCallback callback) override;
  void SyncGetFirstRectForRange(const ::gfx::Range& requested_range, SyncGetFirstRectForRangeCallback callback) override;
  void ExecuteEditCommand(const std::string& command) override;
  void Undo() override;
  void Redo() override;
  void Cut() override;
  void Copy() override;
  void CopyToFindPboard() override;
  void CenterSelection() override;
  void Paste() override;
  void PasteAndMatchStyle() override;
  void SelectAll() override;
  void StartSpeaking() override;
  void StopSpeaking() override;
  void SyncIsSpeaking(SyncIsSpeakingCallback callback) override;
  void GetRenderWidgetAccessibilityToken(GetRenderWidgetAccessibilityTokenCallback callback) override;
  void SetRemoteAccessibilityWindowToken(const std::vector<uint8_t>& window_token) override;
};
class CONTENT_EXPORT RenderWidgetHostNSViewHostAsyncWaiter {
 public:
  explicit RenderWidgetHostNSViewHostAsyncWaiter(RenderWidgetHostNSViewHost* proxy);

  RenderWidgetHostNSViewHostAsyncWaiter(const RenderWidgetHostNSViewHostAsyncWaiter&) = delete;
  RenderWidgetHostNSViewHostAsyncWaiter& operator=(const RenderWidgetHostNSViewHostAsyncWaiter&) = delete;

  ~RenderWidgetHostNSViewHostAsyncWaiter();
  void SyncIsWidgetForMainFrame(
      bool* out_is_for_main_frame);
  bool SyncIsWidgetForMainFrame();
  void SyncGetCharacterIndexAtPoint(
      const ::gfx::PointF& root_point, uint32_t* out_index);
  uint32_t SyncGetCharacterIndexAtPoint(const ::gfx::PointF& root_point);
  void SyncGetFirstRectForRange(
      const ::gfx::Range& requested_range, ::gfx::Rect* out_out_rect, ::gfx::Range* out_out_actual_range, bool* out_success);
  
  void SyncIsSpeaking(
      bool* out_is_speaking);
  bool SyncIsSpeaking();
  void GetRenderWidgetAccessibilityToken(
      ::base::ProcessId* out_host_pid, std::vector<uint8_t>* out_element_token);
  

 private:
  RenderWidgetHostNSViewHost* const proxy_;
};




}  // remote_cocoa::mojom

#endif  // CONTENT_COMMON_RENDER_WIDGET_HOST_NS_VIEW_MOJOM_TEST_UTILS_H_