// content/common/render_widget_host_ns_view.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/common/render_widget_host_ns_view.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/common/render_widget_host_ns_view.mojom-params-data.h"
namespace remote_cocoa {
namespace mojom {

namespace internal {


// static
bool PopupMenu_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PopupMenu_Data* object =
      static_cast<const PopupMenu_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->items, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& items_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->items, validation_context,
                                         &items_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PopupMenu_Data::PopupMenu_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PopupMenuRunner_Hide_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PopupMenuRunner_Hide_Params_Data* object =
      static_cast<const PopupMenuRunner_Hide_Params_Data*>(data);

  return true;
}

PopupMenuRunner_Hide_Params_Data::PopupMenuRunner_Hide_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_InitAsPopup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_InitAsPopup_Params_Data* object =
      static_cast<const RenderWidgetHostNSView_InitAsPopup_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content_rect, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->content_rect, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSView_InitAsPopup_Params_Data::RenderWidgetHostNSView_InitAsPopup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_SetParentWebContentsNSView_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_SetParentWebContentsNSView_Params_Data* object =
      static_cast<const RenderWidgetHostNSView_SetParentWebContentsNSView_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSView_SetParentWebContentsNSView_Params_Data::RenderWidgetHostNSView_SetParentWebContentsNSView_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_DisableDisplay_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_DisableDisplay_Params_Data* object =
      static_cast<const RenderWidgetHostNSView_DisableDisplay_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSView_DisableDisplay_Params_Data::RenderWidgetHostNSView_DisableDisplay_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_MakeFirstResponder_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_MakeFirstResponder_Params_Data* object =
      static_cast<const RenderWidgetHostNSView_MakeFirstResponder_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSView_MakeFirstResponder_Params_Data::RenderWidgetHostNSView_MakeFirstResponder_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_SetBounds_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_SetBounds_Params_Data* object =
      static_cast<const RenderWidgetHostNSView_SetBounds_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rect, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rect, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSView_SetBounds_Params_Data::RenderWidgetHostNSView_SetBounds_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_SetCALayerParams_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_SetCALayerParams_Params_Data* object =
      static_cast<const RenderWidgetHostNSView_SetCALayerParams_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ca_layer_params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ca_layer_params, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSView_SetCALayerParams_Params_Data::RenderWidgetHostNSView_SetCALayerParams_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_SetBackgroundColor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_SetBackgroundColor_Params_Data* object =
      static_cast<const RenderWidgetHostNSView_SetBackgroundColor_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSView_SetBackgroundColor_Params_Data::RenderWidgetHostNSView_SetBackgroundColor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_SetVisible_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_SetVisible_Params_Data* object =
      static_cast<const RenderWidgetHostNSView_SetVisible_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSView_SetVisible_Params_Data::RenderWidgetHostNSView_SetVisible_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_SetTooltipText_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_SetTooltipText_Params_Data* object =
      static_cast<const RenderWidgetHostNSView_SetTooltipText_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_text, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->display_text, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSView_SetTooltipText_Params_Data::RenderWidgetHostNSView_SetTooltipText_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_SetTextInputState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_SetTextInputState_Params_Data* object =
      static_cast<const RenderWidgetHostNSView_SetTextInputState_Params_Data*>(data);


  if (!::ui::mojom::internal::TextInputType_Data
        ::Validate(object->text_input_type, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSView_SetTextInputState_Params_Data::RenderWidgetHostNSView_SetTextInputState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_SetTextSelection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_SetTextSelection_Params_Data* object =
      static_cast<const RenderWidgetHostNSView_SetTextSelection_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->text, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->range, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->range, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSView_SetTextSelection_Params_Data::RenderWidgetHostNSView_SetTextSelection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_SetCompositionRangeInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_SetCompositionRangeInfo_Params_Data* object =
      static_cast<const RenderWidgetHostNSView_SetCompositionRangeInfo_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->range, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->range, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSView_SetCompositionRangeInfo_Params_Data::RenderWidgetHostNSView_SetCompositionRangeInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_CancelComposition_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_CancelComposition_Params_Data* object =
      static_cast<const RenderWidgetHostNSView_CancelComposition_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSView_CancelComposition_Params_Data::RenderWidgetHostNSView_CancelComposition_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_SetShowingContextMenu_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_SetShowingContextMenu_Params_Data* object =
      static_cast<const RenderWidgetHostNSView_SetShowingContextMenu_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSView_SetShowingContextMenu_Params_Data::RenderWidgetHostNSView_SetShowingContextMenu_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_DisplayCursor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_DisplayCursor_Params_Data* object =
      static_cast<const RenderWidgetHostNSView_DisplayCursor_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cursor, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cursor, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSView_DisplayCursor_Params_Data::RenderWidgetHostNSView_DisplayCursor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_SetCursorLocked_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_SetCursorLocked_Params_Data* object =
      static_cast<const RenderWidgetHostNSView_SetCursorLocked_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSView_SetCursorLocked_Params_Data::RenderWidgetHostNSView_SetCursorLocked_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_SetCursorLockedUnacceleratedMovement_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_SetCursorLockedUnacceleratedMovement_Params_Data* object =
      static_cast<const RenderWidgetHostNSView_SetCursorLockedUnacceleratedMovement_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSView_SetCursorLockedUnacceleratedMovement_Params_Data::RenderWidgetHostNSView_SetCursorLockedUnacceleratedMovement_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_ShowDictionaryOverlayForSelection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_ShowDictionaryOverlayForSelection_Params_Data* object =
      static_cast<const RenderWidgetHostNSView_ShowDictionaryOverlayForSelection_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSView_ShowDictionaryOverlayForSelection_Params_Data::RenderWidgetHostNSView_ShowDictionaryOverlayForSelection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_ShowDictionaryOverlay_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_ShowDictionaryOverlay_Params_Data* object =
      static_cast<const RenderWidgetHostNSView_ShowDictionaryOverlay_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->attributed_string, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->attributed_string, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->baseline_point, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->baseline_point, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSView_ShowDictionaryOverlay_Params_Data::RenderWidgetHostNSView_ShowDictionaryOverlay_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_LockKeyboard_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_LockKeyboard_Params_Data* object =
      static_cast<const RenderWidgetHostNSView_LockKeyboard_Params_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& dom_codes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->dom_codes, validation_context,
                                         &dom_codes_validate_params)) {
    return false;
  }

  return true;
}

RenderWidgetHostNSView_LockKeyboard_Params_Data::RenderWidgetHostNSView_LockKeyboard_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_UnlockKeyboard_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_UnlockKeyboard_Params_Data* object =
      static_cast<const RenderWidgetHostNSView_UnlockKeyboard_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSView_UnlockKeyboard_Params_Data::RenderWidgetHostNSView_UnlockKeyboard_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_ShowSharingServicePicker_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_ShowSharingServicePicker_Params_Data* object =
      static_cast<const RenderWidgetHostNSView_ShowSharingServicePicker_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_paths, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& file_paths_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->file_paths, validation_context,
                                         &file_paths_validate_params)) {
    return false;
  }

  return true;
}

RenderWidgetHostNSView_ShowSharingServicePicker_Params_Data::RenderWidgetHostNSView_ShowSharingServicePicker_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_ShowSharingServicePicker_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_ShowSharingServicePicker_ResponseParams_Data* object =
      static_cast<const RenderWidgetHostNSView_ShowSharingServicePicker_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::ShareError_Data
        ::Validate(object->error, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSView_ShowSharingServicePicker_ResponseParams_Data::RenderWidgetHostNSView_ShowSharingServicePicker_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_Destroy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_Destroy_Params_Data* object =
      static_cast<const RenderWidgetHostNSView_Destroy_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSView_Destroy_Params_Data::RenderWidgetHostNSView_Destroy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_GestureScrollEventAck_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_GestureScrollEventAck_Params_Data* object =
      static_cast<const RenderWidgetHostNSView_GestureScrollEventAck_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSView_GestureScrollEventAck_Params_Data::RenderWidgetHostNSView_GestureScrollEventAck_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_DidOverscroll_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_DidOverscroll_Params_Data* object =
      static_cast<const RenderWidgetHostNSView_DidOverscroll_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSView_DidOverscroll_Params_Data::RenderWidgetHostNSView_DidOverscroll_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_DisplayPopupMenu_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_DisplayPopupMenu_Params_Data* object =
      static_cast<const RenderWidgetHostNSView_DisplayPopupMenu_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->menu, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->menu, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSView_DisplayPopupMenu_Params_Data::RenderWidgetHostNSView_DisplayPopupMenu_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSView_DisplayPopupMenu_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSView_DisplayPopupMenu_ResponseParams_Data* object =
      static_cast<const RenderWidgetHostNSView_DisplayPopupMenu_ResponseParams_Data*>(data);

  return true;
}

RenderWidgetHostNSView_DisplayPopupMenu_ResponseParams_Data::RenderWidgetHostNSView_DisplayPopupMenu_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_Params_Data::RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ResponseParams_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ResponseParams_Data*>(data);

  return true;
}

RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ResponseParams_Data::RenderWidgetHostNSViewHost_SyncIsWidgetForMainFrame_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_RequestShutdown_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_RequestShutdown_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_RequestShutdown_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSViewHost_RequestShutdown_Params_Data::RenderWidgetHostNSViewHost_RequestShutdown_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_OnFirstResponderChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_OnFirstResponderChanged_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_OnFirstResponderChanged_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSViewHost_OnFirstResponderChanged_Params_Data::RenderWidgetHostNSViewHost_OnFirstResponderChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_OnWindowIsKeyChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_OnWindowIsKeyChanged_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_OnWindowIsKeyChanged_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSViewHost_OnWindowIsKeyChanged_Params_Data::RenderWidgetHostNSViewHost_OnWindowIsKeyChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_OnBoundsInWindowChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_OnBoundsInWindowChanged_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_OnBoundsInWindowChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->view_bounds_in_window_dip, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->view_bounds_in_window_dip, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSViewHost_OnBoundsInWindowChanged_Params_Data::RenderWidgetHostNSViewHost_OnBoundsInWindowChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_OnWindowFrameInScreenChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_OnWindowFrameInScreenChanged_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_OnWindowFrameInScreenChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->window_frame_in_screen_dip, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->window_frame_in_screen_dip, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSViewHost_OnWindowFrameInScreenChanged_Params_Data::RenderWidgetHostNSViewHost_OnWindowFrameInScreenChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_OnScreenInfosChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_OnScreenInfosChanged_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_OnScreenInfosChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->screen_infos, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->screen_infos, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSViewHost_OnScreenInfosChanged_Params_Data::RenderWidgetHostNSViewHost_OnScreenInfosChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_BeginKeyboardEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_BeginKeyboardEvent_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_BeginKeyboardEvent_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSViewHost_BeginKeyboardEvent_Params_Data::RenderWidgetHostNSViewHost_BeginKeyboardEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_EndKeyboardEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_EndKeyboardEvent_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_EndKeyboardEvent_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSViewHost_EndKeyboardEvent_Params_Data::RenderWidgetHostNSViewHost_EndKeyboardEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_ForwardKeyboardEventWithCommands_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_ForwardKeyboardEventWithCommands_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_ForwardKeyboardEventWithCommands_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->native_event_data, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& native_event_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->native_event_data, validation_context,
                                         &native_event_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->commands, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& commands_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->commands, validation_context,
                                         &commands_validate_params)) {
    return false;
  }

  return true;
}

RenderWidgetHostNSViewHost_ForwardKeyboardEventWithCommands_Params_Data::RenderWidgetHostNSViewHost_ForwardKeyboardEventWithCommands_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_RouteOrProcessMouseEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_RouteOrProcessMouseEvent_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_RouteOrProcessMouseEvent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSViewHost_RouteOrProcessMouseEvent_Params_Data::RenderWidgetHostNSViewHost_RouteOrProcessMouseEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_RouteOrProcessTouchEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_RouteOrProcessTouchEvent_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_RouteOrProcessTouchEvent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSViewHost_RouteOrProcessTouchEvent_Params_Data::RenderWidgetHostNSViewHost_RouteOrProcessTouchEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_RouteOrProcessWheelEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_RouteOrProcessWheelEvent_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_RouteOrProcessWheelEvent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSViewHost_RouteOrProcessWheelEvent_Params_Data::RenderWidgetHostNSViewHost_RouteOrProcessWheelEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_ForwardMouseEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_ForwardMouseEvent_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_ForwardMouseEvent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSViewHost_ForwardMouseEvent_Params_Data::RenderWidgetHostNSViewHost_ForwardMouseEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_ForwardWheelEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_ForwardWheelEvent_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_ForwardWheelEvent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSViewHost_ForwardWheelEvent_Params_Data::RenderWidgetHostNSViewHost_ForwardWheelEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_PinchEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_PinchEvent_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_PinchEvent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSViewHost_PinchEvent_Params_Data::RenderWidgetHostNSViewHost_PinchEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_SmartMagnifyEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_SmartMagnifyEvent_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_SmartMagnifyEvent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSViewHost_SmartMagnifyEvent_Params_Data::RenderWidgetHostNSViewHost_SmartMagnifyEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_ImeSetComposition_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_ImeSetComposition_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_ImeSetComposition_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->text, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ime_text_spans, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& ime_text_spans_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ime_text_spans, validation_context,
                                         &ime_text_spans_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->replacement_range, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->replacement_range, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSViewHost_ImeSetComposition_Params_Data::RenderWidgetHostNSViewHost_ImeSetComposition_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_ImeCommitText_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_ImeCommitText_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_ImeCommitText_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->text, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->replacement_range, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->replacement_range, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSViewHost_ImeCommitText_Params_Data::RenderWidgetHostNSViewHost_ImeCommitText_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_ImeFinishComposingText_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_ImeFinishComposingText_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_ImeFinishComposingText_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSViewHost_ImeFinishComposingText_Params_Data::RenderWidgetHostNSViewHost_ImeFinishComposingText_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_ImeCancelCompositionFromCocoa_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_ImeCancelCompositionFromCocoa_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_ImeCancelCompositionFromCocoa_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSViewHost_ImeCancelCompositionFromCocoa_Params_Data::RenderWidgetHostNSViewHost_ImeCancelCompositionFromCocoa_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_LookUpDictionaryOverlayAtPoint_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_LookUpDictionaryOverlayAtPoint_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_LookUpDictionaryOverlayAtPoint_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->root_point, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->root_point, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSViewHost_LookUpDictionaryOverlayAtPoint_Params_Data::RenderWidgetHostNSViewHost_LookUpDictionaryOverlayAtPoint_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_LookUpDictionaryOverlayFromRange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_LookUpDictionaryOverlayFromRange_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_LookUpDictionaryOverlayFromRange_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->range, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->range, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSViewHost_LookUpDictionaryOverlayFromRange_Params_Data::RenderWidgetHostNSViewHost_LookUpDictionaryOverlayFromRange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->root_point, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->root_point, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_Params_Data::RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ResponseParams_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ResponseParams_Data*>(data);

  return true;
}

RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ResponseParams_Data::RenderWidgetHostNSViewHost_SyncGetCharacterIndexAtPoint_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->requested_range, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->requested_range, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_Params_Data::RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ResponseParams_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->out_rect, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->out_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->out_actual_range, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->out_actual_range, validation_context))
    return false;

  return true;
}

RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ResponseParams_Data::RenderWidgetHostNSViewHost_SyncGetFirstRectForRange_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_ExecuteEditCommand_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_ExecuteEditCommand_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_ExecuteEditCommand_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->command, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& command_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->command, validation_context,
                                         &command_validate_params)) {
    return false;
  }

  return true;
}

RenderWidgetHostNSViewHost_ExecuteEditCommand_Params_Data::RenderWidgetHostNSViewHost_ExecuteEditCommand_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_Undo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_Undo_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_Undo_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSViewHost_Undo_Params_Data::RenderWidgetHostNSViewHost_Undo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_Redo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_Redo_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_Redo_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSViewHost_Redo_Params_Data::RenderWidgetHostNSViewHost_Redo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_Cut_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_Cut_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_Cut_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSViewHost_Cut_Params_Data::RenderWidgetHostNSViewHost_Cut_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_Copy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_Copy_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_Copy_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSViewHost_Copy_Params_Data::RenderWidgetHostNSViewHost_Copy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_CopyToFindPboard_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_CopyToFindPboard_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_CopyToFindPboard_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSViewHost_CopyToFindPboard_Params_Data::RenderWidgetHostNSViewHost_CopyToFindPboard_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_CenterSelection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_CenterSelection_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_CenterSelection_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSViewHost_CenterSelection_Params_Data::RenderWidgetHostNSViewHost_CenterSelection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_Paste_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_Paste_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_Paste_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSViewHost_Paste_Params_Data::RenderWidgetHostNSViewHost_Paste_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_PasteAndMatchStyle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_PasteAndMatchStyle_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_PasteAndMatchStyle_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSViewHost_PasteAndMatchStyle_Params_Data::RenderWidgetHostNSViewHost_PasteAndMatchStyle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_SelectAll_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_SelectAll_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_SelectAll_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSViewHost_SelectAll_Params_Data::RenderWidgetHostNSViewHost_SelectAll_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_StartSpeaking_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_StartSpeaking_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_StartSpeaking_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSViewHost_StartSpeaking_Params_Data::RenderWidgetHostNSViewHost_StartSpeaking_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_StopSpeaking_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_StopSpeaking_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_StopSpeaking_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSViewHost_StopSpeaking_Params_Data::RenderWidgetHostNSViewHost_StopSpeaking_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_SyncIsSpeaking_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_SyncIsSpeaking_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_SyncIsSpeaking_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSViewHost_SyncIsSpeaking_Params_Data::RenderWidgetHostNSViewHost_SyncIsSpeaking_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_SyncIsSpeaking_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_SyncIsSpeaking_ResponseParams_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_SyncIsSpeaking_ResponseParams_Data*>(data);

  return true;
}

RenderWidgetHostNSViewHost_SyncIsSpeaking_ResponseParams_Data::RenderWidgetHostNSViewHost_SyncIsSpeaking_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_Params_Data*>(data);

  return true;
}

RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_Params_Data::RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ResponseParams_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host_pid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->host_pid, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->element_token, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& element_token_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->element_token, validation_context,
                                         &element_token_validate_params)) {
    return false;
  }

  return true;
}

RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ResponseParams_Data::RenderWidgetHostNSViewHost_GetRenderWidgetAccessibilityToken_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderWidgetHostNSViewHost_SetRemoteAccessibilityWindowToken_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderWidgetHostNSViewHost_SetRemoteAccessibilityWindowToken_Params_Data* object =
      static_cast<const RenderWidgetHostNSViewHost_SetRemoteAccessibilityWindowToken_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->window_token, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& window_token_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->window_token, validation_context,
                                         &window_token_validate_params)) {
    return false;
  }

  return true;
}

RenderWidgetHostNSViewHost_SetRemoteAccessibilityWindowToken_Params_Data::RenderWidgetHostNSViewHost_SetRemoteAccessibilityWindowToken_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace remote_cocoa