// content/common/render_message_filter.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_RENDER_MESSAGE_FILTER_MOJOM_H_
#define CONTENT_COMMON_RENDER_MESSAGE_FILTER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/common/render_message_filter.mojom-features.h"  // IWYU pragma: export
#include "content/common/render_message_filter.mojom-shared.h"  // IWYU pragma: export
#include "content/common/render_message_filter.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/common/content_export.h"




namespace content::mojom {

class RenderMessageFilterProxy;

template <typename ImplRefTraits>
class RenderMessageFilterStub;

class RenderMessageFilterRequestValidator;
class RenderMessageFilterResponseValidator;


class CONTENT_EXPORT RenderMessageFilter
    : public RenderMessageFilterInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "content.mojom.RenderMessageFilter";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0, 
    1
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RenderMessageFilterInterfaceBase;
  using Proxy_ = RenderMessageFilterProxy;

  template <typename ImplRefTraits>
  using Stub_ = RenderMessageFilterStub<ImplRefTraits>;

  using RequestValidator_ = RenderMessageFilterRequestValidator;
  using ResponseValidator_ = RenderMessageFilterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGenerateSingleFrameRoutingInfoMinVersion = 0,
    kGenerateFrameRoutingInfosMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GenerateSingleFrameRoutingInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GenerateFrameRoutingInfos_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~RenderMessageFilter() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GenerateSingleFrameRoutingInfo(FrameRoutingInfoPtr* out_info);
  using GenerateSingleFrameRoutingInfoCallback = base::OnceCallback<void(FrameRoutingInfoPtr)>;
  using GenerateSingleFrameRoutingInfoMojoCallback = base::OnceCallback<void(FrameRoutingInfoPtr)>;

  virtual void GenerateSingleFrameRoutingInfo(GenerateSingleFrameRoutingInfoCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GenerateFrameRoutingInfos(std::vector<FrameRoutingInfoPtr>* out_info_array);
  using GenerateFrameRoutingInfosCallback = base::OnceCallback<void(std::vector<FrameRoutingInfoPtr>)>;
  using GenerateFrameRoutingInfosMojoCallback = base::OnceCallback<void(std::vector<FrameRoutingInfoPtr>)>;

  virtual void GenerateFrameRoutingInfos(GenerateFrameRoutingInfosCallback callback) = 0;
};



class CONTENT_EXPORT RenderMessageFilterProxy
    : public RenderMessageFilter {
 public:
  using InterfaceType = RenderMessageFilter;

  explicit RenderMessageFilterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool GenerateSingleFrameRoutingInfo(FrameRoutingInfoPtr* out_info) final;
  
  void GenerateSingleFrameRoutingInfo(GenerateSingleFrameRoutingInfoCallback callback) final;
  
  bool GenerateFrameRoutingInfos(std::vector<FrameRoutingInfoPtr>* out_info_array) final;
  
  void GenerateFrameRoutingInfos(GenerateFrameRoutingInfosCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT RenderMessageFilterStubDispatch {
 public:
  static bool Accept(RenderMessageFilter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RenderMessageFilter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RenderMessageFilter>>
class RenderMessageFilterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RenderMessageFilterStub() = default;
  ~RenderMessageFilterStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RenderMessageFilterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RenderMessageFilterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT RenderMessageFilterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT RenderMessageFilterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class CONTENT_EXPORT FrameRoutingInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FrameRoutingInfo, T>::value>;
  using DataView = FrameRoutingInfoDataView;
  using Data_ = internal::FrameRoutingInfo_Data;

  template <typename... Args>
  static FrameRoutingInfoPtr New(Args&&... args) {
    return FrameRoutingInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FrameRoutingInfoPtr From(const U& u) {
    return mojo::TypeConverter<FrameRoutingInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FrameRoutingInfo>::Convert(*this);
  }


  FrameRoutingInfo();

  FrameRoutingInfo(
      int32_t routing_id,
      const ::blink::LocalFrameToken& frame_token,
      const ::base::UnguessableToken& devtools_frame_token,
      const ::blink::DocumentToken& document_token);


  ~FrameRoutingInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FrameRoutingInfoPtr>
  FrameRoutingInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FrameRoutingInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FrameRoutingInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FrameRoutingInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameRoutingInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameRoutingInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FrameRoutingInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FrameRoutingInfo_UnserializedMessageContext<
            UserType, FrameRoutingInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FrameRoutingInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FrameRoutingInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FrameRoutingInfo_UnserializedMessageContext<
            UserType, FrameRoutingInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FrameRoutingInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t routing_id;
  
  ::blink::LocalFrameToken frame_token;
  
  ::base::UnguessableToken devtools_frame_token;
  
  ::blink::DocumentToken document_token;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FrameRoutingInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FrameRoutingInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FrameRoutingInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FrameRoutingInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
FrameRoutingInfoPtr FrameRoutingInfo::Clone() const {
  return New(
      mojo::Clone(routing_id),
      mojo::Clone(frame_token),
      mojo::Clone(devtools_frame_token),
      mojo::Clone(document_token)
  );
}

template <typename T, FrameRoutingInfo::EnableIfSame<T>*>
bool FrameRoutingInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->routing_id, other_struct.routing_id))
    return false;
  if (!mojo::Equals(this->frame_token, other_struct.frame_token))
    return false;
  if (!mojo::Equals(this->devtools_frame_token, other_struct.devtools_frame_token))
    return false;
  if (!mojo::Equals(this->document_token, other_struct.document_token))
    return false;
  return true;
}

template <typename T, FrameRoutingInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.routing_id < rhs.routing_id)
    return true;
  if (rhs.routing_id < lhs.routing_id)
    return false;
  if (lhs.frame_token < rhs.frame_token)
    return true;
  if (rhs.frame_token < lhs.frame_token)
    return false;
  if (lhs.devtools_frame_token < rhs.devtools_frame_token)
    return true;
  if (rhs.devtools_frame_token < lhs.devtools_frame_token)
    return false;
  if (lhs.document_token < rhs.document_token)
    return true;
  if (rhs.document_token < lhs.document_token)
    return false;
  return false;
}


}  // content::mojom

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::FrameRoutingInfo::DataView,
                                         ::content::mojom::FrameRoutingInfoPtr> {
  static bool IsNull(const ::content::mojom::FrameRoutingInfoPtr& input) { return !input; }
  static void SetToNull(::content::mojom::FrameRoutingInfoPtr* output) { output->reset(); }

  static decltype(::content::mojom::FrameRoutingInfo::routing_id) routing_id(
      const ::content::mojom::FrameRoutingInfoPtr& input) {
    return input->routing_id;
  }

  static const decltype(::content::mojom::FrameRoutingInfo::frame_token)& frame_token(
      const ::content::mojom::FrameRoutingInfoPtr& input) {
    return input->frame_token;
  }

  static const decltype(::content::mojom::FrameRoutingInfo::devtools_frame_token)& devtools_frame_token(
      const ::content::mojom::FrameRoutingInfoPtr& input) {
    return input->devtools_frame_token;
  }

  static const decltype(::content::mojom::FrameRoutingInfo::document_token)& document_token(
      const ::content::mojom::FrameRoutingInfoPtr& input) {
    return input->document_token;
  }

  static bool Read(::content::mojom::FrameRoutingInfo::DataView input, ::content::mojom::FrameRoutingInfoPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_COMMON_RENDER_MESSAGE_FILTER_MOJOM_H_