// content/common/agent_scheduling_group.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_AGENT_SCHEDULING_GROUP_MOJOM_H_
#define CONTENT_COMMON_AGENT_SCHEDULING_GROUP_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/common/agent_scheduling_group.mojom-features.h"  // IWYU pragma: export
#include "content/common/agent_scheduling_group.mojom-shared.h"  // IWYU pragma: export
#include "content/common/agent_scheduling_group.mojom-forward.h"  // IWYU pragma: export
#include "content/common/associated_interfaces.mojom-forward.h"
#include "content/common/frame.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/frame.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/tree_scope_type.mojom-forward.h"
#include "third_party/blink/public/mojom/shared_storage/shared_storage_worklet_service.mojom-forward.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include "third_party/blink/public/mojom/worker/worklet_global_scope_creation_params.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/common/content_export.h"




namespace content::mojom {

class AgentSchedulingGroupHostProxy;

template <typename ImplRefTraits>
class AgentSchedulingGroupHostStub;

class AgentSchedulingGroupHostRequestValidator;


class CONTENT_EXPORT AgentSchedulingGroupHost
    : public AgentSchedulingGroupHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "content.mojom.AgentSchedulingGroupHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AgentSchedulingGroupHostInterfaceBase;
  using Proxy_ = AgentSchedulingGroupHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = AgentSchedulingGroupHostStub<ImplRefTraits>;

  using RequestValidator_ = AgentSchedulingGroupHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDidUnloadRenderFrameMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DidUnloadRenderFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AgentSchedulingGroupHost() = default;

  virtual void DidUnloadRenderFrame(const ::blink::LocalFrameToken& frame_token) = 0;
};

class AgentSchedulingGroupProxy;

template <typename ImplRefTraits>
class AgentSchedulingGroupStub;

class AgentSchedulingGroupRequestValidator;


class CONTENT_EXPORT AgentSchedulingGroup
    : public AgentSchedulingGroupInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "content.mojom.AgentSchedulingGroup";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AgentSchedulingGroupInterfaceBase;
  using Proxy_ = AgentSchedulingGroupProxy;

  template <typename ImplRefTraits>
  using Stub_ = AgentSchedulingGroupStub<ImplRefTraits>;

  using RequestValidator_ = AgentSchedulingGroupRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindAssociatedInterfacesMinVersion = 0,
    kCreateViewMinVersion = 0,
    kCreateFrameMinVersion = 0,
    kCreateSharedStorageWorkletServiceMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BindAssociatedInterfaces_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateView_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateSharedStorageWorkletService_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AgentSchedulingGroup() = default;

  virtual void BindAssociatedInterfaces(::mojo::PendingAssociatedRemote<AgentSchedulingGroupHost> remote_host, ::mojo::PendingAssociatedReceiver<::content::mojom::RouteProvider> route_provider_receiver) = 0;

  virtual void CreateView(::content::mojom::CreateViewParamsPtr params) = 0;

  virtual void CreateFrame(::content::mojom::CreateFrameParamsPtr params) = 0;

  virtual void CreateSharedStorageWorkletService(::mojo::PendingReceiver<::blink::mojom::SharedStorageWorkletService> receiver, ::blink::mojom::WorkletGlobalScopeCreationParamsPtr global_scope_creation_params) = 0;
};



class CONTENT_EXPORT AgentSchedulingGroupHostProxy
    : public AgentSchedulingGroupHost {
 public:
  using InterfaceType = AgentSchedulingGroupHost;

  explicit AgentSchedulingGroupHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DidUnloadRenderFrame(const ::blink::LocalFrameToken& frame_token) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT AgentSchedulingGroupProxy
    : public AgentSchedulingGroup {
 public:
  using InterfaceType = AgentSchedulingGroup;

  explicit AgentSchedulingGroupProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindAssociatedInterfaces(::mojo::PendingAssociatedRemote<AgentSchedulingGroupHost> remote_host, ::mojo::PendingAssociatedReceiver<::content::mojom::RouteProvider> route_provider_receiver) final;
  
  void CreateView(::content::mojom::CreateViewParamsPtr params) final;
  
  void CreateFrame(::content::mojom::CreateFrameParamsPtr params) final;
  
  void CreateSharedStorageWorkletService(::mojo::PendingReceiver<::blink::mojom::SharedStorageWorkletService> receiver, ::blink::mojom::WorkletGlobalScopeCreationParamsPtr global_scope_creation_params) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT AgentSchedulingGroupHostStubDispatch {
 public:
  static bool Accept(AgentSchedulingGroupHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AgentSchedulingGroupHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AgentSchedulingGroupHost>>
class AgentSchedulingGroupHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AgentSchedulingGroupHostStub() = default;
  ~AgentSchedulingGroupHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AgentSchedulingGroupHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AgentSchedulingGroupHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT AgentSchedulingGroupStubDispatch {
 public:
  static bool Accept(AgentSchedulingGroup* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AgentSchedulingGroup* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AgentSchedulingGroup>>
class AgentSchedulingGroupStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AgentSchedulingGroupStub() = default;
  ~AgentSchedulingGroupStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AgentSchedulingGroupStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AgentSchedulingGroupStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT AgentSchedulingGroupHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT AgentSchedulingGroupRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // content::mojom

namespace mojo {

}  // namespace mojo

#endif  // CONTENT_COMMON_AGENT_SCHEDULING_GROUP_MOJOM_H_