// content/browser/private_aggregation/private_aggregation_internals.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_PRIVATE_AGGREGATION_PRIVATE_AGGREGATION_INTERNALS_MOJOM_SEND_VALIDATION_H_
#define CONTENT_BROWSER_PRIVATE_AGGREGATION_PRIVATE_AGGREGATION_INTERNALS_MOJOM_SEND_VALIDATION_H_

#include "content/browser/private_aggregation/private_aggregation_internals.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/mojom/base/int128.mojom-shared.h"

#include "content/browser/private_aggregation/private_aggregation_internals.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::private_aggregation_internals::mojom::ReportStatus, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::private_aggregation_internals::mojom::AggregatableReportRequestIDDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::private_aggregation_internals::mojom::AggregatableReportRequestIDDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::private_aggregation_internals::mojom::internal::AggregatableReportRequestID_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->value = Traits::value(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::private_aggregation_internals::mojom::AggregatableHistogramContributionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::private_aggregation_internals::mojom::AggregatableHistogramContributionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::private_aggregation_internals::mojom::internal::AggregatableHistogramContribution_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::bucket(input)) in_bucket = Traits::bucket(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bucket)::BaseType> bucket_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::Uint128DataView, send_validation>(
        in_bucket,
        bucket_fragment);

      fragment->bucket.Set(
          bucket_fragment.is_null() ? nullptr : bucket_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bucket.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bucket in AggregatableHistogramContribution struct");

      fragment->value = Traits::value(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::private_aggregation_internals::mojom::WebUIAggregatableReportDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::private_aggregation_internals::mojom::WebUIAggregatableReportDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::private_aggregation_internals::mojom::internal::WebUIAggregatableReport_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::private_aggregation_internals::mojom::AggregatableReportRequestIDDataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      fragment->report_time = Traits::report_time(input);

      decltype(Traits::api_identifier(input)) in_api_identifier = Traits::api_identifier(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->api_identifier)::BaseType> api_identifier_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_api_identifier,
        api_identifier_fragment);

      fragment->api_identifier.Set(
          api_identifier_fragment.is_null() ? nullptr : api_identifier_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->api_identifier.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null api_identifier in WebUIAggregatableReport struct");

      decltype(Traits::api_version(input)) in_api_version = Traits::api_version(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->api_version)::BaseType> api_version_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_api_version,
        api_version_fragment);

      fragment->api_version.Set(
          api_version_fragment.is_null() ? nullptr : api_version_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->api_version.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null api_version in WebUIAggregatableReport struct");

      decltype(Traits::report_url(input)) in_report_url = Traits::report_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->report_url)::BaseType> report_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_report_url,
        report_url_fragment);

      fragment->report_url.Set(
          report_url_fragment.is_null() ? nullptr : report_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->report_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null report_url in WebUIAggregatableReport struct");

      decltype(Traits::contributions(input)) in_contributions = Traits::contributions(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->contributions)::BaseType>
          contributions_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& contributions_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::private_aggregation_internals::mojom::AggregatableHistogramContributionDataView>, send_validation>(
        in_contributions,
        contributions_fragment,
        &contributions_validate_params);

      fragment->contributions.Set(
          contributions_fragment.is_null() ? nullptr : contributions_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->contributions.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null contributions in WebUIAggregatableReport struct");

      
      mojo::internal::Serialize<::private_aggregation_internals::mojom::ReportStatus>(
        Traits::status(input),
        &fragment->status);

      decltype(Traits::report_body(input)) in_report_body = Traits::report_body(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->report_body)::BaseType> report_body_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_report_body,
        report_body_fragment);

      fragment->report_body.Set(
          report_body_fragment.is_null() ? nullptr : report_body_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->report_body.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null report_body in WebUIAggregatableReport struct");
  }
};

}  // namespace mojo::internal

#endif  // CONTENT_BROWSER_PRIVATE_AGGREGATION_PRIVATE_AGGREGATION_INTERNALS_MOJOM_SEND_VALIDATION_H_