// content/browser/indexed_db/indexed_db_internals.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_INDEXED_DB_INDEXED_DB_INTERNALS_MOJOM_TEST_UTILS_H_
#define CONTENT_BROWSER_INDEXED_DB_INDEXED_DB_INTERNALS_MOJOM_TEST_UTILS_H_

#include "content/browser/indexed_db/indexed_db_internals.mojom.h"


namespace storage::mojom {


class  IdbInternalsHandlerInterceptorForTesting : public IdbInternalsHandler {
  virtual IdbInternalsHandler* GetForwardingInterface() = 0;
  void GetAllBucketsAcrossAllStorageKeys(GetAllBucketsAcrossAllStorageKeysCallback callback) override;
  void DownloadBucketData(::storage::BucketId bucketId, DownloadBucketDataCallback callback) override;
  void ForceClose(::storage::BucketId bucketId, ForceCloseCallback callback) override;
  void StartMetadataRecording(::storage::BucketId bucket_id, StartMetadataRecordingCallback callback) override;
  void StopMetadataRecording(::storage::BucketId bucket_id, StopMetadataRecordingCallback callback) override;
  void InspectClient(const ::storage::BucketClientInfo& client_info, InspectClientCallback callback) override;
};
class  IdbInternalsHandlerAsyncWaiter {
 public:
  explicit IdbInternalsHandlerAsyncWaiter(IdbInternalsHandler* proxy);

  IdbInternalsHandlerAsyncWaiter(const IdbInternalsHandlerAsyncWaiter&) = delete;
  IdbInternalsHandlerAsyncWaiter& operator=(const IdbInternalsHandlerAsyncWaiter&) = delete;

  ~IdbInternalsHandlerAsyncWaiter();
  void GetAllBucketsAcrossAllStorageKeys(
      std::optional<std::string>* out_error, std::vector<IdbPartitionMetadataPtr>* out_partitions);
  
  void DownloadBucketData(
      ::storage::BucketId bucketId, std::optional<std::string>* out_error);
  std::optional<std::string> DownloadBucketData(::storage::BucketId bucketId);
  void ForceClose(
      ::storage::BucketId bucketId, std::optional<std::string>* out_error);
  std::optional<std::string> ForceClose(::storage::BucketId bucketId);
  void StartMetadataRecording(
      ::storage::BucketId bucket_id, std::optional<std::string>* out_error);
  std::optional<std::string> StartMetadataRecording(::storage::BucketId bucket_id);
  void StopMetadataRecording(
      ::storage::BucketId bucket_id, std::optional<std::string>* out_error, std::vector<::storage::mojom::IdbBucketMetadataPtr>* out_metadata);
  
  void InspectClient(
      const ::storage::BucketClientInfo& client_info, std::optional<std::string>* out_error);
  std::optional<std::string> InspectClient(const ::storage::BucketClientInfo& client_info);

 private:
  IdbInternalsHandler* const proxy_;
};




}  // storage::mojom

#endif  // CONTENT_BROWSER_INDEXED_DB_INDEXED_DB_INTERNALS_MOJOM_TEST_UTILS_H_