// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_Runtime_h
#define content_protocol_Runtime_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace content {
namespace protocol {
namespace Runtime {
using ScriptId = String;
class DeepSerializedValue;
using RemoteObjectId = String;
using UnserializableValue = String;
class RemoteObject;
class CustomPreview;
class ObjectPreview;
class PropertyPreview;
class EntryPreview;
using Timestamp = double;
class CallFrame;
class StackTrace;
using UniqueDebuggerId = String;
class StackTraceId;

// ------------- Forward and enum declarations.

namespace ConsoleAPICalled {
namespace TypeEnum {
CONTENT_EXPORT extern const char* Log;
CONTENT_EXPORT extern const char* Debug;
CONTENT_EXPORT extern const char* Info;
CONTENT_EXPORT extern const char* Error;
CONTENT_EXPORT extern const char* Warning;
CONTENT_EXPORT extern const char* Dir;
CONTENT_EXPORT extern const char* Dirxml;
CONTENT_EXPORT extern const char* Table;
CONTENT_EXPORT extern const char* Trace;
CONTENT_EXPORT extern const char* Clear;
CONTENT_EXPORT extern const char* StartGroup;
CONTENT_EXPORT extern const char* StartGroupCollapsed;
CONTENT_EXPORT extern const char* EndGroup;
CONTENT_EXPORT extern const char* Assert;
CONTENT_EXPORT extern const char* Profile;
CONTENT_EXPORT extern const char* ProfileEnd;
CONTENT_EXPORT extern const char* Count;
CONTENT_EXPORT extern const char* TimeEnd;
} // TypeEnum
} // ConsoleAPICalled

// ------------- Type and builder declarations.

class CONTENT_EXPORT DeepSerializedValue : public ::crdtp::ProtocolObject<DeepSerializedValue> {
public:
    ~DeepSerializedValue() override;  // Defined below

    struct CONTENT_EXPORT TypeEnum {
        static const char* Undefined;
        static const char* Null;
        static const char* String;
        static const char* Number;
        static const char* Boolean;
        static const char* Bigint;
        static const char* Regexp;
        static const char* Date;
        static const char* Symbol;
        static const char* Array;
        static const char* Object;
        static const char* Function;
        static const char* Map;
        static const char* Set;
        static const char* Weakmap;
        static const char* Weakset;
        static const char* Error;
        static const char* Proxy;
        static const char* Promise;
        static const char* Typedarray;
        static const char* Arraybuffer;
        static const char* Node;
        static const char* Window;
        static const char* Generator;
    }; // TypeEnum

    String GetType() { return m_type; }
    void SetType(const String& value);  // Defined below

    bool HasValue() { return !!m_value; }
    protocol::Value* GetValue(protocol::Value* defaultValue) {
       return m_value ? m_value.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Value>& GetValue() const {
       return m_value;
    }
    void SetValue(std::unique_ptr<protocol::Value> value);  // Defined below

    bool HasObjectId() { return !!m_objectId; }
    String GetObjectId(const String& defaultValue) const {
       return m_objectId.value_or(defaultValue);
    }
    const std::optional<String>& GetObjectId() const {
       return m_objectId;
    }
    void SetObjectId(const String& value);  // Defined below

    bool HasWeakLocalObjectReference() { return !!m_weakLocalObjectReference; }
    int GetWeakLocalObjectReference(int defaultValue) const {
       return m_weakLocalObjectReference.value_or(defaultValue);
    }
    const std::optional<int>& GetWeakLocalObjectReference() const {
       return m_weakLocalObjectReference;
    }
    void SetWeakLocalObjectReference(int value);  // Defined below

    template<int STATE>
    class DeepSerializedValueBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            AllFieldsSet = (TypeSet | 0)};


        DeepSerializedValueBuilder<STATE | TypeSet>& SetType(const String& value);  // Defined below

        DeepSerializedValueBuilder<STATE>& SetValue(std::unique_ptr<protocol::Value> value);  // Defined below

        DeepSerializedValueBuilder<STATE>& SetObjectId(const String& value);  // Defined below

        DeepSerializedValueBuilder<STATE>& SetWeakLocalObjectReference(int value);  // Defined below

        std::unique_ptr<DeepSerializedValue> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class DeepSerializedValue;
        DeepSerializedValueBuilder() : m_result(new DeepSerializedValue()) { }

        template<int STEP> DeepSerializedValueBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<DeepSerializedValueBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Runtime::DeepSerializedValue> m_result;
    };

    static DeepSerializedValueBuilder<0> Create()
    {
        return DeepSerializedValueBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    DeepSerializedValue();  // Defined below

    String m_type;
    std::unique_ptr<protocol::Value> m_value;
    std::optional<String> m_objectId;
    std::optional<int> m_weakLocalObjectReference;
};


class CONTENT_EXPORT RemoteObject : public ::crdtp::ProtocolObject<RemoteObject> {
public:
    ~RemoteObject() override;  // Defined below

    struct CONTENT_EXPORT TypeEnum {
        static const char* Object;
        static const char* Function;
        static const char* Undefined;
        static const char* String;
        static const char* Number;
        static const char* Boolean;
        static const char* Symbol;
        static const char* Bigint;
    }; // TypeEnum

    String GetType() { return m_type; }
    void SetType(const String& value);  // Defined below

    struct CONTENT_EXPORT SubtypeEnum {
        static const char* Array;
        static const char* Null;
        static const char* Node;
        static const char* Regexp;
        static const char* Date;
        static const char* Map;
        static const char* Set;
        static const char* Weakmap;
        static const char* Weakset;
        static const char* Iterator;
        static const char* Generator;
        static const char* Error;
        static const char* Proxy;
        static const char* Promise;
        static const char* Typedarray;
        static const char* Arraybuffer;
        static const char* Dataview;
        static const char* Webassemblymemory;
        static const char* Wasmvalue;
        static const char* Trustedtype;
    }; // SubtypeEnum

    bool HasSubtype() { return !!m_subtype; }
    String GetSubtype(const String& defaultValue) const {
       return m_subtype.value_or(defaultValue);
    }
    const std::optional<String>& GetSubtype() const {
       return m_subtype;
    }
    void SetSubtype(const String& value);  // Defined below

    bool HasClassName() { return !!m_className; }
    String GetClassName(const String& defaultValue) const {
       return m_className.value_or(defaultValue);
    }
    const std::optional<String>& GetClassName() const {
       return m_className;
    }
    void SetClassName(const String& value);  // Defined below

    bool HasValue() { return !!m_value; }
    protocol::Value* GetValue(protocol::Value* defaultValue) {
       return m_value ? m_value.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Value>& GetValue() const {
       return m_value;
    }
    void SetValue(std::unique_ptr<protocol::Value> value);  // Defined below

    bool HasUnserializableValue() { return !!m_unserializableValue; }
    String GetUnserializableValue(const String& defaultValue) const {
       return m_unserializableValue.value_or(defaultValue);
    }
    const std::optional<String>& GetUnserializableValue() const {
       return m_unserializableValue;
    }
    void SetUnserializableValue(const String& value);  // Defined below

    bool HasDescription() { return !!m_description; }
    String GetDescription(const String& defaultValue) const {
       return m_description.value_or(defaultValue);
    }
    const std::optional<String>& GetDescription() const {
       return m_description;
    }
    void SetDescription(const String& value);  // Defined below

    bool HasDeepSerializedValue() { return !!m_deepSerializedValue; }
    protocol::Runtime::DeepSerializedValue* GetDeepSerializedValue(protocol::Runtime::DeepSerializedValue* defaultValue) {
       return m_deepSerializedValue ? m_deepSerializedValue.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Runtime::DeepSerializedValue>& GetDeepSerializedValue() const {
       return m_deepSerializedValue;
    }
    void SetDeepSerializedValue(std::unique_ptr<protocol::Runtime::DeepSerializedValue> value);  // Defined below

    bool HasObjectId() { return !!m_objectId; }
    String GetObjectId(const String& defaultValue) const {
       return m_objectId.value_or(defaultValue);
    }
    const std::optional<String>& GetObjectId() const {
       return m_objectId;
    }
    void SetObjectId(const String& value);  // Defined below

    bool HasPreview() { return !!m_preview; }
    protocol::Runtime::ObjectPreview* GetPreview(protocol::Runtime::ObjectPreview* defaultValue) {
       return m_preview ? m_preview.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Runtime::ObjectPreview>& GetPreview() const {
       return m_preview;
    }
    void SetPreview(std::unique_ptr<protocol::Runtime::ObjectPreview> value);  // Defined below

    bool HasCustomPreview() { return !!m_customPreview; }
    protocol::Runtime::CustomPreview* GetCustomPreview(protocol::Runtime::CustomPreview* defaultValue) {
       return m_customPreview ? m_customPreview.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Runtime::CustomPreview>& GetCustomPreview() const {
       return m_customPreview;
    }
    void SetCustomPreview(std::unique_ptr<protocol::Runtime::CustomPreview> value);  // Defined below

    template<int STATE>
    class RemoteObjectBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            AllFieldsSet = (TypeSet | 0)};


        RemoteObjectBuilder<STATE | TypeSet>& SetType(const String& value);  // Defined below

        RemoteObjectBuilder<STATE>& SetSubtype(const String& value);  // Defined below

        RemoteObjectBuilder<STATE>& SetClassName(const String& value);  // Defined below

        RemoteObjectBuilder<STATE>& SetValue(std::unique_ptr<protocol::Value> value);  // Defined below

        RemoteObjectBuilder<STATE>& SetUnserializableValue(const String& value);  // Defined below

        RemoteObjectBuilder<STATE>& SetDescription(const String& value);  // Defined below

        RemoteObjectBuilder<STATE>& SetDeepSerializedValue(std::unique_ptr<protocol::Runtime::DeepSerializedValue> value);  // Defined below

        RemoteObjectBuilder<STATE>& SetObjectId(const String& value);  // Defined below

        RemoteObjectBuilder<STATE>& SetPreview(std::unique_ptr<protocol::Runtime::ObjectPreview> value);  // Defined below

        RemoteObjectBuilder<STATE>& SetCustomPreview(std::unique_ptr<protocol::Runtime::CustomPreview> value);  // Defined below

        std::unique_ptr<RemoteObject> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class RemoteObject;
        RemoteObjectBuilder() : m_result(new RemoteObject()) { }

        template<int STEP> RemoteObjectBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<RemoteObjectBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Runtime::RemoteObject> m_result;
    };

    static RemoteObjectBuilder<0> Create()
    {
        return RemoteObjectBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    RemoteObject();  // Defined below

    String m_type;
    std::optional<String> m_subtype;
    std::optional<String> m_className;
    std::unique_ptr<protocol::Value> m_value;
    std::optional<String> m_unserializableValue;
    std::optional<String> m_description;
    std::unique_ptr<protocol::Runtime::DeepSerializedValue> m_deepSerializedValue;
    std::optional<String> m_objectId;
    std::unique_ptr<protocol::Runtime::ObjectPreview> m_preview;
    std::unique_ptr<protocol::Runtime::CustomPreview> m_customPreview;
};


class CONTENT_EXPORT CustomPreview : public ::crdtp::ProtocolObject<CustomPreview> {
public:
    ~CustomPreview() override;  // Defined below

    String GetHeader() { return m_header; }
    void SetHeader(const String& value);  // Defined below

    bool HasBodyGetterId() { return !!m_bodyGetterId; }
    String GetBodyGetterId(const String& defaultValue) const {
       return m_bodyGetterId.value_or(defaultValue);
    }
    const std::optional<String>& GetBodyGetterId() const {
       return m_bodyGetterId;
    }
    void SetBodyGetterId(const String& value);  // Defined below

    template<int STATE>
    class CustomPreviewBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            HeaderSet = 1 << 1,
            AllFieldsSet = (HeaderSet | 0)};


        CustomPreviewBuilder<STATE | HeaderSet>& SetHeader(const String& value);  // Defined below

        CustomPreviewBuilder<STATE>& SetBodyGetterId(const String& value);  // Defined below

        std::unique_ptr<CustomPreview> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CustomPreview;
        CustomPreviewBuilder() : m_result(new CustomPreview()) { }

        template<int STEP> CustomPreviewBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CustomPreviewBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Runtime::CustomPreview> m_result;
    };

    static CustomPreviewBuilder<0> Create()
    {
        return CustomPreviewBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CustomPreview();  // Defined below

    String m_header;
    std::optional<String> m_bodyGetterId;
};


class CONTENT_EXPORT ObjectPreview : public ::crdtp::ProtocolObject<ObjectPreview> {
public:
    ~ObjectPreview() override;  // Defined below

    struct CONTENT_EXPORT TypeEnum {
        static const char* Object;
        static const char* Function;
        static const char* Undefined;
        static const char* String;
        static const char* Number;
        static const char* Boolean;
        static const char* Symbol;
        static const char* Bigint;
    }; // TypeEnum

    String GetType() { return m_type; }
    void SetType(const String& value);  // Defined below

    struct CONTENT_EXPORT SubtypeEnum {
        static const char* Array;
        static const char* Null;
        static const char* Node;
        static const char* Regexp;
        static const char* Date;
        static const char* Map;
        static const char* Set;
        static const char* Weakmap;
        static const char* Weakset;
        static const char* Iterator;
        static const char* Generator;
        static const char* Error;
        static const char* Proxy;
        static const char* Promise;
        static const char* Typedarray;
        static const char* Arraybuffer;
        static const char* Dataview;
        static const char* Webassemblymemory;
        static const char* Wasmvalue;
        static const char* Trustedtype;
    }; // SubtypeEnum

    bool HasSubtype() { return !!m_subtype; }
    String GetSubtype(const String& defaultValue) const {
       return m_subtype.value_or(defaultValue);
    }
    const std::optional<String>& GetSubtype() const {
       return m_subtype;
    }
    void SetSubtype(const String& value);  // Defined below

    bool HasDescription() { return !!m_description; }
    String GetDescription(const String& defaultValue) const {
       return m_description.value_or(defaultValue);
    }
    const std::optional<String>& GetDescription() const {
       return m_description;
    }
    void SetDescription(const String& value);  // Defined below

    bool GetOverflow() { return m_overflow; }
    void SetOverflow(bool value);  // Defined below

    protocol::Array<protocol::Runtime::PropertyPreview>* GetProperties() { return m_properties.get(); }
    void SetProperties(std::unique_ptr<protocol::Array<protocol::Runtime::PropertyPreview>> value);  // Defined below

    bool HasEntries() { return !!m_entries; }
    protocol::Array<protocol::Runtime::EntryPreview>* GetEntries(protocol::Array<protocol::Runtime::EntryPreview>* defaultValue) {
       return m_entries ? m_entries.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Runtime::EntryPreview>>& GetEntries() const {
       return m_entries;
    }
    void SetEntries(std::unique_ptr<protocol::Array<protocol::Runtime::EntryPreview>> value);  // Defined below

    template<int STATE>
    class ObjectPreviewBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            OverflowSet = 1 << 2,
            PropertiesSet = 1 << 3,
            AllFieldsSet = (TypeSet | OverflowSet | PropertiesSet | 0)};


        ObjectPreviewBuilder<STATE | TypeSet>& SetType(const String& value);  // Defined below

        ObjectPreviewBuilder<STATE>& SetSubtype(const String& value);  // Defined below

        ObjectPreviewBuilder<STATE>& SetDescription(const String& value);  // Defined below

        ObjectPreviewBuilder<STATE | OverflowSet>& SetOverflow(bool value);  // Defined below

        ObjectPreviewBuilder<STATE | PropertiesSet>& SetProperties(std::unique_ptr<protocol::Array<protocol::Runtime::PropertyPreview>> value);  // Defined below

        ObjectPreviewBuilder<STATE>& SetEntries(std::unique_ptr<protocol::Array<protocol::Runtime::EntryPreview>> value);  // Defined below

        std::unique_ptr<ObjectPreview> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ObjectPreview;
        ObjectPreviewBuilder() : m_result(new ObjectPreview()) { }

        template<int STEP> ObjectPreviewBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ObjectPreviewBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Runtime::ObjectPreview> m_result;
    };

    static ObjectPreviewBuilder<0> Create()
    {
        return ObjectPreviewBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ObjectPreview();  // Defined below

    String m_type;
    std::optional<String> m_subtype;
    std::optional<String> m_description;
    bool m_overflow;
    std::unique_ptr<protocol::Array<protocol::Runtime::PropertyPreview>> m_properties;
    std::unique_ptr<protocol::Array<protocol::Runtime::EntryPreview>> m_entries;
};


class CONTENT_EXPORT PropertyPreview : public ::crdtp::ProtocolObject<PropertyPreview> {
public:
    ~PropertyPreview() override;  // Defined below

    String GetName() { return m_name; }
    void SetName(const String& value);  // Defined below

    struct CONTENT_EXPORT TypeEnum {
        static const char* Object;
        static const char* Function;
        static const char* Undefined;
        static const char* String;
        static const char* Number;
        static const char* Boolean;
        static const char* Symbol;
        static const char* Accessor;
        static const char* Bigint;
    }; // TypeEnum

    String GetType() { return m_type; }
    void SetType(const String& value);  // Defined below

    bool HasValue() { return !!m_value; }
    String GetValue(const String& defaultValue) const {
       return m_value.value_or(defaultValue);
    }
    const std::optional<String>& GetValue() const {
       return m_value;
    }
    void SetValue(const String& value);  // Defined below

    bool HasValuePreview() { return !!m_valuePreview; }
    protocol::Runtime::ObjectPreview* GetValuePreview(protocol::Runtime::ObjectPreview* defaultValue) {
       return m_valuePreview ? m_valuePreview.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Runtime::ObjectPreview>& GetValuePreview() const {
       return m_valuePreview;
    }
    void SetValuePreview(std::unique_ptr<protocol::Runtime::ObjectPreview> value);  // Defined below

    struct CONTENT_EXPORT SubtypeEnum {
        static const char* Array;
        static const char* Null;
        static const char* Node;
        static const char* Regexp;
        static const char* Date;
        static const char* Map;
        static const char* Set;
        static const char* Weakmap;
        static const char* Weakset;
        static const char* Iterator;
        static const char* Generator;
        static const char* Error;
        static const char* Proxy;
        static const char* Promise;
        static const char* Typedarray;
        static const char* Arraybuffer;
        static const char* Dataview;
        static const char* Webassemblymemory;
        static const char* Wasmvalue;
        static const char* Trustedtype;
    }; // SubtypeEnum

    bool HasSubtype() { return !!m_subtype; }
    String GetSubtype(const String& defaultValue) const {
       return m_subtype.value_or(defaultValue);
    }
    const std::optional<String>& GetSubtype() const {
       return m_subtype;
    }
    void SetSubtype(const String& value);  // Defined below

    template<int STATE>
    class PropertyPreviewBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            TypeSet = 1 << 2,
            AllFieldsSet = (NameSet | TypeSet | 0)};


        PropertyPreviewBuilder<STATE | NameSet>& SetName(const String& value);  // Defined below

        PropertyPreviewBuilder<STATE | TypeSet>& SetType(const String& value);  // Defined below

        PropertyPreviewBuilder<STATE>& SetValue(const String& value);  // Defined below

        PropertyPreviewBuilder<STATE>& SetValuePreview(std::unique_ptr<protocol::Runtime::ObjectPreview> value);  // Defined below

        PropertyPreviewBuilder<STATE>& SetSubtype(const String& value);  // Defined below

        std::unique_ptr<PropertyPreview> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PropertyPreview;
        PropertyPreviewBuilder() : m_result(new PropertyPreview()) { }

        template<int STEP> PropertyPreviewBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PropertyPreviewBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Runtime::PropertyPreview> m_result;
    };

    static PropertyPreviewBuilder<0> Create()
    {
        return PropertyPreviewBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PropertyPreview();  // Defined below

    String m_name;
    String m_type;
    std::optional<String> m_value;
    std::unique_ptr<protocol::Runtime::ObjectPreview> m_valuePreview;
    std::optional<String> m_subtype;
};


class CONTENT_EXPORT EntryPreview : public ::crdtp::ProtocolObject<EntryPreview> {
public:
    ~EntryPreview() override;  // Defined below

    bool HasKey() { return !!m_key; }
    protocol::Runtime::ObjectPreview* GetKey(protocol::Runtime::ObjectPreview* defaultValue) {
       return m_key ? m_key.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Runtime::ObjectPreview>& GetKey() const {
       return m_key;
    }
    void SetKey(std::unique_ptr<protocol::Runtime::ObjectPreview> value);  // Defined below

    protocol::Runtime::ObjectPreview* GetValue() { return m_value.get(); }
    void SetValue(std::unique_ptr<protocol::Runtime::ObjectPreview> value);  // Defined below

    template<int STATE>
    class EntryPreviewBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ValueSet = 1 << 1,
            AllFieldsSet = (ValueSet | 0)};


        EntryPreviewBuilder<STATE>& SetKey(std::unique_ptr<protocol::Runtime::ObjectPreview> value);  // Defined below

        EntryPreviewBuilder<STATE | ValueSet>& SetValue(std::unique_ptr<protocol::Runtime::ObjectPreview> value);  // Defined below

        std::unique_ptr<EntryPreview> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class EntryPreview;
        EntryPreviewBuilder() : m_result(new EntryPreview()) { }

        template<int STEP> EntryPreviewBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<EntryPreviewBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Runtime::EntryPreview> m_result;
    };

    static EntryPreviewBuilder<0> Create()
    {
        return EntryPreviewBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    EntryPreview();  // Defined below

    std::unique_ptr<protocol::Runtime::ObjectPreview> m_key;
    std::unique_ptr<protocol::Runtime::ObjectPreview> m_value;
};


class CONTENT_EXPORT CallFrame : public ::crdtp::ProtocolObject<CallFrame> {
public:
    ~CallFrame() override;  // Defined below

    String GetFunctionName() { return m_functionName; }
    void SetFunctionName(const String& value);  // Defined below

    String GetScriptId() { return m_scriptId; }
    void SetScriptId(const String& value);  // Defined below

    String GetUrl() { return m_url; }
    void SetUrl(const String& value);  // Defined below

    int GetLineNumber() { return m_lineNumber; }
    void SetLineNumber(int value);  // Defined below

    int GetColumnNumber() { return m_columnNumber; }
    void SetColumnNumber(int value);  // Defined below

    template<int STATE>
    class CallFrameBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FunctionNameSet = 1 << 1,
            ScriptIdSet = 1 << 2,
            UrlSet = 1 << 3,
            LineNumberSet = 1 << 4,
            ColumnNumberSet = 1 << 5,
            AllFieldsSet = (FunctionNameSet | ScriptIdSet | UrlSet | LineNumberSet | ColumnNumberSet | 0)};


        CallFrameBuilder<STATE | FunctionNameSet>& SetFunctionName(const String& value);  // Defined below

        CallFrameBuilder<STATE | ScriptIdSet>& SetScriptId(const String& value);  // Defined below

        CallFrameBuilder<STATE | UrlSet>& SetUrl(const String& value);  // Defined below

        CallFrameBuilder<STATE | LineNumberSet>& SetLineNumber(int value);  // Defined below

        CallFrameBuilder<STATE | ColumnNumberSet>& SetColumnNumber(int value);  // Defined below

        std::unique_ptr<CallFrame> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CallFrame;
        CallFrameBuilder() : m_result(new CallFrame()) { }

        template<int STEP> CallFrameBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CallFrameBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Runtime::CallFrame> m_result;
    };

    static CallFrameBuilder<0> Create()
    {
        return CallFrameBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CallFrame();  // Defined below

    String m_functionName;
    String m_scriptId;
    String m_url;
    int m_lineNumber;
    int m_columnNumber;
};


class CONTENT_EXPORT StackTrace : public ::crdtp::ProtocolObject<StackTrace> {
public:
    ~StackTrace() override;  // Defined below

    bool HasDescription() { return !!m_description; }
    String GetDescription(const String& defaultValue) const {
       return m_description.value_or(defaultValue);
    }
    const std::optional<String>& GetDescription() const {
       return m_description;
    }
    void SetDescription(const String& value);  // Defined below

    protocol::Array<protocol::Runtime::CallFrame>* GetCallFrames() { return m_callFrames.get(); }
    void SetCallFrames(std::unique_ptr<protocol::Array<protocol::Runtime::CallFrame>> value);  // Defined below

    bool HasParent() { return !!m_parent; }
    protocol::Runtime::StackTrace* GetParent(protocol::Runtime::StackTrace* defaultValue) {
       return m_parent ? m_parent.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Runtime::StackTrace>& GetParent() const {
       return m_parent;
    }
    void SetParent(std::unique_ptr<protocol::Runtime::StackTrace> value);  // Defined below

    bool HasParentId() { return !!m_parentId; }
    protocol::Runtime::StackTraceId* GetParentId(protocol::Runtime::StackTraceId* defaultValue) {
       return m_parentId ? m_parentId.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Runtime::StackTraceId>& GetParentId() const {
       return m_parentId;
    }
    void SetParentId(std::unique_ptr<protocol::Runtime::StackTraceId> value);  // Defined below

    template<int STATE>
    class StackTraceBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CallFramesSet = 1 << 1,
            AllFieldsSet = (CallFramesSet | 0)};


        StackTraceBuilder<STATE>& SetDescription(const String& value);  // Defined below

        StackTraceBuilder<STATE | CallFramesSet>& SetCallFrames(std::unique_ptr<protocol::Array<protocol::Runtime::CallFrame>> value);  // Defined below

        StackTraceBuilder<STATE>& SetParent(std::unique_ptr<protocol::Runtime::StackTrace> value);  // Defined below

        StackTraceBuilder<STATE>& SetParentId(std::unique_ptr<protocol::Runtime::StackTraceId> value);  // Defined below

        std::unique_ptr<StackTrace> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class StackTrace;
        StackTraceBuilder() : m_result(new StackTrace()) { }

        template<int STEP> StackTraceBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<StackTraceBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Runtime::StackTrace> m_result;
    };

    static StackTraceBuilder<0> Create()
    {
        return StackTraceBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    StackTrace();  // Defined below

    std::optional<String> m_description;
    std::unique_ptr<protocol::Array<protocol::Runtime::CallFrame>> m_callFrames;
    std::unique_ptr<protocol::Runtime::StackTrace> m_parent;
    std::unique_ptr<protocol::Runtime::StackTraceId> m_parentId;
};


class CONTENT_EXPORT StackTraceId : public ::crdtp::ProtocolObject<StackTraceId> {
public:
    ~StackTraceId() override;  // Defined below

    String GetId() { return m_id; }
    void SetId(const String& value);  // Defined below

    bool HasDebuggerId() { return !!m_debuggerId; }
    String GetDebuggerId(const String& defaultValue) const {
       return m_debuggerId.value_or(defaultValue);
    }
    const std::optional<String>& GetDebuggerId() const {
       return m_debuggerId;
    }
    void SetDebuggerId(const String& value);  // Defined below

    template<int STATE>
    class StackTraceIdBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            IdSet = 1 << 1,
            AllFieldsSet = (IdSet | 0)};


        StackTraceIdBuilder<STATE | IdSet>& SetId(const String& value);  // Defined below

        StackTraceIdBuilder<STATE>& SetDebuggerId(const String& value);  // Defined below

        std::unique_ptr<StackTraceId> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class StackTraceId;
        StackTraceIdBuilder() : m_result(new StackTraceId()) { }

        template<int STEP> StackTraceIdBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<StackTraceIdBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Runtime::StackTraceId> m_result;
    };

    static StackTraceIdBuilder<0> Create()
    {
        return StackTraceIdBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    StackTraceId();  // Defined below

    String m_id;
    std::optional<String> m_debuggerId;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline DeepSerializedValue::~DeepSerializedValue() = default;
inline void DeepSerializedValue::SetType(const String& value) { m_type = value; }
inline void DeepSerializedValue::SetValue(std::unique_ptr<protocol::Value> value) { m_value = std::move(value); }
inline void DeepSerializedValue::SetObjectId(const String& value) { m_objectId = value; }
inline void DeepSerializedValue::SetWeakLocalObjectReference(int value) { m_weakLocalObjectReference = value; }

template<int STATE>
inline DeepSerializedValue::DeepSerializedValueBuilder<STATE | DeepSerializedValue::DeepSerializedValueBuilder<STATE>::TypeSet>&
DeepSerializedValue::DeepSerializedValueBuilder<STATE>::SetType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->SetType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline DeepSerializedValue::DeepSerializedValueBuilder<STATE>& DeepSerializedValue::DeepSerializedValueBuilder<STATE>::SetValue(std::unique_ptr<protocol::Value> value) {
  m_result->SetValue(std::move(value));
  return *this;
}
template<int STATE>
inline DeepSerializedValue::DeepSerializedValueBuilder<STATE>& DeepSerializedValue::DeepSerializedValueBuilder<STATE>::SetObjectId(const String& value) {
  m_result->SetObjectId(value);
  return *this;
}
template<int STATE>
inline DeepSerializedValue::DeepSerializedValueBuilder<STATE>& DeepSerializedValue::DeepSerializedValueBuilder<STATE>::SetWeakLocalObjectReference(int value) {
  m_result->SetWeakLocalObjectReference(value);
  return *this;
}

inline DeepSerializedValue::DeepSerializedValue() {
}
inline RemoteObject::~RemoteObject() = default;
inline void RemoteObject::SetType(const String& value) { m_type = value; }
inline void RemoteObject::SetSubtype(const String& value) { m_subtype = value; }
inline void RemoteObject::SetClassName(const String& value) { m_className = value; }
inline void RemoteObject::SetValue(std::unique_ptr<protocol::Value> value) { m_value = std::move(value); }
inline void RemoteObject::SetUnserializableValue(const String& value) { m_unserializableValue = value; }
inline void RemoteObject::SetDescription(const String& value) { m_description = value; }
inline void RemoteObject::SetDeepSerializedValue(std::unique_ptr<protocol::Runtime::DeepSerializedValue> value) { m_deepSerializedValue = std::move(value); }
inline void RemoteObject::SetObjectId(const String& value) { m_objectId = value; }
inline void RemoteObject::SetPreview(std::unique_ptr<protocol::Runtime::ObjectPreview> value) { m_preview = std::move(value); }
inline void RemoteObject::SetCustomPreview(std::unique_ptr<protocol::Runtime::CustomPreview> value) { m_customPreview = std::move(value); }

template<int STATE>
inline RemoteObject::RemoteObjectBuilder<STATE | RemoteObject::RemoteObjectBuilder<STATE>::TypeSet>&
RemoteObject::RemoteObjectBuilder<STATE>::SetType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->SetType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline RemoteObject::RemoteObjectBuilder<STATE>& RemoteObject::RemoteObjectBuilder<STATE>::SetSubtype(const String& value) {
  m_result->SetSubtype(value);
  return *this;
}
template<int STATE>
inline RemoteObject::RemoteObjectBuilder<STATE>& RemoteObject::RemoteObjectBuilder<STATE>::SetClassName(const String& value) {
  m_result->SetClassName(value);
  return *this;
}
template<int STATE>
inline RemoteObject::RemoteObjectBuilder<STATE>& RemoteObject::RemoteObjectBuilder<STATE>::SetValue(std::unique_ptr<protocol::Value> value) {
  m_result->SetValue(std::move(value));
  return *this;
}
template<int STATE>
inline RemoteObject::RemoteObjectBuilder<STATE>& RemoteObject::RemoteObjectBuilder<STATE>::SetUnserializableValue(const String& value) {
  m_result->SetUnserializableValue(value);
  return *this;
}
template<int STATE>
inline RemoteObject::RemoteObjectBuilder<STATE>& RemoteObject::RemoteObjectBuilder<STATE>::SetDescription(const String& value) {
  m_result->SetDescription(value);
  return *this;
}
template<int STATE>
inline RemoteObject::RemoteObjectBuilder<STATE>& RemoteObject::RemoteObjectBuilder<STATE>::SetDeepSerializedValue(std::unique_ptr<protocol::Runtime::DeepSerializedValue> value) {
  m_result->SetDeepSerializedValue(std::move(value));
  return *this;
}
template<int STATE>
inline RemoteObject::RemoteObjectBuilder<STATE>& RemoteObject::RemoteObjectBuilder<STATE>::SetObjectId(const String& value) {
  m_result->SetObjectId(value);
  return *this;
}
template<int STATE>
inline RemoteObject::RemoteObjectBuilder<STATE>& RemoteObject::RemoteObjectBuilder<STATE>::SetPreview(std::unique_ptr<protocol::Runtime::ObjectPreview> value) {
  m_result->SetPreview(std::move(value));
  return *this;
}
template<int STATE>
inline RemoteObject::RemoteObjectBuilder<STATE>& RemoteObject::RemoteObjectBuilder<STATE>::SetCustomPreview(std::unique_ptr<protocol::Runtime::CustomPreview> value) {
  m_result->SetCustomPreview(std::move(value));
  return *this;
}

inline RemoteObject::RemoteObject() {
}
inline CustomPreview::~CustomPreview() = default;
inline void CustomPreview::SetHeader(const String& value) { m_header = value; }
inline void CustomPreview::SetBodyGetterId(const String& value) { m_bodyGetterId = value; }

template<int STATE>
inline CustomPreview::CustomPreviewBuilder<STATE | CustomPreview::CustomPreviewBuilder<STATE>::HeaderSet>&
CustomPreview::CustomPreviewBuilder<STATE>::SetHeader(const String& value) {
  static_assert(!(STATE & HeaderSet), "property header should not be set yet");
  m_result->SetHeader(value);
  return castState<HeaderSet>();
}
template<int STATE>
inline CustomPreview::CustomPreviewBuilder<STATE>& CustomPreview::CustomPreviewBuilder<STATE>::SetBodyGetterId(const String& value) {
  m_result->SetBodyGetterId(value);
  return *this;
}

inline CustomPreview::CustomPreview() {
}
inline ObjectPreview::~ObjectPreview() = default;
inline void ObjectPreview::SetType(const String& value) { m_type = value; }
inline void ObjectPreview::SetSubtype(const String& value) { m_subtype = value; }
inline void ObjectPreview::SetDescription(const String& value) { m_description = value; }
inline void ObjectPreview::SetOverflow(bool value) { m_overflow = value; }
inline void ObjectPreview::SetProperties(std::unique_ptr<protocol::Array<protocol::Runtime::PropertyPreview>> value) { m_properties = std::move(value); }
inline void ObjectPreview::SetEntries(std::unique_ptr<protocol::Array<protocol::Runtime::EntryPreview>> value) { m_entries = std::move(value); }

template<int STATE>
inline ObjectPreview::ObjectPreviewBuilder<STATE | ObjectPreview::ObjectPreviewBuilder<STATE>::TypeSet>&
ObjectPreview::ObjectPreviewBuilder<STATE>::SetType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->SetType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline ObjectPreview::ObjectPreviewBuilder<STATE>& ObjectPreview::ObjectPreviewBuilder<STATE>::SetSubtype(const String& value) {
  m_result->SetSubtype(value);
  return *this;
}
template<int STATE>
inline ObjectPreview::ObjectPreviewBuilder<STATE>& ObjectPreview::ObjectPreviewBuilder<STATE>::SetDescription(const String& value) {
  m_result->SetDescription(value);
  return *this;
}
template<int STATE>
inline ObjectPreview::ObjectPreviewBuilder<STATE | ObjectPreview::ObjectPreviewBuilder<STATE>::OverflowSet>&
ObjectPreview::ObjectPreviewBuilder<STATE>::SetOverflow(bool value) {
  static_assert(!(STATE & OverflowSet), "property overflow should not be set yet");
  m_result->SetOverflow(value);
  return castState<OverflowSet>();
}
template<int STATE>
inline ObjectPreview::ObjectPreviewBuilder<STATE | ObjectPreview::ObjectPreviewBuilder<STATE>::PropertiesSet>&
ObjectPreview::ObjectPreviewBuilder<STATE>::SetProperties(std::unique_ptr<protocol::Array<protocol::Runtime::PropertyPreview>> value) {
  static_assert(!(STATE & PropertiesSet), "property properties should not be set yet");
  m_result->SetProperties(std::move(value));
  return castState<PropertiesSet>();
}
template<int STATE>
inline ObjectPreview::ObjectPreviewBuilder<STATE>& ObjectPreview::ObjectPreviewBuilder<STATE>::SetEntries(std::unique_ptr<protocol::Array<protocol::Runtime::EntryPreview>> value) {
  m_result->SetEntries(std::move(value));
  return *this;
}

inline ObjectPreview::ObjectPreview() {
  m_overflow = false;
}
inline PropertyPreview::~PropertyPreview() = default;
inline void PropertyPreview::SetName(const String& value) { m_name = value; }
inline void PropertyPreview::SetType(const String& value) { m_type = value; }
inline void PropertyPreview::SetValue(const String& value) { m_value = value; }
inline void PropertyPreview::SetValuePreview(std::unique_ptr<protocol::Runtime::ObjectPreview> value) { m_valuePreview = std::move(value); }
inline void PropertyPreview::SetSubtype(const String& value) { m_subtype = value; }

template<int STATE>
inline PropertyPreview::PropertyPreviewBuilder<STATE | PropertyPreview::PropertyPreviewBuilder<STATE>::NameSet>&
PropertyPreview::PropertyPreviewBuilder<STATE>::SetName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->SetName(value);
  return castState<NameSet>();
}
template<int STATE>
inline PropertyPreview::PropertyPreviewBuilder<STATE | PropertyPreview::PropertyPreviewBuilder<STATE>::TypeSet>&
PropertyPreview::PropertyPreviewBuilder<STATE>::SetType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->SetType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline PropertyPreview::PropertyPreviewBuilder<STATE>& PropertyPreview::PropertyPreviewBuilder<STATE>::SetValue(const String& value) {
  m_result->SetValue(value);
  return *this;
}
template<int STATE>
inline PropertyPreview::PropertyPreviewBuilder<STATE>& PropertyPreview::PropertyPreviewBuilder<STATE>::SetValuePreview(std::unique_ptr<protocol::Runtime::ObjectPreview> value) {
  m_result->SetValuePreview(std::move(value));
  return *this;
}
template<int STATE>
inline PropertyPreview::PropertyPreviewBuilder<STATE>& PropertyPreview::PropertyPreviewBuilder<STATE>::SetSubtype(const String& value) {
  m_result->SetSubtype(value);
  return *this;
}

inline PropertyPreview::PropertyPreview() {
}
inline EntryPreview::~EntryPreview() = default;
inline void EntryPreview::SetKey(std::unique_ptr<protocol::Runtime::ObjectPreview> value) { m_key = std::move(value); }
inline void EntryPreview::SetValue(std::unique_ptr<protocol::Runtime::ObjectPreview> value) { m_value = std::move(value); }

template<int STATE>
inline EntryPreview::EntryPreviewBuilder<STATE>& EntryPreview::EntryPreviewBuilder<STATE>::SetKey(std::unique_ptr<protocol::Runtime::ObjectPreview> value) {
  m_result->SetKey(std::move(value));
  return *this;
}
template<int STATE>
inline EntryPreview::EntryPreviewBuilder<STATE | EntryPreview::EntryPreviewBuilder<STATE>::ValueSet>&
EntryPreview::EntryPreviewBuilder<STATE>::SetValue(std::unique_ptr<protocol::Runtime::ObjectPreview> value) {
  static_assert(!(STATE & ValueSet), "property value should not be set yet");
  m_result->SetValue(std::move(value));
  return castState<ValueSet>();
}

inline EntryPreview::EntryPreview() {
}
inline CallFrame::~CallFrame() = default;
inline void CallFrame::SetFunctionName(const String& value) { m_functionName = value; }
inline void CallFrame::SetScriptId(const String& value) { m_scriptId = value; }
inline void CallFrame::SetUrl(const String& value) { m_url = value; }
inline void CallFrame::SetLineNumber(int value) { m_lineNumber = value; }
inline void CallFrame::SetColumnNumber(int value) { m_columnNumber = value; }

template<int STATE>
inline CallFrame::CallFrameBuilder<STATE | CallFrame::CallFrameBuilder<STATE>::FunctionNameSet>&
CallFrame::CallFrameBuilder<STATE>::SetFunctionName(const String& value) {
  static_assert(!(STATE & FunctionNameSet), "property functionName should not be set yet");
  m_result->SetFunctionName(value);
  return castState<FunctionNameSet>();
}
template<int STATE>
inline CallFrame::CallFrameBuilder<STATE | CallFrame::CallFrameBuilder<STATE>::ScriptIdSet>&
CallFrame::CallFrameBuilder<STATE>::SetScriptId(const String& value) {
  static_assert(!(STATE & ScriptIdSet), "property scriptId should not be set yet");
  m_result->SetScriptId(value);
  return castState<ScriptIdSet>();
}
template<int STATE>
inline CallFrame::CallFrameBuilder<STATE | CallFrame::CallFrameBuilder<STATE>::UrlSet>&
CallFrame::CallFrameBuilder<STATE>::SetUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->SetUrl(value);
  return castState<UrlSet>();
}
template<int STATE>
inline CallFrame::CallFrameBuilder<STATE | CallFrame::CallFrameBuilder<STATE>::LineNumberSet>&
CallFrame::CallFrameBuilder<STATE>::SetLineNumber(int value) {
  static_assert(!(STATE & LineNumberSet), "property lineNumber should not be set yet");
  m_result->SetLineNumber(value);
  return castState<LineNumberSet>();
}
template<int STATE>
inline CallFrame::CallFrameBuilder<STATE | CallFrame::CallFrameBuilder<STATE>::ColumnNumberSet>&
CallFrame::CallFrameBuilder<STATE>::SetColumnNumber(int value) {
  static_assert(!(STATE & ColumnNumberSet), "property columnNumber should not be set yet");
  m_result->SetColumnNumber(value);
  return castState<ColumnNumberSet>();
}

inline CallFrame::CallFrame() {
  m_lineNumber = 0;
  m_columnNumber = 0;
}
inline StackTrace::~StackTrace() = default;
inline void StackTrace::SetDescription(const String& value) { m_description = value; }
inline void StackTrace::SetCallFrames(std::unique_ptr<protocol::Array<protocol::Runtime::CallFrame>> value) { m_callFrames = std::move(value); }
inline void StackTrace::SetParent(std::unique_ptr<protocol::Runtime::StackTrace> value) { m_parent = std::move(value); }
inline void StackTrace::SetParentId(std::unique_ptr<protocol::Runtime::StackTraceId> value) { m_parentId = std::move(value); }

template<int STATE>
inline StackTrace::StackTraceBuilder<STATE>& StackTrace::StackTraceBuilder<STATE>::SetDescription(const String& value) {
  m_result->SetDescription(value);
  return *this;
}
template<int STATE>
inline StackTrace::StackTraceBuilder<STATE | StackTrace::StackTraceBuilder<STATE>::CallFramesSet>&
StackTrace::StackTraceBuilder<STATE>::SetCallFrames(std::unique_ptr<protocol::Array<protocol::Runtime::CallFrame>> value) {
  static_assert(!(STATE & CallFramesSet), "property callFrames should not be set yet");
  m_result->SetCallFrames(std::move(value));
  return castState<CallFramesSet>();
}
template<int STATE>
inline StackTrace::StackTraceBuilder<STATE>& StackTrace::StackTraceBuilder<STATE>::SetParent(std::unique_ptr<protocol::Runtime::StackTrace> value) {
  m_result->SetParent(std::move(value));
  return *this;
}
template<int STATE>
inline StackTrace::StackTraceBuilder<STATE>& StackTrace::StackTraceBuilder<STATE>::SetParentId(std::unique_ptr<protocol::Runtime::StackTraceId> value) {
  m_result->SetParentId(std::move(value));
  return *this;
}

inline StackTrace::StackTrace() {
}
inline StackTraceId::~StackTraceId() = default;
inline void StackTraceId::SetId(const String& value) { m_id = value; }
inline void StackTraceId::SetDebuggerId(const String& value) { m_debuggerId = value; }

template<int STATE>
inline StackTraceId::StackTraceIdBuilder<STATE | StackTraceId::StackTraceIdBuilder<STATE>::IdSet>&
StackTraceId::StackTraceIdBuilder<STATE>::SetId(const String& value) {
  static_assert(!(STATE & IdSet), "property id should not be set yet");
  m_result->SetId(value);
  return castState<IdSet>();
}
template<int STATE>
inline StackTraceId::StackTraceIdBuilder<STATE>& StackTraceId::StackTraceIdBuilder<STATE>::SetDebuggerId(const String& value) {
  m_result->SetDebuggerId(value);
  return *this;
}

inline StackTraceId::StackTraceId() {
}

// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }


    virtual DispatchResponse Disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Runtime
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_Runtime_h)
