// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_Overlay_h
#define content_protocol_Overlay_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "content/browser/devtools/protocol/dom.h"
#include "content/browser/devtools/protocol/page.h"
#include "content/browser/devtools/protocol/runtime.h"

namespace content {
namespace protocol {
namespace Overlay {
class GridHighlightConfig;
class FlexContainerHighlightConfig;
class FlexItemHighlightConfig;
class LineStyle;
class BoxStyle;
using ContrastAlgorithm = String;
class HighlightConfig;
using ColorFormat = String;
class ContainerQueryContainerHighlightConfig;
using InspectMode = String;

// ------------- Forward and enum declarations.

namespace ContrastAlgorithmEnum {
CONTENT_EXPORT extern const char Aa[];
CONTENT_EXPORT extern const char Aaa[];
CONTENT_EXPORT extern const char Apca[];
} // namespace ContrastAlgorithmEnum

namespace ColorFormatEnum {
CONTENT_EXPORT extern const char Rgb[];
CONTENT_EXPORT extern const char Hsl[];
CONTENT_EXPORT extern const char Hwb[];
CONTENT_EXPORT extern const char Hex[];
} // namespace ColorFormatEnum

namespace InspectModeEnum {
CONTENT_EXPORT extern const char SearchForNode[];
CONTENT_EXPORT extern const char SearchForUAShadowDOM[];
CONTENT_EXPORT extern const char CaptureAreaScreenshot[];
CONTENT_EXPORT extern const char None[];
} // namespace InspectModeEnum

// ------------- Type and builder declarations.

class CONTENT_EXPORT GridHighlightConfig : public ::crdtp::ProtocolObject<GridHighlightConfig> {
public:
    ~GridHighlightConfig() override;  // Defined below

    bool HasShowGridExtensionLines() { return !!m_showGridExtensionLines; }
    bool GetShowGridExtensionLines(bool defaultValue) const {
       return m_showGridExtensionLines.value_or(defaultValue);
    }
    const std::optional<bool>& GetShowGridExtensionLines() const {
       return m_showGridExtensionLines;
    }
    void SetShowGridExtensionLines(bool value);  // Defined below

    bool HasShowPositiveLineNumbers() { return !!m_showPositiveLineNumbers; }
    bool GetShowPositiveLineNumbers(bool defaultValue) const {
       return m_showPositiveLineNumbers.value_or(defaultValue);
    }
    const std::optional<bool>& GetShowPositiveLineNumbers() const {
       return m_showPositiveLineNumbers;
    }
    void SetShowPositiveLineNumbers(bool value);  // Defined below

    bool HasShowNegativeLineNumbers() { return !!m_showNegativeLineNumbers; }
    bool GetShowNegativeLineNumbers(bool defaultValue) const {
       return m_showNegativeLineNumbers.value_or(defaultValue);
    }
    const std::optional<bool>& GetShowNegativeLineNumbers() const {
       return m_showNegativeLineNumbers;
    }
    void SetShowNegativeLineNumbers(bool value);  // Defined below

    bool HasShowAreaNames() { return !!m_showAreaNames; }
    bool GetShowAreaNames(bool defaultValue) const {
       return m_showAreaNames.value_or(defaultValue);
    }
    const std::optional<bool>& GetShowAreaNames() const {
       return m_showAreaNames;
    }
    void SetShowAreaNames(bool value);  // Defined below

    bool HasShowLineNames() { return !!m_showLineNames; }
    bool GetShowLineNames(bool defaultValue) const {
       return m_showLineNames.value_or(defaultValue);
    }
    const std::optional<bool>& GetShowLineNames() const {
       return m_showLineNames;
    }
    void SetShowLineNames(bool value);  // Defined below

    bool HasShowTrackSizes() { return !!m_showTrackSizes; }
    bool GetShowTrackSizes(bool defaultValue) const {
       return m_showTrackSizes.value_or(defaultValue);
    }
    const std::optional<bool>& GetShowTrackSizes() const {
       return m_showTrackSizes;
    }
    void SetShowTrackSizes(bool value);  // Defined below

    bool HasGridBorderColor() { return !!m_gridBorderColor; }
    protocol::DOM::RGBA* GetGridBorderColor(protocol::DOM::RGBA* defaultValue) {
       return m_gridBorderColor ? m_gridBorderColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& GetGridBorderColor() const {
       return m_gridBorderColor;
    }
    void SetGridBorderColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

    bool HasCellBorderColor() { return !!m_cellBorderColor; }
    protocol::DOM::RGBA* GetCellBorderColor(protocol::DOM::RGBA* defaultValue) {
       return m_cellBorderColor ? m_cellBorderColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& GetCellBorderColor() const {
       return m_cellBorderColor;
    }
    void SetCellBorderColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

    bool HasRowLineColor() { return !!m_rowLineColor; }
    protocol::DOM::RGBA* GetRowLineColor(protocol::DOM::RGBA* defaultValue) {
       return m_rowLineColor ? m_rowLineColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& GetRowLineColor() const {
       return m_rowLineColor;
    }
    void SetRowLineColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

    bool HasColumnLineColor() { return !!m_columnLineColor; }
    protocol::DOM::RGBA* GetColumnLineColor(protocol::DOM::RGBA* defaultValue) {
       return m_columnLineColor ? m_columnLineColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& GetColumnLineColor() const {
       return m_columnLineColor;
    }
    void SetColumnLineColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

    bool HasGridBorderDash() { return !!m_gridBorderDash; }
    bool GetGridBorderDash(bool defaultValue) const {
       return m_gridBorderDash.value_or(defaultValue);
    }
    const std::optional<bool>& GetGridBorderDash() const {
       return m_gridBorderDash;
    }
    void SetGridBorderDash(bool value);  // Defined below

    bool HasCellBorderDash() { return !!m_cellBorderDash; }
    bool GetCellBorderDash(bool defaultValue) const {
       return m_cellBorderDash.value_or(defaultValue);
    }
    const std::optional<bool>& GetCellBorderDash() const {
       return m_cellBorderDash;
    }
    void SetCellBorderDash(bool value);  // Defined below

    bool HasRowLineDash() { return !!m_rowLineDash; }
    bool GetRowLineDash(bool defaultValue) const {
       return m_rowLineDash.value_or(defaultValue);
    }
    const std::optional<bool>& GetRowLineDash() const {
       return m_rowLineDash;
    }
    void SetRowLineDash(bool value);  // Defined below

    bool HasColumnLineDash() { return !!m_columnLineDash; }
    bool GetColumnLineDash(bool defaultValue) const {
       return m_columnLineDash.value_or(defaultValue);
    }
    const std::optional<bool>& GetColumnLineDash() const {
       return m_columnLineDash;
    }
    void SetColumnLineDash(bool value);  // Defined below

    bool HasRowGapColor() { return !!m_rowGapColor; }
    protocol::DOM::RGBA* GetRowGapColor(protocol::DOM::RGBA* defaultValue) {
       return m_rowGapColor ? m_rowGapColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& GetRowGapColor() const {
       return m_rowGapColor;
    }
    void SetRowGapColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

    bool HasRowHatchColor() { return !!m_rowHatchColor; }
    protocol::DOM::RGBA* GetRowHatchColor(protocol::DOM::RGBA* defaultValue) {
       return m_rowHatchColor ? m_rowHatchColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& GetRowHatchColor() const {
       return m_rowHatchColor;
    }
    void SetRowHatchColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

    bool HasColumnGapColor() { return !!m_columnGapColor; }
    protocol::DOM::RGBA* GetColumnGapColor(protocol::DOM::RGBA* defaultValue) {
       return m_columnGapColor ? m_columnGapColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& GetColumnGapColor() const {
       return m_columnGapColor;
    }
    void SetColumnGapColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

    bool HasColumnHatchColor() { return !!m_columnHatchColor; }
    protocol::DOM::RGBA* GetColumnHatchColor(protocol::DOM::RGBA* defaultValue) {
       return m_columnHatchColor ? m_columnHatchColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& GetColumnHatchColor() const {
       return m_columnHatchColor;
    }
    void SetColumnHatchColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

    bool HasAreaBorderColor() { return !!m_areaBorderColor; }
    protocol::DOM::RGBA* GetAreaBorderColor(protocol::DOM::RGBA* defaultValue) {
       return m_areaBorderColor ? m_areaBorderColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& GetAreaBorderColor() const {
       return m_areaBorderColor;
    }
    void SetAreaBorderColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

    bool HasGridBackgroundColor() { return !!m_gridBackgroundColor; }
    protocol::DOM::RGBA* GetGridBackgroundColor(protocol::DOM::RGBA* defaultValue) {
       return m_gridBackgroundColor ? m_gridBackgroundColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& GetGridBackgroundColor() const {
       return m_gridBackgroundColor;
    }
    void SetGridBackgroundColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

    template<int STATE>
    class GridHighlightConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        GridHighlightConfigBuilder<STATE>& SetShowGridExtensionLines(bool value);  // Defined below

        GridHighlightConfigBuilder<STATE>& SetShowPositiveLineNumbers(bool value);  // Defined below

        GridHighlightConfigBuilder<STATE>& SetShowNegativeLineNumbers(bool value);  // Defined below

        GridHighlightConfigBuilder<STATE>& SetShowAreaNames(bool value);  // Defined below

        GridHighlightConfigBuilder<STATE>& SetShowLineNames(bool value);  // Defined below

        GridHighlightConfigBuilder<STATE>& SetShowTrackSizes(bool value);  // Defined below

        GridHighlightConfigBuilder<STATE>& SetGridBorderColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

        GridHighlightConfigBuilder<STATE>& SetCellBorderColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

        GridHighlightConfigBuilder<STATE>& SetRowLineColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

        GridHighlightConfigBuilder<STATE>& SetColumnLineColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

        GridHighlightConfigBuilder<STATE>& SetGridBorderDash(bool value);  // Defined below

        GridHighlightConfigBuilder<STATE>& SetCellBorderDash(bool value);  // Defined below

        GridHighlightConfigBuilder<STATE>& SetRowLineDash(bool value);  // Defined below

        GridHighlightConfigBuilder<STATE>& SetColumnLineDash(bool value);  // Defined below

        GridHighlightConfigBuilder<STATE>& SetRowGapColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

        GridHighlightConfigBuilder<STATE>& SetRowHatchColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

        GridHighlightConfigBuilder<STATE>& SetColumnGapColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

        GridHighlightConfigBuilder<STATE>& SetColumnHatchColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

        GridHighlightConfigBuilder<STATE>& SetAreaBorderColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

        GridHighlightConfigBuilder<STATE>& SetGridBackgroundColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

        std::unique_ptr<GridHighlightConfig> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class GridHighlightConfig;
        GridHighlightConfigBuilder() : m_result(new GridHighlightConfig()) { }

        template<int STEP> GridHighlightConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<GridHighlightConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Overlay::GridHighlightConfig> m_result;
    };

    static GridHighlightConfigBuilder<0> Create()
    {
        return GridHighlightConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    GridHighlightConfig();  // Defined below

    std::optional<bool> m_showGridExtensionLines;
    std::optional<bool> m_showPositiveLineNumbers;
    std::optional<bool> m_showNegativeLineNumbers;
    std::optional<bool> m_showAreaNames;
    std::optional<bool> m_showLineNames;
    std::optional<bool> m_showTrackSizes;
    std::unique_ptr<protocol::DOM::RGBA> m_gridBorderColor;
    std::unique_ptr<protocol::DOM::RGBA> m_cellBorderColor;
    std::unique_ptr<protocol::DOM::RGBA> m_rowLineColor;
    std::unique_ptr<protocol::DOM::RGBA> m_columnLineColor;
    std::optional<bool> m_gridBorderDash;
    std::optional<bool> m_cellBorderDash;
    std::optional<bool> m_rowLineDash;
    std::optional<bool> m_columnLineDash;
    std::unique_ptr<protocol::DOM::RGBA> m_rowGapColor;
    std::unique_ptr<protocol::DOM::RGBA> m_rowHatchColor;
    std::unique_ptr<protocol::DOM::RGBA> m_columnGapColor;
    std::unique_ptr<protocol::DOM::RGBA> m_columnHatchColor;
    std::unique_ptr<protocol::DOM::RGBA> m_areaBorderColor;
    std::unique_ptr<protocol::DOM::RGBA> m_gridBackgroundColor;
};


class CONTENT_EXPORT FlexContainerHighlightConfig : public ::crdtp::ProtocolObject<FlexContainerHighlightConfig> {
public:
    ~FlexContainerHighlightConfig() override;  // Defined below

    bool HasContainerBorder() { return !!m_containerBorder; }
    protocol::Overlay::LineStyle* GetContainerBorder(protocol::Overlay::LineStyle* defaultValue) {
       return m_containerBorder ? m_containerBorder.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::LineStyle>& GetContainerBorder() const {
       return m_containerBorder;
    }
    void SetContainerBorder(std::unique_ptr<protocol::Overlay::LineStyle> value);  // Defined below

    bool HasLineSeparator() { return !!m_lineSeparator; }
    protocol::Overlay::LineStyle* GetLineSeparator(protocol::Overlay::LineStyle* defaultValue) {
       return m_lineSeparator ? m_lineSeparator.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::LineStyle>& GetLineSeparator() const {
       return m_lineSeparator;
    }
    void SetLineSeparator(std::unique_ptr<protocol::Overlay::LineStyle> value);  // Defined below

    bool HasItemSeparator() { return !!m_itemSeparator; }
    protocol::Overlay::LineStyle* GetItemSeparator(protocol::Overlay::LineStyle* defaultValue) {
       return m_itemSeparator ? m_itemSeparator.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::LineStyle>& GetItemSeparator() const {
       return m_itemSeparator;
    }
    void SetItemSeparator(std::unique_ptr<protocol::Overlay::LineStyle> value);  // Defined below

    bool HasMainDistributedSpace() { return !!m_mainDistributedSpace; }
    protocol::Overlay::BoxStyle* GetMainDistributedSpace(protocol::Overlay::BoxStyle* defaultValue) {
       return m_mainDistributedSpace ? m_mainDistributedSpace.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::BoxStyle>& GetMainDistributedSpace() const {
       return m_mainDistributedSpace;
    }
    void SetMainDistributedSpace(std::unique_ptr<protocol::Overlay::BoxStyle> value);  // Defined below

    bool HasCrossDistributedSpace() { return !!m_crossDistributedSpace; }
    protocol::Overlay::BoxStyle* GetCrossDistributedSpace(protocol::Overlay::BoxStyle* defaultValue) {
       return m_crossDistributedSpace ? m_crossDistributedSpace.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::BoxStyle>& GetCrossDistributedSpace() const {
       return m_crossDistributedSpace;
    }
    void SetCrossDistributedSpace(std::unique_ptr<protocol::Overlay::BoxStyle> value);  // Defined below

    bool HasRowGapSpace() { return !!m_rowGapSpace; }
    protocol::Overlay::BoxStyle* GetRowGapSpace(protocol::Overlay::BoxStyle* defaultValue) {
       return m_rowGapSpace ? m_rowGapSpace.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::BoxStyle>& GetRowGapSpace() const {
       return m_rowGapSpace;
    }
    void SetRowGapSpace(std::unique_ptr<protocol::Overlay::BoxStyle> value);  // Defined below

    bool HasColumnGapSpace() { return !!m_columnGapSpace; }
    protocol::Overlay::BoxStyle* GetColumnGapSpace(protocol::Overlay::BoxStyle* defaultValue) {
       return m_columnGapSpace ? m_columnGapSpace.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::BoxStyle>& GetColumnGapSpace() const {
       return m_columnGapSpace;
    }
    void SetColumnGapSpace(std::unique_ptr<protocol::Overlay::BoxStyle> value);  // Defined below

    bool HasCrossAlignment() { return !!m_crossAlignment; }
    protocol::Overlay::LineStyle* GetCrossAlignment(protocol::Overlay::LineStyle* defaultValue) {
       return m_crossAlignment ? m_crossAlignment.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::LineStyle>& GetCrossAlignment() const {
       return m_crossAlignment;
    }
    void SetCrossAlignment(std::unique_ptr<protocol::Overlay::LineStyle> value);  // Defined below

    template<int STATE>
    class FlexContainerHighlightConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        FlexContainerHighlightConfigBuilder<STATE>& SetContainerBorder(std::unique_ptr<protocol::Overlay::LineStyle> value);  // Defined below

        FlexContainerHighlightConfigBuilder<STATE>& SetLineSeparator(std::unique_ptr<protocol::Overlay::LineStyle> value);  // Defined below

        FlexContainerHighlightConfigBuilder<STATE>& SetItemSeparator(std::unique_ptr<protocol::Overlay::LineStyle> value);  // Defined below

        FlexContainerHighlightConfigBuilder<STATE>& SetMainDistributedSpace(std::unique_ptr<protocol::Overlay::BoxStyle> value);  // Defined below

        FlexContainerHighlightConfigBuilder<STATE>& SetCrossDistributedSpace(std::unique_ptr<protocol::Overlay::BoxStyle> value);  // Defined below

        FlexContainerHighlightConfigBuilder<STATE>& SetRowGapSpace(std::unique_ptr<protocol::Overlay::BoxStyle> value);  // Defined below

        FlexContainerHighlightConfigBuilder<STATE>& SetColumnGapSpace(std::unique_ptr<protocol::Overlay::BoxStyle> value);  // Defined below

        FlexContainerHighlightConfigBuilder<STATE>& SetCrossAlignment(std::unique_ptr<protocol::Overlay::LineStyle> value);  // Defined below

        std::unique_ptr<FlexContainerHighlightConfig> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FlexContainerHighlightConfig;
        FlexContainerHighlightConfigBuilder() : m_result(new FlexContainerHighlightConfig()) { }

        template<int STEP> FlexContainerHighlightConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FlexContainerHighlightConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Overlay::FlexContainerHighlightConfig> m_result;
    };

    static FlexContainerHighlightConfigBuilder<0> Create()
    {
        return FlexContainerHighlightConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FlexContainerHighlightConfig();  // Defined below

    std::unique_ptr<protocol::Overlay::LineStyle> m_containerBorder;
    std::unique_ptr<protocol::Overlay::LineStyle> m_lineSeparator;
    std::unique_ptr<protocol::Overlay::LineStyle> m_itemSeparator;
    std::unique_ptr<protocol::Overlay::BoxStyle> m_mainDistributedSpace;
    std::unique_ptr<protocol::Overlay::BoxStyle> m_crossDistributedSpace;
    std::unique_ptr<protocol::Overlay::BoxStyle> m_rowGapSpace;
    std::unique_ptr<protocol::Overlay::BoxStyle> m_columnGapSpace;
    std::unique_ptr<protocol::Overlay::LineStyle> m_crossAlignment;
};


class CONTENT_EXPORT FlexItemHighlightConfig : public ::crdtp::ProtocolObject<FlexItemHighlightConfig> {
public:
    ~FlexItemHighlightConfig() override;  // Defined below

    bool HasBaseSizeBox() { return !!m_baseSizeBox; }
    protocol::Overlay::BoxStyle* GetBaseSizeBox(protocol::Overlay::BoxStyle* defaultValue) {
       return m_baseSizeBox ? m_baseSizeBox.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::BoxStyle>& GetBaseSizeBox() const {
       return m_baseSizeBox;
    }
    void SetBaseSizeBox(std::unique_ptr<protocol::Overlay::BoxStyle> value);  // Defined below

    bool HasBaseSizeBorder() { return !!m_baseSizeBorder; }
    protocol::Overlay::LineStyle* GetBaseSizeBorder(protocol::Overlay::LineStyle* defaultValue) {
       return m_baseSizeBorder ? m_baseSizeBorder.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::LineStyle>& GetBaseSizeBorder() const {
       return m_baseSizeBorder;
    }
    void SetBaseSizeBorder(std::unique_ptr<protocol::Overlay::LineStyle> value);  // Defined below

    bool HasFlexibilityArrow() { return !!m_flexibilityArrow; }
    protocol::Overlay::LineStyle* GetFlexibilityArrow(protocol::Overlay::LineStyle* defaultValue) {
       return m_flexibilityArrow ? m_flexibilityArrow.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::LineStyle>& GetFlexibilityArrow() const {
       return m_flexibilityArrow;
    }
    void SetFlexibilityArrow(std::unique_ptr<protocol::Overlay::LineStyle> value);  // Defined below

    template<int STATE>
    class FlexItemHighlightConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        FlexItemHighlightConfigBuilder<STATE>& SetBaseSizeBox(std::unique_ptr<protocol::Overlay::BoxStyle> value);  // Defined below

        FlexItemHighlightConfigBuilder<STATE>& SetBaseSizeBorder(std::unique_ptr<protocol::Overlay::LineStyle> value);  // Defined below

        FlexItemHighlightConfigBuilder<STATE>& SetFlexibilityArrow(std::unique_ptr<protocol::Overlay::LineStyle> value);  // Defined below

        std::unique_ptr<FlexItemHighlightConfig> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FlexItemHighlightConfig;
        FlexItemHighlightConfigBuilder() : m_result(new FlexItemHighlightConfig()) { }

        template<int STEP> FlexItemHighlightConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FlexItemHighlightConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Overlay::FlexItemHighlightConfig> m_result;
    };

    static FlexItemHighlightConfigBuilder<0> Create()
    {
        return FlexItemHighlightConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FlexItemHighlightConfig();  // Defined below

    std::unique_ptr<protocol::Overlay::BoxStyle> m_baseSizeBox;
    std::unique_ptr<protocol::Overlay::LineStyle> m_baseSizeBorder;
    std::unique_ptr<protocol::Overlay::LineStyle> m_flexibilityArrow;
};


class CONTENT_EXPORT LineStyle : public ::crdtp::ProtocolObject<LineStyle> {
public:
    ~LineStyle() override;  // Defined below

    bool HasColor() { return !!m_color; }
    protocol::DOM::RGBA* GetColor(protocol::DOM::RGBA* defaultValue) {
       return m_color ? m_color.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& GetColor() const {
       return m_color;
    }
    void SetColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

    struct CONTENT_EXPORT PatternEnum {
        static const char* Dashed;
        static const char* Dotted;
    }; // PatternEnum

    bool HasPattern() { return !!m_pattern; }
    String GetPattern(const String& defaultValue) const {
       return m_pattern.value_or(defaultValue);
    }
    const std::optional<String>& GetPattern() const {
       return m_pattern;
    }
    void SetPattern(const String& value);  // Defined below

    template<int STATE>
    class LineStyleBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        LineStyleBuilder<STATE>& SetColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

        LineStyleBuilder<STATE>& SetPattern(const String& value);  // Defined below

        std::unique_ptr<LineStyle> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class LineStyle;
        LineStyleBuilder() : m_result(new LineStyle()) { }

        template<int STEP> LineStyleBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<LineStyleBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Overlay::LineStyle> m_result;
    };

    static LineStyleBuilder<0> Create()
    {
        return LineStyleBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    LineStyle();  // Defined below

    std::unique_ptr<protocol::DOM::RGBA> m_color;
    std::optional<String> m_pattern;
};


class CONTENT_EXPORT BoxStyle : public ::crdtp::ProtocolObject<BoxStyle> {
public:
    ~BoxStyle() override;  // Defined below

    bool HasFillColor() { return !!m_fillColor; }
    protocol::DOM::RGBA* GetFillColor(protocol::DOM::RGBA* defaultValue) {
       return m_fillColor ? m_fillColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& GetFillColor() const {
       return m_fillColor;
    }
    void SetFillColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

    bool HasHatchColor() { return !!m_hatchColor; }
    protocol::DOM::RGBA* GetHatchColor(protocol::DOM::RGBA* defaultValue) {
       return m_hatchColor ? m_hatchColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& GetHatchColor() const {
       return m_hatchColor;
    }
    void SetHatchColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

    template<int STATE>
    class BoxStyleBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        BoxStyleBuilder<STATE>& SetFillColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

        BoxStyleBuilder<STATE>& SetHatchColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

        std::unique_ptr<BoxStyle> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class BoxStyle;
        BoxStyleBuilder() : m_result(new BoxStyle()) { }

        template<int STEP> BoxStyleBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BoxStyleBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Overlay::BoxStyle> m_result;
    };

    static BoxStyleBuilder<0> Create()
    {
        return BoxStyleBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    BoxStyle();  // Defined below

    std::unique_ptr<protocol::DOM::RGBA> m_fillColor;
    std::unique_ptr<protocol::DOM::RGBA> m_hatchColor;
};


class CONTENT_EXPORT HighlightConfig : public ::crdtp::ProtocolObject<HighlightConfig> {
public:
    ~HighlightConfig() override;  // Defined below

    bool HasShowInfo() { return !!m_showInfo; }
    bool GetShowInfo(bool defaultValue) const {
       return m_showInfo.value_or(defaultValue);
    }
    const std::optional<bool>& GetShowInfo() const {
       return m_showInfo;
    }
    void SetShowInfo(bool value);  // Defined below

    bool HasShowStyles() { return !!m_showStyles; }
    bool GetShowStyles(bool defaultValue) const {
       return m_showStyles.value_or(defaultValue);
    }
    const std::optional<bool>& GetShowStyles() const {
       return m_showStyles;
    }
    void SetShowStyles(bool value);  // Defined below

    bool HasShowRulers() { return !!m_showRulers; }
    bool GetShowRulers(bool defaultValue) const {
       return m_showRulers.value_or(defaultValue);
    }
    const std::optional<bool>& GetShowRulers() const {
       return m_showRulers;
    }
    void SetShowRulers(bool value);  // Defined below

    bool HasShowAccessibilityInfo() { return !!m_showAccessibilityInfo; }
    bool GetShowAccessibilityInfo(bool defaultValue) const {
       return m_showAccessibilityInfo.value_or(defaultValue);
    }
    const std::optional<bool>& GetShowAccessibilityInfo() const {
       return m_showAccessibilityInfo;
    }
    void SetShowAccessibilityInfo(bool value);  // Defined below

    bool HasShowExtensionLines() { return !!m_showExtensionLines; }
    bool GetShowExtensionLines(bool defaultValue) const {
       return m_showExtensionLines.value_or(defaultValue);
    }
    const std::optional<bool>& GetShowExtensionLines() const {
       return m_showExtensionLines;
    }
    void SetShowExtensionLines(bool value);  // Defined below

    bool HasContentColor() { return !!m_contentColor; }
    protocol::DOM::RGBA* GetContentColor(protocol::DOM::RGBA* defaultValue) {
       return m_contentColor ? m_contentColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& GetContentColor() const {
       return m_contentColor;
    }
    void SetContentColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

    bool HasPaddingColor() { return !!m_paddingColor; }
    protocol::DOM::RGBA* GetPaddingColor(protocol::DOM::RGBA* defaultValue) {
       return m_paddingColor ? m_paddingColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& GetPaddingColor() const {
       return m_paddingColor;
    }
    void SetPaddingColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

    bool HasBorderColor() { return !!m_borderColor; }
    protocol::DOM::RGBA* GetBorderColor(protocol::DOM::RGBA* defaultValue) {
       return m_borderColor ? m_borderColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& GetBorderColor() const {
       return m_borderColor;
    }
    void SetBorderColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

    bool HasMarginColor() { return !!m_marginColor; }
    protocol::DOM::RGBA* GetMarginColor(protocol::DOM::RGBA* defaultValue) {
       return m_marginColor ? m_marginColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& GetMarginColor() const {
       return m_marginColor;
    }
    void SetMarginColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

    bool HasEventTargetColor() { return !!m_eventTargetColor; }
    protocol::DOM::RGBA* GetEventTargetColor(protocol::DOM::RGBA* defaultValue) {
       return m_eventTargetColor ? m_eventTargetColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& GetEventTargetColor() const {
       return m_eventTargetColor;
    }
    void SetEventTargetColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

    bool HasShapeColor() { return !!m_shapeColor; }
    protocol::DOM::RGBA* GetShapeColor(protocol::DOM::RGBA* defaultValue) {
       return m_shapeColor ? m_shapeColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& GetShapeColor() const {
       return m_shapeColor;
    }
    void SetShapeColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

    bool HasShapeMarginColor() { return !!m_shapeMarginColor; }
    protocol::DOM::RGBA* GetShapeMarginColor(protocol::DOM::RGBA* defaultValue) {
       return m_shapeMarginColor ? m_shapeMarginColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& GetShapeMarginColor() const {
       return m_shapeMarginColor;
    }
    void SetShapeMarginColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

    bool HasCssGridColor() { return !!m_cssGridColor; }
    protocol::DOM::RGBA* GetCssGridColor(protocol::DOM::RGBA* defaultValue) {
       return m_cssGridColor ? m_cssGridColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& GetCssGridColor() const {
       return m_cssGridColor;
    }
    void SetCssGridColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

    bool HasColorFormat() { return !!m_colorFormat; }
    String GetColorFormat(const String& defaultValue) const {
       return m_colorFormat.value_or(defaultValue);
    }
    const std::optional<String>& GetColorFormat() const {
       return m_colorFormat;
    }
    void SetColorFormat(const String& value);  // Defined below

    bool HasGridHighlightConfig() { return !!m_gridHighlightConfig; }
    protocol::Overlay::GridHighlightConfig* GetGridHighlightConfig(protocol::Overlay::GridHighlightConfig* defaultValue) {
       return m_gridHighlightConfig ? m_gridHighlightConfig.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::GridHighlightConfig>& GetGridHighlightConfig() const {
       return m_gridHighlightConfig;
    }
    void SetGridHighlightConfig(std::unique_ptr<protocol::Overlay::GridHighlightConfig> value);  // Defined below

    bool HasFlexContainerHighlightConfig() { return !!m_flexContainerHighlightConfig; }
    protocol::Overlay::FlexContainerHighlightConfig* GetFlexContainerHighlightConfig(protocol::Overlay::FlexContainerHighlightConfig* defaultValue) {
       return m_flexContainerHighlightConfig ? m_flexContainerHighlightConfig.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::FlexContainerHighlightConfig>& GetFlexContainerHighlightConfig() const {
       return m_flexContainerHighlightConfig;
    }
    void SetFlexContainerHighlightConfig(std::unique_ptr<protocol::Overlay::FlexContainerHighlightConfig> value);  // Defined below

    bool HasFlexItemHighlightConfig() { return !!m_flexItemHighlightConfig; }
    protocol::Overlay::FlexItemHighlightConfig* GetFlexItemHighlightConfig(protocol::Overlay::FlexItemHighlightConfig* defaultValue) {
       return m_flexItemHighlightConfig ? m_flexItemHighlightConfig.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::FlexItemHighlightConfig>& GetFlexItemHighlightConfig() const {
       return m_flexItemHighlightConfig;
    }
    void SetFlexItemHighlightConfig(std::unique_ptr<protocol::Overlay::FlexItemHighlightConfig> value);  // Defined below

    bool HasContrastAlgorithm() { return !!m_contrastAlgorithm; }
    String GetContrastAlgorithm(const String& defaultValue) const {
       return m_contrastAlgorithm.value_or(defaultValue);
    }
    const std::optional<String>& GetContrastAlgorithm() const {
       return m_contrastAlgorithm;
    }
    void SetContrastAlgorithm(const String& value);  // Defined below

    bool HasContainerQueryContainerHighlightConfig() { return !!m_containerQueryContainerHighlightConfig; }
    protocol::Overlay::ContainerQueryContainerHighlightConfig* GetContainerQueryContainerHighlightConfig(protocol::Overlay::ContainerQueryContainerHighlightConfig* defaultValue) {
       return m_containerQueryContainerHighlightConfig ? m_containerQueryContainerHighlightConfig.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::ContainerQueryContainerHighlightConfig>& GetContainerQueryContainerHighlightConfig() const {
       return m_containerQueryContainerHighlightConfig;
    }
    void SetContainerQueryContainerHighlightConfig(std::unique_ptr<protocol::Overlay::ContainerQueryContainerHighlightConfig> value);  // Defined below

    template<int STATE>
    class HighlightConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        HighlightConfigBuilder<STATE>& SetShowInfo(bool value);  // Defined below

        HighlightConfigBuilder<STATE>& SetShowStyles(bool value);  // Defined below

        HighlightConfigBuilder<STATE>& SetShowRulers(bool value);  // Defined below

        HighlightConfigBuilder<STATE>& SetShowAccessibilityInfo(bool value);  // Defined below

        HighlightConfigBuilder<STATE>& SetShowExtensionLines(bool value);  // Defined below

        HighlightConfigBuilder<STATE>& SetContentColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

        HighlightConfigBuilder<STATE>& SetPaddingColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

        HighlightConfigBuilder<STATE>& SetBorderColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

        HighlightConfigBuilder<STATE>& SetMarginColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

        HighlightConfigBuilder<STATE>& SetEventTargetColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

        HighlightConfigBuilder<STATE>& SetShapeColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

        HighlightConfigBuilder<STATE>& SetShapeMarginColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

        HighlightConfigBuilder<STATE>& SetCssGridColor(std::unique_ptr<protocol::DOM::RGBA> value);  // Defined below

        HighlightConfigBuilder<STATE>& SetColorFormat(const String& value);  // Defined below

        HighlightConfigBuilder<STATE>& SetGridHighlightConfig(std::unique_ptr<protocol::Overlay::GridHighlightConfig> value);  // Defined below

        HighlightConfigBuilder<STATE>& SetFlexContainerHighlightConfig(std::unique_ptr<protocol::Overlay::FlexContainerHighlightConfig> value);  // Defined below

        HighlightConfigBuilder<STATE>& SetFlexItemHighlightConfig(std::unique_ptr<protocol::Overlay::FlexItemHighlightConfig> value);  // Defined below

        HighlightConfigBuilder<STATE>& SetContrastAlgorithm(const String& value);  // Defined below

        HighlightConfigBuilder<STATE>& SetContainerQueryContainerHighlightConfig(std::unique_ptr<protocol::Overlay::ContainerQueryContainerHighlightConfig> value);  // Defined below

        std::unique_ptr<HighlightConfig> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class HighlightConfig;
        HighlightConfigBuilder() : m_result(new HighlightConfig()) { }

        template<int STEP> HighlightConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<HighlightConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Overlay::HighlightConfig> m_result;
    };

    static HighlightConfigBuilder<0> Create()
    {
        return HighlightConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    HighlightConfig();  // Defined below

    std::optional<bool> m_showInfo;
    std::optional<bool> m_showStyles;
    std::optional<bool> m_showRulers;
    std::optional<bool> m_showAccessibilityInfo;
    std::optional<bool> m_showExtensionLines;
    std::unique_ptr<protocol::DOM::RGBA> m_contentColor;
    std::unique_ptr<protocol::DOM::RGBA> m_paddingColor;
    std::unique_ptr<protocol::DOM::RGBA> m_borderColor;
    std::unique_ptr<protocol::DOM::RGBA> m_marginColor;
    std::unique_ptr<protocol::DOM::RGBA> m_eventTargetColor;
    std::unique_ptr<protocol::DOM::RGBA> m_shapeColor;
    std::unique_ptr<protocol::DOM::RGBA> m_shapeMarginColor;
    std::unique_ptr<protocol::DOM::RGBA> m_cssGridColor;
    std::optional<String> m_colorFormat;
    std::unique_ptr<protocol::Overlay::GridHighlightConfig> m_gridHighlightConfig;
    std::unique_ptr<protocol::Overlay::FlexContainerHighlightConfig> m_flexContainerHighlightConfig;
    std::unique_ptr<protocol::Overlay::FlexItemHighlightConfig> m_flexItemHighlightConfig;
    std::optional<String> m_contrastAlgorithm;
    std::unique_ptr<protocol::Overlay::ContainerQueryContainerHighlightConfig> m_containerQueryContainerHighlightConfig;
};


class CONTENT_EXPORT ContainerQueryContainerHighlightConfig : public ::crdtp::ProtocolObject<ContainerQueryContainerHighlightConfig> {
public:
    ~ContainerQueryContainerHighlightConfig() override;  // Defined below

    bool HasContainerBorder() { return !!m_containerBorder; }
    protocol::Overlay::LineStyle* GetContainerBorder(protocol::Overlay::LineStyle* defaultValue) {
       return m_containerBorder ? m_containerBorder.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::LineStyle>& GetContainerBorder() const {
       return m_containerBorder;
    }
    void SetContainerBorder(std::unique_ptr<protocol::Overlay::LineStyle> value);  // Defined below

    bool HasDescendantBorder() { return !!m_descendantBorder; }
    protocol::Overlay::LineStyle* GetDescendantBorder(protocol::Overlay::LineStyle* defaultValue) {
       return m_descendantBorder ? m_descendantBorder.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::LineStyle>& GetDescendantBorder() const {
       return m_descendantBorder;
    }
    void SetDescendantBorder(std::unique_ptr<protocol::Overlay::LineStyle> value);  // Defined below

    template<int STATE>
    class ContainerQueryContainerHighlightConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        ContainerQueryContainerHighlightConfigBuilder<STATE>& SetContainerBorder(std::unique_ptr<protocol::Overlay::LineStyle> value);  // Defined below

        ContainerQueryContainerHighlightConfigBuilder<STATE>& SetDescendantBorder(std::unique_ptr<protocol::Overlay::LineStyle> value);  // Defined below

        std::unique_ptr<ContainerQueryContainerHighlightConfig> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ContainerQueryContainerHighlightConfig;
        ContainerQueryContainerHighlightConfigBuilder() : m_result(new ContainerQueryContainerHighlightConfig()) { }

        template<int STEP> ContainerQueryContainerHighlightConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ContainerQueryContainerHighlightConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Overlay::ContainerQueryContainerHighlightConfig> m_result;
    };

    static ContainerQueryContainerHighlightConfigBuilder<0> Create()
    {
        return ContainerQueryContainerHighlightConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ContainerQueryContainerHighlightConfig();  // Defined below

    std::unique_ptr<protocol::Overlay::LineStyle> m_containerBorder;
    std::unique_ptr<protocol::Overlay::LineStyle> m_descendantBorder;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline GridHighlightConfig::~GridHighlightConfig() = default;
inline void GridHighlightConfig::SetShowGridExtensionLines(bool value) { m_showGridExtensionLines = value; }
inline void GridHighlightConfig::SetShowPositiveLineNumbers(bool value) { m_showPositiveLineNumbers = value; }
inline void GridHighlightConfig::SetShowNegativeLineNumbers(bool value) { m_showNegativeLineNumbers = value; }
inline void GridHighlightConfig::SetShowAreaNames(bool value) { m_showAreaNames = value; }
inline void GridHighlightConfig::SetShowLineNames(bool value) { m_showLineNames = value; }
inline void GridHighlightConfig::SetShowTrackSizes(bool value) { m_showTrackSizes = value; }
inline void GridHighlightConfig::SetGridBorderColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_gridBorderColor = std::move(value); }
inline void GridHighlightConfig::SetCellBorderColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_cellBorderColor = std::move(value); }
inline void GridHighlightConfig::SetRowLineColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_rowLineColor = std::move(value); }
inline void GridHighlightConfig::SetColumnLineColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_columnLineColor = std::move(value); }
inline void GridHighlightConfig::SetGridBorderDash(bool value) { m_gridBorderDash = value; }
inline void GridHighlightConfig::SetCellBorderDash(bool value) { m_cellBorderDash = value; }
inline void GridHighlightConfig::SetRowLineDash(bool value) { m_rowLineDash = value; }
inline void GridHighlightConfig::SetColumnLineDash(bool value) { m_columnLineDash = value; }
inline void GridHighlightConfig::SetRowGapColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_rowGapColor = std::move(value); }
inline void GridHighlightConfig::SetRowHatchColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_rowHatchColor = std::move(value); }
inline void GridHighlightConfig::SetColumnGapColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_columnGapColor = std::move(value); }
inline void GridHighlightConfig::SetColumnHatchColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_columnHatchColor = std::move(value); }
inline void GridHighlightConfig::SetAreaBorderColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_areaBorderColor = std::move(value); }
inline void GridHighlightConfig::SetGridBackgroundColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_gridBackgroundColor = std::move(value); }

template<int STATE>
inline GridHighlightConfig::GridHighlightConfigBuilder<STATE>& GridHighlightConfig::GridHighlightConfigBuilder<STATE>::SetShowGridExtensionLines(bool value) {
  m_result->SetShowGridExtensionLines(value);
  return *this;
}
template<int STATE>
inline GridHighlightConfig::GridHighlightConfigBuilder<STATE>& GridHighlightConfig::GridHighlightConfigBuilder<STATE>::SetShowPositiveLineNumbers(bool value) {
  m_result->SetShowPositiveLineNumbers(value);
  return *this;
}
template<int STATE>
inline GridHighlightConfig::GridHighlightConfigBuilder<STATE>& GridHighlightConfig::GridHighlightConfigBuilder<STATE>::SetShowNegativeLineNumbers(bool value) {
  m_result->SetShowNegativeLineNumbers(value);
  return *this;
}
template<int STATE>
inline GridHighlightConfig::GridHighlightConfigBuilder<STATE>& GridHighlightConfig::GridHighlightConfigBuilder<STATE>::SetShowAreaNames(bool value) {
  m_result->SetShowAreaNames(value);
  return *this;
}
template<int STATE>
inline GridHighlightConfig::GridHighlightConfigBuilder<STATE>& GridHighlightConfig::GridHighlightConfigBuilder<STATE>::SetShowLineNames(bool value) {
  m_result->SetShowLineNames(value);
  return *this;
}
template<int STATE>
inline GridHighlightConfig::GridHighlightConfigBuilder<STATE>& GridHighlightConfig::GridHighlightConfigBuilder<STATE>::SetShowTrackSizes(bool value) {
  m_result->SetShowTrackSizes(value);
  return *this;
}
template<int STATE>
inline GridHighlightConfig::GridHighlightConfigBuilder<STATE>& GridHighlightConfig::GridHighlightConfigBuilder<STATE>::SetGridBorderColor(std::unique_ptr<protocol::DOM::RGBA> value) {
  m_result->SetGridBorderColor(std::move(value));
  return *this;
}
template<int STATE>
inline GridHighlightConfig::GridHighlightConfigBuilder<STATE>& GridHighlightConfig::GridHighlightConfigBuilder<STATE>::SetCellBorderColor(std::unique_ptr<protocol::DOM::RGBA> value) {
  m_result->SetCellBorderColor(std::move(value));
  return *this;
}
template<int STATE>
inline GridHighlightConfig::GridHighlightConfigBuilder<STATE>& GridHighlightConfig::GridHighlightConfigBuilder<STATE>::SetRowLineColor(std::unique_ptr<protocol::DOM::RGBA> value) {
  m_result->SetRowLineColor(std::move(value));
  return *this;
}
template<int STATE>
inline GridHighlightConfig::GridHighlightConfigBuilder<STATE>& GridHighlightConfig::GridHighlightConfigBuilder<STATE>::SetColumnLineColor(std::unique_ptr<protocol::DOM::RGBA> value) {
  m_result->SetColumnLineColor(std::move(value));
  return *this;
}
template<int STATE>
inline GridHighlightConfig::GridHighlightConfigBuilder<STATE>& GridHighlightConfig::GridHighlightConfigBuilder<STATE>::SetGridBorderDash(bool value) {
  m_result->SetGridBorderDash(value);
  return *this;
}
template<int STATE>
inline GridHighlightConfig::GridHighlightConfigBuilder<STATE>& GridHighlightConfig::GridHighlightConfigBuilder<STATE>::SetCellBorderDash(bool value) {
  m_result->SetCellBorderDash(value);
  return *this;
}
template<int STATE>
inline GridHighlightConfig::GridHighlightConfigBuilder<STATE>& GridHighlightConfig::GridHighlightConfigBuilder<STATE>::SetRowLineDash(bool value) {
  m_result->SetRowLineDash(value);
  return *this;
}
template<int STATE>
inline GridHighlightConfig::GridHighlightConfigBuilder<STATE>& GridHighlightConfig::GridHighlightConfigBuilder<STATE>::SetColumnLineDash(bool value) {
  m_result->SetColumnLineDash(value);
  return *this;
}
template<int STATE>
inline GridHighlightConfig::GridHighlightConfigBuilder<STATE>& GridHighlightConfig::GridHighlightConfigBuilder<STATE>::SetRowGapColor(std::unique_ptr<protocol::DOM::RGBA> value) {
  m_result->SetRowGapColor(std::move(value));
  return *this;
}
template<int STATE>
inline GridHighlightConfig::GridHighlightConfigBuilder<STATE>& GridHighlightConfig::GridHighlightConfigBuilder<STATE>::SetRowHatchColor(std::unique_ptr<protocol::DOM::RGBA> value) {
  m_result->SetRowHatchColor(std::move(value));
  return *this;
}
template<int STATE>
inline GridHighlightConfig::GridHighlightConfigBuilder<STATE>& GridHighlightConfig::GridHighlightConfigBuilder<STATE>::SetColumnGapColor(std::unique_ptr<protocol::DOM::RGBA> value) {
  m_result->SetColumnGapColor(std::move(value));
  return *this;
}
template<int STATE>
inline GridHighlightConfig::GridHighlightConfigBuilder<STATE>& GridHighlightConfig::GridHighlightConfigBuilder<STATE>::SetColumnHatchColor(std::unique_ptr<protocol::DOM::RGBA> value) {
  m_result->SetColumnHatchColor(std::move(value));
  return *this;
}
template<int STATE>
inline GridHighlightConfig::GridHighlightConfigBuilder<STATE>& GridHighlightConfig::GridHighlightConfigBuilder<STATE>::SetAreaBorderColor(std::unique_ptr<protocol::DOM::RGBA> value) {
  m_result->SetAreaBorderColor(std::move(value));
  return *this;
}
template<int STATE>
inline GridHighlightConfig::GridHighlightConfigBuilder<STATE>& GridHighlightConfig::GridHighlightConfigBuilder<STATE>::SetGridBackgroundColor(std::unique_ptr<protocol::DOM::RGBA> value) {
  m_result->SetGridBackgroundColor(std::move(value));
  return *this;
}

inline GridHighlightConfig::GridHighlightConfig() {
}
inline FlexContainerHighlightConfig::~FlexContainerHighlightConfig() = default;
inline void FlexContainerHighlightConfig::SetContainerBorder(std::unique_ptr<protocol::Overlay::LineStyle> value) { m_containerBorder = std::move(value); }
inline void FlexContainerHighlightConfig::SetLineSeparator(std::unique_ptr<protocol::Overlay::LineStyle> value) { m_lineSeparator = std::move(value); }
inline void FlexContainerHighlightConfig::SetItemSeparator(std::unique_ptr<protocol::Overlay::LineStyle> value) { m_itemSeparator = std::move(value); }
inline void FlexContainerHighlightConfig::SetMainDistributedSpace(std::unique_ptr<protocol::Overlay::BoxStyle> value) { m_mainDistributedSpace = std::move(value); }
inline void FlexContainerHighlightConfig::SetCrossDistributedSpace(std::unique_ptr<protocol::Overlay::BoxStyle> value) { m_crossDistributedSpace = std::move(value); }
inline void FlexContainerHighlightConfig::SetRowGapSpace(std::unique_ptr<protocol::Overlay::BoxStyle> value) { m_rowGapSpace = std::move(value); }
inline void FlexContainerHighlightConfig::SetColumnGapSpace(std::unique_ptr<protocol::Overlay::BoxStyle> value) { m_columnGapSpace = std::move(value); }
inline void FlexContainerHighlightConfig::SetCrossAlignment(std::unique_ptr<protocol::Overlay::LineStyle> value) { m_crossAlignment = std::move(value); }

template<int STATE>
inline FlexContainerHighlightConfig::FlexContainerHighlightConfigBuilder<STATE>& FlexContainerHighlightConfig::FlexContainerHighlightConfigBuilder<STATE>::SetContainerBorder(std::unique_ptr<protocol::Overlay::LineStyle> value) {
  m_result->SetContainerBorder(std::move(value));
  return *this;
}
template<int STATE>
inline FlexContainerHighlightConfig::FlexContainerHighlightConfigBuilder<STATE>& FlexContainerHighlightConfig::FlexContainerHighlightConfigBuilder<STATE>::SetLineSeparator(std::unique_ptr<protocol::Overlay::LineStyle> value) {
  m_result->SetLineSeparator(std::move(value));
  return *this;
}
template<int STATE>
inline FlexContainerHighlightConfig::FlexContainerHighlightConfigBuilder<STATE>& FlexContainerHighlightConfig::FlexContainerHighlightConfigBuilder<STATE>::SetItemSeparator(std::unique_ptr<protocol::Overlay::LineStyle> value) {
  m_result->SetItemSeparator(std::move(value));
  return *this;
}
template<int STATE>
inline FlexContainerHighlightConfig::FlexContainerHighlightConfigBuilder<STATE>& FlexContainerHighlightConfig::FlexContainerHighlightConfigBuilder<STATE>::SetMainDistributedSpace(std::unique_ptr<protocol::Overlay::BoxStyle> value) {
  m_result->SetMainDistributedSpace(std::move(value));
  return *this;
}
template<int STATE>
inline FlexContainerHighlightConfig::FlexContainerHighlightConfigBuilder<STATE>& FlexContainerHighlightConfig::FlexContainerHighlightConfigBuilder<STATE>::SetCrossDistributedSpace(std::unique_ptr<protocol::Overlay::BoxStyle> value) {
  m_result->SetCrossDistributedSpace(std::move(value));
  return *this;
}
template<int STATE>
inline FlexContainerHighlightConfig::FlexContainerHighlightConfigBuilder<STATE>& FlexContainerHighlightConfig::FlexContainerHighlightConfigBuilder<STATE>::SetRowGapSpace(std::unique_ptr<protocol::Overlay::BoxStyle> value) {
  m_result->SetRowGapSpace(std::move(value));
  return *this;
}
template<int STATE>
inline FlexContainerHighlightConfig::FlexContainerHighlightConfigBuilder<STATE>& FlexContainerHighlightConfig::FlexContainerHighlightConfigBuilder<STATE>::SetColumnGapSpace(std::unique_ptr<protocol::Overlay::BoxStyle> value) {
  m_result->SetColumnGapSpace(std::move(value));
  return *this;
}
template<int STATE>
inline FlexContainerHighlightConfig::FlexContainerHighlightConfigBuilder<STATE>& FlexContainerHighlightConfig::FlexContainerHighlightConfigBuilder<STATE>::SetCrossAlignment(std::unique_ptr<protocol::Overlay::LineStyle> value) {
  m_result->SetCrossAlignment(std::move(value));
  return *this;
}

inline FlexContainerHighlightConfig::FlexContainerHighlightConfig() {
}
inline FlexItemHighlightConfig::~FlexItemHighlightConfig() = default;
inline void FlexItemHighlightConfig::SetBaseSizeBox(std::unique_ptr<protocol::Overlay::BoxStyle> value) { m_baseSizeBox = std::move(value); }
inline void FlexItemHighlightConfig::SetBaseSizeBorder(std::unique_ptr<protocol::Overlay::LineStyle> value) { m_baseSizeBorder = std::move(value); }
inline void FlexItemHighlightConfig::SetFlexibilityArrow(std::unique_ptr<protocol::Overlay::LineStyle> value) { m_flexibilityArrow = std::move(value); }

template<int STATE>
inline FlexItemHighlightConfig::FlexItemHighlightConfigBuilder<STATE>& FlexItemHighlightConfig::FlexItemHighlightConfigBuilder<STATE>::SetBaseSizeBox(std::unique_ptr<protocol::Overlay::BoxStyle> value) {
  m_result->SetBaseSizeBox(std::move(value));
  return *this;
}
template<int STATE>
inline FlexItemHighlightConfig::FlexItemHighlightConfigBuilder<STATE>& FlexItemHighlightConfig::FlexItemHighlightConfigBuilder<STATE>::SetBaseSizeBorder(std::unique_ptr<protocol::Overlay::LineStyle> value) {
  m_result->SetBaseSizeBorder(std::move(value));
  return *this;
}
template<int STATE>
inline FlexItemHighlightConfig::FlexItemHighlightConfigBuilder<STATE>& FlexItemHighlightConfig::FlexItemHighlightConfigBuilder<STATE>::SetFlexibilityArrow(std::unique_ptr<protocol::Overlay::LineStyle> value) {
  m_result->SetFlexibilityArrow(std::move(value));
  return *this;
}

inline FlexItemHighlightConfig::FlexItemHighlightConfig() {
}
inline LineStyle::~LineStyle() = default;
inline void LineStyle::SetColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_color = std::move(value); }
inline void LineStyle::SetPattern(const String& value) { m_pattern = value; }

template<int STATE>
inline LineStyle::LineStyleBuilder<STATE>& LineStyle::LineStyleBuilder<STATE>::SetColor(std::unique_ptr<protocol::DOM::RGBA> value) {
  m_result->SetColor(std::move(value));
  return *this;
}
template<int STATE>
inline LineStyle::LineStyleBuilder<STATE>& LineStyle::LineStyleBuilder<STATE>::SetPattern(const String& value) {
  m_result->SetPattern(value);
  return *this;
}

inline LineStyle::LineStyle() {
}
inline BoxStyle::~BoxStyle() = default;
inline void BoxStyle::SetFillColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_fillColor = std::move(value); }
inline void BoxStyle::SetHatchColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_hatchColor = std::move(value); }

template<int STATE>
inline BoxStyle::BoxStyleBuilder<STATE>& BoxStyle::BoxStyleBuilder<STATE>::SetFillColor(std::unique_ptr<protocol::DOM::RGBA> value) {
  m_result->SetFillColor(std::move(value));
  return *this;
}
template<int STATE>
inline BoxStyle::BoxStyleBuilder<STATE>& BoxStyle::BoxStyleBuilder<STATE>::SetHatchColor(std::unique_ptr<protocol::DOM::RGBA> value) {
  m_result->SetHatchColor(std::move(value));
  return *this;
}

inline BoxStyle::BoxStyle() {
}
inline HighlightConfig::~HighlightConfig() = default;
inline void HighlightConfig::SetShowInfo(bool value) { m_showInfo = value; }
inline void HighlightConfig::SetShowStyles(bool value) { m_showStyles = value; }
inline void HighlightConfig::SetShowRulers(bool value) { m_showRulers = value; }
inline void HighlightConfig::SetShowAccessibilityInfo(bool value) { m_showAccessibilityInfo = value; }
inline void HighlightConfig::SetShowExtensionLines(bool value) { m_showExtensionLines = value; }
inline void HighlightConfig::SetContentColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_contentColor = std::move(value); }
inline void HighlightConfig::SetPaddingColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_paddingColor = std::move(value); }
inline void HighlightConfig::SetBorderColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_borderColor = std::move(value); }
inline void HighlightConfig::SetMarginColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_marginColor = std::move(value); }
inline void HighlightConfig::SetEventTargetColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_eventTargetColor = std::move(value); }
inline void HighlightConfig::SetShapeColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_shapeColor = std::move(value); }
inline void HighlightConfig::SetShapeMarginColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_shapeMarginColor = std::move(value); }
inline void HighlightConfig::SetCssGridColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_cssGridColor = std::move(value); }
inline void HighlightConfig::SetColorFormat(const String& value) { m_colorFormat = value; }
inline void HighlightConfig::SetGridHighlightConfig(std::unique_ptr<protocol::Overlay::GridHighlightConfig> value) { m_gridHighlightConfig = std::move(value); }
inline void HighlightConfig::SetFlexContainerHighlightConfig(std::unique_ptr<protocol::Overlay::FlexContainerHighlightConfig> value) { m_flexContainerHighlightConfig = std::move(value); }
inline void HighlightConfig::SetFlexItemHighlightConfig(std::unique_ptr<protocol::Overlay::FlexItemHighlightConfig> value) { m_flexItemHighlightConfig = std::move(value); }
inline void HighlightConfig::SetContrastAlgorithm(const String& value) { m_contrastAlgorithm = value; }
inline void HighlightConfig::SetContainerQueryContainerHighlightConfig(std::unique_ptr<protocol::Overlay::ContainerQueryContainerHighlightConfig> value) { m_containerQueryContainerHighlightConfig = std::move(value); }

template<int STATE>
inline HighlightConfig::HighlightConfigBuilder<STATE>& HighlightConfig::HighlightConfigBuilder<STATE>::SetShowInfo(bool value) {
  m_result->SetShowInfo(value);
  return *this;
}
template<int STATE>
inline HighlightConfig::HighlightConfigBuilder<STATE>& HighlightConfig::HighlightConfigBuilder<STATE>::SetShowStyles(bool value) {
  m_result->SetShowStyles(value);
  return *this;
}
template<int STATE>
inline HighlightConfig::HighlightConfigBuilder<STATE>& HighlightConfig::HighlightConfigBuilder<STATE>::SetShowRulers(bool value) {
  m_result->SetShowRulers(value);
  return *this;
}
template<int STATE>
inline HighlightConfig::HighlightConfigBuilder<STATE>& HighlightConfig::HighlightConfigBuilder<STATE>::SetShowAccessibilityInfo(bool value) {
  m_result->SetShowAccessibilityInfo(value);
  return *this;
}
template<int STATE>
inline HighlightConfig::HighlightConfigBuilder<STATE>& HighlightConfig::HighlightConfigBuilder<STATE>::SetShowExtensionLines(bool value) {
  m_result->SetShowExtensionLines(value);
  return *this;
}
template<int STATE>
inline HighlightConfig::HighlightConfigBuilder<STATE>& HighlightConfig::HighlightConfigBuilder<STATE>::SetContentColor(std::unique_ptr<protocol::DOM::RGBA> value) {
  m_result->SetContentColor(std::move(value));
  return *this;
}
template<int STATE>
inline HighlightConfig::HighlightConfigBuilder<STATE>& HighlightConfig::HighlightConfigBuilder<STATE>::SetPaddingColor(std::unique_ptr<protocol::DOM::RGBA> value) {
  m_result->SetPaddingColor(std::move(value));
  return *this;
}
template<int STATE>
inline HighlightConfig::HighlightConfigBuilder<STATE>& HighlightConfig::HighlightConfigBuilder<STATE>::SetBorderColor(std::unique_ptr<protocol::DOM::RGBA> value) {
  m_result->SetBorderColor(std::move(value));
  return *this;
}
template<int STATE>
inline HighlightConfig::HighlightConfigBuilder<STATE>& HighlightConfig::HighlightConfigBuilder<STATE>::SetMarginColor(std::unique_ptr<protocol::DOM::RGBA> value) {
  m_result->SetMarginColor(std::move(value));
  return *this;
}
template<int STATE>
inline HighlightConfig::HighlightConfigBuilder<STATE>& HighlightConfig::HighlightConfigBuilder<STATE>::SetEventTargetColor(std::unique_ptr<protocol::DOM::RGBA> value) {
  m_result->SetEventTargetColor(std::move(value));
  return *this;
}
template<int STATE>
inline HighlightConfig::HighlightConfigBuilder<STATE>& HighlightConfig::HighlightConfigBuilder<STATE>::SetShapeColor(std::unique_ptr<protocol::DOM::RGBA> value) {
  m_result->SetShapeColor(std::move(value));
  return *this;
}
template<int STATE>
inline HighlightConfig::HighlightConfigBuilder<STATE>& HighlightConfig::HighlightConfigBuilder<STATE>::SetShapeMarginColor(std::unique_ptr<protocol::DOM::RGBA> value) {
  m_result->SetShapeMarginColor(std::move(value));
  return *this;
}
template<int STATE>
inline HighlightConfig::HighlightConfigBuilder<STATE>& HighlightConfig::HighlightConfigBuilder<STATE>::SetCssGridColor(std::unique_ptr<protocol::DOM::RGBA> value) {
  m_result->SetCssGridColor(std::move(value));
  return *this;
}
template<int STATE>
inline HighlightConfig::HighlightConfigBuilder<STATE>& HighlightConfig::HighlightConfigBuilder<STATE>::SetColorFormat(const String& value) {
  m_result->SetColorFormat(value);
  return *this;
}
template<int STATE>
inline HighlightConfig::HighlightConfigBuilder<STATE>& HighlightConfig::HighlightConfigBuilder<STATE>::SetGridHighlightConfig(std::unique_ptr<protocol::Overlay::GridHighlightConfig> value) {
  m_result->SetGridHighlightConfig(std::move(value));
  return *this;
}
template<int STATE>
inline HighlightConfig::HighlightConfigBuilder<STATE>& HighlightConfig::HighlightConfigBuilder<STATE>::SetFlexContainerHighlightConfig(std::unique_ptr<protocol::Overlay::FlexContainerHighlightConfig> value) {
  m_result->SetFlexContainerHighlightConfig(std::move(value));
  return *this;
}
template<int STATE>
inline HighlightConfig::HighlightConfigBuilder<STATE>& HighlightConfig::HighlightConfigBuilder<STATE>::SetFlexItemHighlightConfig(std::unique_ptr<protocol::Overlay::FlexItemHighlightConfig> value) {
  m_result->SetFlexItemHighlightConfig(std::move(value));
  return *this;
}
template<int STATE>
inline HighlightConfig::HighlightConfigBuilder<STATE>& HighlightConfig::HighlightConfigBuilder<STATE>::SetContrastAlgorithm(const String& value) {
  m_result->SetContrastAlgorithm(value);
  return *this;
}
template<int STATE>
inline HighlightConfig::HighlightConfigBuilder<STATE>& HighlightConfig::HighlightConfigBuilder<STATE>::SetContainerQueryContainerHighlightConfig(std::unique_ptr<protocol::Overlay::ContainerQueryContainerHighlightConfig> value) {
  m_result->SetContainerQueryContainerHighlightConfig(std::move(value));
  return *this;
}

inline HighlightConfig::HighlightConfig() {
}
inline ContainerQueryContainerHighlightConfig::~ContainerQueryContainerHighlightConfig() = default;
inline void ContainerQueryContainerHighlightConfig::SetContainerBorder(std::unique_ptr<protocol::Overlay::LineStyle> value) { m_containerBorder = std::move(value); }
inline void ContainerQueryContainerHighlightConfig::SetDescendantBorder(std::unique_ptr<protocol::Overlay::LineStyle> value) { m_descendantBorder = std::move(value); }

template<int STATE>
inline ContainerQueryContainerHighlightConfig::ContainerQueryContainerHighlightConfigBuilder<STATE>& ContainerQueryContainerHighlightConfig::ContainerQueryContainerHighlightConfigBuilder<STATE>::SetContainerBorder(std::unique_ptr<protocol::Overlay::LineStyle> value) {
  m_result->SetContainerBorder(std::move(value));
  return *this;
}
template<int STATE>
inline ContainerQueryContainerHighlightConfig::ContainerQueryContainerHighlightConfigBuilder<STATE>& ContainerQueryContainerHighlightConfig::ContainerQueryContainerHighlightConfigBuilder<STATE>::SetDescendantBorder(std::unique_ptr<protocol::Overlay::LineStyle> value) {
  m_result->SetDescendantBorder(std::move(value));
  return *this;
}

inline ContainerQueryContainerHighlightConfig::ContainerQueryContainerHighlightConfig() {
}

// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse SetInspectMode(const String& in_mode, std::unique_ptr<protocol::Overlay::HighlightConfig> in_highlightConfig) = 0;
    virtual DispatchResponse SetPausedInDebuggerMessage(std::optional<String> in_message) = 0;

    virtual DispatchResponse Disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void InspectNodeRequested(int backendNodeId);
    void NodeHighlightRequested(int nodeId);
    void ScreenshotRequested(std::unique_ptr<protocol::Page::Viewport> viewport);
    void InspectModeCanceled();

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Overlay
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_Overlay_h)
