// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_Fetch_h
#define content_protocol_Fetch_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "content/browser/devtools/protocol/network.h"
#include "content/browser/devtools/protocol/io.h"
#include "content/browser/devtools/protocol/page.h"

namespace content {
namespace protocol {
namespace Fetch {
using RequestId = String;
using RequestStage = String;
class RequestPattern;
class HeaderEntry;
class AuthChallenge;
class AuthChallengeResponse;

// ------------- Forward and enum declarations.

namespace RequestStageEnum {
CONTENT_EXPORT extern const char Request[];
CONTENT_EXPORT extern const char Response[];
} // namespace RequestStageEnum

// ------------- Type and builder declarations.

class CONTENT_EXPORT RequestPattern : public ::crdtp::ProtocolObject<RequestPattern> {
public:
    ~RequestPattern() override;  // Defined below

    bool HasUrlPattern() { return !!m_urlPattern; }
    String GetUrlPattern(const String& defaultValue) const {
       return m_urlPattern.value_or(defaultValue);
    }
    const std::optional<String>& GetUrlPattern() const {
       return m_urlPattern;
    }
    void SetUrlPattern(const String& value);  // Defined below

    bool HasResourceType() { return !!m_resourceType; }
    String GetResourceType(const String& defaultValue) const {
       return m_resourceType.value_or(defaultValue);
    }
    const std::optional<String>& GetResourceType() const {
       return m_resourceType;
    }
    void SetResourceType(const String& value);  // Defined below

    bool HasRequestStage() { return !!m_requestStage; }
    String GetRequestStage(const String& defaultValue) const {
       return m_requestStage.value_or(defaultValue);
    }
    const std::optional<String>& GetRequestStage() const {
       return m_requestStage;
    }
    void SetRequestStage(const String& value);  // Defined below

    template<int STATE>
    class RequestPatternBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        RequestPatternBuilder<STATE>& SetUrlPattern(const String& value);  // Defined below

        RequestPatternBuilder<STATE>& SetResourceType(const String& value);  // Defined below

        RequestPatternBuilder<STATE>& SetRequestStage(const String& value);  // Defined below

        std::unique_ptr<RequestPattern> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class RequestPattern;
        RequestPatternBuilder() : m_result(new RequestPattern()) { }

        template<int STEP> RequestPatternBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<RequestPatternBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Fetch::RequestPattern> m_result;
    };

    static RequestPatternBuilder<0> Create()
    {
        return RequestPatternBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    RequestPattern();  // Defined below

    std::optional<String> m_urlPattern;
    std::optional<String> m_resourceType;
    std::optional<String> m_requestStage;
};


class CONTENT_EXPORT HeaderEntry : public ::crdtp::ProtocolObject<HeaderEntry> {
public:
    ~HeaderEntry() override;  // Defined below

    String GetName() { return m_name; }
    void SetName(const String& value);  // Defined below

    String GetValue() { return m_value; }
    void SetValue(const String& value);  // Defined below

    template<int STATE>
    class HeaderEntryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (NameSet | ValueSet | 0)};


        HeaderEntryBuilder<STATE | NameSet>& SetName(const String& value);  // Defined below

        HeaderEntryBuilder<STATE | ValueSet>& SetValue(const String& value);  // Defined below

        std::unique_ptr<HeaderEntry> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class HeaderEntry;
        HeaderEntryBuilder() : m_result(new HeaderEntry()) { }

        template<int STEP> HeaderEntryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<HeaderEntryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Fetch::HeaderEntry> m_result;
    };

    static HeaderEntryBuilder<0> Create()
    {
        return HeaderEntryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    HeaderEntry();  // Defined below

    String m_name;
    String m_value;
};


class CONTENT_EXPORT AuthChallenge : public ::crdtp::ProtocolObject<AuthChallenge> {
public:
    ~AuthChallenge() override;  // Defined below

    struct CONTENT_EXPORT SourceEnum {
        static const char* Server;
        static const char* Proxy;
    }; // SourceEnum

    bool HasSource() { return !!m_source; }
    String GetSource(const String& defaultValue) const {
       return m_source.value_or(defaultValue);
    }
    const std::optional<String>& GetSource() const {
       return m_source;
    }
    void SetSource(const String& value);  // Defined below

    String GetOrigin() { return m_origin; }
    void SetOrigin(const String& value);  // Defined below

    String GetScheme() { return m_scheme; }
    void SetScheme(const String& value);  // Defined below

    String GetRealm() { return m_realm; }
    void SetRealm(const String& value);  // Defined below

    template<int STATE>
    class AuthChallengeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            OriginSet = 1 << 1,
            SchemeSet = 1 << 2,
            RealmSet = 1 << 3,
            AllFieldsSet = (OriginSet | SchemeSet | RealmSet | 0)};


        AuthChallengeBuilder<STATE>& SetSource(const String& value);  // Defined below

        AuthChallengeBuilder<STATE | OriginSet>& SetOrigin(const String& value);  // Defined below

        AuthChallengeBuilder<STATE | SchemeSet>& SetScheme(const String& value);  // Defined below

        AuthChallengeBuilder<STATE | RealmSet>& SetRealm(const String& value);  // Defined below

        std::unique_ptr<AuthChallenge> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AuthChallenge;
        AuthChallengeBuilder() : m_result(new AuthChallenge()) { }

        template<int STEP> AuthChallengeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AuthChallengeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Fetch::AuthChallenge> m_result;
    };

    static AuthChallengeBuilder<0> Create()
    {
        return AuthChallengeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AuthChallenge();  // Defined below

    std::optional<String> m_source;
    String m_origin;
    String m_scheme;
    String m_realm;
};


class CONTENT_EXPORT AuthChallengeResponse : public ::crdtp::ProtocolObject<AuthChallengeResponse> {
public:
    ~AuthChallengeResponse() override;  // Defined below

    struct CONTENT_EXPORT ResponseEnum {
        static const char* Default;
        static const char* CancelAuth;
        static const char* ProvideCredentials;
    }; // ResponseEnum

    String GetResponse() { return m_response; }
    void SetResponse(const String& value);  // Defined below

    bool HasUsername() { return !!m_username; }
    String GetUsername(const String& defaultValue) const {
       return m_username.value_or(defaultValue);
    }
    const std::optional<String>& GetUsername() const {
       return m_username;
    }
    void SetUsername(const String& value);  // Defined below

    bool HasPassword() { return !!m_password; }
    String GetPassword(const String& defaultValue) const {
       return m_password.value_or(defaultValue);
    }
    const std::optional<String>& GetPassword() const {
       return m_password;
    }
    void SetPassword(const String& value);  // Defined below

    template<int STATE>
    class AuthChallengeResponseBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ResponseSet = 1 << 1,
            AllFieldsSet = (ResponseSet | 0)};


        AuthChallengeResponseBuilder<STATE | ResponseSet>& SetResponse(const String& value);  // Defined below

        AuthChallengeResponseBuilder<STATE>& SetUsername(const String& value);  // Defined below

        AuthChallengeResponseBuilder<STATE>& SetPassword(const String& value);  // Defined below

        std::unique_ptr<AuthChallengeResponse> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AuthChallengeResponse;
        AuthChallengeResponseBuilder() : m_result(new AuthChallengeResponse()) { }

        template<int STEP> AuthChallengeResponseBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AuthChallengeResponseBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Fetch::AuthChallengeResponse> m_result;
    };

    static AuthChallengeResponseBuilder<0> Create()
    {
        return AuthChallengeResponseBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AuthChallengeResponse();  // Defined below

    String m_response;
    std::optional<String> m_username;
    std::optional<String> m_password;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline RequestPattern::~RequestPattern() = default;
inline void RequestPattern::SetUrlPattern(const String& value) { m_urlPattern = value; }
inline void RequestPattern::SetResourceType(const String& value) { m_resourceType = value; }
inline void RequestPattern::SetRequestStage(const String& value) { m_requestStage = value; }

template<int STATE>
inline RequestPattern::RequestPatternBuilder<STATE>& RequestPattern::RequestPatternBuilder<STATE>::SetUrlPattern(const String& value) {
  m_result->SetUrlPattern(value);
  return *this;
}
template<int STATE>
inline RequestPattern::RequestPatternBuilder<STATE>& RequestPattern::RequestPatternBuilder<STATE>::SetResourceType(const String& value) {
  m_result->SetResourceType(value);
  return *this;
}
template<int STATE>
inline RequestPattern::RequestPatternBuilder<STATE>& RequestPattern::RequestPatternBuilder<STATE>::SetRequestStage(const String& value) {
  m_result->SetRequestStage(value);
  return *this;
}

inline RequestPattern::RequestPattern() {
}
inline HeaderEntry::~HeaderEntry() = default;
inline void HeaderEntry::SetName(const String& value) { m_name = value; }
inline void HeaderEntry::SetValue(const String& value) { m_value = value; }

template<int STATE>
inline HeaderEntry::HeaderEntryBuilder<STATE | HeaderEntry::HeaderEntryBuilder<STATE>::NameSet>&
HeaderEntry::HeaderEntryBuilder<STATE>::SetName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->SetName(value);
  return castState<NameSet>();
}
template<int STATE>
inline HeaderEntry::HeaderEntryBuilder<STATE | HeaderEntry::HeaderEntryBuilder<STATE>::ValueSet>&
HeaderEntry::HeaderEntryBuilder<STATE>::SetValue(const String& value) {
  static_assert(!(STATE & ValueSet), "property value should not be set yet");
  m_result->SetValue(value);
  return castState<ValueSet>();
}

inline HeaderEntry::HeaderEntry() {
}
inline AuthChallenge::~AuthChallenge() = default;
inline void AuthChallenge::SetSource(const String& value) { m_source = value; }
inline void AuthChallenge::SetOrigin(const String& value) { m_origin = value; }
inline void AuthChallenge::SetScheme(const String& value) { m_scheme = value; }
inline void AuthChallenge::SetRealm(const String& value) { m_realm = value; }

template<int STATE>
inline AuthChallenge::AuthChallengeBuilder<STATE>& AuthChallenge::AuthChallengeBuilder<STATE>::SetSource(const String& value) {
  m_result->SetSource(value);
  return *this;
}
template<int STATE>
inline AuthChallenge::AuthChallengeBuilder<STATE | AuthChallenge::AuthChallengeBuilder<STATE>::OriginSet>&
AuthChallenge::AuthChallengeBuilder<STATE>::SetOrigin(const String& value) {
  static_assert(!(STATE & OriginSet), "property origin should not be set yet");
  m_result->SetOrigin(value);
  return castState<OriginSet>();
}
template<int STATE>
inline AuthChallenge::AuthChallengeBuilder<STATE | AuthChallenge::AuthChallengeBuilder<STATE>::SchemeSet>&
AuthChallenge::AuthChallengeBuilder<STATE>::SetScheme(const String& value) {
  static_assert(!(STATE & SchemeSet), "property scheme should not be set yet");
  m_result->SetScheme(value);
  return castState<SchemeSet>();
}
template<int STATE>
inline AuthChallenge::AuthChallengeBuilder<STATE | AuthChallenge::AuthChallengeBuilder<STATE>::RealmSet>&
AuthChallenge::AuthChallengeBuilder<STATE>::SetRealm(const String& value) {
  static_assert(!(STATE & RealmSet), "property realm should not be set yet");
  m_result->SetRealm(value);
  return castState<RealmSet>();
}

inline AuthChallenge::AuthChallenge() {
}
inline AuthChallengeResponse::~AuthChallengeResponse() = default;
inline void AuthChallengeResponse::SetResponse(const String& value) { m_response = value; }
inline void AuthChallengeResponse::SetUsername(const String& value) { m_username = value; }
inline void AuthChallengeResponse::SetPassword(const String& value) { m_password = value; }

template<int STATE>
inline AuthChallengeResponse::AuthChallengeResponseBuilder<STATE | AuthChallengeResponse::AuthChallengeResponseBuilder<STATE>::ResponseSet>&
AuthChallengeResponse::AuthChallengeResponseBuilder<STATE>::SetResponse(const String& value) {
  static_assert(!(STATE & ResponseSet), "property response should not be set yet");
  m_result->SetResponse(value);
  return castState<ResponseSet>();
}
template<int STATE>
inline AuthChallengeResponse::AuthChallengeResponseBuilder<STATE>& AuthChallengeResponse::AuthChallengeResponseBuilder<STATE>::SetUsername(const String& value) {
  m_result->SetUsername(value);
  return *this;
}
template<int STATE>
inline AuthChallengeResponse::AuthChallengeResponseBuilder<STATE>& AuthChallengeResponse::AuthChallengeResponseBuilder<STATE>::SetPassword(const String& value) {
  m_result->SetPassword(value);
  return *this;
}

inline AuthChallengeResponse::AuthChallengeResponse() {
}

// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse Disable() = 0;
    class CONTENT_EXPORT EnableCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~EnableCallback() { }
    };
    virtual void Enable(std::unique_ptr<protocol::Array<protocol::Fetch::RequestPattern>> in_patterns, std::optional<bool> in_handleAuthRequests, std::unique_ptr<EnableCallback> callback) = 0;
    class CONTENT_EXPORT FailRequestCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~FailRequestCallback() { }
    };
    virtual void FailRequest(const String& in_requestId, const String& in_errorReason, std::unique_ptr<FailRequestCallback> callback) = 0;
    class CONTENT_EXPORT FulfillRequestCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~FulfillRequestCallback() { }
    };
    virtual void FulfillRequest(const String& in_requestId, int in_responseCode, std::unique_ptr<protocol::Array<protocol::Fetch::HeaderEntry>> in_responseHeaders, std::optional<Binary> in_binaryResponseHeaders, std::optional<Binary> in_body, std::optional<String> in_responsePhrase, std::unique_ptr<FulfillRequestCallback> callback) = 0;
    class CONTENT_EXPORT ContinueRequestCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~ContinueRequestCallback() { }
    };
    virtual void ContinueRequest(const String& in_requestId, std::optional<String> in_url, std::optional<String> in_method, std::optional<Binary> in_postData, std::unique_ptr<protocol::Array<protocol::Fetch::HeaderEntry>> in_headers, std::optional<bool> in_interceptResponse, std::unique_ptr<ContinueRequestCallback> callback) = 0;
    class CONTENT_EXPORT ContinueWithAuthCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~ContinueWithAuthCallback() { }
    };
    virtual void ContinueWithAuth(const String& in_requestId, std::unique_ptr<protocol::Fetch::AuthChallengeResponse> in_authChallengeResponse, std::unique_ptr<ContinueWithAuthCallback> callback) = 0;
    class CONTENT_EXPORT ContinueResponseCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~ContinueResponseCallback() { }
    };
    virtual void ContinueResponse(const String& in_requestId, std::optional<int> in_responseCode, std::optional<String> in_responsePhrase, std::unique_ptr<protocol::Array<protocol::Fetch::HeaderEntry>> in_responseHeaders, std::optional<Binary> in_binaryResponseHeaders, std::unique_ptr<ContinueResponseCallback> callback) = 0;
    class CONTENT_EXPORT GetResponseBodyCallback {
    public:
        virtual void sendSuccess(const String& body, bool base64Encoded) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetResponseBodyCallback() { }
    };
    virtual void GetResponseBody(const String& in_requestId, std::unique_ptr<GetResponseBodyCallback> callback) = 0;
    class CONTENT_EXPORT TakeResponseBodyAsStreamCallback {
    public:
        virtual void sendSuccess(const String& stream) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~TakeResponseBodyAsStreamCallback() { }
    };
    virtual void TakeResponseBodyAsStream(const String& in_requestId, std::unique_ptr<TakeResponseBodyAsStreamCallback> callback) = 0;

};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void RequestPaused(const String& requestId, std::unique_ptr<protocol::Network::Request> request, const String& frameId, const String& resourceType, std::optional<String> responseErrorReason = {}, std::optional<int> responseStatusCode = {}, std::optional<String> responseStatusText = {}, std::unique_ptr<protocol::Array<protocol::Fetch::HeaderEntry>> responseHeaders = {}, std::optional<String> networkId = {}, std::optional<String> redirectedRequestId = {});
    void AuthRequired(const String& requestId, std::unique_ptr<protocol::Network::Request> request, const String& frameId, const String& resourceType, std::unique_ptr<protocol::Fetch::AuthChallenge> authChallenge);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Fetch
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_Fetch_h)
