// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { sendWithPromise } from 'chrome://resources/js/cr.js';
export class FlagsBrowserProxyImpl {
    // 
    restartBrowser() {
        chrome.send('restartBrowser');
    }
    requestDeprecatedFeatures() {
        return sendWithPromise('requestDeprecatedFeatures');
    }
    // 
    resetAllFlags() {
        chrome.send('resetAllFlags');
    }
    requestExperimentalFeatures() {
        return sendWithPromise('requestExperimentalFeatures');
    }
    enableExperimentalFeature(internalName, enable) {
        chrome.send('enableExperimentalFeature', [internalName, String(enable)]);
    }
    selectExperimentalFeature(internalName, index) {
        chrome.send('enableExperimentalFeature', [`${internalName}@${index}`, 'true']);
    }
    setOriginListFlag(internalName, value) {
        chrome.send('setOriginListFlag', [internalName, value]);
    }
    setStringFlag(internalName, value) {
        chrome.send('setStringFlag', [internalName, value]);
    }
    static getInstance() {
        return instance || (instance = new FlagsBrowserProxyImpl());
    }
    static setInstance(obj) {
        instance = obj;
    }
}
let instance = null;
