// components/webapps/services/web_app_origin_association/public/mojom/web_app_origin_association_parser.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/webapps/services/web_app_origin_association/public/mojom/web_app_origin_association_parser.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/webapps/services/web_app_origin_association/public/mojom/web_app_origin_association_parser.mojom-params-data.h"
#include "components/webapps/services/web_app_origin_association/public/mojom/web_app_origin_association_parser.mojom-shared-message-ids.h"

#include "components/webapps/services/web_app_origin_association/public/mojom/web_app_origin_association_parser.mojom-import-headers.h"
#include "components/webapps/services/web_app_origin_association/public/mojom/web_app_origin_association_parser.mojom-test-utils.h"


namespace webapps::mojom {
WebAppOriginAssociation::WebAppOriginAssociation()
    : apps() {}

WebAppOriginAssociation::WebAppOriginAssociation(
    std::vector<AssociatedWebAppPtr> apps_in)
    : apps(std::move(apps_in)) {}

WebAppOriginAssociation::~WebAppOriginAssociation() = default;

void WebAppOriginAssociation::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "apps"), this->apps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<AssociatedWebAppPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebAppOriginAssociation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AssociatedWebApp::AssociatedWebApp()
    : web_app_identity(),
      scope() {}

AssociatedWebApp::AssociatedWebApp(
    const ::GURL& web_app_identity_in,
    const ::GURL& scope_in)
    : web_app_identity(std::move(web_app_identity_in)),
      scope(std::move(scope_in)) {}

AssociatedWebApp::~AssociatedWebApp() = default;

void AssociatedWebApp::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "web_app_identity"), this->web_app_identity,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scope"), this->scope,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AssociatedWebApp::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebAppOriginAssociationError::WebAppOriginAssociationError()
    : message(),
      line(),
      column() {}

WebAppOriginAssociationError::WebAppOriginAssociationError(
    const std::string& message_in,
    int32_t line_in,
    int32_t column_in)
    : message(std::move(message_in)),
      line(std::move(line_in)),
      column(std::move(column_in)) {}

WebAppOriginAssociationError::~WebAppOriginAssociationError() = default;
size_t WebAppOriginAssociationError::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->message);
  seed = mojo::internal::Hash(seed, this->line);
  seed = mojo::internal::Hash(seed, this->column);
  return seed;
}

void WebAppOriginAssociationError::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message"), this->message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "line"), this->line,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "column"), this->column,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebAppOriginAssociationError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

WebAppOriginAssociationParser::IPCStableHashFunction WebAppOriginAssociationParser::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebAppOriginAssociationParser>(message.name())) {
    case messages::WebAppOriginAssociationParser::kParseWebAppOriginAssociation: {
      return &WebAppOriginAssociationParser::ParseWebAppOriginAssociation_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebAppOriginAssociationParser::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebAppOriginAssociationParser>(message.name())) {
      case messages::WebAppOriginAssociationParser::kParseWebAppOriginAssociation:
            return "Receive webapps::mojom::WebAppOriginAssociationParser::ParseWebAppOriginAssociation";
    }
  } else {
    switch (static_cast<messages::WebAppOriginAssociationParser>(message.name())) {
      case messages::WebAppOriginAssociationParser::kParseWebAppOriginAssociation:
            return "Receive reply webapps::mojom::WebAppOriginAssociationParser::ParseWebAppOriginAssociation";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebAppOriginAssociationParser::ParseWebAppOriginAssociation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x500e86ad;  // IPCStableHash for webapps::mojom::WebAppOriginAssociationParser::ParseWebAppOriginAssociation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WebAppOriginAssociationParser_ParseWebAppOriginAssociation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebAppOriginAssociationParser_ParseWebAppOriginAssociation_ForwardToCallback(
      WebAppOriginAssociationParser::ParseWebAppOriginAssociationCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebAppOriginAssociationParser_ParseWebAppOriginAssociation_ForwardToCallback(const WebAppOriginAssociationParser_ParseWebAppOriginAssociation_ForwardToCallback&) = delete;
  WebAppOriginAssociationParser_ParseWebAppOriginAssociation_ForwardToCallback& operator=(const WebAppOriginAssociationParser_ParseWebAppOriginAssociation_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebAppOriginAssociationParser::ParseWebAppOriginAssociationCallback callback_;
};

WebAppOriginAssociationParserProxy::WebAppOriginAssociationParserProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebAppOriginAssociationParserProxy::ParseWebAppOriginAssociation(
    const std::string& in_raw_json, const ::url::Origin& in_associate_origin, ParseWebAppOriginAssociationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send webapps::mojom::WebAppOriginAssociationParser::ParseWebAppOriginAssociation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("raw_json"), in_raw_json,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("associate_origin"), in_associate_origin,
                        "<value of type const ::url::Origin&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppOriginAssociationParser::kParseWebAppOriginAssociation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webapps::mojom::internal::WebAppOriginAssociationParser_ParseWebAppOriginAssociation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->raw_json)::BaseType> raw_json_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_raw_json,
    raw_json_fragment);

  params->raw_json.Set(
      raw_json_fragment.is_null() ? nullptr : raw_json_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->raw_json.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null raw_json in WebAppOriginAssociationParser.ParseWebAppOriginAssociation request");
  mojo::internal::MessageFragment<
      typename decltype(params->associate_origin)::BaseType> associate_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_associate_origin,
    associate_origin_fragment);

  params->associate_origin.Set(
      associate_origin_fragment.is_null() ? nullptr : associate_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->associate_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null associate_origin in WebAppOriginAssociationParser.ParseWebAppOriginAssociation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppOriginAssociationParser::Name_);
  message.set_method_name("ParseWebAppOriginAssociation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebAppOriginAssociationParser_ParseWebAppOriginAssociation_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class WebAppOriginAssociationParser_ParseWebAppOriginAssociation_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebAppOriginAssociationParser::ParseWebAppOriginAssociationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebAppOriginAssociationParser_ParseWebAppOriginAssociation_ProxyToResponder> proxy(
        new WebAppOriginAssociationParser_ParseWebAppOriginAssociation_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebAppOriginAssociationParser_ParseWebAppOriginAssociation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebAppOriginAssociationParser_ParseWebAppOriginAssociation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebAppOriginAssociationParser_ParseWebAppOriginAssociation_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebAppOriginAssociationParser::ParseWebAppOriginAssociationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      WebAppOriginAssociationPtr in_association, std::vector<WebAppOriginAssociationErrorPtr> in_errors);
};

bool WebAppOriginAssociationParser_ParseWebAppOriginAssociation_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebAppOriginAssociationParser_ParseWebAppOriginAssociation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebAppOriginAssociationParser_ParseWebAppOriginAssociation_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebAppOriginAssociationParser.0
  bool success = true;
  WebAppOriginAssociationPtr p_association{};
  std::vector<WebAppOriginAssociationErrorPtr> p_errors{};
  WebAppOriginAssociationParser_ParseWebAppOriginAssociation_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAssociation(&p_association))
    success = false;
  if (success && !input_data_view.ReadErrors(&p_errors))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebAppOriginAssociationParser::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_association), 
std::move(p_errors));
  }
  return true;
}

void WebAppOriginAssociationParser_ParseWebAppOriginAssociation_ProxyToResponder::Run(
    WebAppOriginAssociationPtr in_association, std::vector<WebAppOriginAssociationErrorPtr> in_errors) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply webapps::mojom::WebAppOriginAssociationParser::ParseWebAppOriginAssociation", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("association"), in_association,
                        "<value of type WebAppOriginAssociationPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("errors"), in_errors,
                        "<value of type std::vector<WebAppOriginAssociationErrorPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppOriginAssociationParser::kParseWebAppOriginAssociation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webapps::mojom::internal::WebAppOriginAssociationParser_ParseWebAppOriginAssociation_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->association)::BaseType> association_fragment(
          params.message());
  
  mojo::internal::Serialize<::webapps::mojom::WebAppOriginAssociationDataView>(
    in_association,
    association_fragment);

  params->association.Set(
      association_fragment.is_null() ? nullptr : association_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->errors)::BaseType>
      errors_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& errors_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::webapps::mojom::WebAppOriginAssociationErrorDataView>>(
    in_errors,
    errors_fragment,
    &errors_validate_params);

  params->errors.Set(
      errors_fragment.is_null() ? nullptr : errors_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->errors.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null errors in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppOriginAssociationParser::Name_);
  message.set_method_name("ParseWebAppOriginAssociation");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebAppOriginAssociationParserStubDispatch::Accept(
    WebAppOriginAssociationParser* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebAppOriginAssociationParser>(message->header()->name)) {
    case messages::WebAppOriginAssociationParser::kParseWebAppOriginAssociation: {
      break;
    }
  }
  return false;
}

// static
bool WebAppOriginAssociationParserStubDispatch::AcceptWithResponder(
    WebAppOriginAssociationParser* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebAppOriginAssociationParser>(message->header()->name)) {
    case messages::WebAppOriginAssociationParser::kParseWebAppOriginAssociation: {
      internal::WebAppOriginAssociationParser_ParseWebAppOriginAssociation_Params_Data* params =
          reinterpret_cast<
              internal::WebAppOriginAssociationParser_ParseWebAppOriginAssociation_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebAppOriginAssociationParser.0
      bool success = true;
      std::string p_raw_json{};
      ::url::Origin p_associate_origin{};
      WebAppOriginAssociationParser_ParseWebAppOriginAssociation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRawJson(&p_raw_json))
        success = false;
      if (success && !input_data_view.ReadAssociateOrigin(&p_associate_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebAppOriginAssociationParser::Name_, 0, false);
        return false;
      }
      auto callback =
          WebAppOriginAssociationParser_ParseWebAppOriginAssociation_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ParseWebAppOriginAssociation(        
        std::move(p_raw_json), 
        std::move(p_associate_origin), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebAppOriginAssociationParserValidationInfo[] = {
    { &internal::WebAppOriginAssociationParser_ParseWebAppOriginAssociation_Params_Data::Validate,
     &internal::WebAppOriginAssociationParser_ParseWebAppOriginAssociation_ResponseParams_Data::Validate},
};

bool WebAppOriginAssociationParserRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::webapps::mojom::WebAppOriginAssociationParser::Name_,
    kWebAppOriginAssociationParserValidationInfo);
}

bool WebAppOriginAssociationParserResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::webapps::mojom::WebAppOriginAssociationParser::Name_,
    kWebAppOriginAssociationParserValidationInfo);
}


}  // webapps::mojom


namespace mojo {


// static
bool StructTraits<::webapps::mojom::WebAppOriginAssociation::DataView, ::webapps::mojom::WebAppOriginAssociationPtr>::Read(
    ::webapps::mojom::WebAppOriginAssociation::DataView input,
    ::webapps::mojom::WebAppOriginAssociationPtr* output) {
  bool success = true;
  ::webapps::mojom::WebAppOriginAssociationPtr result(::webapps::mojom::WebAppOriginAssociation::New());
  
      if (success && !input.ReadApps(&result->apps))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webapps::mojom::AssociatedWebApp::DataView, ::webapps::mojom::AssociatedWebAppPtr>::Read(
    ::webapps::mojom::AssociatedWebApp::DataView input,
    ::webapps::mojom::AssociatedWebAppPtr* output) {
  bool success = true;
  ::webapps::mojom::AssociatedWebAppPtr result(::webapps::mojom::AssociatedWebApp::New());
  
      if (success && !input.ReadWebAppIdentity(&result->web_app_identity))
        success = false;
      if (success && !input.ReadScope(&result->scope))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webapps::mojom::WebAppOriginAssociationError::DataView, ::webapps::mojom::WebAppOriginAssociationErrorPtr>::Read(
    ::webapps::mojom::WebAppOriginAssociationError::DataView input,
    ::webapps::mojom::WebAppOriginAssociationErrorPtr* output) {
  bool success = true;
  ::webapps::mojom::WebAppOriginAssociationErrorPtr result(::webapps::mojom::WebAppOriginAssociationError::New());
  
      if (success && !input.ReadMessage(&result->message))
        success = false;
      if (success)
        result->line = input.line();
      if (success)
        result->column = input.column();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace webapps::mojom {


void WebAppOriginAssociationParserInterceptorForTesting::ParseWebAppOriginAssociation(const std::string& raw_json, const ::url::Origin& associate_origin, ParseWebAppOriginAssociationCallback callback) {
  GetForwardingInterface()->ParseWebAppOriginAssociation(
    std::move(raw_json)
    , 
    std::move(associate_origin)
    , std::move(callback));
}
WebAppOriginAssociationParserAsyncWaiter::WebAppOriginAssociationParserAsyncWaiter(
    WebAppOriginAssociationParser* proxy) : proxy_(proxy) {}

WebAppOriginAssociationParserAsyncWaiter::~WebAppOriginAssociationParserAsyncWaiter() = default;


void WebAppOriginAssociationParserAsyncWaiter::ParseWebAppOriginAssociation(
    const std::string& raw_json, const ::url::Origin& associate_origin, WebAppOriginAssociationPtr* out_association, std::vector<WebAppOriginAssociationErrorPtr>* out_errors) {
  base::RunLoop loop;
  proxy_->ParseWebAppOriginAssociation(
      std::move(raw_json),
      std::move(associate_origin),
      base::BindOnce(
          [](base::RunLoop* loop,
             WebAppOriginAssociationPtr* out_association
,
             std::vector<WebAppOriginAssociationErrorPtr>* out_errors
,
             WebAppOriginAssociationPtr association,
             std::vector<WebAppOriginAssociationErrorPtr> errors) {*out_association = std::move(association);*out_errors = std::move(errors);
            loop->Quit();
          },
          &loop,
          out_association,
          out_errors));
  loop.Run();
}








}  // webapps::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif