// components/webapps/common/web_page_metadata.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_WEBAPPS_COMMON_WEB_PAGE_METADATA_MOJOM_SHARED_H_
#define COMPONENTS_WEBAPPS_COMMON_WEB_PAGE_METADATA_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/webapps/common/web_page_metadata.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"




#include "components/webapps/common/web_page_metadata.mojom-data-view.h"




namespace std {

template <>
struct hash<::webapps::mojom::WebPageMobileCapable>
    : public mojo::internal::EnumHashImpl<::webapps::mojom::WebPageMobileCapable> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webapps::mojom::WebPageMobileCapable, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::webapps::mojom::WebPageMobileCapable, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::webapps::mojom::WebPageMobileCapable>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webapps::mojom::WebPageIconInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webapps::mojom::WebPageIconInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webapps::mojom::internal::WebPageIconInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in WebPageIconInfo struct");

    fragment->square_size_px = Traits::square_size_px(input);
  }

  static bool Deserialize(::webapps::mojom::internal::WebPageIconInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webapps::mojom::WebPageIconInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webapps::mojom::WebPageMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webapps::mojom::WebPageMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webapps::mojom::internal::WebPageMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::application_name(input)) in_application_name = Traits::application_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->application_name)::BaseType> application_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_application_name,
      application_name_fragment);

    fragment->application_name.Set(
        application_name_fragment.is_null() ? nullptr : application_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->application_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null application_name in WebPageMetadata struct");

    decltype(Traits::description(input)) in_description = Traits::description(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description)::BaseType> description_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_description,
      description_fragment);

    fragment->description.Set(
        description_fragment.is_null() ? nullptr : description_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->description.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null description in WebPageMetadata struct");

    decltype(Traits::application_url(input)) in_application_url = Traits::application_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->application_url)::BaseType> application_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_application_url,
      application_url_fragment);

    fragment->application_url.Set(
        application_url_fragment.is_null() ? nullptr : application_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->application_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null application_url in WebPageMetadata struct");

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in WebPageMetadata struct");

    decltype(Traits::icons(input)) in_icons = Traits::icons(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icons)::BaseType>
        icons_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::webapps::mojom::WebPageIconInfoDataView>>(
      in_icons,
      icons_fragment,
      &icons_validate_params);

    fragment->icons.Set(
        icons_fragment.is_null() ? nullptr : icons_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->icons.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null icons in WebPageMetadata struct");

    
    mojo::internal::Serialize<::webapps::mojom::WebPageMobileCapable>(
      Traits::mobile_capable(input),
      &fragment->mobile_capable);
  }

  static bool Deserialize(::webapps::mojom::internal::WebPageMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webapps::mojom::WebPageMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace webapps::mojom {

inline void WebPageIconInfoDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void WebPageMetadataDataView::GetApplicationNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->application_name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void WebPageMetadataDataView::GetDescriptionDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->description.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void WebPageMetadataDataView::GetApplicationUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->application_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void WebPageMetadataDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void WebPageMetadataDataView::GetIconsDataView(
    mojo::ArrayDataView<WebPageIconInfoDataView>* output) {
  auto pointer = data_->icons.Get();
  *output = mojo::ArrayDataView<WebPageIconInfoDataView>(pointer, message_);
}



}  // webapps::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::webapps::mojom::WebPageMobileCapable> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::webapps::mojom::WebPageMobileCapable value);
};

} // namespace perfetto

#endif  // COMPONENTS_WEBAPPS_COMMON_WEB_PAGE_METADATA_MOJOM_SHARED_H_