// components/web_package/mojom/web_bundle_parser.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_TEST_UTILS_H_
#define COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_TEST_UTILS_H_

#include "components/web_package/mojom/web_bundle_parser.mojom.h"


namespace web_package::mojom {


class  WebBundleParserFactoryInterceptorForTesting : public WebBundleParserFactory {
  virtual WebBundleParserFactory* GetForwardingInterface() = 0;
  void GetParserForDataSource(::mojo::PendingReceiver<WebBundleParser> receiver, const std::optional<::GURL>& base_url, ::mojo::PendingRemote<BundleDataSource> data_source) override;
  void BindFileDataSource(::mojo::PendingReceiver<BundleDataSource> data_source, ::base::File file) override;
};
class  WebBundleParserFactoryAsyncWaiter {
 public:
  explicit WebBundleParserFactoryAsyncWaiter(WebBundleParserFactory* proxy);

  WebBundleParserFactoryAsyncWaiter(const WebBundleParserFactoryAsyncWaiter&) = delete;
  WebBundleParserFactoryAsyncWaiter& operator=(const WebBundleParserFactoryAsyncWaiter&) = delete;

  ~WebBundleParserFactoryAsyncWaiter();

 private:
  WebBundleParserFactory* const proxy_;
};


class  WebBundleParserInterceptorForTesting : public WebBundleParser {
  virtual WebBundleParser* GetForwardingInterface() = 0;
  void ParseIntegrityBlock(ParseIntegrityBlockCallback callback) override;
  void ParseMetadata(std::optional<uint64_t> offset, ParseMetadataCallback callback) override;
  void ParseResponse(uint64_t response_offset, uint64_t response_length, ParseResponseCallback callback) override;
  void Close(CloseCallback callback) override;
};
class  WebBundleParserAsyncWaiter {
 public:
  explicit WebBundleParserAsyncWaiter(WebBundleParser* proxy);

  WebBundleParserAsyncWaiter(const WebBundleParserAsyncWaiter&) = delete;
  WebBundleParserAsyncWaiter& operator=(const WebBundleParserAsyncWaiter&) = delete;

  ~WebBundleParserAsyncWaiter();
  void ParseIntegrityBlock(
      BundleIntegrityBlockPtr* out_Result, BundleIntegrityBlockParseErrorPtr* out_error);
  
  void ParseMetadata(
      std::optional<uint64_t> offset, BundleMetadataPtr* out_Result, BundleMetadataParseErrorPtr* out_error);
  
  void ParseResponse(
      uint64_t response_offset, uint64_t response_length, BundleResponsePtr* out_Result, BundleResponseParseErrorPtr* out_error);
  
  void Close(
      );
  

 private:
  WebBundleParser* const proxy_;
};


class  BundleDataSourceInterceptorForTesting : public BundleDataSource {
  virtual BundleDataSource* GetForwardingInterface() = 0;
  void Read(uint64_t offset, uint64_t length, ReadCallback callback) override;
  void Length(LengthCallback callback) override;
  void IsRandomAccessContext(IsRandomAccessContextCallback callback) override;
  void Close(CloseCallback callback) override;
};
class  BundleDataSourceAsyncWaiter {
 public:
  explicit BundleDataSourceAsyncWaiter(BundleDataSource* proxy);

  BundleDataSourceAsyncWaiter(const BundleDataSourceAsyncWaiter&) = delete;
  BundleDataSourceAsyncWaiter& operator=(const BundleDataSourceAsyncWaiter&) = delete;

  ~BundleDataSourceAsyncWaiter();
  void Read(
      uint64_t offset, uint64_t length, std::optional<std::vector<uint8_t>>* out_buffer);
  std::optional<std::vector<uint8_t>> Read(uint64_t offset, uint64_t length);
  void Length(
      int64_t* out_length);
  int64_t Length();
  void IsRandomAccessContext(
      bool* out_is_random_access);
  bool IsRandomAccessContext();
  void Close(
      );
  

 private:
  BundleDataSource* const proxy_;
};




}  // web_package::mojom

#endif  // COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_TEST_UTILS_H_