// components/web_package/mojom/web_bundle_parser.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_SEND_VALIDATION_H_

#include "components/web_package/mojom/web_bundle_parser.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "components/web_package/mojom/web_bundle_parser.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::web_package::mojom::BundleParseErrorType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::web_package::mojom::BundleFormatVersion, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::web_package::mojom::BundleIntegrityBlockParseErrorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::BundleIntegrityBlockParseErrorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::BundleIntegrityBlockParseError_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::web_package::mojom::BundleParseErrorType>(
        Traits::type(input),
        &fragment->type);

      decltype(Traits::message(input)) in_message = Traits::message(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->message)::BaseType> message_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_message,
        message_fragment);

      fragment->message.Set(
          message_fragment.is_null() ? nullptr : message_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->message.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null message in BundleIntegrityBlockParseError struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::web_package::mojom::BundleMetadataParseErrorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::BundleMetadataParseErrorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::BundleMetadataParseError_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::web_package::mojom::BundleParseErrorType>(
        Traits::type(input),
        &fragment->type);

      decltype(Traits::message(input)) in_message = Traits::message(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->message)::BaseType> message_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_message,
        message_fragment);

      fragment->message.Set(
          message_fragment.is_null() ? nullptr : message_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->message.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null message in BundleMetadataParseError struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::web_package::mojom::BundleResponseParseErrorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::BundleResponseParseErrorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::BundleResponseParseError_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::web_package::mojom::BundleParseErrorType>(
        Traits::type(input),
        &fragment->type);

      decltype(Traits::message(input)) in_message = Traits::message(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->message)::BaseType> message_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_message,
        message_fragment);

      fragment->message.Set(
          message_fragment.is_null() ? nullptr : message_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->message.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null message in BundleResponseParseError struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::web_package::mojom::BundleIntegrityBlockAttributesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::BundleIntegrityBlockAttributesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::BundleIntegrityBlockAttributes_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::web_bundle_id(input)) in_web_bundle_id = Traits::web_bundle_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->web_bundle_id)::BaseType> web_bundle_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_web_bundle_id,
        web_bundle_id_fragment);

      fragment->web_bundle_id.Set(
          web_bundle_id_fragment.is_null() ? nullptr : web_bundle_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->web_bundle_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null web_bundle_id in BundleIntegrityBlockAttributes struct");

      decltype(Traits::cbor(input)) in_cbor = Traits::cbor(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cbor)::BaseType>
          cbor_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& cbor_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_cbor,
        cbor_fragment,
        &cbor_validate_params);

      fragment->cbor.Set(
          cbor_fragment.is_null() ? nullptr : cbor_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cbor.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cbor in BundleIntegrityBlockAttributes struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::web_package::mojom::BundleIntegrityBlockDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::BundleIntegrityBlockDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::BundleIntegrityBlock_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->size = Traits::size(input);

      decltype(Traits::signature_stack(input)) in_signature_stack = Traits::signature_stack(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->signature_stack)::BaseType>
          signature_stack_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& signature_stack_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::web_package::mojom::BundleIntegrityBlockSignatureStackEntryDataView>, send_validation>(
        in_signature_stack,
        signature_stack_fragment,
        &signature_stack_validate_params);

      fragment->signature_stack.Set(
          signature_stack_fragment.is_null() ? nullptr : signature_stack_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->signature_stack.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null signature_stack in BundleIntegrityBlock struct");

      decltype(Traits::attributes(input)) in_attributes = Traits::attributes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->attributes)::BaseType> attributes_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::web_package::mojom::BundleIntegrityBlockAttributesDataView, send_validation>(
        in_attributes,
        attributes_fragment);

      fragment->attributes.Set(
          attributes_fragment.is_null() ? nullptr : attributes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->attributes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null attributes in BundleIntegrityBlock struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::web_package::mojom::Ed25519PublicKeyDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::Ed25519PublicKeyDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::Ed25519PublicKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::bytes(input)) in_bytes = Traits::bytes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bytes)::BaseType>
          bytes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
          mojo::internal::GetArrayValidator<32, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_bytes,
        bytes_fragment,
        &bytes_validate_params);

      fragment->bytes.Set(
          bytes_fragment.is_null() ? nullptr : bytes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bytes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bytes in Ed25519PublicKey struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::web_package::mojom::Ed25519SignatureDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::Ed25519SignatureDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::Ed25519Signature_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::bytes(input)) in_bytes = Traits::bytes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bytes)::BaseType>
          bytes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
          mojo::internal::GetArrayValidator<64, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_bytes,
        bytes_fragment,
        &bytes_validate_params);

      fragment->bytes.Set(
          bytes_fragment.is_null() ? nullptr : bytes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bytes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bytes in Ed25519Signature struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::web_package::mojom::SignatureInfoEd25519DataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::SignatureInfoEd25519DataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::SignatureInfoEd25519_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::public_key(input)) in_public_key = Traits::public_key(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->public_key)::BaseType> public_key_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::web_package::mojom::Ed25519PublicKeyDataView, send_validation>(
        in_public_key,
        public_key_fragment);

      fragment->public_key.Set(
          public_key_fragment.is_null() ? nullptr : public_key_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->public_key.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null public_key in SignatureInfoEd25519 struct");

      decltype(Traits::signature(input)) in_signature = Traits::signature(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->signature)::BaseType> signature_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::web_package::mojom::Ed25519SignatureDataView, send_validation>(
        in_signature,
        signature_fragment);

      fragment->signature.Set(
          signature_fragment.is_null() ? nullptr : signature_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->signature.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null signature in SignatureInfoEd25519 struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::web_package::mojom::EcdsaP256PublicKeyDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::EcdsaP256PublicKeyDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::EcdsaP256PublicKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::bytes(input)) in_bytes = Traits::bytes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bytes)::BaseType>
          bytes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
          mojo::internal::GetArrayValidator<33, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_bytes,
        bytes_fragment,
        &bytes_validate_params);

      fragment->bytes.Set(
          bytes_fragment.is_null() ? nullptr : bytes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bytes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bytes in EcdsaP256PublicKey struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::web_package::mojom::EcdsaP256SHA256SignatureDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::EcdsaP256SHA256SignatureDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::EcdsaP256SHA256Signature_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::bytes(input)) in_bytes = Traits::bytes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bytes)::BaseType>
          bytes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_bytes,
        bytes_fragment,
        &bytes_validate_params);

      fragment->bytes.Set(
          bytes_fragment.is_null() ? nullptr : bytes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bytes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bytes in EcdsaP256SHA256Signature struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::web_package::mojom::SignatureInfoEcdsaP256SHA256DataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::SignatureInfoEcdsaP256SHA256DataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::SignatureInfoEcdsaP256SHA256_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::public_key(input)) in_public_key = Traits::public_key(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->public_key)::BaseType> public_key_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::web_package::mojom::EcdsaP256PublicKeyDataView, send_validation>(
        in_public_key,
        public_key_fragment);

      fragment->public_key.Set(
          public_key_fragment.is_null() ? nullptr : public_key_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->public_key.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null public_key in SignatureInfoEcdsaP256SHA256 struct");

      decltype(Traits::signature(input)) in_signature = Traits::signature(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->signature)::BaseType> signature_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::web_package::mojom::EcdsaP256SHA256SignatureDataView, send_validation>(
        in_signature,
        signature_fragment);

      fragment->signature.Set(
          signature_fragment.is_null() ? nullptr : signature_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->signature.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null signature in SignatureInfoEcdsaP256SHA256 struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::web_package::mojom::SignatureInfoUnknownDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::SignatureInfoUnknownDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::SignatureInfoUnknown_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::web_package::mojom::BundleIntegrityBlockSignatureStackEntryDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::BundleIntegrityBlockSignatureStackEntryDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::BundleIntegrityBlockSignatureStackEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::attributes_cbor(input)) in_attributes_cbor = Traits::attributes_cbor(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->attributes_cbor)::BaseType>
          attributes_cbor_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& attributes_cbor_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_attributes_cbor,
        attributes_cbor_fragment,
        &attributes_cbor_validate_params);

      fragment->attributes_cbor.Set(
          attributes_cbor_fragment.is_null() ? nullptr : attributes_cbor_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->attributes_cbor.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null attributes_cbor in BundleIntegrityBlockSignatureStackEntry struct");

      decltype(Traits::signature_info(input)) in_signature_info = Traits::signature_info(input);
      mojo::internal::MessageFragment<decltype(fragment->signature_info)>
          signature_info_fragment(fragment.message());
      signature_info_fragment.Claim(&fragment->signature_info);
      
      mojo::internal::Serialize<::web_package::mojom::SignatureInfoDataView, send_validation>(
        in_signature_info,
        signature_info_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->signature_info.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null signature_info in BundleIntegrityBlockSignatureStackEntry struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::web_package::mojom::BundleMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::BundleMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::BundleMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::web_package::mojom::BundleFormatVersion>(
        Traits::version(input),
        &fragment->version);

      decltype(Traits::primary_url(input)) in_primary_url = Traits::primary_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->primary_url)::BaseType> primary_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_primary_url,
        primary_url_fragment);

      fragment->primary_url.Set(
          primary_url_fragment.is_null() ? nullptr : primary_url_fragment.data());

      decltype(Traits::requests(input)) in_requests = Traits::requests(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->requests)::BaseType>
          requests_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& requests_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::url::mojom::UrlDataView, ::web_package::mojom::BundleResponseLocationDataView>, send_validation>(
        in_requests,
        requests_fragment,
        &requests_validate_params);

      fragment->requests.Set(
          requests_fragment.is_null() ? nullptr : requests_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->requests.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null requests in BundleMetadata struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::web_package::mojom::BundleResponseLocationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::BundleResponseLocationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::BundleResponseLocation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->offset = Traits::offset(input);

      fragment->length = Traits::length(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::web_package::mojom::BundleResponseDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::web_package::mojom::BundleResponseDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::web_package::mojom::internal::BundleResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->response_code = Traits::response_code(input);

      decltype(Traits::response_headers(input)) in_response_headers = Traits::response_headers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->response_headers)::BaseType>
          response_headers_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& response_headers_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>, send_validation>(
        in_response_headers,
        response_headers_fragment,
        &response_headers_validate_params);

      fragment->response_headers.Set(
          response_headers_fragment.is_null() ? nullptr : response_headers_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->response_headers.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null response_headers in BundleResponse struct");

      fragment->payload_offset = Traits::payload_offset(input);

      fragment->payload_length = Traits::payload_length(input);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::web_package::mojom::SignatureInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::web_package::mojom::SignatureInfoDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::web_package::mojom::internal::SignatureInfo_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::web_package::mojom::SignatureInfoDataView::Tag::kUnknown: {
    decltype(Traits::unknown(input))
    in_unknown = Traits::unknown(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_unknown)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::web_package::mojom::SignatureInfoUnknownDataView, send_validation>(
  in_unknown,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null unknown in SignatureInfo union");
    fragment->data.f_unknown.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::web_package::mojom::SignatureInfoDataView::Tag::kEd25519: {
    decltype(Traits::ed25519(input))
    in_ed25519 = Traits::ed25519(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_ed25519)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::web_package::mojom::SignatureInfoEd25519DataView, send_validation>(
  in_ed25519,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null ed25519 in SignatureInfo union");
    fragment->data.f_ed25519.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::web_package::mojom::SignatureInfoDataView::Tag::kEcdsaP256Sha256: {
    decltype(Traits::ecdsa_p256_sha256(input))
    in_ecdsa_p256_sha256 = Traits::ecdsa_p256_sha256(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_ecdsa_p256_sha256)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::web_package::mojom::SignatureInfoEcdsaP256SHA256DataView, send_validation>(
  in_ecdsa_p256_sha256,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null ecdsa_p256_sha256 in SignatureInfo union");
    fragment->data.f_ecdsa_p256_sha256.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_WEB_PACKAGE_MOJOM_WEB_BUNDLE_PARSER_MOJOM_SEND_VALIDATION_H_