// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef ui_devtools_protocol_Tracing_h
#define ui_devtools_protocol_Tracing_h

#include "components/ui_devtools/devtools_export.h"
#include "components/ui_devtools/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace ui_devtools {
namespace protocol {
namespace Tracing {

// ------------- Forward and enum declarations.

// ------------- Type and builder declarations.

// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.

// ------------- Backend interface.

class UI_DEVTOOLS_EXPORT Backend {
public:
    virtual ~Backend() { }

    class UI_DEVTOOLS_EXPORT StartCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~StartCallback() { }
    };
    virtual void start(std::optional<String> in_categories, std::optional<String> in_options, std::optional<double> in_bufferUsageReportingInterval, std::unique_ptr<StartCallback> callback) = 0;
    virtual DispatchResponse end() = 0;
    virtual DispatchResponse disable() = 0;
    virtual DispatchResponse enable() = 0;

};

// ------------- Frontend interface.

class UI_DEVTOOLS_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void dataCollected(std::unique_ptr<protocol::Array<protocol::DictionaryValue>> value);
    void tracingComplete(std::optional<bool> dataLossOccurred = {});
    void bufferUsage(std::optional<double> percentFull = {}, std::optional<double> eventCount = {}, std::optional<double> value = {});

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class UI_DEVTOOLS_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class UI_DEVTOOLS_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Tracing
} // namespace ui_devtools
} // namespace protocol

#endif // !defined(ui_devtools_protocol_Tracing_h)
