// components/translate/content/common/translate.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/translate/content/common/translate.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/translate/content/common/translate.mojom-params-data.h"
#include "components/translate/content/common/translate.mojom-shared-message-ids.h"

#include "components/translate/content/common/translate.mojom-import-headers.h"
#include "components/translate/content/common/translate.mojom-test-utils.h"


namespace translate::mojom {
LanguageDetectionDetails::LanguageDetectionDetails()
    : url(),
      adopted_language(),
      has_notranslate(),
      has_run_lang_detection(),
      time(),
      content_language(),
      model_detected_language(),
      is_model_reliable(),
      html_root_language(),
      contents(),
      model_reliability_score(),
      detection_model_version() {}

LanguageDetectionDetails::LanguageDetectionDetails(
    const ::GURL& url_in,
    const std::string& adopted_language_in,
    bool has_notranslate_in,
    bool has_run_lang_detection_in,
    ::base::Time time_in,
    const std::string& content_language_in,
    const std::string& model_detected_language_in,
    bool is_model_reliable_in,
    const std::string& html_root_language_in,
    const ::std::u16string& contents_in,
    float model_reliability_score_in,
    const std::string& detection_model_version_in)
    : url(std::move(url_in)),
      adopted_language(std::move(adopted_language_in)),
      has_notranslate(std::move(has_notranslate_in)),
      has_run_lang_detection(std::move(has_run_lang_detection_in)),
      time(std::move(time_in)),
      content_language(std::move(content_language_in)),
      model_detected_language(std::move(model_detected_language_in)),
      is_model_reliable(std::move(is_model_reliable_in)),
      html_root_language(std::move(html_root_language_in)),
      contents(std::move(contents_in)),
      model_reliability_score(std::move(model_reliability_score_in)),
      detection_model_version(std::move(detection_model_version_in)) {}

LanguageDetectionDetails::~LanguageDetectionDetails() = default;

void LanguageDetectionDetails::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "adopted_language"), this->adopted_language,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_notranslate"), this->has_notranslate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_run_lang_detection"), this->has_run_lang_detection,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "time"), this->time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_language"), this->content_language,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "model_detected_language"), this->model_detected_language,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_model_reliable"), this->is_model_reliable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "html_root_language"), this->html_root_language,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contents"), this->contents,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "model_reliability_score"), this->model_reliability_score,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "detection_model_version"), this->detection_model_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LanguageDetectionDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

TranslateAgent::IPCStableHashFunction TranslateAgent::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TranslateAgent>(message.name())) {
    case messages::TranslateAgent::kTranslateFrame: {
      return &TranslateAgent::TranslateFrame_Sym::IPCStableHash;
    }
    case messages::TranslateAgent::kRevertTranslation: {
      return &TranslateAgent::RevertTranslation_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TranslateAgent::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TranslateAgent>(message.name())) {
      case messages::TranslateAgent::kTranslateFrame:
            return "Receive translate::mojom::TranslateAgent::TranslateFrame";
      case messages::TranslateAgent::kRevertTranslation:
            return "Receive translate::mojom::TranslateAgent::RevertTranslation";
    }
  } else {
    switch (static_cast<messages::TranslateAgent>(message.name())) {
      case messages::TranslateAgent::kTranslateFrame:
            return "Receive reply translate::mojom::TranslateAgent::TranslateFrame";
      case messages::TranslateAgent::kRevertTranslation:
            return "Receive reply translate::mojom::TranslateAgent::RevertTranslation";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TranslateAgent::TranslateFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xae161b59;  // IPCStableHash for translate::mojom::TranslateAgent::TranslateFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TranslateAgent::RevertTranslation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3448e6c1;  // IPCStableHash for translate::mojom::TranslateAgent::RevertTranslation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class TranslateAgent_TranslateFrame_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TranslateAgent_TranslateFrame_ForwardToCallback(
      TranslateAgent::TranslateFrameCallback callback
      ) : callback_(std::move(callback)) {
  }

  TranslateAgent_TranslateFrame_ForwardToCallback(const TranslateAgent_TranslateFrame_ForwardToCallback&) = delete;
  TranslateAgent_TranslateFrame_ForwardToCallback& operator=(const TranslateAgent_TranslateFrame_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TranslateAgent::TranslateFrameCallback callback_;
};

TranslateAgentProxy::TranslateAgentProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TranslateAgentProxy::TranslateFrame(
    const std::string& in_translate_script, const std::string& in_source_lang, const std::string& in_target_lang, TranslateFrameCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send translate::mojom::TranslateAgent::TranslateFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("translate_script"), in_translate_script,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_lang"), in_source_lang,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target_lang"), in_target_lang,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TranslateAgent::kTranslateFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::translate::mojom::internal::TranslateAgent_TranslateFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->translate_script)::BaseType> translate_script_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_translate_script,
    translate_script_fragment);

  params->translate_script.Set(
      translate_script_fragment.is_null() ? nullptr : translate_script_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->translate_script.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null translate_script in TranslateAgent.TranslateFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->source_lang)::BaseType> source_lang_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_source_lang,
    source_lang_fragment);

  params->source_lang.Set(
      source_lang_fragment.is_null() ? nullptr : source_lang_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_lang.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_lang in TranslateAgent.TranslateFrame request");
  mojo::internal::MessageFragment<
      typename decltype(params->target_lang)::BaseType> target_lang_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_target_lang,
    target_lang_fragment);

  params->target_lang.Set(
      target_lang_fragment.is_null() ? nullptr : target_lang_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->target_lang.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null target_lang in TranslateAgent.TranslateFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TranslateAgent::Name_);
  message.set_method_name("TranslateFrame");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TranslateAgent_TranslateFrame_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void TranslateAgentProxy::RevertTranslation(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send translate::mojom::TranslateAgent::RevertTranslation");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TranslateAgent::kRevertTranslation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::translate::mojom::internal::TranslateAgent_RevertTranslation_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TranslateAgent::Name_);
  message.set_method_name("RevertTranslation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class TranslateAgent_TranslateFrame_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TranslateAgent::TranslateFrameCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TranslateAgent_TranslateFrame_ProxyToResponder> proxy(
        new TranslateAgent_TranslateFrame_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TranslateAgent_TranslateFrame_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TranslateAgent_TranslateFrame_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TranslateAgent_TranslateFrame_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TranslateAgent::TranslateFrameCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_cancelled, const std::string& in_original_lang, const std::string& in_translated_lang, ::translate::TranslateErrors in_error);
};

bool TranslateAgent_TranslateFrame_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TranslateAgent_TranslateFrame_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TranslateAgent_TranslateFrame_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TranslateAgent.0
  bool success = true;
  bool p_cancelled{};
  std::string p_original_lang{};
  std::string p_translated_lang{};
  ::translate::TranslateErrors p_error{};
  TranslateAgent_TranslateFrame_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_cancelled = input_data_view.cancelled();
  if (success && !input_data_view.ReadOriginalLang(&p_original_lang))
    success = false;
  if (success && !input_data_view.ReadTranslatedLang(&p_translated_lang))
    success = false;
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TranslateAgent::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_cancelled), 
std::move(p_original_lang), 
std::move(p_translated_lang), 
std::move(p_error));
  }
  return true;
}

void TranslateAgent_TranslateFrame_ProxyToResponder::Run(
    bool in_cancelled, const std::string& in_original_lang, const std::string& in_translated_lang, ::translate::TranslateErrors in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply translate::mojom::TranslateAgent::TranslateFrame", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cancelled"), in_cancelled,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("original_lang"), in_original_lang,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("translated_lang"), in_translated_lang,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::translate::TranslateErrors>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TranslateAgent::kTranslateFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::translate::mojom::internal::TranslateAgent_TranslateFrame_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->cancelled = in_cancelled;
  mojo::internal::MessageFragment<
      typename decltype(params->original_lang)::BaseType> original_lang_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_original_lang,
    original_lang_fragment);

  params->original_lang.Set(
      original_lang_fragment.is_null() ? nullptr : original_lang_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->original_lang.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null original_lang in ");
  mojo::internal::MessageFragment<
      typename decltype(params->translated_lang)::BaseType> translated_lang_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_translated_lang,
    translated_lang_fragment);

  params->translated_lang.Set(
      translated_lang_fragment.is_null() ? nullptr : translated_lang_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->translated_lang.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null translated_lang in ");

  
  mojo::internal::Serialize<::translate::mojom::TranslateError>(
    in_error,
    &params->error);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TranslateAgent::Name_);
  message.set_method_name("TranslateFrame");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool TranslateAgentStubDispatch::Accept(
    TranslateAgent* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TranslateAgent>(message->header()->name)) {
    case messages::TranslateAgent::kTranslateFrame: {
      break;
    }
    case messages::TranslateAgent::kRevertTranslation: {
      DCHECK(message->is_serialized());
      internal::TranslateAgent_RevertTranslation_Params_Data* params =
          reinterpret_cast<internal::TranslateAgent_RevertTranslation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TranslateAgent.1
      bool success = true;
      TranslateAgent_RevertTranslation_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TranslateAgent::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RevertTranslation(        );
      return true;
    }
  }
  return false;
}

// static
bool TranslateAgentStubDispatch::AcceptWithResponder(
    TranslateAgent* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TranslateAgent>(message->header()->name)) {
    case messages::TranslateAgent::kTranslateFrame: {
      internal::TranslateAgent_TranslateFrame_Params_Data* params =
          reinterpret_cast<
              internal::TranslateAgent_TranslateFrame_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TranslateAgent.0
      bool success = true;
      std::string p_translate_script{};
      std::string p_source_lang{};
      std::string p_target_lang{};
      TranslateAgent_TranslateFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTranslateScript(&p_translate_script))
        success = false;
      if (success && !input_data_view.ReadSourceLang(&p_source_lang))
        success = false;
      if (success && !input_data_view.ReadTargetLang(&p_target_lang))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TranslateAgent::Name_, 0, false);
        return false;
      }
      auto callback =
          TranslateAgent_TranslateFrame_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TranslateFrame(        
        std::move(p_translate_script), 
        std::move(p_source_lang), 
        std::move(p_target_lang), std::move(callback));
      return true;
    }
    case messages::TranslateAgent::kRevertTranslation: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kTranslateAgentValidationInfo[] = {
    { &internal::TranslateAgent_TranslateFrame_Params_Data::Validate,
     &internal::TranslateAgent_TranslateFrame_ResponseParams_Data::Validate},
    { &internal::TranslateAgent_RevertTranslation_Params_Data::Validate,
     nullptr /* no response */},
};

bool TranslateAgentRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::translate::mojom::TranslateAgent::Name_,
    kTranslateAgentValidationInfo);
}

bool TranslateAgentResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::translate::mojom::TranslateAgent::Name_,
    kTranslateAgentValidationInfo);
}
// The declaration includes the definition on other builds.

ContentTranslateDriver::IPCStableHashFunction ContentTranslateDriver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ContentTranslateDriver>(message.name())) {
    case messages::ContentTranslateDriver::kRegisterPage: {
      return &ContentTranslateDriver::RegisterPage_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ContentTranslateDriver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ContentTranslateDriver>(message.name())) {
      case messages::ContentTranslateDriver::kRegisterPage:
            return "Receive translate::mojom::ContentTranslateDriver::RegisterPage";
    }
  } else {
    switch (static_cast<messages::ContentTranslateDriver>(message.name())) {
      case messages::ContentTranslateDriver::kRegisterPage:
            return "Receive reply translate::mojom::ContentTranslateDriver::RegisterPage";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ContentTranslateDriver::RegisterPage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x732e6486;  // IPCStableHash for translate::mojom::ContentTranslateDriver::RegisterPage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ContentTranslateDriverProxy::ContentTranslateDriverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ContentTranslateDriverProxy::RegisterPage(
    ::mojo::PendingRemote<TranslateAgent> in_translate_agent, const ::translate::LanguageDetectionDetails& in_details, bool in_translation_critiera_met) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send translate::mojom::ContentTranslateDriver::RegisterPage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("translate_agent"), in_translate_agent,
                        "<value of type ::mojo::PendingRemote<TranslateAgent>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type const ::translate::LanguageDetectionDetails&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("translation_critiera_met"), in_translation_critiera_met,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContentTranslateDriver::kRegisterPage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::translate::mojom::internal::ContentTranslateDriver_RegisterPage_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::translate::mojom::TranslateAgentInterfaceBase>>(
    in_translate_agent,
    &params->translate_agent,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->translate_agent)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid translate_agent in ContentTranslateDriver.RegisterPage request");
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType> details_fragment(
          params.message());
  
  mojo::internal::Serialize<::translate::mojom::LanguageDetectionDetailsDataView>(
    in_details,
    details_fragment);

  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->details.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null details in ContentTranslateDriver.RegisterPage request");

  params->translation_critiera_met = in_translation_critiera_met;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContentTranslateDriver::Name_);
  message.set_method_name("RegisterPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ContentTranslateDriverStubDispatch::Accept(
    ContentTranslateDriver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ContentTranslateDriver>(message->header()->name)) {
    case messages::ContentTranslateDriver::kRegisterPage: {
      DCHECK(message->is_serialized());
      internal::ContentTranslateDriver_RegisterPage_Params_Data* params =
          reinterpret_cast<internal::ContentTranslateDriver_RegisterPage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ContentTranslateDriver.0
      bool success = true;
      ::mojo::PendingRemote<TranslateAgent> p_translate_agent{};
      ::translate::LanguageDetectionDetails p_details{};
      bool p_translation_critiera_met{};
      ContentTranslateDriver_RegisterPage_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_translate_agent =
            input_data_view.TakeTranslateAgent<decltype(p_translate_agent)>();
      }
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (success)
        p_translation_critiera_met = input_data_view.translation_critiera_met();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContentTranslateDriver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterPage(        
        std::move(p_translate_agent), 
        std::move(p_details), 
        std::move(p_translation_critiera_met));
      return true;
    }
  }
  return false;
}

// static
bool ContentTranslateDriverStubDispatch::AcceptWithResponder(
    ContentTranslateDriver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ContentTranslateDriver>(message->header()->name)) {
    case messages::ContentTranslateDriver::kRegisterPage: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kContentTranslateDriverValidationInfo[] = {
    { &internal::ContentTranslateDriver_RegisterPage_Params_Data::Validate,
     nullptr /* no response */},
};

bool ContentTranslateDriverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::translate::mojom::ContentTranslateDriver::Name_,
    kContentTranslateDriverValidationInfo);
}



}  // translate::mojom


namespace mojo {


// static
bool StructTraits<::translate::mojom::LanguageDetectionDetails::DataView, ::translate::mojom::LanguageDetectionDetailsPtr>::Read(
    ::translate::mojom::LanguageDetectionDetails::DataView input,
    ::translate::mojom::LanguageDetectionDetailsPtr* output) {
  bool success = true;
  ::translate::mojom::LanguageDetectionDetailsPtr result(::translate::mojom::LanguageDetectionDetails::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadAdoptedLanguage(&result->adopted_language))
        success = false;
      if (success)
        result->has_notranslate = input.has_notranslate();
      if (success)
        result->has_run_lang_detection = input.has_run_lang_detection();
      if (success && !input.ReadTime(&result->time))
        success = false;
      if (success && !input.ReadContentLanguage(&result->content_language))
        success = false;
      if (success && !input.ReadModelDetectedLanguage(&result->model_detected_language))
        success = false;
      if (success)
        result->is_model_reliable = input.is_model_reliable();
      if (success && !input.ReadHtmlRootLanguage(&result->html_root_language))
        success = false;
      if (success && !input.ReadContents(&result->contents))
        success = false;
      if (success)
        result->model_reliability_score = input.model_reliability_score();
      if (success && !input.ReadDetectionModelVersion(&result->detection_model_version))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace translate::mojom {


void TranslateAgentInterceptorForTesting::TranslateFrame(const std::string& translate_script, const std::string& source_lang, const std::string& target_lang, TranslateFrameCallback callback) {
  GetForwardingInterface()->TranslateFrame(
    std::move(translate_script)
    , 
    std::move(source_lang)
    , 
    std::move(target_lang)
    , std::move(callback));
}
void TranslateAgentInterceptorForTesting::RevertTranslation() {
  GetForwardingInterface()->RevertTranslation();
}
TranslateAgentAsyncWaiter::TranslateAgentAsyncWaiter(
    TranslateAgent* proxy) : proxy_(proxy) {}

TranslateAgentAsyncWaiter::~TranslateAgentAsyncWaiter() = default;


void TranslateAgentAsyncWaiter::TranslateFrame(
    const std::string& translate_script, const std::string& source_lang, const std::string& target_lang, bool* out_cancelled, std::string* out_original_lang, std::string* out_translated_lang, ::translate::TranslateErrors* out_error) {
  base::RunLoop loop;
  proxy_->TranslateFrame(
      std::move(translate_script),
      std::move(source_lang),
      std::move(target_lang),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_cancelled
,
             std::string* out_original_lang
,
             std::string* out_translated_lang
,
             ::translate::TranslateErrors* out_error
,
             bool cancelled,
             const std::string& original_lang,
             const std::string& translated_lang,
             ::translate::TranslateErrors error) {*out_cancelled = std::move(cancelled);*out_original_lang = std::move(original_lang);*out_translated_lang = std::move(translated_lang);*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_cancelled,
          out_original_lang,
          out_translated_lang,
          out_error));
  loop.Run();
}






void ContentTranslateDriverInterceptorForTesting::RegisterPage(::mojo::PendingRemote<TranslateAgent> translate_agent, const ::translate::LanguageDetectionDetails& details, bool translation_critiera_met) {
  GetForwardingInterface()->RegisterPage(
    std::move(translate_agent)
    , 
    std::move(details)
    , 
    std::move(translation_critiera_met)
    );
}
ContentTranslateDriverAsyncWaiter::ContentTranslateDriverAsyncWaiter(
    ContentTranslateDriver* proxy) : proxy_(proxy) {}

ContentTranslateDriverAsyncWaiter::~ContentTranslateDriverAsyncWaiter() = default;







}  // translate::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif