// components/translate/content/common/translate.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_TRANSLATE_CONTENT_COMMON_TRANSLATE_MOJOM_PARAMS_DATA_H_
#define COMPONENTS_TRANSLATE_CONTENT_COMMON_TRANSLATE_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace translate::mojom {
namespace internal {
class  TranslateAgent_TranslateFrame_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> translate_script;
  mojo::internal::Pointer<mojo::internal::String_Data> source_lang;
  mojo::internal::Pointer<mojo::internal::String_Data> target_lang;

 private:
  friend class mojo::internal::MessageFragment<TranslateAgent_TranslateFrame_Params_Data>;

  TranslateAgent_TranslateFrame_Params_Data();
  ~TranslateAgent_TranslateFrame_Params_Data() = delete;
};
static_assert(sizeof(TranslateAgent_TranslateFrame_Params_Data) == 32,
              "Bad sizeof(TranslateAgent_TranslateFrame_Params_Data)");
class  TranslateAgent_TranslateFrame_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t cancelled : 1;
  uint8_t pad0_[3];
  int32_t error;
  mojo::internal::Pointer<mojo::internal::String_Data> original_lang;
  mojo::internal::Pointer<mojo::internal::String_Data> translated_lang;

 private:
  friend class mojo::internal::MessageFragment<TranslateAgent_TranslateFrame_ResponseParams_Data>;

  TranslateAgent_TranslateFrame_ResponseParams_Data();
  ~TranslateAgent_TranslateFrame_ResponseParams_Data() = delete;
};
static_assert(sizeof(TranslateAgent_TranslateFrame_ResponseParams_Data) == 32,
              "Bad sizeof(TranslateAgent_TranslateFrame_ResponseParams_Data)");
class  TranslateAgent_RevertTranslation_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<TranslateAgent_RevertTranslation_Params_Data>;

  TranslateAgent_RevertTranslation_Params_Data();
  ~TranslateAgent_RevertTranslation_Params_Data() = delete;
};
static_assert(sizeof(TranslateAgent_RevertTranslation_Params_Data) == 8,
              "Bad sizeof(TranslateAgent_RevertTranslation_Params_Data)");
class  ContentTranslateDriver_RegisterPage_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data translate_agent;
  mojo::internal::Pointer<internal::LanguageDetectionDetails_Data> details;
  uint8_t translation_critiera_met : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<ContentTranslateDriver_RegisterPage_Params_Data>;

  ContentTranslateDriver_RegisterPage_Params_Data();
  ~ContentTranslateDriver_RegisterPage_Params_Data() = delete;
};
static_assert(sizeof(ContentTranslateDriver_RegisterPage_Params_Data) == 32,
              "Bad sizeof(ContentTranslateDriver_RegisterPage_Params_Data)");

}  // namespace internal


class TranslateAgent_TranslateFrame_ParamsDataView {
 public:
  TranslateAgent_TranslateFrame_ParamsDataView() = default;

  TranslateAgent_TranslateFrame_ParamsDataView(
      internal::TranslateAgent_TranslateFrame_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTranslateScriptDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTranslateScript(UserType* output) {
    
    auto* pointer = data_->translate_script.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSourceLangDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceLang(UserType* output) {
    
    auto* pointer = data_->source_lang.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTargetLangDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTargetLang(UserType* output) {
    
    auto* pointer = data_->target_lang.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::TranslateAgent_TranslateFrame_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TranslateAgent_TranslateFrame_ResponseParamsDataView {
 public:
  TranslateAgent_TranslateFrame_ResponseParamsDataView() = default;

  TranslateAgent_TranslateFrame_ResponseParamsDataView(
      internal::TranslateAgent_TranslateFrame_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool cancelled() const {
    return data_->cancelled;
  }
  inline void GetOriginalLangDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOriginalLang(UserType* output) {
    
    auto* pointer = data_->original_lang.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTranslatedLangDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTranslatedLang(UserType* output) {
    
    auto* pointer = data_->translated_lang.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::translate::mojom::TranslateError>(
        data_value, output);
  }
  TranslateError error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::translate::mojom::TranslateError>(data_->error));
  }
 private:
  internal::TranslateAgent_TranslateFrame_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TranslateAgent_RevertTranslation_ParamsDataView {
 public:
  TranslateAgent_RevertTranslation_ParamsDataView() = default;

  TranslateAgent_RevertTranslation_ParamsDataView(
      internal::TranslateAgent_RevertTranslation_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::TranslateAgent_RevertTranslation_Params_Data* data_ = nullptr;
};


class ContentTranslateDriver_RegisterPage_ParamsDataView {
 public:
  ContentTranslateDriver_RegisterPage_ParamsDataView() = default;

  ContentTranslateDriver_RegisterPage_ParamsDataView(
      internal::ContentTranslateDriver_RegisterPage_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeTranslateAgent() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::translate::mojom::TranslateAgentInterfaceBase>>(
            &data_->translate_agent, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetDetailsDataView(
      LanguageDetectionDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDetails(UserType* output) {
    
    auto* pointer = data_->details.Get();
    return mojo::internal::Deserialize<::translate::mojom::LanguageDetectionDetailsDataView>(
        pointer, output, message_);
  }
  bool translation_critiera_met() const {
    return data_->translation_critiera_met;
  }
 private:
  internal::ContentTranslateDriver_RegisterPage_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void TranslateAgent_TranslateFrame_ParamsDataView::GetTranslateScriptDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->translate_script.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TranslateAgent_TranslateFrame_ParamsDataView::GetSourceLangDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->source_lang.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TranslateAgent_TranslateFrame_ParamsDataView::GetTargetLangDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->target_lang.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void TranslateAgent_TranslateFrame_ResponseParamsDataView::GetOriginalLangDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->original_lang.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TranslateAgent_TranslateFrame_ResponseParamsDataView::GetTranslatedLangDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->translated_lang.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void ContentTranslateDriver_RegisterPage_ParamsDataView::GetDetailsDataView(
    LanguageDetectionDetailsDataView* output) {
  auto pointer = data_->details.Get();
  *output = LanguageDetectionDetailsDataView(pointer, message_);
}



}  // translate::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // COMPONENTS_TRANSLATE_CONTENT_COMMON_TRANSLATE_MOJOM_PARAMS_DATA_H_