// components/services/storage/public/mojom/local_storage_control.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_LOCAL_STORAGE_CONTROL_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_LOCAL_STORAGE_CONTROL_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/storage/public/mojom/local_storage_control.mojom-features.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/local_storage_control.mojom-shared.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/local_storage_control.mojom-forward.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/storage_policy_update.mojom-forward.h"
#include "components/services/storage/public/mojom/storage_usage_info.mojom-forward.h"
#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom-forward.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace storage::mojom {

class LocalStorageControlProxy;

template <typename ImplRefTraits>
class LocalStorageControlStub;

class LocalStorageControlRequestValidator;
class LocalStorageControlResponseValidator;


class LocalStorageControl
    : public LocalStorageControlInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "storage.mojom.LocalStorageControl";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LocalStorageControlInterfaceBase;
  using Proxy_ = LocalStorageControlProxy;

  template <typename ImplRefTraits>
  using Stub_ = LocalStorageControlStub<ImplRefTraits>;

  using RequestValidator_ = LocalStorageControlRequestValidator;
  using ResponseValidator_ = LocalStorageControlResponseValidator;
  enum MethodMinVersions : uint32_t {
    kBindStorageAreaMinVersion = 0,
    kGetUsageMinVersion = 0,
    kDeleteStorageMinVersion = 0,
    kCleanUpStorageMinVersion = 0,
    kFlushMinVersion = 0,
    kPurgeMemoryMinVersion = 0,
    kApplyPolicyUpdatesMinVersion = 0,
    kForceKeepSessionStateMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BindStorageArea_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetUsage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteStorage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CleanUpStorage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Flush_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PurgeMemory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ApplyPolicyUpdates_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ForceKeepSessionState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LocalStorageControl() = default;

  virtual void BindStorageArea(const ::blink::StorageKey& storage_key, ::mojo::PendingReceiver<::blink::mojom::StorageArea> receiver) = 0;

  using GetUsageCallback = base::OnceCallback<void(std::vector<::storage::mojom::StorageUsageInfoPtr>)>;
  using GetUsageMojoCallback = base::OnceCallback<void(std::vector<::storage::mojom::StorageUsageInfoPtr>)>;

  virtual void GetUsage(GetUsageCallback callback) = 0;

  using DeleteStorageCallback = base::OnceCallback<void()>;
  using DeleteStorageMojoCallback = base::OnceCallback<void()>;

  virtual void DeleteStorage(const ::blink::StorageKey& storage_key, DeleteStorageCallback callback) = 0;

  using CleanUpStorageCallback = base::OnceCallback<void()>;
  using CleanUpStorageMojoCallback = base::OnceCallback<void()>;

  virtual void CleanUpStorage(CleanUpStorageCallback callback) = 0;

  virtual void Flush() = 0;

  virtual void PurgeMemory() = 0;

  virtual void ApplyPolicyUpdates(std::vector<::storage::mojom::StoragePolicyUpdatePtr> policy_updates) = 0;

  virtual void ForceKeepSessionState() = 0;
};



class  LocalStorageControlProxy
    : public LocalStorageControl {
 public:
  using InterfaceType = LocalStorageControl;

  explicit LocalStorageControlProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindStorageArea(const ::blink::StorageKey& storage_key, ::mojo::PendingReceiver<::blink::mojom::StorageArea> receiver) final;
  
  void GetUsage(GetUsageCallback callback) final;
  
  void DeleteStorage(const ::blink::StorageKey& storage_key, DeleteStorageCallback callback) final;
  
  void CleanUpStorage(CleanUpStorageCallback callback) final;
  
  void Flush() final;
  
  void PurgeMemory() final;
  
  void ApplyPolicyUpdates(std::vector<::storage::mojom::StoragePolicyUpdatePtr> policy_updates) final;
  
  void ForceKeepSessionState() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  LocalStorageControlStubDispatch {
 public:
  static bool Accept(LocalStorageControl* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LocalStorageControl* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LocalStorageControl>>
class LocalStorageControlStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LocalStorageControlStub() = default;
  ~LocalStorageControlStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalStorageControlStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalStorageControlStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  LocalStorageControlRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  LocalStorageControlResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // storage::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_LOCAL_STORAGE_CONTROL_MOJOM_H_