// components/services/storage/privileged/mojom/indexed_db_internals_types.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_INDEXED_DB_INTERNALS_TYPES_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_INDEXED_DB_INTERNALS_TYPES_MOJOM_SEND_VALIDATION_H_

#include "components/services/storage/privileged/mojom/indexed_db_internals_types.mojom-shared-internal.h"
#include "components/services/storage/privileged/mojom/bucket_client_info.mojom-shared.h"
#include "components/services/storage/public/mojom/buckets/bucket_locator.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"

#include "components/services/storage/privileged/mojom/indexed_db_internals_types.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::storage::mojom::IdbTransactionMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::storage::mojom::IdbTransactionState, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::storage::mojom::IdbOriginMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::IdbOriginMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::IdbOriginMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::origin(input)) in_origin = Traits::origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->origin)::BaseType> origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_origin,
        origin_fragment);

      fragment->origin.Set(
          origin_fragment.is_null() ? nullptr : origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in IdbOriginMetadata struct");

      decltype(Traits::storage_keys(input)) in_storage_keys = Traits::storage_keys(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->storage_keys)::BaseType>
          storage_keys_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& storage_keys_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::IdbStorageKeyMetadataDataView>, send_validation>(
        in_storage_keys,
        storage_keys_fragment,
        &storage_keys_validate_params);

      fragment->storage_keys.Set(
          storage_keys_fragment.is_null() ? nullptr : storage_keys_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->storage_keys.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null storage_keys in IdbOriginMetadata struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::storage::mojom::IdbStorageKeyMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::IdbStorageKeyMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::IdbStorageKeyMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::top_level_site(input)) in_top_level_site = Traits::top_level_site(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->top_level_site)::BaseType> top_level_site_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::SchemefulSiteDataView, send_validation>(
        in_top_level_site,
        top_level_site_fragment);

      fragment->top_level_site.Set(
          top_level_site_fragment.is_null() ? nullptr : top_level_site_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->top_level_site.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null top_level_site in IdbStorageKeyMetadata struct");

      decltype(Traits::serialized_storage_key(input)) in_serialized_storage_key = Traits::serialized_storage_key(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->serialized_storage_key)::BaseType> serialized_storage_key_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_serialized_storage_key,
        serialized_storage_key_fragment);

      fragment->serialized_storage_key.Set(
          serialized_storage_key_fragment.is_null() ? nullptr : serialized_storage_key_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->serialized_storage_key.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null serialized_storage_key in IdbStorageKeyMetadata struct");

      decltype(Traits::buckets(input)) in_buckets = Traits::buckets(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->buckets)::BaseType>
          buckets_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& buckets_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::IdbBucketMetadataDataView>, send_validation>(
        in_buckets,
        buckets_fragment,
        &buckets_validate_params);

      fragment->buckets.Set(
          buckets_fragment.is_null() ? nullptr : buckets_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->buckets.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null buckets in IdbStorageKeyMetadata struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::storage::mojom::IdbBucketMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::IdbBucketMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::IdbBucketMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::bucket_locator(input)) in_bucket_locator = Traits::bucket_locator(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bucket_locator)::BaseType> bucket_locator_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::storage::mojom::BucketLocatorDataView, send_validation>(
        in_bucket_locator,
        bucket_locator_fragment);

      fragment->bucket_locator.Set(
          bucket_locator_fragment.is_null() ? nullptr : bucket_locator_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bucket_locator.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bucket_locator in IdbBucketMetadata struct");

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in IdbBucketMetadata struct");

      fragment->size = Traits::size(input);

      decltype(Traits::last_modified(input)) in_last_modified = Traits::last_modified(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_modified)::BaseType> last_modified_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_last_modified,
        last_modified_fragment);

      fragment->last_modified.Set(
          last_modified_fragment.is_null() ? nullptr : last_modified_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->last_modified.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_modified in IdbBucketMetadata struct");

      decltype(Traits::paths(input)) in_paths = Traits::paths(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->paths)::BaseType>
          paths_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& paths_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>, send_validation>(
        in_paths,
        paths_fragment,
        &paths_validate_params);

      fragment->paths.Set(
          paths_fragment.is_null() ? nullptr : paths_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->paths.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null paths in IdbBucketMetadata struct");

      fragment->connection_count = Traits::connection_count(input);

      decltype(Traits::databases(input)) in_databases = Traits::databases(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->databases)::BaseType>
          databases_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& databases_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::IdbDatabaseMetadataDataView>, send_validation>(
        in_databases,
        databases_fragment,
        &databases_validate_params);

      fragment->databases.Set(
          databases_fragment.is_null() ? nullptr : databases_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->databases.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null databases in IdbBucketMetadata struct");

      decltype(Traits::clients(input)) in_clients = Traits::clients(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->clients)::BaseType>
          clients_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& clients_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::BucketClientInfoDataView>, send_validation>(
        in_clients,
        clients_fragment,
        &clients_validate_params);

      fragment->clients.Set(
          clients_fragment.is_null() ? nullptr : clients_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->clients.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null clients in IdbBucketMetadata struct");

      fragment->delta_recording_start_ms = Traits::delta_recording_start_ms(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::storage::mojom::IdbDatabaseMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::IdbDatabaseMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::IdbDatabaseMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in IdbDatabaseMetadata struct");

      fragment->connection_count = Traits::connection_count(input);

      fragment->active_open_delete = Traits::active_open_delete(input);

      fragment->pending_open_delete = Traits::pending_open_delete(input);

      decltype(Traits::transactions(input)) in_transactions = Traits::transactions(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->transactions)::BaseType>
          transactions_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& transactions_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::IdbTransactionMetadataDataView>, send_validation>(
        in_transactions,
        transactions_fragment,
        &transactions_validate_params);

      fragment->transactions.Set(
          transactions_fragment.is_null() ? nullptr : transactions_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->transactions.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null transactions in IdbDatabaseMetadata struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::storage::mojom::IdbTransactionMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::IdbTransactionMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::IdbTransactionMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::storage::mojom::IdbTransactionMode>(
        Traits::mode(input),
        &fragment->mode);

      
      mojo::internal::Serialize<::storage::mojom::IdbTransactionState>(
        Traits::state(input),
        &fragment->state);

      fragment->tid = Traits::tid(input);

      fragment->connection_id = Traits::connection_id(input);

      decltype(Traits::client_token(input)) in_client_token = Traits::client_token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->client_token)::BaseType> client_token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_client_token,
        client_token_fragment);

      fragment->client_token.Set(
          client_token_fragment.is_null() ? nullptr : client_token_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->client_token.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null client_token in IdbTransactionMetadata struct");

      fragment->age = Traits::age(input);

      fragment->runtime = Traits::runtime(input);

      fragment->tasks_scheduled = Traits::tasks_scheduled(input);

      fragment->tasks_completed = Traits::tasks_completed(input);

      decltype(Traits::scope(input)) in_scope = Traits::scope(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scope)::BaseType>
          scope_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& scope_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>, send_validation>(
        in_scope,
        scope_fragment,
        &scope_validate_params);

      fragment->scope.Set(
          scope_fragment.is_null() ? nullptr : scope_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scope.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scope in IdbTransactionMetadata struct");

      decltype(Traits::state_history(input)) in_state_history = Traits::state_history(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->state_history)::BaseType>
          state_history_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& state_history_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::IdbTransactionMetadataStateHistoryDataView>, send_validation>(
        in_state_history,
        state_history_fragment,
        &state_history_validate_params);

      fragment->state_history.Set(
          state_history_fragment.is_null() ? nullptr : state_history_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->state_history.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null state_history in IdbTransactionMetadata struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::storage::mojom::IdbTransactionMetadataStateHistoryDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::IdbTransactionMetadataStateHistoryDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::IdbTransactionMetadataStateHistory_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::storage::mojom::IdbTransactionState>(
        Traits::state(input),
        &fragment->state);

      fragment->duration = Traits::duration(input);
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_INDEXED_DB_INTERNALS_TYPES_MOJOM_SEND_VALIDATION_H_