// components/services/patch/public/mojom/file_patcher.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_PATCH_PUBLIC_MOJOM_FILE_PATCHER_MOJOM_H_
#define COMPONENTS_SERVICES_PATCH_PUBLIC_MOJOM_FILE_PATCHER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/patch/public/mojom/file_patcher.mojom-features.h"  // IWYU pragma: export
#include "components/services/patch/public/mojom/file_patcher.mojom-shared.h"  // IWYU pragma: export
#include "components/services/patch/public/mojom/file_patcher.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file.mojom.h"
#include "sandbox/policy/mojom/sandbox.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "components/services/patch/public/mojom/file_patcher_mojom_traits.h"




namespace patch::mojom {

class FilePatcherProxy;

template <typename ImplRefTraits>
class FilePatcherStub;

class FilePatcherRequestValidator;
class FilePatcherResponseValidator;


class FilePatcher
    : public FilePatcherInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "patch.mojom.FilePatcher";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kService;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FilePatcherInterfaceBase;
  using Proxy_ = FilePatcherProxy;

  template <typename ImplRefTraits>
  using Stub_ = FilePatcherStub<ImplRefTraits>;

  using RequestValidator_ = FilePatcherRequestValidator;
  using ResponseValidator_ = FilePatcherResponseValidator;
  enum MethodMinVersions : uint32_t {
    kPatchFilePuffPatchMinVersion = 0,
    kPatchFileZucchiniMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct PatchFilePuffPatch_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PatchFileZucchini_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FilePatcher() = default;

  using PatchFilePuffPatchCallback = base::OnceCallback<void(int32_t)>;
  using PatchFilePuffPatchMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void PatchFilePuffPatch(::base::File input_file, ::base::File patch_file, ::base::File output_file, PatchFilePuffPatchCallback callback) = 0;

  using PatchFileZucchiniCallback = base::OnceCallback<void(zucchini::status::Code)>;
  using PatchFileZucchiniMojoCallback = base::OnceCallback<void(zucchini::status::Code)>;

  virtual void PatchFileZucchini(::base::File input_file, ::base::File patch_file, ::base::File output_file, PatchFileZucchiniCallback callback) = 0;
};



class  FilePatcherProxy
    : public FilePatcher {
 public:
  using InterfaceType = FilePatcher;

  explicit FilePatcherProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void PatchFilePuffPatch(::base::File input_file, ::base::File patch_file, ::base::File output_file, PatchFilePuffPatchCallback callback) final;
  
  void PatchFileZucchini(::base::File input_file, ::base::File patch_file, ::base::File output_file, PatchFileZucchiniCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  FilePatcherStubDispatch {
 public:
  static bool Accept(FilePatcher* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FilePatcher* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FilePatcher>>
class FilePatcherStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FilePatcherStub() = default;
  ~FilePatcherStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FilePatcherStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FilePatcherStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FilePatcherRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FilePatcherResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // patch::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_PATCH_PUBLIC_MOJOM_FILE_PATCHER_MOJOM_H_