// components/services/patch/public/mojom/file_patcher.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/services/patch/public/mojom/file_patcher.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/patch/public/mojom/file_patcher.mojom-params-data.h"
namespace patch {
namespace mojom {

NOINLINE static const char* ZucchiniStatusToStringHelper(ZucchiniStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ZucchiniStatus::kStatusSuccess:
      return "kStatusSuccess";
    case ZucchiniStatus::kStatusInvalidParam:
      return "kStatusInvalidParam";
    case ZucchiniStatus::kStatusFileReadError:
      return "kStatusFileReadError";
    case ZucchiniStatus::kStatusFileWriteError:
      return "kStatusFileWriteError";
    case ZucchiniStatus::kStatusPatchReadError:
      return "kStatusPatchReadError";
    case ZucchiniStatus::kStatusPatchWriteError:
      return "kStatusPatchWriteError";
    case ZucchiniStatus::kStatusInvalidOldImage:
      return "kStatusInvalidOldImage";
    case ZucchiniStatus::kStatusInvalidNewImage:
      return "kStatusInvalidNewImage";
    case ZucchiniStatus::kStatusDiskFull:
      return "kStatusDiskFull";
    case ZucchiniStatus::kStatusIoError:
      return "kStatusIoError";
    case ZucchiniStatus::kStatusFatal:
      return "kStatusFatal";
    default:
      return nullptr;
  }
}

std::string ZucchiniStatusToString(ZucchiniStatus value) {
  const char *str = ZucchiniStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ZucchiniStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ZucchiniStatus value) {
  return os << ZucchiniStatusToString(value);
}

namespace internal {


// static
bool FilePatcher_PatchFilePuffPatch_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FilePatcher_PatchFilePuffPatch_Params_Data* object =
      static_cast<const FilePatcher_PatchFilePuffPatch_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_file, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_file, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->patch_file, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->patch_file, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_file, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_file, validation_context))
    return false;

  return true;
}

FilePatcher_PatchFilePuffPatch_Params_Data::FilePatcher_PatchFilePuffPatch_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FilePatcher_PatchFilePuffPatch_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FilePatcher_PatchFilePuffPatch_ResponseParams_Data* object =
      static_cast<const FilePatcher_PatchFilePuffPatch_ResponseParams_Data*>(data);

  return true;
}

FilePatcher_PatchFilePuffPatch_ResponseParams_Data::FilePatcher_PatchFilePuffPatch_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FilePatcher_PatchFileZucchini_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FilePatcher_PatchFileZucchini_Params_Data* object =
      static_cast<const FilePatcher_PatchFileZucchini_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_file, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_file, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->patch_file, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->patch_file, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_file, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->output_file, validation_context))
    return false;

  return true;
}

FilePatcher_PatchFileZucchini_Params_Data::FilePatcher_PatchFileZucchini_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FilePatcher_PatchFileZucchini_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FilePatcher_PatchFileZucchini_ResponseParams_Data* object =
      static_cast<const FilePatcher_PatchFileZucchini_ResponseParams_Data*>(data);


  if (!::patch::mojom::internal::ZucchiniStatus_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

FilePatcher_PatchFileZucchini_ResponseParams_Data::FilePatcher_PatchFileZucchini_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace patch

namespace perfetto {

// static
void TraceFormatTraits<::patch::mojom::ZucchiniStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::patch::mojom::ZucchiniStatus value) {
  return std::move(context).WriteString(::patch::mojom::ZucchiniStatusToString(value));
}

} // namespace perfetto