// components/services/paint_preview_compositor/public/mojom/paint_preview_compositor.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/services/paint_preview_compositor/public/mojom/paint_preview_compositor.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/paint_preview_compositor/public/mojom/paint_preview_compositor.mojom-params-data.h"
namespace paint_preview {
namespace mojom {

NOINLINE static const char* PaintPreviewCompositor_BeginCompositeStatusToStringHelper(PaintPreviewCompositor_BeginCompositeStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PaintPreviewCompositor_BeginCompositeStatus::kCompositingFailure:
      return "kCompositingFailure";
    case PaintPreviewCompositor_BeginCompositeStatus::kDeserializingFailure:
      return "kDeserializingFailure";
    case PaintPreviewCompositor_BeginCompositeStatus::kSuccess:
      return "kSuccess";
    case PaintPreviewCompositor_BeginCompositeStatus::kPartialSuccess:
      return "kPartialSuccess";
    default:
      return nullptr;
  }
}

std::string PaintPreviewCompositor_BeginCompositeStatusToString(PaintPreviewCompositor_BeginCompositeStatus value) {
  const char *str = PaintPreviewCompositor_BeginCompositeStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PaintPreviewCompositor_BeginCompositeStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PaintPreviewCompositor_BeginCompositeStatus value) {
  return os << PaintPreviewCompositor_BeginCompositeStatusToString(value);
}

NOINLINE static const char* PaintPreviewCompositor_BitmapStatusToStringHelper(PaintPreviewCompositor_BitmapStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PaintPreviewCompositor_BitmapStatus::kSuccess:
      return "kSuccess";
    case PaintPreviewCompositor_BitmapStatus::kMissingFrame:
      return "kMissingFrame";
    case PaintPreviewCompositor_BitmapStatus::kAllocFailed:
      return "kAllocFailed";
    default:
      return nullptr;
  }
}

std::string PaintPreviewCompositor_BitmapStatusToString(PaintPreviewCompositor_BitmapStatus value) {
  const char *str = PaintPreviewCompositor_BitmapStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PaintPreviewCompositor_BitmapStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PaintPreviewCompositor_BitmapStatus value) {
  return os << PaintPreviewCompositor_BitmapStatusToString(value);
}

namespace internal {


// static
bool PaintPreviewBeginCompositeRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaintPreviewBeginCompositeRequest_Data* object =
      static_cast<const PaintPreviewBeginCompositeRequest_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->preview, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->preview, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->recording_map, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& recording_map_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->recording_map, validation_context,
                                         &recording_map_validate_params)) {
    return false;
  }

  return true;
}

PaintPreviewBeginCompositeRequest_Data::PaintPreviewBeginCompositeRequest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SubframeClipRect_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SubframeClipRect_Data* object =
      static_cast<const SubframeClipRect_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_guid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_guid, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->clip_rect, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->clip_rect, validation_context))
    return false;

  return true;
}

SubframeClipRect_Data::SubframeClipRect_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameData_Data* object =
      static_cast<const FrameData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scroll_extents, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scroll_extents, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scroll_offsets, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scroll_offsets, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subframes, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& subframes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->subframes, validation_context,
                                         &subframes_validate_params)) {
    return false;
  }

  return true;
}

FrameData_Data::FrameData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintPreviewBeginCompositeResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaintPreviewBeginCompositeResponse_Data* object =
      static_cast<const PaintPreviewBeginCompositeResponse_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->root_frame_guid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->root_frame_guid, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frames, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& frames_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->frames, validation_context,
                                         &frames_validate_params)) {
    return false;
  }

  return true;
}

PaintPreviewBeginCompositeResponse_Data::PaintPreviewBeginCompositeResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintPreviewCompositor_BeginSeparatedFrameComposite_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaintPreviewCompositor_BeginSeparatedFrameComposite_Params_Data* object =
      static_cast<const PaintPreviewCompositor_BeginSeparatedFrameComposite_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  return true;
}

PaintPreviewCompositor_BeginSeparatedFrameComposite_Params_Data::PaintPreviewCompositor_BeginSeparatedFrameComposite_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintPreviewCompositor_BeginSeparatedFrameComposite_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaintPreviewCompositor_BeginSeparatedFrameComposite_ResponseParams_Data* object =
      static_cast<const PaintPreviewCompositor_BeginSeparatedFrameComposite_ResponseParams_Data*>(data);


  if (!::paint_preview::mojom::internal::PaintPreviewCompositor_BeginCompositeStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->response, validation_context))
    return false;

  return true;
}

PaintPreviewCompositor_BeginSeparatedFrameComposite_ResponseParams_Data::PaintPreviewCompositor_BeginSeparatedFrameComposite_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintPreviewCompositor_BitmapForSeparatedFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaintPreviewCompositor_BitmapForSeparatedFrame_Params_Data* object =
      static_cast<const PaintPreviewCompositor_BitmapForSeparatedFrame_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_guid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_guid, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->clip_rect, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->clip_rect, validation_context))
    return false;

  return true;
}

PaintPreviewCompositor_BitmapForSeparatedFrame_Params_Data::PaintPreviewCompositor_BitmapForSeparatedFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintPreviewCompositor_BitmapForSeparatedFrame_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaintPreviewCompositor_BitmapForSeparatedFrame_ResponseParams_Data* object =
      static_cast<const PaintPreviewCompositor_BitmapForSeparatedFrame_ResponseParams_Data*>(data);


  if (!::paint_preview::mojom::internal::PaintPreviewCompositor_BitmapStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->bitmap, validation_context))
    return false;

  return true;
}

PaintPreviewCompositor_BitmapForSeparatedFrame_ResponseParams_Data::PaintPreviewCompositor_BitmapForSeparatedFrame_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintPreviewCompositor_BeginMainFrameComposite_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaintPreviewCompositor_BeginMainFrameComposite_Params_Data* object =
      static_cast<const PaintPreviewCompositor_BeginMainFrameComposite_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  return true;
}

PaintPreviewCompositor_BeginMainFrameComposite_Params_Data::PaintPreviewCompositor_BeginMainFrameComposite_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintPreviewCompositor_BeginMainFrameComposite_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaintPreviewCompositor_BeginMainFrameComposite_ResponseParams_Data* object =
      static_cast<const PaintPreviewCompositor_BeginMainFrameComposite_ResponseParams_Data*>(data);


  if (!::paint_preview::mojom::internal::PaintPreviewCompositor_BeginCompositeStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->response, validation_context))
    return false;

  return true;
}

PaintPreviewCompositor_BeginMainFrameComposite_ResponseParams_Data::PaintPreviewCompositor_BeginMainFrameComposite_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintPreviewCompositor_BitmapForMainFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaintPreviewCompositor_BitmapForMainFrame_Params_Data* object =
      static_cast<const PaintPreviewCompositor_BitmapForMainFrame_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->clip_rect, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->clip_rect, validation_context))
    return false;

  return true;
}

PaintPreviewCompositor_BitmapForMainFrame_Params_Data::PaintPreviewCompositor_BitmapForMainFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintPreviewCompositor_BitmapForMainFrame_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaintPreviewCompositor_BitmapForMainFrame_ResponseParams_Data* object =
      static_cast<const PaintPreviewCompositor_BitmapForMainFrame_ResponseParams_Data*>(data);


  if (!::paint_preview::mojom::internal::PaintPreviewCompositor_BitmapStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->bitmap, validation_context))
    return false;

  return true;
}

PaintPreviewCompositor_BitmapForMainFrame_ResponseParams_Data::PaintPreviewCompositor_BitmapForMainFrame_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintPreviewCompositor_SetRootFrameUrl_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaintPreviewCompositor_SetRootFrameUrl_Params_Data* object =
      static_cast<const PaintPreviewCompositor_SetRootFrameUrl_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

PaintPreviewCompositor_SetRootFrameUrl_Params_Data::PaintPreviewCompositor_SetRootFrameUrl_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintPreviewCompositorCollection_SetDiscardableSharedMemoryManager_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaintPreviewCompositorCollection_SetDiscardableSharedMemoryManager_Params_Data* object =
      static_cast<const PaintPreviewCompositorCollection_SetDiscardableSharedMemoryManager_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->manager, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->manager,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PaintPreviewCompositorCollection_SetDiscardableSharedMemoryManager_Params_Data::PaintPreviewCompositorCollection_SetDiscardableSharedMemoryManager_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintPreviewCompositorCollection_CreateCompositor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaintPreviewCompositorCollection_CreateCompositor_Params_Data* object =
      static_cast<const PaintPreviewCompositorCollection_CreateCompositor_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->compositor, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->compositor,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PaintPreviewCompositorCollection_CreateCompositor_Params_Data::PaintPreviewCompositorCollection_CreateCompositor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintPreviewCompositorCollection_CreateCompositor_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaintPreviewCompositorCollection_CreateCompositor_ResponseParams_Data* object =
      static_cast<const PaintPreviewCompositorCollection_CreateCompositor_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->compositor_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->compositor_id, validation_context))
    return false;

  return true;
}

PaintPreviewCompositorCollection_CreateCompositor_ResponseParams_Data::PaintPreviewCompositorCollection_CreateCompositor_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintPreviewCompositorCollection_OnMemoryPressure_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaintPreviewCompositorCollection_OnMemoryPressure_Params_Data* object =
      static_cast<const PaintPreviewCompositorCollection_OnMemoryPressure_Params_Data*>(data);


  if (!::mojo_base::mojom::internal::MemoryPressureLevel_Data
        ::Validate(object->memory_pressure_level, validation_context))
    return false;

  return true;
}

PaintPreviewCompositorCollection_OnMemoryPressure_Params_Data::PaintPreviewCompositorCollection_OnMemoryPressure_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintPreviewCompositorCollection_ListCompositors_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaintPreviewCompositorCollection_ListCompositors_Params_Data* object =
      static_cast<const PaintPreviewCompositorCollection_ListCompositors_Params_Data*>(data);

  return true;
}

PaintPreviewCompositorCollection_ListCompositors_Params_Data::PaintPreviewCompositorCollection_ListCompositors_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintPreviewCompositorCollection_ListCompositors_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaintPreviewCompositorCollection_ListCompositors_ResponseParams_Data* object =
      static_cast<const PaintPreviewCompositorCollection_ListCompositors_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->compositor_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& compositor_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->compositor_ids, validation_context,
                                         &compositor_ids_validate_params)) {
    return false;
  }

  return true;
}

PaintPreviewCompositorCollection_ListCompositors_ResponseParams_Data::PaintPreviewCompositorCollection_ListCompositors_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace paint_preview

namespace perfetto {

// static
void TraceFormatTraits<::paint_preview::mojom::PaintPreviewCompositor_BeginCompositeStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::paint_preview::mojom::PaintPreviewCompositor_BeginCompositeStatus value) {
  return std::move(context).WriteString(::paint_preview::mojom::PaintPreviewCompositor_BeginCompositeStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::paint_preview::mojom::PaintPreviewCompositor_BitmapStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::paint_preview::mojom::PaintPreviewCompositor_BitmapStatus value) {
  return std::move(context).WriteString(::paint_preview::mojom::PaintPreviewCompositor_BitmapStatusToString(value));
}

} // namespace perfetto