// components/services/on_device_translation/public/mojom/on_device_translation_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/on_device_translation/public/mojom/on_device_translation_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/on_device_translation/public/mojom/on_device_translation_service.mojom-params-data.h"
#include "components/services/on_device_translation/public/mojom/on_device_translation_service.mojom-shared-message-ids.h"

#include "components/services/on_device_translation/public/mojom/on_device_translation_service.mojom-import-headers.h"
#include "components/services/on_device_translation/public/mojom/on_device_translation_service.mojom-test-utils.h"


namespace on_device_translation::mojom {
OnDeviceTranslationLanguagePackage::OnDeviceTranslationLanguagePackage()
    : language1(),
      language2() {}

OnDeviceTranslationLanguagePackage::OnDeviceTranslationLanguagePackage(
    const std::string& language1_in,
    const std::string& language2_in)
    : language1(std::move(language1_in)),
      language2(std::move(language2_in)) {}

OnDeviceTranslationLanguagePackage::~OnDeviceTranslationLanguagePackage() = default;
size_t OnDeviceTranslationLanguagePackage::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->language1);
  seed = mojo::internal::Hash(seed, this->language2);
  return seed;
}

void OnDeviceTranslationLanguagePackage::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "language1"), this->language1,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "language2"), this->language2,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool OnDeviceTranslationLanguagePackage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
OnDeviceTranslationServiceConfig::OnDeviceTranslationServiceConfig()
    : packages(),
      file_operation_proxy() {}

OnDeviceTranslationServiceConfig::OnDeviceTranslationServiceConfig(
    std::vector<OnDeviceTranslationLanguagePackagePtr> packages_in,
    ::mojo::PendingRemote<FileOperationProxy> file_operation_proxy_in)
    : packages(std::move(packages_in)),
      file_operation_proxy(std::move(file_operation_proxy_in)) {}

OnDeviceTranslationServiceConfig::~OnDeviceTranslationServiceConfig() = default;

void OnDeviceTranslationServiceConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "packages"), this->packages,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<OnDeviceTranslationLanguagePackagePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_operation_proxy"), this->file_operation_proxy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<FileOperationProxy>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool OnDeviceTranslationServiceConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

FileOperationProxy::IPCStableHashFunction FileOperationProxy::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FileOperationProxy>(message.name())) {
    case messages::FileOperationProxy::kFileExists: {
      return &FileOperationProxy::FileExists_Sym::IPCStableHash;
    }
    case messages::FileOperationProxy::kOpen: {
      return &FileOperationProxy::Open_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FileOperationProxy::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FileOperationProxy>(message.name())) {
      case messages::FileOperationProxy::kFileExists:
            return "Receive on_device_translation::mojom::FileOperationProxy::FileExists";
      case messages::FileOperationProxy::kOpen:
            return "Receive on_device_translation::mojom::FileOperationProxy::Open";
    }
  } else {
    switch (static_cast<messages::FileOperationProxy>(message.name())) {
      case messages::FileOperationProxy::kFileExists:
            return "Receive reply on_device_translation::mojom::FileOperationProxy::FileExists";
      case messages::FileOperationProxy::kOpen:
            return "Receive reply on_device_translation::mojom::FileOperationProxy::Open";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FileOperationProxy::FileExists_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcecbd2bd;  // IPCStableHash for on_device_translation::mojom::FileOperationProxy::FileExists
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileOperationProxy::Open_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x33b0a2c2;  // IPCStableHash for on_device_translation::mojom::FileOperationProxy::Open
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool FileOperationProxy::FileExists(uint32_t package_index, const ::base::FilePath& relative_path, bool* out_exists, bool* out_is_directory) {
  NOTREACHED();
}
bool FileOperationProxy::Open(uint32_t package_index, const ::base::FilePath& relative_path, ::base::File* out_file) {
  NOTREACHED();
}
class FileOperationProxy_FileExists_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FileOperationProxy_FileExists_HandleSyncResponse(
      bool* result, bool* out_exists, bool* out_is_directory)
      : result_(result), out_exists_(out_exists), out_is_directory_(out_is_directory) {
    DCHECK(!*result_);
  }

  FileOperationProxy_FileExists_HandleSyncResponse(const FileOperationProxy_FileExists_HandleSyncResponse&) = delete;
  FileOperationProxy_FileExists_HandleSyncResponse& operator=(const FileOperationProxy_FileExists_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_exists_;
  bool* out_is_directory_;};

class FileOperationProxy_FileExists_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileOperationProxy_FileExists_ForwardToCallback(
      FileOperationProxy::FileExistsCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileOperationProxy_FileExists_ForwardToCallback(const FileOperationProxy_FileExists_ForwardToCallback&) = delete;
  FileOperationProxy_FileExists_ForwardToCallback& operator=(const FileOperationProxy_FileExists_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileOperationProxy::FileExistsCallback callback_;
};
class FileOperationProxy_Open_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FileOperationProxy_Open_HandleSyncResponse(
      bool* result, ::base::File* out_file)
      : result_(result), out_file_(out_file) {
    DCHECK(!*result_);
  }

  FileOperationProxy_Open_HandleSyncResponse(const FileOperationProxy_Open_HandleSyncResponse&) = delete;
  FileOperationProxy_Open_HandleSyncResponse& operator=(const FileOperationProxy_Open_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File* out_file_;};

class FileOperationProxy_Open_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileOperationProxy_Open_ForwardToCallback(
      FileOperationProxy::OpenCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileOperationProxy_Open_ForwardToCallback(const FileOperationProxy_Open_ForwardToCallback&) = delete;
  FileOperationProxy_Open_ForwardToCallback& operator=(const FileOperationProxy_Open_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileOperationProxy::OpenCallback callback_;
};

FileOperationProxyProxy::FileOperationProxyProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool FileOperationProxyProxy::FileExists(
    uint32_t param_package_index, const ::base::FilePath& param_relative_path, bool* out_param_exists, bool* out_param_is_directory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call on_device_translation::mojom::FileOperationProxy::FileExists (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("package_index"), param_package_index,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("relative_path"), param_relative_path,
                        "<value of type const ::base::FilePath&>");
   });
#else
  TRACE_EVENT0("mojom", "FileOperationProxy::FileExists");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileOperationProxy::kFileExists), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_translation::mojom::internal::FileOperationProxy_FileExists_Params_Data> params(
          message);
  params.Allocate();

  params->package_index = param_package_index;
  mojo::internal::MessageFragment<
      typename decltype(params->relative_path)::BaseType> relative_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    param_relative_path,
    relative_path_fragment);

  params->relative_path.Set(
      relative_path_fragment.is_null() ? nullptr : relative_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->relative_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null relative_path in FileOperationProxy.FileExists request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileOperationProxy::Name_);
  message.set_method_name("FileExists");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileOperationProxy_FileExists_HandleSyncResponse(
          &result, out_param_exists, out_param_is_directory));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FileOperationProxy::FileExists", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("exists"), out_param_exists,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_directory"), out_param_is_directory,
                        "<value of type bool>");
   });
#endif
  return result;
}

void FileOperationProxyProxy::FileExists(
    uint32_t in_package_index, const ::base::FilePath& in_relative_path, FileExistsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_translation::mojom::FileOperationProxy::FileExists", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("package_index"), in_package_index,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("relative_path"), in_relative_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileOperationProxy::kFileExists), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_translation::mojom::internal::FileOperationProxy_FileExists_Params_Data> params(
          message);
  params.Allocate();

  params->package_index = in_package_index;
  mojo::internal::MessageFragment<
      typename decltype(params->relative_path)::BaseType> relative_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_relative_path,
    relative_path_fragment);

  params->relative_path.Set(
      relative_path_fragment.is_null() ? nullptr : relative_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->relative_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null relative_path in FileOperationProxy.FileExists request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileOperationProxy::Name_);
  message.set_method_name("FileExists");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileOperationProxy_FileExists_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool FileOperationProxyProxy::Open(
    uint32_t param_package_index, const ::base::FilePath& param_relative_path, ::base::File* out_param_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call on_device_translation::mojom::FileOperationProxy::Open (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("package_index"), param_package_index,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("relative_path"), param_relative_path,
                        "<value of type const ::base::FilePath&>");
   });
#else
  TRACE_EVENT0("mojom", "FileOperationProxy::Open");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileOperationProxy::kOpen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_translation::mojom::internal::FileOperationProxy_Open_Params_Data> params(
          message);
  params.Allocate();

  params->package_index = param_package_index;
  mojo::internal::MessageFragment<
      typename decltype(params->relative_path)::BaseType> relative_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    param_relative_path,
    relative_path_fragment);

  params->relative_path.Set(
      relative_path_fragment.is_null() ? nullptr : relative_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->relative_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null relative_path in FileOperationProxy.Open request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileOperationProxy::Name_);
  message.set_method_name("Open");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileOperationProxy_Open_HandleSyncResponse(
          &result, out_param_file));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FileOperationProxy::Open", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), out_param_file,
                        "<value of type ::base::File>");
   });
#endif
  return result;
}

void FileOperationProxyProxy::Open(
    uint32_t in_package_index, const ::base::FilePath& in_relative_path, OpenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_translation::mojom::FileOperationProxy::Open", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("package_index"), in_package_index,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("relative_path"), in_relative_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileOperationProxy::kOpen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_translation::mojom::internal::FileOperationProxy_Open_Params_Data> params(
          message);
  params.Allocate();

  params->package_index = in_package_index;
  mojo::internal::MessageFragment<
      typename decltype(params->relative_path)::BaseType> relative_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_relative_path,
    relative_path_fragment);

  params->relative_path.Set(
      relative_path_fragment.is_null() ? nullptr : relative_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->relative_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null relative_path in FileOperationProxy.Open request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileOperationProxy::Name_);
  message.set_method_name("Open");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileOperationProxy_Open_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class FileOperationProxy_FileExists_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileOperationProxy::FileExistsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileOperationProxy_FileExists_ProxyToResponder> proxy(
        new FileOperationProxy_FileExists_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileOperationProxy_FileExists_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileOperationProxy_FileExists_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileOperationProxy_FileExists_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileOperationProxy::FileExistsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_exists, bool in_is_directory);
};

bool FileOperationProxy_FileExists_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileOperationProxy_FileExists_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileOperationProxy_FileExists_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileOperationProxy.0
  bool success = true;
  bool p_exists{};
  bool p_is_directory{};
  FileOperationProxy_FileExists_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_exists = input_data_view.exists();
  if (success)
    p_is_directory = input_data_view.is_directory();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileOperationProxy::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_exists), 
std::move(p_is_directory));
  }
  return true;
}

void FileOperationProxy_FileExists_ProxyToResponder::Run(
    bool in_exists, bool in_is_directory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply on_device_translation::mojom::FileOperationProxy::FileExists", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("exists"), in_exists,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_directory"), in_is_directory,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileOperationProxy::kFileExists), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_translation::mojom::internal::FileOperationProxy_FileExists_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->exists = in_exists;

  params->is_directory = in_is_directory;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileOperationProxy::Name_);
  message.set_method_name("FileExists");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FileOperationProxy_FileExists_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileOperationProxy_FileExists_ResponseParams_Data* params =
      reinterpret_cast<internal::FileOperationProxy_FileExists_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FileOperationProxy.0
  bool success = true;
  bool p_exists{};
  bool p_is_directory{};
  FileOperationProxy_FileExists_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_exists = input_data_view.exists();
  if (success)
    p_is_directory = input_data_view.is_directory();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileOperationProxy::Name_, 0, true);
    return false;
  }
  *out_exists_ = std::move(p_exists);
  *out_is_directory_ = std::move(p_is_directory);
  *result_ = true;
  return true;
}
class FileOperationProxy_Open_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileOperationProxy::OpenCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileOperationProxy_Open_ProxyToResponder> proxy(
        new FileOperationProxy_Open_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileOperationProxy_Open_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileOperationProxy_Open_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileOperationProxy_Open_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileOperationProxy::OpenCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File in_file);
};

bool FileOperationProxy_Open_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileOperationProxy_Open_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileOperationProxy_Open_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileOperationProxy.1
  bool success = true;
  ::base::File p_file{};
  FileOperationProxy_Open_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFile(&p_file))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileOperationProxy::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_file));
  }
  return true;
}

void FileOperationProxy_Open_ProxyToResponder::Run(
    ::base::File in_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply on_device_translation::mojom::FileOperationProxy::Open", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), in_file,
                        "<value of type ::base::File>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileOperationProxy::kOpen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_translation::mojom::internal::FileOperationProxy_Open_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file)::BaseType> file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
    in_file,
    file_fragment);

  params->file.Set(
      file_fragment.is_null() ? nullptr : file_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileOperationProxy::Name_);
  message.set_method_name("Open");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FileOperationProxy_Open_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileOperationProxy_Open_ResponseParams_Data* params =
      reinterpret_cast<internal::FileOperationProxy_Open_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FileOperationProxy.1
  bool success = true;
  ::base::File p_file{};
  FileOperationProxy_Open_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFile(&p_file))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileOperationProxy::Name_, 1, true);
    return false;
  }
  *out_file_ = std::move(p_file);
  *result_ = true;
  return true;
}

// static
bool FileOperationProxyStubDispatch::Accept(
    FileOperationProxy* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FileOperationProxy>(message->header()->name)) {
    case messages::FileOperationProxy::kFileExists: {
      break;
    }
    case messages::FileOperationProxy::kOpen: {
      break;
    }
  }
  return false;
}

// static
bool FileOperationProxyStubDispatch::AcceptWithResponder(
    FileOperationProxy* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FileOperationProxy>(message->header()->name)) {
    case messages::FileOperationProxy::kFileExists: {
      internal::FileOperationProxy_FileExists_Params_Data* params =
          reinterpret_cast<
              internal::FileOperationProxy_FileExists_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileOperationProxy.0
      bool success = true;
      uint32_t p_package_index{};
      ::base::FilePath p_relative_path{};
      FileOperationProxy_FileExists_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_package_index = input_data_view.package_index();
      if (success && !input_data_view.ReadRelativePath(&p_relative_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileOperationProxy::Name_, 0, false);
        return false;
      }
      auto callback =
          FileOperationProxy_FileExists_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FileExists(        
        std::move(p_package_index), 
        std::move(p_relative_path), std::move(callback));
      return true;
    }
    case messages::FileOperationProxy::kOpen: {
      internal::FileOperationProxy_Open_Params_Data* params =
          reinterpret_cast<
              internal::FileOperationProxy_Open_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileOperationProxy.1
      bool success = true;
      uint32_t p_package_index{};
      ::base::FilePath p_relative_path{};
      FileOperationProxy_Open_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_package_index = input_data_view.package_index();
      if (success && !input_data_view.ReadRelativePath(&p_relative_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileOperationProxy::Name_, 1, false);
        return false;
      }
      auto callback =
          FileOperationProxy_Open_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Open(        
        std::move(p_package_index), 
        std::move(p_relative_path), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFileOperationProxyValidationInfo[] = {
    { &internal::FileOperationProxy_FileExists_Params_Data::Validate,
     &internal::FileOperationProxy_FileExists_ResponseParams_Data::Validate},
    { &internal::FileOperationProxy_Open_Params_Data::Validate,
     &internal::FileOperationProxy_Open_ResponseParams_Data::Validate},
};

bool FileOperationProxyRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::on_device_translation::mojom::FileOperationProxy::Name_,
    kFileOperationProxyValidationInfo);
}

bool FileOperationProxyResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::on_device_translation::mojom::FileOperationProxy::Name_,
    kFileOperationProxyValidationInfo);
}
// The declaration includes the definition on other builds.

OnDeviceTranslationService::IPCStableHashFunction OnDeviceTranslationService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::OnDeviceTranslationService>(message.name())) {
    case messages::OnDeviceTranslationService::kSetServiceConfig: {
      return &OnDeviceTranslationService::SetServiceConfig_Sym::IPCStableHash;
    }
    case messages::OnDeviceTranslationService::kCreateTranslator: {
      return &OnDeviceTranslationService::CreateTranslator_Sym::IPCStableHash;
    }
    case messages::OnDeviceTranslationService::kCanTranslate: {
      return &OnDeviceTranslationService::CanTranslate_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* OnDeviceTranslationService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::OnDeviceTranslationService>(message.name())) {
      case messages::OnDeviceTranslationService::kSetServiceConfig:
            return "Receive on_device_translation::mojom::OnDeviceTranslationService::SetServiceConfig";
      case messages::OnDeviceTranslationService::kCreateTranslator:
            return "Receive on_device_translation::mojom::OnDeviceTranslationService::CreateTranslator";
      case messages::OnDeviceTranslationService::kCanTranslate:
            return "Receive on_device_translation::mojom::OnDeviceTranslationService::CanTranslate";
    }
  } else {
    switch (static_cast<messages::OnDeviceTranslationService>(message.name())) {
      case messages::OnDeviceTranslationService::kSetServiceConfig:
            return "Receive reply on_device_translation::mojom::OnDeviceTranslationService::SetServiceConfig";
      case messages::OnDeviceTranslationService::kCreateTranslator:
            return "Receive reply on_device_translation::mojom::OnDeviceTranslationService::CreateTranslator";
      case messages::OnDeviceTranslationService::kCanTranslate:
            return "Receive reply on_device_translation::mojom::OnDeviceTranslationService::CanTranslate";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t OnDeviceTranslationService::SetServiceConfig_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xefec8c1e;  // IPCStableHash for on_device_translation::mojom::OnDeviceTranslationService::SetServiceConfig
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t OnDeviceTranslationService::CreateTranslator_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfb7f9129;  // IPCStableHash for on_device_translation::mojom::OnDeviceTranslationService::CreateTranslator
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t OnDeviceTranslationService::CanTranslate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x629a1fda;  // IPCStableHash for on_device_translation::mojom::OnDeviceTranslationService::CanTranslate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class OnDeviceTranslationService_CreateTranslator_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  OnDeviceTranslationService_CreateTranslator_ForwardToCallback(
      OnDeviceTranslationService::CreateTranslatorCallback callback
      ) : callback_(std::move(callback)) {
  }

  OnDeviceTranslationService_CreateTranslator_ForwardToCallback(const OnDeviceTranslationService_CreateTranslator_ForwardToCallback&) = delete;
  OnDeviceTranslationService_CreateTranslator_ForwardToCallback& operator=(const OnDeviceTranslationService_CreateTranslator_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  OnDeviceTranslationService::CreateTranslatorCallback callback_;
};

class OnDeviceTranslationService_CanTranslate_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  OnDeviceTranslationService_CanTranslate_ForwardToCallback(
      OnDeviceTranslationService::CanTranslateCallback callback
      ) : callback_(std::move(callback)) {
  }

  OnDeviceTranslationService_CanTranslate_ForwardToCallback(const OnDeviceTranslationService_CanTranslate_ForwardToCallback&) = delete;
  OnDeviceTranslationService_CanTranslate_ForwardToCallback& operator=(const OnDeviceTranslationService_CanTranslate_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  OnDeviceTranslationService::CanTranslateCallback callback_;
};

OnDeviceTranslationServiceProxy::OnDeviceTranslationServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void OnDeviceTranslationServiceProxy::SetServiceConfig(
    OnDeviceTranslationServiceConfigPtr in_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_translation::mojom::OnDeviceTranslationService::SetServiceConfig", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type OnDeviceTranslationServiceConfigPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceTranslationService::kSetServiceConfig), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_translation::mojom::internal::OnDeviceTranslationService_SetServiceConfig_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  
  mojo::internal::Serialize<::on_device_translation::mojom::OnDeviceTranslationServiceConfigDataView>(
    in_config,
    config_fragment);

  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null config in OnDeviceTranslationService.SetServiceConfig request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceTranslationService::Name_);
  message.set_method_name("SetServiceConfig");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void OnDeviceTranslationServiceProxy::CreateTranslator(
    const std::string& in_source_lang, const std::string& in_target_lang, ::mojo::PendingReceiver<::on_device_translation::mojom::Translator> in_receiver, CreateTranslatorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_translation::mojom::OnDeviceTranslationService::CreateTranslator", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_lang"), in_source_lang,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target_lang"), in_target_lang,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::on_device_translation::mojom::Translator>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceTranslationService::kCreateTranslator), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_translation::mojom::internal::OnDeviceTranslationService_CreateTranslator_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source_lang)::BaseType> source_lang_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_source_lang,
    source_lang_fragment);

  params->source_lang.Set(
      source_lang_fragment.is_null() ? nullptr : source_lang_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_lang.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_lang in OnDeviceTranslationService.CreateTranslator request");
  mojo::internal::MessageFragment<
      typename decltype(params->target_lang)::BaseType> target_lang_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_target_lang,
    target_lang_fragment);

  params->target_lang.Set(
      target_lang_fragment.is_null() ? nullptr : target_lang_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->target_lang.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null target_lang in OnDeviceTranslationService.CreateTranslator request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::on_device_translation::mojom::TranslatorInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in OnDeviceTranslationService.CreateTranslator request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceTranslationService::Name_);
  message.set_method_name("CreateTranslator");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new OnDeviceTranslationService_CreateTranslator_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void OnDeviceTranslationServiceProxy::CanTranslate(
    const std::string& in_source_lang, const std::string& in_target_lang, CanTranslateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_translation::mojom::OnDeviceTranslationService::CanTranslate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_lang"), in_source_lang,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target_lang"), in_target_lang,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceTranslationService::kCanTranslate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_translation::mojom::internal::OnDeviceTranslationService_CanTranslate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source_lang)::BaseType> source_lang_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_source_lang,
    source_lang_fragment);

  params->source_lang.Set(
      source_lang_fragment.is_null() ? nullptr : source_lang_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_lang.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_lang in OnDeviceTranslationService.CanTranslate request");
  mojo::internal::MessageFragment<
      typename decltype(params->target_lang)::BaseType> target_lang_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_target_lang,
    target_lang_fragment);

  params->target_lang.Set(
      target_lang_fragment.is_null() ? nullptr : target_lang_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->target_lang.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null target_lang in OnDeviceTranslationService.CanTranslate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceTranslationService::Name_);
  message.set_method_name("CanTranslate");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new OnDeviceTranslationService_CanTranslate_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class OnDeviceTranslationService_CreateTranslator_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static OnDeviceTranslationService::CreateTranslatorCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<OnDeviceTranslationService_CreateTranslator_ProxyToResponder> proxy(
        new OnDeviceTranslationService_CreateTranslator_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&OnDeviceTranslationService_CreateTranslator_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~OnDeviceTranslationService_CreateTranslator_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  OnDeviceTranslationService_CreateTranslator_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "OnDeviceTranslationService::CreateTranslatorCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CreateTranslatorResult in_result);
};

bool OnDeviceTranslationService_CreateTranslator_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::OnDeviceTranslationService_CreateTranslator_ResponseParams_Data* params =
      reinterpret_cast<
          internal::OnDeviceTranslationService_CreateTranslator_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for OnDeviceTranslationService.1
  bool success = true;
  CreateTranslatorResult p_result{};
  OnDeviceTranslationService_CreateTranslator_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        OnDeviceTranslationService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void OnDeviceTranslationService_CreateTranslator_ProxyToResponder::Run(
    CreateTranslatorResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply on_device_translation::mojom::OnDeviceTranslationService::CreateTranslator", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CreateTranslatorResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceTranslationService::kCreateTranslator), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_translation::mojom::internal::OnDeviceTranslationService_CreateTranslator_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::on_device_translation::mojom::CreateTranslatorResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceTranslationService::Name_);
  message.set_method_name("CreateTranslator");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class OnDeviceTranslationService_CanTranslate_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static OnDeviceTranslationService::CanTranslateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<OnDeviceTranslationService_CanTranslate_ProxyToResponder> proxy(
        new OnDeviceTranslationService_CanTranslate_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&OnDeviceTranslationService_CanTranslate_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~OnDeviceTranslationService_CanTranslate_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  OnDeviceTranslationService_CanTranslate_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "OnDeviceTranslationService::CanTranslateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_can_stranslate);
};

bool OnDeviceTranslationService_CanTranslate_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::OnDeviceTranslationService_CanTranslate_ResponseParams_Data* params =
      reinterpret_cast<
          internal::OnDeviceTranslationService_CanTranslate_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for OnDeviceTranslationService.2
  bool success = true;
  bool p_can_stranslate{};
  OnDeviceTranslationService_CanTranslate_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_can_stranslate = input_data_view.can_stranslate();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        OnDeviceTranslationService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_can_stranslate));
  }
  return true;
}

void OnDeviceTranslationService_CanTranslate_ProxyToResponder::Run(
    bool in_can_stranslate) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply on_device_translation::mojom::OnDeviceTranslationService::CanTranslate", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("can_stranslate"), in_can_stranslate,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceTranslationService::kCanTranslate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_translation::mojom::internal::OnDeviceTranslationService_CanTranslate_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->can_stranslate = in_can_stranslate;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceTranslationService::Name_);
  message.set_method_name("CanTranslate");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool OnDeviceTranslationServiceStubDispatch::Accept(
    OnDeviceTranslationService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::OnDeviceTranslationService>(message->header()->name)) {
    case messages::OnDeviceTranslationService::kSetServiceConfig: {
      DCHECK(message->is_serialized());
      internal::OnDeviceTranslationService_SetServiceConfig_Params_Data* params =
          reinterpret_cast<internal::OnDeviceTranslationService_SetServiceConfig_Params_Data*>(
              message->mutable_payload());
      

      // Validation for OnDeviceTranslationService.0
      bool success = true;
      OnDeviceTranslationServiceConfigPtr p_config{};
      OnDeviceTranslationService_SetServiceConfig_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OnDeviceTranslationService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetServiceConfig(        
        std::move(p_config));
      return true;
    }
    case messages::OnDeviceTranslationService::kCreateTranslator: {
      break;
    }
    case messages::OnDeviceTranslationService::kCanTranslate: {
      break;
    }
  }
  return false;
}

// static
bool OnDeviceTranslationServiceStubDispatch::AcceptWithResponder(
    OnDeviceTranslationService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::OnDeviceTranslationService>(message->header()->name)) {
    case messages::OnDeviceTranslationService::kSetServiceConfig: {
      break;
    }
    case messages::OnDeviceTranslationService::kCreateTranslator: {
      internal::OnDeviceTranslationService_CreateTranslator_Params_Data* params =
          reinterpret_cast<
              internal::OnDeviceTranslationService_CreateTranslator_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for OnDeviceTranslationService.1
      bool success = true;
      std::string p_source_lang{};
      std::string p_target_lang{};
      ::mojo::PendingReceiver<::on_device_translation::mojom::Translator> p_receiver{};
      OnDeviceTranslationService_CreateTranslator_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSourceLang(&p_source_lang))
        success = false;
      if (success && !input_data_view.ReadTargetLang(&p_target_lang))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OnDeviceTranslationService::Name_, 1, false);
        return false;
      }
      auto callback =
          OnDeviceTranslationService_CreateTranslator_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateTranslator(        
        std::move(p_source_lang), 
        std::move(p_target_lang), 
        std::move(p_receiver), std::move(callback));
      return true;
    }
    case messages::OnDeviceTranslationService::kCanTranslate: {
      internal::OnDeviceTranslationService_CanTranslate_Params_Data* params =
          reinterpret_cast<
              internal::OnDeviceTranslationService_CanTranslate_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for OnDeviceTranslationService.2
      bool success = true;
      std::string p_source_lang{};
      std::string p_target_lang{};
      OnDeviceTranslationService_CanTranslate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSourceLang(&p_source_lang))
        success = false;
      if (success && !input_data_view.ReadTargetLang(&p_target_lang))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OnDeviceTranslationService::Name_, 2, false);
        return false;
      }
      auto callback =
          OnDeviceTranslationService_CanTranslate_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CanTranslate(        
        std::move(p_source_lang), 
        std::move(p_target_lang), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kOnDeviceTranslationServiceValidationInfo[] = {
    { &internal::OnDeviceTranslationService_SetServiceConfig_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::OnDeviceTranslationService_CreateTranslator_Params_Data::Validate,
     &internal::OnDeviceTranslationService_CreateTranslator_ResponseParams_Data::Validate},
    { &internal::OnDeviceTranslationService_CanTranslate_Params_Data::Validate,
     &internal::OnDeviceTranslationService_CanTranslate_ResponseParams_Data::Validate},
};

bool OnDeviceTranslationServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::on_device_translation::mojom::OnDeviceTranslationService::Name_,
    kOnDeviceTranslationServiceValidationInfo);
}

bool OnDeviceTranslationServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::on_device_translation::mojom::OnDeviceTranslationService::Name_,
    kOnDeviceTranslationServiceValidationInfo);
}


}  // on_device_translation::mojom


namespace mojo {


// static
bool StructTraits<::on_device_translation::mojom::OnDeviceTranslationLanguagePackage::DataView, ::on_device_translation::mojom::OnDeviceTranslationLanguagePackagePtr>::Read(
    ::on_device_translation::mojom::OnDeviceTranslationLanguagePackage::DataView input,
    ::on_device_translation::mojom::OnDeviceTranslationLanguagePackagePtr* output) {
  bool success = true;
  ::on_device_translation::mojom::OnDeviceTranslationLanguagePackagePtr result(::on_device_translation::mojom::OnDeviceTranslationLanguagePackage::New());
  
      if (success && !input.ReadLanguage1(&result->language1))
        success = false;
      if (success && !input.ReadLanguage2(&result->language2))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::on_device_translation::mojom::OnDeviceTranslationServiceConfig::DataView, ::on_device_translation::mojom::OnDeviceTranslationServiceConfigPtr>::Read(
    ::on_device_translation::mojom::OnDeviceTranslationServiceConfig::DataView input,
    ::on_device_translation::mojom::OnDeviceTranslationServiceConfigPtr* output) {
  bool success = true;
  ::on_device_translation::mojom::OnDeviceTranslationServiceConfigPtr result(::on_device_translation::mojom::OnDeviceTranslationServiceConfig::New());
  
      if (success && !input.ReadPackages(&result->packages))
        success = false;
      if (success) {
        result->file_operation_proxy =
            input.TakeFileOperationProxy<decltype(result->file_operation_proxy)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace on_device_translation::mojom {


void FileOperationProxyInterceptorForTesting::FileExists(uint32_t package_index, const ::base::FilePath& relative_path, FileExistsCallback callback) {
  GetForwardingInterface()->FileExists(
    std::move(package_index)
    , 
    std::move(relative_path)
    , std::move(callback));
}
void FileOperationProxyInterceptorForTesting::Open(uint32_t package_index, const ::base::FilePath& relative_path, OpenCallback callback) {
  GetForwardingInterface()->Open(
    std::move(package_index)
    , 
    std::move(relative_path)
    , std::move(callback));
}
FileOperationProxyAsyncWaiter::FileOperationProxyAsyncWaiter(
    FileOperationProxy* proxy) : proxy_(proxy) {}

FileOperationProxyAsyncWaiter::~FileOperationProxyAsyncWaiter() = default;


void FileOperationProxyAsyncWaiter::FileExists(
    uint32_t package_index, const ::base::FilePath& relative_path, bool* out_exists, bool* out_is_directory) {
  base::RunLoop loop;
  proxy_->FileExists(
      std::move(package_index),
      std::move(relative_path),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_exists
,
             bool* out_is_directory
,
             bool exists,
             bool is_directory) {*out_exists = std::move(exists);*out_is_directory = std::move(is_directory);
            loop->Quit();
          },
          &loop,
          out_exists,
          out_is_directory));
  loop.Run();
}



void FileOperationProxyAsyncWaiter::Open(
    uint32_t package_index, const ::base::FilePath& relative_path, ::base::File* out_file) {
  base::RunLoop loop;
  proxy_->Open(
      std::move(package_index),
      std::move(relative_path),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File* out_file
,
             ::base::File file) {*out_file = std::move(file);
            loop->Quit();
          },
          &loop,
          out_file));
  loop.Run();
}

::base::File FileOperationProxyAsyncWaiter::Open(
    uint32_t package_index, const ::base::FilePath& relative_path) {
  ::base::File async_wait_result;
  Open(std::move(package_index),std::move(relative_path),&async_wait_result);
  return async_wait_result;
}




void OnDeviceTranslationServiceInterceptorForTesting::SetServiceConfig(OnDeviceTranslationServiceConfigPtr config) {
  GetForwardingInterface()->SetServiceConfig(
    std::move(config)
    );
}
void OnDeviceTranslationServiceInterceptorForTesting::CreateTranslator(const std::string& source_lang, const std::string& target_lang, ::mojo::PendingReceiver<::on_device_translation::mojom::Translator> receiver, CreateTranslatorCallback callback) {
  GetForwardingInterface()->CreateTranslator(
    std::move(source_lang)
    , 
    std::move(target_lang)
    , 
    std::move(receiver)
    , std::move(callback));
}
void OnDeviceTranslationServiceInterceptorForTesting::CanTranslate(const std::string& source_lang, const std::string& target_lang, CanTranslateCallback callback) {
  GetForwardingInterface()->CanTranslate(
    std::move(source_lang)
    , 
    std::move(target_lang)
    , std::move(callback));
}
OnDeviceTranslationServiceAsyncWaiter::OnDeviceTranslationServiceAsyncWaiter(
    OnDeviceTranslationService* proxy) : proxy_(proxy) {}

OnDeviceTranslationServiceAsyncWaiter::~OnDeviceTranslationServiceAsyncWaiter() = default;


void OnDeviceTranslationServiceAsyncWaiter::CreateTranslator(
    const std::string& source_lang, const std::string& target_lang, ::mojo::PendingReceiver<::on_device_translation::mojom::Translator> receiver, CreateTranslatorResult* out_result) {
  base::RunLoop loop;
  proxy_->CreateTranslator(
      std::move(source_lang),
      std::move(target_lang),
      std::move(receiver),
      base::BindOnce(
          [](base::RunLoop* loop,
             CreateTranslatorResult* out_result
,
             CreateTranslatorResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

CreateTranslatorResult OnDeviceTranslationServiceAsyncWaiter::CreateTranslator(
    const std::string& source_lang, const std::string& target_lang, ::mojo::PendingReceiver<::on_device_translation::mojom::Translator> receiver) {
  CreateTranslatorResult async_wait_result;
  CreateTranslator(std::move(source_lang),std::move(target_lang),std::move(receiver),&async_wait_result);
  return async_wait_result;
}

void OnDeviceTranslationServiceAsyncWaiter::CanTranslate(
    const std::string& source_lang, const std::string& target_lang, bool* out_can_stranslate) {
  base::RunLoop loop;
  proxy_->CanTranslate(
      std::move(source_lang),
      std::move(target_lang),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_can_stranslate
,
             bool can_stranslate) {*out_can_stranslate = std::move(can_stranslate);
            loop->Quit();
          },
          &loop,
          out_can_stranslate));
  loop.Run();
}

bool OnDeviceTranslationServiceAsyncWaiter::CanTranslate(
    const std::string& source_lang, const std::string& target_lang) {
  bool async_wait_result;
  CanTranslate(std::move(source_lang),std::move(target_lang),&async_wait_result);
  return async_wait_result;
}






}  // on_device_translation::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif