// components/services/on_device_translation/public/mojom/on_device_translation_service.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_ON_DEVICE_TRANSLATION_PUBLIC_MOJOM_ON_DEVICE_TRANSLATION_SERVICE_MOJOM_TEST_UTILS_H_
#define COMPONENTS_SERVICES_ON_DEVICE_TRANSLATION_PUBLIC_MOJOM_ON_DEVICE_TRANSLATION_SERVICE_MOJOM_TEST_UTILS_H_

#include "components/services/on_device_translation/public/mojom/on_device_translation_service.mojom.h"


namespace on_device_translation::mojom {


class  FileOperationProxyInterceptorForTesting : public FileOperationProxy {
  virtual FileOperationProxy* GetForwardingInterface() = 0;
  void FileExists(uint32_t package_index, const ::base::FilePath& relative_path, FileExistsCallback callback) override;
  void Open(uint32_t package_index, const ::base::FilePath& relative_path, OpenCallback callback) override;
};
class  FileOperationProxyAsyncWaiter {
 public:
  explicit FileOperationProxyAsyncWaiter(FileOperationProxy* proxy);

  FileOperationProxyAsyncWaiter(const FileOperationProxyAsyncWaiter&) = delete;
  FileOperationProxyAsyncWaiter& operator=(const FileOperationProxyAsyncWaiter&) = delete;

  ~FileOperationProxyAsyncWaiter();
  void FileExists(
      uint32_t package_index, const ::base::FilePath& relative_path, bool* out_exists, bool* out_is_directory);
  
  void Open(
      uint32_t package_index, const ::base::FilePath& relative_path, ::base::File* out_file);
  ::base::File Open(uint32_t package_index, const ::base::FilePath& relative_path);

 private:
  FileOperationProxy* const proxy_;
};


class  OnDeviceTranslationServiceInterceptorForTesting : public OnDeviceTranslationService {
  virtual OnDeviceTranslationService* GetForwardingInterface() = 0;
  void SetServiceConfig(OnDeviceTranslationServiceConfigPtr config) override;
  void CreateTranslator(const std::string& source_lang, const std::string& target_lang, ::mojo::PendingReceiver<::on_device_translation::mojom::Translator> receiver, CreateTranslatorCallback callback) override;
  void CanTranslate(const std::string& source_lang, const std::string& target_lang, CanTranslateCallback callback) override;
};
class  OnDeviceTranslationServiceAsyncWaiter {
 public:
  explicit OnDeviceTranslationServiceAsyncWaiter(OnDeviceTranslationService* proxy);

  OnDeviceTranslationServiceAsyncWaiter(const OnDeviceTranslationServiceAsyncWaiter&) = delete;
  OnDeviceTranslationServiceAsyncWaiter& operator=(const OnDeviceTranslationServiceAsyncWaiter&) = delete;

  ~OnDeviceTranslationServiceAsyncWaiter();
  void CreateTranslator(
      const std::string& source_lang, const std::string& target_lang, ::mojo::PendingReceiver<::on_device_translation::mojom::Translator> receiver, CreateTranslatorResult* out_result);
  CreateTranslatorResult CreateTranslator(const std::string& source_lang, const std::string& target_lang, ::mojo::PendingReceiver<::on_device_translation::mojom::Translator> receiver);
  void CanTranslate(
      const std::string& source_lang, const std::string& target_lang, bool* out_can_stranslate);
  bool CanTranslate(const std::string& source_lang, const std::string& target_lang);

 private:
  OnDeviceTranslationService* const proxy_;
};




}  // on_device_translation::mojom

#endif  // COMPONENTS_SERVICES_ON_DEVICE_TRANSLATION_PUBLIC_MOJOM_ON_DEVICE_TRANSLATION_SERVICE_MOJOM_TEST_UTILS_H_