// components/services/on_device_translation/public/mojom/on_device_translation_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/services/on_device_translation/public/mojom/on_device_translation_service.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/on_device_translation/public/mojom/on_device_translation_service.mojom-params-data.h"
namespace on_device_translation {
namespace mojom {

NOINLINE static const char* CreateTranslatorResultToStringHelper(CreateTranslatorResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CreateTranslatorResult::kSuccess:
      return "kSuccess";
    case CreateTranslatorResult::kErrorInvalidBinary:
      return "kErrorInvalidBinary";
    case CreateTranslatorResult::kErrorInvalidFunctionPointer:
      return "kErrorInvalidFunctionPointer";
    case CreateTranslatorResult::kErrorFailedToInitialize:
      return "kErrorFailedToInitialize";
    case CreateTranslatorResult::kErrorFailedToCreateTranslator:
      return "kErrorFailedToCreateTranslator";
    case CreateTranslatorResult::kErrorInvalidVersion:
      return "kErrorInvalidVersion";
    default:
      return nullptr;
  }
}

std::string CreateTranslatorResultToString(CreateTranslatorResult value) {
  const char *str = CreateTranslatorResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CreateTranslatorResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CreateTranslatorResult value) {
  return os << CreateTranslatorResultToString(value);
}

namespace internal {


// static
bool OnDeviceTranslationLanguagePackage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceTranslationLanguagePackage_Data* object =
      static_cast<const OnDeviceTranslationLanguagePackage_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->language1, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& language1_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->language1, validation_context,
                                         &language1_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->language2, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& language2_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->language2, validation_context,
                                         &language2_validate_params)) {
    return false;
  }

  return true;
}

OnDeviceTranslationLanguagePackage_Data::OnDeviceTranslationLanguagePackage_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceTranslationServiceConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceTranslationServiceConfig_Data* object =
      static_cast<const OnDeviceTranslationServiceConfig_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->packages, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& packages_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->packages, validation_context,
                                         &packages_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->file_operation_proxy, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->file_operation_proxy,
                                                 validation_context)) {
    return false;
  }

  return true;
}

OnDeviceTranslationServiceConfig_Data::OnDeviceTranslationServiceConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileOperationProxy_FileExists_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileOperationProxy_FileExists_Params_Data* object =
      static_cast<const FileOperationProxy_FileExists_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->relative_path, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->relative_path, validation_context))
    return false;

  return true;
}

FileOperationProxy_FileExists_Params_Data::FileOperationProxy_FileExists_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileOperationProxy_FileExists_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileOperationProxy_FileExists_ResponseParams_Data* object =
      static_cast<const FileOperationProxy_FileExists_ResponseParams_Data*>(data);

  return true;
}

FileOperationProxy_FileExists_ResponseParams_Data::FileOperationProxy_FileExists_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileOperationProxy_Open_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileOperationProxy_Open_Params_Data* object =
      static_cast<const FileOperationProxy_Open_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->relative_path, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->relative_path, validation_context))
    return false;

  return true;
}

FileOperationProxy_Open_Params_Data::FileOperationProxy_Open_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileOperationProxy_Open_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileOperationProxy_Open_ResponseParams_Data* object =
      static_cast<const FileOperationProxy_Open_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->file, validation_context))
    return false;

  return true;
}

FileOperationProxy_Open_ResponseParams_Data::FileOperationProxy_Open_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceTranslationService_SetServiceConfig_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceTranslationService_SetServiceConfig_Params_Data* object =
      static_cast<const OnDeviceTranslationService_SetServiceConfig_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->config, validation_context))
    return false;

  return true;
}

OnDeviceTranslationService_SetServiceConfig_Params_Data::OnDeviceTranslationService_SetServiceConfig_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceTranslationService_CreateTranslator_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceTranslationService_CreateTranslator_Params_Data* object =
      static_cast<const OnDeviceTranslationService_CreateTranslator_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_lang, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& source_lang_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->source_lang, validation_context,
                                         &source_lang_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->target_lang, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& target_lang_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->target_lang, validation_context,
                                         &target_lang_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

OnDeviceTranslationService_CreateTranslator_Params_Data::OnDeviceTranslationService_CreateTranslator_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceTranslationService_CreateTranslator_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceTranslationService_CreateTranslator_ResponseParams_Data* object =
      static_cast<const OnDeviceTranslationService_CreateTranslator_ResponseParams_Data*>(data);


  if (!::on_device_translation::mojom::internal::CreateTranslatorResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

OnDeviceTranslationService_CreateTranslator_ResponseParams_Data::OnDeviceTranslationService_CreateTranslator_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceTranslationService_CanTranslate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceTranslationService_CanTranslate_Params_Data* object =
      static_cast<const OnDeviceTranslationService_CanTranslate_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_lang, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& source_lang_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->source_lang, validation_context,
                                         &source_lang_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->target_lang, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& target_lang_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->target_lang, validation_context,
                                         &target_lang_validate_params)) {
    return false;
  }

  return true;
}

OnDeviceTranslationService_CanTranslate_Params_Data::OnDeviceTranslationService_CanTranslate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceTranslationService_CanTranslate_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceTranslationService_CanTranslate_ResponseParams_Data* object =
      static_cast<const OnDeviceTranslationService_CanTranslate_ResponseParams_Data*>(data);

  return true;
}

OnDeviceTranslationService_CanTranslate_ResponseParams_Data::OnDeviceTranslationService_CanTranslate_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace on_device_translation

namespace perfetto {

// static
void TraceFormatTraits<::on_device_translation::mojom::CreateTranslatorResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::on_device_translation::mojom::CreateTranslatorResult value) {
  return std::move(context).WriteString(::on_device_translation::mojom::CreateTranslatorResultToString(value));
}

} // namespace perfetto