// components/services/filesystem/public/mojom/types.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'components/services/filesystem/public/mojom/types.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('filesystem.mojom');
  var file_path$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file_path.mojom', '../../../../../mojo/public/mojom/base/file_path.mojom.js');
  }
  var safe_base_name$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/safe_base_name.mojom', '../../../../../mojo/public/mojom/base/safe_base_name.mojom.js');
  }


  var FLAG_OPEN = 0x1;
  var FLAG_CREATE = 0x2;
  var FLAG_OPEN_ALWAYS = 0x4;
  var CREATE_ALWAYS = 0x8;
  var FLAG_OPEN_TRUNCATED = 0x10;
  var FLAG_READ = 0x20;
  var FLAG_WRITE = 0x40;
  var FLAG_APPEND = 0x80;
  var DELETE_ON_CLOSE = 0x2000;
  var FLAG_WRITE_ATTRIBUTES = 0x4000;
  var DELETE_FLAG_RECURSIVE = 0x1;
  var Whence = {};
  Whence.FROM_BEGIN = 0;
  Whence.FROM_CURRENT = 1;
  Whence.FROM_END = 2;
  Whence.MIN_VALUE = 0;
  Whence.MAX_VALUE = 2;

  Whence.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  Whence.toKnownEnumValue = function(value) {
    return value;
  };

  Whence.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var FsFileType = {};
  FsFileType.UNKNOWN = 0;
  FsFileType.REGULAR_FILE = 1;
  FsFileType.DIRECTORY = 2;
  FsFileType.MIN_VALUE = 0;
  FsFileType.MAX_VALUE = 2;

  FsFileType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  FsFileType.toKnownEnumValue = function(value) {
    return value;
  };

  FsFileType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function TimespecOrNow(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TimespecOrNow.prototype.initDefaults_ = function() {
    this.now = false;
    this.seconds = 0;
  };
  TimespecOrNow.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TimespecOrNow.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  TimespecOrNow.encodedSize = codec.kStructHeaderSize + 16;

  TimespecOrNow.decode = function(decoder) {
    var packed;
    var val = new TimespecOrNow();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.now = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.seconds =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  TimespecOrNow.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TimespecOrNow.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.now & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Double, val.seconds);
  };
  function FileInformation(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileInformation.prototype.initDefaults_ = function() {
    this.type = 0;
    this.size = 0;
    this.atime = 0;
    this.mtime = 0;
    this.ctime = 0;
  };
  FileInformation.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileInformation.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileInformation.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, FsFileType);
    if (err !== validator.validationError.NONE)
        return err;





    return validator.validationError.NONE;
  };

  FileInformation.encodedSize = codec.kStructHeaderSize + 40;

  FileInformation.decode = function(decoder) {
    var packed;
    var val = new FileInformation();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(FsFileType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.size =
        decoder.decodeStruct(codec.Int64);
    val.atime =
        decoder.decodeStruct(codec.Double);
    val.mtime =
        decoder.decodeStruct(codec.Double);
    val.ctime =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  FileInformation.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileInformation.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int64, val.size);
    encoder.encodeStruct(codec.Double, val.atime);
    encoder.encodeStruct(codec.Double, val.mtime);
    encoder.encodeStruct(codec.Double, val.ctime);
  };
  function DirectoryEntry(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DirectoryEntry.prototype.initDefaults_ = function() {
    this.name = null;
    this.displayName = null;
    this.type = 0;
  };
  DirectoryEntry.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DirectoryEntry.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectoryEntry.name
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, safe_base_name$.SafeBaseName, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectoryEntry.displayName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectoryEntry.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, FsFileType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DirectoryEntry.encodedSize = codec.kStructHeaderSize + 24;

  DirectoryEntry.decode = function(decoder) {
    var packed;
    var val = new DirectoryEntry();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStructPointer(safe_base_name$.SafeBaseName);
    val.displayName =
        decoder.decodeStruct(codec.String);
    val.type =
        decoder.decodeStruct(new codec.Enum(FsFileType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DirectoryEntry.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DirectoryEntry.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(safe_base_name$.SafeBaseName, val.name);
    encoder.encodeStruct(codec.String, val.displayName);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.FLAG_OPEN = FLAG_OPEN;
  exports.FLAG_CREATE = FLAG_CREATE;
  exports.FLAG_OPEN_ALWAYS = FLAG_OPEN_ALWAYS;
  exports.CREATE_ALWAYS = CREATE_ALWAYS;
  exports.FLAG_OPEN_TRUNCATED = FLAG_OPEN_TRUNCATED;
  exports.FLAG_READ = FLAG_READ;
  exports.FLAG_WRITE = FLAG_WRITE;
  exports.FLAG_APPEND = FLAG_APPEND;
  exports.DELETE_ON_CLOSE = DELETE_ON_CLOSE;
  exports.FLAG_WRITE_ATTRIBUTES = FLAG_WRITE_ATTRIBUTES;
  exports.DELETE_FLAG_RECURSIVE = DELETE_FLAG_RECURSIVE;
  exports.Whence = Whence;
  exports.FsFileType = FsFileType;
  exports.TimespecOrNow = TimespecOrNow;
  exports.FileInformation = FileInformation;
  exports.DirectoryEntry = DirectoryEntry;
})();