// components/services/filesystem/public/mojom/types.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_TYPES_MOJOM_H_
#define COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_TYPES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/filesystem/public/mojom/types.mojom-features.h"  // IWYU pragma: export
#include "components/services/filesystem/public/mojom/types.mojom-shared.h"  // IWYU pragma: export
#include "components/services/filesystem/public/mojom/types.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file_path.mojom-forward.h"
#include "mojo/public/mojom/base/safe_base_name.mojom.h"
#include <string>
#include <vector>








namespace filesystem::mojom {





class  TimespecOrNow {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TimespecOrNow, T>::value>;
  using DataView = TimespecOrNowDataView;
  using Data_ = internal::TimespecOrNow_Data;

  template <typename... Args>
  static TimespecOrNowPtr New(Args&&... args) {
    return TimespecOrNowPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TimespecOrNowPtr From(const U& u) {
    return mojo::TypeConverter<TimespecOrNowPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TimespecOrNow>::Convert(*this);
  }


  TimespecOrNow();

  TimespecOrNow(
      bool now,
      double seconds);


  ~TimespecOrNow();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TimespecOrNowPtr>
  TimespecOrNowPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TimespecOrNow::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TimespecOrNow::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TimespecOrNow::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TimespecOrNow::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TimespecOrNow::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TimespecOrNow::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TimespecOrNow_UnserializedMessageContext<
            UserType, TimespecOrNow::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TimespecOrNow::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TimespecOrNow::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TimespecOrNow_UnserializedMessageContext<
            UserType, TimespecOrNow::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TimespecOrNow::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool now;
  
  double seconds;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TimespecOrNow::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TimespecOrNow::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TimespecOrNow::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TimespecOrNow::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class  FileInformation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FileInformation, T>::value>;
  using DataView = FileInformationDataView;
  using Data_ = internal::FileInformation_Data;

  template <typename... Args>
  static FileInformationPtr New(Args&&... args) {
    return FileInformationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FileInformationPtr From(const U& u) {
    return mojo::TypeConverter<FileInformationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileInformation>::Convert(*this);
  }


  FileInformation();

  FileInformation(
      FsFileType type,
      int64_t size,
      double atime,
      double mtime,
      double ctime);


  ~FileInformation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FileInformationPtr>
  FileInformationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FileInformation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FileInformation::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FileInformation::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileInformation::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileInformation::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileInformation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FileInformation_UnserializedMessageContext<
            UserType, FileInformation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FileInformation::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FileInformation::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FileInformation_UnserializedMessageContext<
            UserType, FileInformation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FileInformation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  FsFileType type;
  
  int64_t size;
  
  double atime;
  
  double mtime;
  
  double ctime;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FileInformation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FileInformation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FileInformation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FileInformation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DirectoryEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DirectoryEntry, T>::value>;
  using DataView = DirectoryEntryDataView;
  using Data_ = internal::DirectoryEntry_Data;

  template <typename... Args>
  static DirectoryEntryPtr New(Args&&... args) {
    return DirectoryEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DirectoryEntryPtr From(const U& u) {
    return mojo::TypeConverter<DirectoryEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DirectoryEntry>::Convert(*this);
  }


  DirectoryEntry();

  DirectoryEntry(
      const ::base::SafeBaseName& name,
      const std::string& display_name,
      FsFileType type);


  ~DirectoryEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DirectoryEntryPtr>
  DirectoryEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DirectoryEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DirectoryEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DirectoryEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DirectoryEntry::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DirectoryEntry::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DirectoryEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DirectoryEntry_UnserializedMessageContext<
            UserType, DirectoryEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DirectoryEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DirectoryEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DirectoryEntry_UnserializedMessageContext<
            UserType, DirectoryEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DirectoryEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::SafeBaseName name;
  
  std::string display_name;
  
  FsFileType type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DirectoryEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DirectoryEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DirectoryEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DirectoryEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
TimespecOrNowPtr TimespecOrNow::Clone() const {
  return New(
      mojo::Clone(now),
      mojo::Clone(seconds)
  );
}

template <typename T, TimespecOrNow::EnableIfSame<T>*>
bool TimespecOrNow::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->now, other_struct.now))
    return false;
  if (!mojo::Equals(this->seconds, other_struct.seconds))
    return false;
  return true;
}

template <typename T, TimespecOrNow::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.now < rhs.now)
    return true;
  if (rhs.now < lhs.now)
    return false;
  if (lhs.seconds < rhs.seconds)
    return true;
  if (rhs.seconds < lhs.seconds)
    return false;
  return false;
}
template <typename StructPtrType>
FileInformationPtr FileInformation::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(size),
      mojo::Clone(atime),
      mojo::Clone(mtime),
      mojo::Clone(ctime)
  );
}

template <typename T, FileInformation::EnableIfSame<T>*>
bool FileInformation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->atime, other_struct.atime))
    return false;
  if (!mojo::Equals(this->mtime, other_struct.mtime))
    return false;
  if (!mojo::Equals(this->ctime, other_struct.ctime))
    return false;
  return true;
}

template <typename T, FileInformation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  if (lhs.atime < rhs.atime)
    return true;
  if (rhs.atime < lhs.atime)
    return false;
  if (lhs.mtime < rhs.mtime)
    return true;
  if (rhs.mtime < lhs.mtime)
    return false;
  if (lhs.ctime < rhs.ctime)
    return true;
  if (rhs.ctime < lhs.ctime)
    return false;
  return false;
}
template <typename StructPtrType>
DirectoryEntryPtr DirectoryEntry::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(display_name),
      mojo::Clone(type)
  );
}

template <typename T, DirectoryEntry::EnableIfSame<T>*>
bool DirectoryEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->display_name, other_struct.display_name))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  return true;
}

template <typename T, DirectoryEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.display_name < rhs.display_name)
    return true;
  if (rhs.display_name < lhs.display_name)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  return false;
}


}  // filesystem::mojom

namespace mojo {


template <>
struct  StructTraits<::filesystem::mojom::TimespecOrNow::DataView,
                                         ::filesystem::mojom::TimespecOrNowPtr> {
  static bool IsNull(const ::filesystem::mojom::TimespecOrNowPtr& input) { return !input; }
  static void SetToNull(::filesystem::mojom::TimespecOrNowPtr* output) { output->reset(); }

  static decltype(::filesystem::mojom::TimespecOrNow::now) now(
      const ::filesystem::mojom::TimespecOrNowPtr& input) {
    return input->now;
  }

  static decltype(::filesystem::mojom::TimespecOrNow::seconds) seconds(
      const ::filesystem::mojom::TimespecOrNowPtr& input) {
    return input->seconds;
  }

  static bool Read(::filesystem::mojom::TimespecOrNow::DataView input, ::filesystem::mojom::TimespecOrNowPtr* output);
};


template <>
struct  StructTraits<::filesystem::mojom::FileInformation::DataView,
                                         ::filesystem::mojom::FileInformationPtr> {
  static bool IsNull(const ::filesystem::mojom::FileInformationPtr& input) { return !input; }
  static void SetToNull(::filesystem::mojom::FileInformationPtr* output) { output->reset(); }

  static decltype(::filesystem::mojom::FileInformation::type) type(
      const ::filesystem::mojom::FileInformationPtr& input) {
    return input->type;
  }

  static decltype(::filesystem::mojom::FileInformation::size) size(
      const ::filesystem::mojom::FileInformationPtr& input) {
    return input->size;
  }

  static decltype(::filesystem::mojom::FileInformation::atime) atime(
      const ::filesystem::mojom::FileInformationPtr& input) {
    return input->atime;
  }

  static decltype(::filesystem::mojom::FileInformation::mtime) mtime(
      const ::filesystem::mojom::FileInformationPtr& input) {
    return input->mtime;
  }

  static decltype(::filesystem::mojom::FileInformation::ctime) ctime(
      const ::filesystem::mojom::FileInformationPtr& input) {
    return input->ctime;
  }

  static bool Read(::filesystem::mojom::FileInformation::DataView input, ::filesystem::mojom::FileInformationPtr* output);
};


template <>
struct  StructTraits<::filesystem::mojom::DirectoryEntry::DataView,
                                         ::filesystem::mojom::DirectoryEntryPtr> {
  static bool IsNull(const ::filesystem::mojom::DirectoryEntryPtr& input) { return !input; }
  static void SetToNull(::filesystem::mojom::DirectoryEntryPtr* output) { output->reset(); }

  static const decltype(::filesystem::mojom::DirectoryEntry::name)& name(
      const ::filesystem::mojom::DirectoryEntryPtr& input) {
    return input->name;
  }

  static const decltype(::filesystem::mojom::DirectoryEntry::display_name)& display_name(
      const ::filesystem::mojom::DirectoryEntryPtr& input) {
    return input->display_name;
  }

  static decltype(::filesystem::mojom::DirectoryEntry::type) type(
      const ::filesystem::mojom::DirectoryEntryPtr& input) {
    return input->type;
  }

  static bool Read(::filesystem::mojom::DirectoryEntry::DataView input, ::filesystem::mojom::DirectoryEntryPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_TYPES_MOJOM_H_