// components/services/filesystem/public/mojom/directory.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_DIRECTORY_MOJOM_BLINK_TEST_UTILS_H_
#define COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_DIRECTORY_MOJOM_BLINK_TEST_UTILS_H_

#include "components/services/filesystem/public/mojom/directory.mojom-blink.h"


namespace filesystem::mojom::blink {


class  DirectoryInterceptorForTesting : public Directory {
  virtual Directory* GetForwardingInterface() = 0;
  void Read(ReadCallback callback) override;
  void OpenFileHandle(const ::blink::String& path, uint32_t open_flags, OpenFileHandleCallback callback) override;
  void OpenFileHandles(::blink::Vector<FileOpenDetailsPtr> files, OpenFileHandlesCallback callback) override;
  void OpenDirectory(const ::blink::String& path, ::mojo::PendingReceiver<Directory> directory, uint32_t open_flags, OpenDirectoryCallback callback) override;
  void Rename(const ::blink::String& path, const ::blink::String& new_path, RenameCallback callback) override;
  void Replace(const ::blink::String& path, const ::blink::String& new_path, ReplaceCallback callback) override;
  void Delete(const ::blink::String& path, uint32_t delete_flags, DeleteCallback callback) override;
  void Exists(const ::blink::String& path, ExistsCallback callback) override;
  void IsWritable(const ::blink::String& path, IsWritableCallback callback) override;
  void Flush(FlushCallback callback) override;
  void StatFile(const ::blink::String& path, StatFileCallback callback) override;
  void Clone(::mojo::PendingReceiver<Directory> directory) override;
  void ReadEntireFile(const ::blink::String& path, ReadEntireFileCallback callback) override;
  void WriteFile(const ::blink::String& path, const ::blink::Vector<uint8_t>& data, WriteFileCallback callback) override;
};
class  DirectoryAsyncWaiter {
 public:
  explicit DirectoryAsyncWaiter(Directory* proxy);

  DirectoryAsyncWaiter(const DirectoryAsyncWaiter&) = delete;
  DirectoryAsyncWaiter& operator=(const DirectoryAsyncWaiter&) = delete;

  ~DirectoryAsyncWaiter();
  void Read(
      ::base::File::Error* out_error, std::optional<::blink::Vector<::filesystem::mojom::blink::DirectoryEntryPtr>>* out_directory_contents);
  
  void OpenFileHandle(
      const ::blink::String& path, uint32_t open_flags, ::base::File::Error* out_error, ::base::File* out_file_handle);
  
  void OpenFileHandles(
      ::blink::Vector<FileOpenDetailsPtr> files, ::blink::Vector<FileOpenResultPtr>* out_results);
  ::blink::Vector<FileOpenResultPtr> OpenFileHandles(::blink::Vector<FileOpenDetailsPtr> files);
  void OpenDirectory(
      const ::blink::String& path, ::mojo::PendingReceiver<Directory> directory, uint32_t open_flags, ::base::File::Error* out_error);
  ::base::File::Error OpenDirectory(const ::blink::String& path, ::mojo::PendingReceiver<Directory> directory, uint32_t open_flags);
  void Rename(
      const ::blink::String& path, const ::blink::String& new_path, ::base::File::Error* out_error);
  ::base::File::Error Rename(const ::blink::String& path, const ::blink::String& new_path);
  void Replace(
      const ::blink::String& path, const ::blink::String& new_path, ::base::File::Error* out_error);
  ::base::File::Error Replace(const ::blink::String& path, const ::blink::String& new_path);
  void Delete(
      const ::blink::String& path, uint32_t delete_flags, ::base::File::Error* out_error);
  ::base::File::Error Delete(const ::blink::String& path, uint32_t delete_flags);
  void Exists(
      const ::blink::String& path, ::base::File::Error* out_error, bool* out_exists);
  
  void IsWritable(
      const ::blink::String& path, ::base::File::Error* out_error, bool* out_is_writable);
  
  void Flush(
      ::base::File::Error* out_error);
  ::base::File::Error Flush();
  void StatFile(
      const ::blink::String& path, ::base::File::Error* out_error, ::filesystem::mojom::blink::FileInformationPtr* out_file_information);
  
  void ReadEntireFile(
      const ::blink::String& path, ::base::File::Error* out_error, ::blink::Vector<uint8_t>* out_data);
  
  void WriteFile(
      const ::blink::String& path, const ::blink::Vector<uint8_t>& data, ::base::File::Error* out_error);
  ::base::File::Error WriteFile(const ::blink::String& path, const ::blink::Vector<uint8_t>& data);

 private:
  Directory* const proxy_;
};




}  // filesystem::mojom::blink

#endif  // COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_DIRECTORY_MOJOM_BLINK_TEST_UTILS_H_