// components/safe_browsing/core/common/safe_browsing_url_checker.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SAFE_BROWSING_CORE_COMMON_SAFE_BROWSING_URL_CHECKER_MOJOM_H_
#define COMPONENTS_SAFE_BROWSING_CORE_COMMON_SAFE_BROWSING_URL_CHECKER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/safe_browsing/core/common/safe_browsing_url_checker.mojom-features.h"  // IWYU pragma: export
#include "components/safe_browsing/core/common/safe_browsing_url_checker.mojom-shared.h"  // IWYU pragma: export
#include "components/safe_browsing/core/common/safe_browsing_url_checker.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace safe_browsing::mojom {

class SafeBrowsingUrlCheckerProxy;

template <typename ImplRefTraits>
class SafeBrowsingUrlCheckerStub;

class SafeBrowsingUrlCheckerRequestValidator;
class SafeBrowsingUrlCheckerResponseValidator;


class SafeBrowsingUrlChecker
    : public SafeBrowsingUrlCheckerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "safe_browsing.mojom.SafeBrowsingUrlChecker";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SafeBrowsingUrlCheckerInterfaceBase;
  using Proxy_ = SafeBrowsingUrlCheckerProxy;

  template <typename ImplRefTraits>
  using Stub_ = SafeBrowsingUrlCheckerStub<ImplRefTraits>;

  using RequestValidator_ = SafeBrowsingUrlCheckerRequestValidator;
  using ResponseValidator_ = SafeBrowsingUrlCheckerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCheckUrlMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CheckUrl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SafeBrowsingUrlChecker() = default;

  using CheckUrlCallback = base::OnceCallback<void(bool, bool)>;
  using CheckUrlMojoCallback = base::OnceCallback<void(bool, bool)>;

  virtual void CheckUrl(const ::GURL& url, const std::string& method, CheckUrlCallback callback) = 0;
};



class  SafeBrowsingUrlCheckerProxy
    : public SafeBrowsingUrlChecker {
 public:
  using InterfaceType = SafeBrowsingUrlChecker;

  explicit SafeBrowsingUrlCheckerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CheckUrl(const ::GURL& url, const std::string& method, CheckUrlCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SafeBrowsingUrlCheckerStubDispatch {
 public:
  static bool Accept(SafeBrowsingUrlChecker* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SafeBrowsingUrlChecker* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SafeBrowsingUrlChecker>>
class SafeBrowsingUrlCheckerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SafeBrowsingUrlCheckerStub() = default;
  ~SafeBrowsingUrlCheckerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SafeBrowsingUrlCheckerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SafeBrowsingUrlCheckerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SafeBrowsingUrlCheckerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SafeBrowsingUrlCheckerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // safe_browsing::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_SAFE_BROWSING_CORE_COMMON_SAFE_BROWSING_URL_CHECKER_MOJOM_H_