// components/safe_browsing/content/common/safe_browsing.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/safe_browsing/content/common/safe_browsing.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/safe_browsing/content/common/safe_browsing.mojom-params-data.h"
namespace safe_browsing {
namespace mojom {

NOINLINE static const char* PhishingDetectorResultToStringHelper(PhishingDetectorResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PhishingDetectorResult::SUCCESS:
      return "SUCCESS";
    case PhishingDetectorResult::CLASSIFIER_NOT_READY:
      return "CLASSIFIER_NOT_READY";
    case PhishingDetectorResult::CANCELLED:
      return "CANCELLED";
    case PhishingDetectorResult::FORWARD_BACK_TRANSITION:
      return "FORWARD_BACK_TRANSITION";
    case PhishingDetectorResult::INVALID_SCORE:
      return "INVALID_SCORE";
    case PhishingDetectorResult::INVALID_URL_FORMAT_REQUEST:
      return "INVALID_URL_FORMAT_REQUEST";
    case PhishingDetectorResult::INVALID_DOCUMENT_LOADER:
      return "INVALID_DOCUMENT_LOADER";
    case PhishingDetectorResult::URL_FEATURE_EXTRACTION_FAILED:
      return "URL_FEATURE_EXTRACTION_FAILED";
    case PhishingDetectorResult::DOM_EXTRACTION_FAILED:
      return "DOM_EXTRACTION_FAILED";
    case PhishingDetectorResult::TERM_EXTRACTION_FAILED:
      return "TERM_EXTRACTION_FAILED";
    case PhishingDetectorResult::VISUAL_EXTRACTION_FAILED:
      return "VISUAL_EXTRACTION_FAILED";
    default:
      return nullptr;
  }
}

std::string PhishingDetectorResultToString(PhishingDetectorResult value) {
  const char *str = PhishingDetectorResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PhishingDetectorResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PhishingDetectorResult value) {
  return os << PhishingDetectorResultToString(value);
}

NOINLINE static const char* ClientSideDetectionTypeToStringHelper(ClientSideDetectionType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ClientSideDetectionType::kForceRequest:
      return "kForceRequest";
    case ClientSideDetectionType::kTriggerModels:
      return "kTriggerModels";
    case ClientSideDetectionType::kNotificationPermissionPrompt:
      return "kNotificationPermissionPrompt";
    case ClientSideDetectionType::kKeyboardLock:
      return "kKeyboardLock";
    case ClientSideDetectionType::kPointerLock:
      return "kPointerLock";
    case ClientSideDetectionType::kVibrationApi:
      return "kVibrationApi";
    case ClientSideDetectionType::kFullscreen:
      return "kFullscreen";
    case ClientSideDetectionType::kPasswordProtection:
      return "kPasswordProtection";
    case ClientSideDetectionType::kClipboardCopyApi:
      return "kClipboardCopyApi";
    case ClientSideDetectionType::kCreditCardForm:
      return "kCreditCardForm";
    default:
      return nullptr;
  }
}

std::string ClientSideDetectionTypeToString(ClientSideDetectionType value) {
  const char *str = ClientSideDetectionTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ClientSideDetectionType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ClientSideDetectionType value) {
  return os << ClientSideDetectionTypeToString(value);
}

NOINLINE static const char* PhishingImageEmbeddingResultToStringHelper(PhishingImageEmbeddingResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PhishingImageEmbeddingResult::kSuccess:
      return "kSuccess";
    case PhishingImageEmbeddingResult::kImageEmbedderNotReady:
      return "kImageEmbedderNotReady";
    case PhishingImageEmbeddingResult::kCancelled:
      return "kCancelled";
    case PhishingImageEmbeddingResult::kForwardBackTransition:
      return "kForwardBackTransition";
    case PhishingImageEmbeddingResult::kFailed:
      return "kFailed";
    default:
      return nullptr;
  }
}

std::string PhishingImageEmbeddingResultToString(PhishingImageEmbeddingResult value) {
  const char *str = PhishingImageEmbeddingResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PhishingImageEmbeddingResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PhishingImageEmbeddingResult value) {
  return os << PhishingImageEmbeddingResultToString(value);
}

NOINLINE static const char* WebRequestProtocolTypeToStringHelper(WebRequestProtocolType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebRequestProtocolType::kHttpHttps:
      return "kHttpHttps";
    case WebRequestProtocolType::kWebSocket:
      return "kWebSocket";
    default:
      return nullptr;
  }
}

std::string WebRequestProtocolTypeToString(WebRequestProtocolType value) {
  const char *str = WebRequestProtocolTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebRequestProtocolType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebRequestProtocolType value) {
  return os << WebRequestProtocolTypeToString(value);
}

NOINLINE static const char* WebRequestContactInitiatorTypeToStringHelper(WebRequestContactInitiatorType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebRequestContactInitiatorType::kExtension:
      return "kExtension";
    case WebRequestContactInitiatorType::kContentScript:
      return "kContentScript";
    default:
      return nullptr;
  }
}

std::string WebRequestContactInitiatorTypeToString(WebRequestContactInitiatorType value) {
  const char *str = WebRequestContactInitiatorTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebRequestContactInitiatorType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebRequestContactInitiatorType value) {
  return os << WebRequestContactInitiatorTypeToString(value);
}

namespace internal {


// static
bool AttributeNameValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AttributeNameValue_Data* object =
      static_cast<const AttributeNameValue_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  return true;
}

AttributeNameValue_Data::AttributeNameValue_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ThreatDOMDetailsNode_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 88, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ThreatDOMDetailsNode_Data* object =
      static_cast<const ThreatDOMDetailsNode_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tag_name, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tag_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tag_name, validation_context,
                                         &tag_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parent, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->parent, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->children, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& children_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->children, validation_context,
                                         &children_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->child_node_ids, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& child_node_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->child_node_ids, validation_context,
                                         &child_node_ids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->attributes, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& attributes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->attributes, validation_context,
                                         &attributes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnion(object->child_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->inner_html, 10, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& inner_html_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->inner_html, validation_context,
                                         &inner_html_validate_params)) {
    return false;
  }

  return true;
}

ThreatDOMDetailsNode_Data::ThreatDOMDetailsNode_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SafeBrowsing_CreateCheckerAndCheck_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SafeBrowsing_CreateCheckerAndCheck_Params_Data* object =
      static_cast<const SafeBrowsing_CreateCheckerAndCheck_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& method_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->method, validation_context,
                                         &method_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->headers, validation_context))
    return false;

  return true;
}

SafeBrowsing_CreateCheckerAndCheck_Params_Data::SafeBrowsing_CreateCheckerAndCheck_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SafeBrowsing_CreateCheckerAndCheck_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SafeBrowsing_CreateCheckerAndCheck_ResponseParams_Data* object =
      static_cast<const SafeBrowsing_CreateCheckerAndCheck_ResponseParams_Data*>(data);

  return true;
}

SafeBrowsing_CreateCheckerAndCheck_ResponseParams_Data::SafeBrowsing_CreateCheckerAndCheck_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SafeBrowsing_Clone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SafeBrowsing_Clone_Params_Data* object =
      static_cast<const SafeBrowsing_Clone_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SafeBrowsing_Clone_Params_Data::SafeBrowsing_Clone_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ThreatReporter_GetThreatDOMDetails_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ThreatReporter_GetThreatDOMDetails_Params_Data* object =
      static_cast<const ThreatReporter_GetThreatDOMDetails_Params_Data*>(data);

  return true;
}

ThreatReporter_GetThreatDOMDetails_Params_Data::ThreatReporter_GetThreatDOMDetails_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ThreatReporter_GetThreatDOMDetails_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ThreatReporter_GetThreatDOMDetails_ResponseParams_Data* object =
      static_cast<const ThreatReporter_GetThreatDOMDetails_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->nodes, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& nodes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->nodes, validation_context,
                                         &nodes_validate_params)) {
    return false;
  }

  return true;
}

ThreatReporter_GetThreatDOMDetails_ResponseParams_Data::ThreatReporter_GetThreatDOMDetails_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PhishingDetector_StartPhishingDetection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PhishingDetector_StartPhishingDetection_Params_Data* object =
      static_cast<const PhishingDetector_StartPhishingDetection_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;


  if (!::safe_browsing::mojom::internal::ClientSideDetectionType_Data
        ::Validate(object->request_type, validation_context))
    return false;

  return true;
}

PhishingDetector_StartPhishingDetection_Params_Data::PhishingDetector_StartPhishingDetection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PhishingDetector_StartPhishingDetection_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PhishingDetector_StartPhishingDetection_ResponseParams_Data* object =
      static_cast<const PhishingDetector_StartPhishingDetection_ResponseParams_Data*>(data);


  if (!::safe_browsing::mojom::internal::PhishingDetectorResult_Data
        ::Validate(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  return true;
}

PhishingDetector_StartPhishingDetection_ResponseParams_Data::PhishingDetector_StartPhishingDetection_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PhishingModelSetter_SetImageEmbeddingAndPhishingFlatBufferModel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PhishingModelSetter_SetImageEmbeddingAndPhishingFlatBufferModel_Params_Data* object =
      static_cast<const PhishingModelSetter_SetImageEmbeddingAndPhishingFlatBufferModel_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->region, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->region, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->tflite_model, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->image_embedding_model, validation_context))
    return false;

  return true;
}

PhishingModelSetter_SetImageEmbeddingAndPhishingFlatBufferModel_Params_Data::PhishingModelSetter_SetImageEmbeddingAndPhishingFlatBufferModel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PhishingModelSetter_AttachImageEmbeddingModel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PhishingModelSetter_AttachImageEmbeddingModel_Params_Data* object =
      static_cast<const PhishingModelSetter_AttachImageEmbeddingModel_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->image_embedding_model, validation_context))
    return false;

  return true;
}

PhishingModelSetter_AttachImageEmbeddingModel_Params_Data::PhishingModelSetter_AttachImageEmbeddingModel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PhishingModelSetter_SetPhishingFlatBufferModel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PhishingModelSetter_SetPhishingFlatBufferModel_Params_Data* object =
      static_cast<const PhishingModelSetter_SetPhishingFlatBufferModel_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->region, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->region, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->tflite_model, validation_context))
    return false;

  return true;
}

PhishingModelSetter_SetPhishingFlatBufferModel_Params_Data::PhishingModelSetter_SetPhishingFlatBufferModel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PhishingModelSetter_ClearScorer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PhishingModelSetter_ClearScorer_Params_Data* object =
      static_cast<const PhishingModelSetter_ClearScorer_Params_Data*>(data);

  return true;
}

PhishingModelSetter_ClearScorer_Params_Data::PhishingModelSetter_ClearScorer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PhishingModelSetter_SetTestObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PhishingModelSetter_SetTestObserver_Params_Data* object =
      static_cast<const PhishingModelSetter_SetTestObserver_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PhishingModelSetter_SetTestObserver_Params_Data::PhishingModelSetter_SetTestObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PhishingModelSetter_SetTestObserver_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PhishingModelSetter_SetTestObserver_ResponseParams_Data* object =
      static_cast<const PhishingModelSetter_SetTestObserver_ResponseParams_Data*>(data);

  return true;
}

PhishingModelSetter_SetTestObserver_ResponseParams_Data::PhishingModelSetter_SetTestObserver_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PhishingModelSetterTestObserver_PhishingModelUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PhishingModelSetterTestObserver_PhishingModelUpdated_Params_Data* object =
      static_cast<const PhishingModelSetterTestObserver_PhishingModelUpdated_Params_Data*>(data);

  return true;
}

PhishingModelSetterTestObserver_PhishingModelUpdated_Params_Data::PhishingModelSetterTestObserver_PhishingModelUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PhishingImageEmbedderDetector_StartImageEmbedding_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PhishingImageEmbedderDetector_StartImageEmbedding_Params_Data* object =
      static_cast<const PhishingImageEmbedderDetector_StartImageEmbedding_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

PhishingImageEmbedderDetector_StartImageEmbedding_Params_Data::PhishingImageEmbedderDetector_StartImageEmbedding_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PhishingImageEmbedderDetector_StartImageEmbedding_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PhishingImageEmbedderDetector_StartImageEmbedding_ResponseParams_Data* object =
      static_cast<const PhishingImageEmbedderDetector_StartImageEmbedding_ResponseParams_Data*>(data);


  if (!::safe_browsing::mojom::internal::PhishingImageEmbeddingResult_Data
        ::Validate(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->image_embedding_request, validation_context))
    return false;

  return true;
}

PhishingImageEmbedderDetector_StartImageEmbedding_ResponseParams_Data::PhishingImageEmbedderDetector_StartImageEmbedding_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ExtensionWebRequestReporter_SendWebRequestData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ExtensionWebRequestReporter_SendWebRequestData_Params_Data* object =
      static_cast<const ExtensionWebRequestReporter_SendWebRequestData_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin_extension_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& origin_extension_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->origin_extension_id, validation_context,
                                         &origin_extension_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->telemetry_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->telemetry_url, validation_context))
    return false;


  if (!::safe_browsing::mojom::internal::WebRequestProtocolType_Data
        ::Validate(object->protocol_type, validation_context))
    return false;


  if (!::safe_browsing::mojom::internal::WebRequestContactInitiatorType_Data
        ::Validate(object->contact_initiator_type, validation_context))
    return false;

  return true;
}

ExtensionWebRequestReporter_SendWebRequestData_Params_Data::ExtensionWebRequestReporter_SendWebRequestData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ExtensionWebRequestReporter_Clone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ExtensionWebRequestReporter_Clone_Params_Data* object =
      static_cast<const ExtensionWebRequestReporter_Clone_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ExtensionWebRequestReporter_Clone_Params_Data::ExtensionWebRequestReporter_Clone_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace safe_browsing

namespace perfetto {

// static
void TraceFormatTraits<::safe_browsing::mojom::PhishingDetectorResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::safe_browsing::mojom::PhishingDetectorResult value) {
  return std::move(context).WriteString(::safe_browsing::mojom::PhishingDetectorResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::safe_browsing::mojom::ClientSideDetectionType>::WriteIntoTrace(
   perfetto::TracedValue context, ::safe_browsing::mojom::ClientSideDetectionType value) {
  return std::move(context).WriteString(::safe_browsing::mojom::ClientSideDetectionTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::safe_browsing::mojom::PhishingImageEmbeddingResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::safe_browsing::mojom::PhishingImageEmbeddingResult value) {
  return std::move(context).WriteString(::safe_browsing::mojom::PhishingImageEmbeddingResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::safe_browsing::mojom::WebRequestProtocolType>::WriteIntoTrace(
   perfetto::TracedValue context, ::safe_browsing::mojom::WebRequestProtocolType value) {
  return std::move(context).WriteString(::safe_browsing::mojom::WebRequestProtocolTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::safe_browsing::mojom::WebRequestContactInitiatorType>::WriteIntoTrace(
   perfetto::TracedValue context, ::safe_browsing::mojom::WebRequestContactInitiatorType value) {
  return std::move(context).WriteString(::safe_browsing::mojom::WebRequestContactInitiatorTypeToString(value));
}

} // namespace perfetto