// components/remote_cocoa/common/native_widget_ns_window.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_REMOTE_COCOA_COMMON_NATIVE_WIDGET_NS_WINDOW_MOJOM_DATA_VIEW_H_
#define COMPONENTS_REMOTE_COCOA_COMMON_NATIVE_WIDGET_NS_WINDOW_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/remote_cocoa/common/native_widget_ns_window.mojom-shared-internal.h"
#include "components/remote_cocoa/common/select_file_dialog.mojom-shared.h"
#include "components/remote_cocoa/common/menu.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "ui/base/cursor/mojom/cursor.mojom-shared.h"
#include "ui/base/mojom/color_mode.mojom-shared.h"
#include "ui/base/mojom/ui_base_types.mojom-shared.h"
#include "ui/events/mojom/event_constants.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/ca_layer_params.mojom-shared.h"


namespace remote_cocoa::mojom {
class CreateWindowParamsDataView;

class NativeWidgetNSWindowInitParamsDataView;



}  // remote_cocoa::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::remote_cocoa::mojom::CreateWindowParamsDataView> {
  using Data = ::remote_cocoa::mojom::internal::CreateWindowParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::remote_cocoa::mojom::NativeWidgetNSWindowInitParamsDataView> {
  using Data = ::remote_cocoa::mojom::internal::NativeWidgetNSWindowInitParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace remote_cocoa::mojom {


enum class WindowClass : int32_t {
  
  kDefault = 0,
  
  kBrowser = 1,
  
  kFrameless = 2,
  
  kOverlay = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, WindowClass value);
inline bool IsKnownEnumValue(WindowClass value) {
  return internal::WindowClass_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WindowVisibilityState : int32_t {
  
  kHideWindow = 0,
  
  kShowAndActivateWindow = 1,
  
  kShowInactive = 2,
  
  kMiniaturizeWindow = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, WindowVisibilityState value);
inline bool IsKnownEnumValue(WindowVisibilityState value) {
  return internal::WindowVisibilityState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class VisibilityTransition : int32_t {
  
  kShow = 1,
  
  kHide = 2,
  
  kBoth = 3,
  
  kNone = 4,
  kMinValue = 1,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, VisibilityTransition value);
inline bool IsKnownEnumValue(VisibilityTransition value) {
  return internal::VisibilityTransition_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ToolbarVisibilityStyle : int32_t {
  
  kNone = 0,
  
  kAlways = 1,
  
  kAutohide = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, ToolbarVisibilityStyle value);
inline bool IsKnownEnumValue(ToolbarVisibilityStyle value) {
  return internal::ToolbarVisibilityStyle_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class NativeWidgetNSWindowInterfaceBase {};

using NativeWidgetNSWindowPtrDataView =
    mojo::InterfacePtrDataView<NativeWidgetNSWindowInterfaceBase>;
using NativeWidgetNSWindowRequestDataView =
    mojo::InterfaceRequestDataView<NativeWidgetNSWindowInterfaceBase>;
using NativeWidgetNSWindowAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<NativeWidgetNSWindowInterfaceBase>;
using NativeWidgetNSWindowAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<NativeWidgetNSWindowInterfaceBase>;


class CreateWindowParamsDataView {
 public:
  CreateWindowParamsDataView() = default;

  CreateWindowParamsDataView(
      internal::CreateWindowParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadWindowClass(UserType* output) const {
    auto data_value = data_->window_class;
    return mojo::internal::Deserialize<::remote_cocoa::mojom::WindowClass>(
        data_value, output);
  }
  WindowClass window_class() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::remote_cocoa::mojom::WindowClass>(data_->window_class));
  }
  uint64_t style_mask() const {
    return data_->style_mask;
  }
  bool titlebar_appears_transparent() const {
    return data_->titlebar_appears_transparent;
  }
  bool window_title_hidden() const {
    return data_->window_title_hidden;
  }
  bool animation_enabled() const {
    return data_->animation_enabled;
  }
 private:
  internal::CreateWindowParams_Data* data_ = nullptr;
};


class NativeWidgetNSWindowInitParamsDataView {
 public:
  NativeWidgetNSWindowInitParamsDataView() = default;

  NativeWidgetNSWindowInitParamsDataView(
      internal::NativeWidgetNSWindowInitParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadModalType(UserType* output) const {
    auto data_value = data_->modal_type;
    return mojo::internal::Deserialize<::ui::mojom::ModalType>(
        data_value, output);
  }
  ::ui::mojom::ModalType modal_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::ModalType>(data_->modal_type));
  }
  bool is_translucent() const {
    return data_->is_translucent;
  }
  bool has_window_server_shadow() const {
    return data_->has_window_server_shadow;
  }
  bool force_into_collection_cycle() const {
    return data_->force_into_collection_cycle;
  }
  inline void GetStateRestorationDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStateRestorationData(UserType* output) {
    
    auto* pointer = data_->state_restoration_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  bool is_tooltip() const {
    return data_->is_tooltip;
  }
 private:
  internal::NativeWidgetNSWindowInitParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // remote_cocoa::mojom

#endif  // COMPONENTS_REMOTE_COCOA_COMMON_NATIVE_WIDGET_NS_WINDOW_MOJOM_DATA_VIEW_H_