// components/remote_cocoa/common/menu.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_REMOTE_COCOA_COMMON_MENU_MOJOM_SHARED_INTERNAL_H_
#define COMPONENTS_REMOTE_COCOA_COMMON_MENU_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "components/remote_cocoa/common/font.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared-internal.h"
#include "skia/public/mojom/skcolor.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared-internal.h"
#include "ui/gfx/image/mojom/image.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace remote_cocoa::mojom {
namespace internal {
class MenuItemCommonFields_Data;
class SubmenuMenuItem_Data;
class MenuControllerParams_Data;
class ContextMenu_Data;
class MenuItem_Data;

#pragma pack(push, 1)


class  MenuItem_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  MenuItem_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~MenuItem_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<MenuItem_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class MenuItem_Tag : uint32_t {

    
    kSeparator,
    
    kRegular,
    
    kSubmenu,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::MenuItemCommonFields_Data> f_separator;
    mojo::internal::Pointer<internal::MenuItemCommonFields_Data> f_regular;
    mojo::internal::Pointer<internal::SubmenuMenuItem_Data> f_submenu;
    uint64_t unknown;
  };

  uint32_t size;
  MenuItem_Tag tag;
  Union_ data;
};
static_assert(sizeof(MenuItem_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(MenuItem_Data)");
class  MenuItemCommonFields_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t command_id;
  uint8_t may_have_mnemonics : 1;
  uint8_t is_checked : 1;
  uint8_t is_enabled : 1;
  uint8_t is_visible : 1;
  uint8_t is_alerted : 1;
  uint8_t is_new_feature : 1;
  uint8_t pad6_[3];
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> label;
  mojo::internal::Pointer<::gfx::mojom::internal::ImageSkia_Data> icon;

 private:
  friend class mojo::internal::MessageFragment<MenuItemCommonFields_Data>;

  MenuItemCommonFields_Data();
  ~MenuItemCommonFields_Data() = delete;
};
static_assert(sizeof(MenuItemCommonFields_Data) == 32,
              "Bad sizeof(MenuItemCommonFields_Data)");
// Used by MenuItemCommonFields::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct MenuItemCommonFields_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  MenuItemCommonFields_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~MenuItemCommonFields_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<MenuItemCommonFields_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    MenuItemCommonFields_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  SubmenuMenuItem_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::MenuItemCommonFields_Data> common;
  mojo::internal::Pointer<mojo::internal::Array_Data<internal::MenuItem_Data>> children;

 private:
  friend class mojo::internal::MessageFragment<SubmenuMenuItem_Data>;

  SubmenuMenuItem_Data();
  ~SubmenuMenuItem_Data() = delete;
};
static_assert(sizeof(SubmenuMenuItem_Data) == 24,
              "Bad sizeof(SubmenuMenuItem_Data)");
// Used by SubmenuMenuItem::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SubmenuMenuItem_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SubmenuMenuItem_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SubmenuMenuItem_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SubmenuMenuItem_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SubmenuMenuItem_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  MenuControllerParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::remote_cocoa::mojom::internal::Font_Data> badge_font;
  mojo::internal::Pointer<::skia::mojom::internal::SkColor_Data> badge_color;
  mojo::internal::Pointer<::skia::mojom::internal::SkColor_Data> badge_text_color;
  uint32_t badge_horizontal_margin;
  uint32_t badge_internal_padding;
  uint32_t badge_min_height;
  uint32_t badge_radius;
  mojo::internal::Pointer<::skia::mojom::internal::SkColor_Data> iph_dot_color;

 private:
  friend class mojo::internal::MessageFragment<MenuControllerParams_Data>;

  MenuControllerParams_Data();
  ~MenuControllerParams_Data() = delete;
};
static_assert(sizeof(MenuControllerParams_Data) == 56,
              "Bad sizeof(MenuControllerParams_Data)");
// Used by MenuControllerParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct MenuControllerParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  MenuControllerParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~MenuControllerParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<MenuControllerParams_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    MenuControllerParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ContextMenu_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<internal::MenuItem_Data>> items;
  mojo::internal::Pointer<::gfx::mojom::internal::Point_Data> anchor;
  uint64_t target_view_id;
  mojo::internal::Pointer<internal::MenuControllerParams_Data> params;

 private:
  friend class mojo::internal::MessageFragment<ContextMenu_Data>;

  ContextMenu_Data();
  ~ContextMenu_Data() = delete;
};
static_assert(sizeof(ContextMenu_Data) == 40,
              "Bad sizeof(ContextMenu_Data)");
// Used by ContextMenu::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ContextMenu_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ContextMenu_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ContextMenu_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ContextMenu_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ContextMenu_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // remote_cocoa::mojom

#endif  // COMPONENTS_REMOTE_COCOA_COMMON_MENU_MOJOM_SHARED_INTERNAL_H_