// components/remote_cocoa/common/menu.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_REMOTE_COCOA_COMMON_MENU_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_REMOTE_COCOA_COMMON_MENU_MOJOM_SEND_VALIDATION_H_

#include "components/remote_cocoa/common/menu.mojom-shared-internal.h"
#include "components/remote_cocoa/common/font.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/image/mojom/image.mojom-shared.h"

#include "components/remote_cocoa/common/menu.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::remote_cocoa::mojom::MenuItemCommonFieldsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::remote_cocoa::mojom::MenuItemCommonFieldsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::remote_cocoa::mojom::internal::MenuItemCommonFields_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->command_id = Traits::command_id(input);

      decltype(Traits::label(input)) in_label = Traits::label(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->label)::BaseType> label_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_label,
        label_fragment);

      fragment->label.Set(
          label_fragment.is_null() ? nullptr : label_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->label.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null label in MenuItemCommonFields struct");

      fragment->may_have_mnemonics = Traits::may_have_mnemonics(input);

      fragment->is_checked = Traits::is_checked(input);

      decltype(Traits::icon(input)) in_icon = Traits::icon(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->icon)::BaseType> icon_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::ImageSkiaDataView, send_validation>(
        in_icon,
        icon_fragment);

      fragment->icon.Set(
          icon_fragment.is_null() ? nullptr : icon_fragment.data());

      fragment->is_enabled = Traits::is_enabled(input);

      fragment->is_visible = Traits::is_visible(input);

      fragment->is_alerted = Traits::is_alerted(input);

      fragment->is_new_feature = Traits::is_new_feature(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::remote_cocoa::mojom::SubmenuMenuItemDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::remote_cocoa::mojom::SubmenuMenuItemDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::remote_cocoa::mojom::internal::SubmenuMenuItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::common(input)) in_common = Traits::common(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->common)::BaseType> common_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::remote_cocoa::mojom::MenuItemCommonFieldsDataView, send_validation>(
        in_common,
        common_fragment);

      fragment->common.Set(
          common_fragment.is_null() ? nullptr : common_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->common.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null common in SubmenuMenuItem struct");

      decltype(Traits::children(input)) in_children = Traits::children(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->children)::BaseType>
          children_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& children_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::remote_cocoa::mojom::MenuItemDataView>, send_validation>(
        in_children,
        children_fragment,
        &children_validate_params);

      fragment->children.Set(
          children_fragment.is_null() ? nullptr : children_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->children.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null children in SubmenuMenuItem struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::remote_cocoa::mojom::MenuControllerParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::remote_cocoa::mojom::MenuControllerParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::remote_cocoa::mojom::internal::MenuControllerParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::badge_font(input)) in_badge_font = Traits::badge_font(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->badge_font)::BaseType> badge_font_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::remote_cocoa::mojom::FontDataView, send_validation>(
        in_badge_font,
        badge_font_fragment);

      fragment->badge_font.Set(
          badge_font_fragment.is_null() ? nullptr : badge_font_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->badge_font.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null badge_font in MenuControllerParams struct");

      decltype(Traits::badge_color(input)) in_badge_color = Traits::badge_color(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->badge_color)::BaseType> badge_color_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::skia::mojom::SkColorDataView, send_validation>(
        in_badge_color,
        badge_color_fragment);

      fragment->badge_color.Set(
          badge_color_fragment.is_null() ? nullptr : badge_color_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->badge_color.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null badge_color in MenuControllerParams struct");

      decltype(Traits::badge_text_color(input)) in_badge_text_color = Traits::badge_text_color(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->badge_text_color)::BaseType> badge_text_color_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::skia::mojom::SkColorDataView, send_validation>(
        in_badge_text_color,
        badge_text_color_fragment);

      fragment->badge_text_color.Set(
          badge_text_color_fragment.is_null() ? nullptr : badge_text_color_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->badge_text_color.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null badge_text_color in MenuControllerParams struct");

      fragment->badge_horizontal_margin = Traits::badge_horizontal_margin(input);

      fragment->badge_internal_padding = Traits::badge_internal_padding(input);

      fragment->badge_min_height = Traits::badge_min_height(input);

      fragment->badge_radius = Traits::badge_radius(input);

      decltype(Traits::iph_dot_color(input)) in_iph_dot_color = Traits::iph_dot_color(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->iph_dot_color)::BaseType> iph_dot_color_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::skia::mojom::SkColorDataView, send_validation>(
        in_iph_dot_color,
        iph_dot_color_fragment);

      fragment->iph_dot_color.Set(
          iph_dot_color_fragment.is_null() ? nullptr : iph_dot_color_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->iph_dot_color.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null iph_dot_color in MenuControllerParams struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::remote_cocoa::mojom::ContextMenuDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::remote_cocoa::mojom::ContextMenuDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::remote_cocoa::mojom::internal::ContextMenu_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::items(input)) in_items = Traits::items(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->items)::BaseType>
          items_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& items_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::remote_cocoa::mojom::MenuItemDataView>, send_validation>(
        in_items,
        items_fragment,
        &items_validate_params);

      fragment->items.Set(
          items_fragment.is_null() ? nullptr : items_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->items.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null items in ContextMenu struct");

      decltype(Traits::anchor(input)) in_anchor = Traits::anchor(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->anchor)::BaseType> anchor_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointDataView, send_validation>(
        in_anchor,
        anchor_fragment);

      fragment->anchor.Set(
          anchor_fragment.is_null() ? nullptr : anchor_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->anchor.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null anchor in ContextMenu struct");

      fragment->target_view_id = Traits::target_view_id(input);

      decltype(Traits::params(input)) in_params = Traits::params(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->params)::BaseType> params_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::remote_cocoa::mojom::MenuControllerParamsDataView, send_validation>(
        in_params,
        params_fragment);

      fragment->params.Set(
          params_fragment.is_null() ? nullptr : params_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->params.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null params in ContextMenu struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::remote_cocoa::mojom::MenuItemDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::remote_cocoa::mojom::MenuItemDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::remote_cocoa::mojom::internal::MenuItem_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::remote_cocoa::mojom::MenuItemDataView::Tag::kSeparator: {
    decltype(Traits::separator(input))
    in_separator = Traits::separator(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_separator)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::remote_cocoa::mojom::MenuItemCommonFieldsDataView, send_validation>(
  in_separator,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null separator in MenuItem union");
    fragment->data.f_separator.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::remote_cocoa::mojom::MenuItemDataView::Tag::kRegular: {
    decltype(Traits::regular(input))
    in_regular = Traits::regular(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_regular)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::remote_cocoa::mojom::MenuItemCommonFieldsDataView, send_validation>(
  in_regular,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null regular in MenuItem union");
    fragment->data.f_regular.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::remote_cocoa::mojom::MenuItemDataView::Tag::kSubmenu: {
    decltype(Traits::submenu(input))
    in_submenu = Traits::submenu(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_submenu)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::remote_cocoa::mojom::SubmenuMenuItemDataView, send_validation>(
  in_submenu,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null submenu in MenuItem union");
    fragment->data.f_submenu.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_REMOTE_COCOA_COMMON_MENU_MOJOM_SEND_VALIDATION_H_