import '/strings.m.js';
import { CustomElement } from 'chrome://resources/js/custom_element.js';
export interface Status {
    policyDescriptionKey: string;
    flexOrgWarning: any;
    assetId?: string;
    location?: string;
    directoryApiId?: string;
    clientId: string;
    isOffHoursActive?: boolean;
    deviceId: string;
    enrollmentToken: string;
    domain: string;
    machine?: string;
    version?: string;
    username: string;
    gaiaId: string;
    profileId: string;
    status: string;
    refreshInterval: string;
    timeSinceLastRefresh: string;
    timeSinceLastFetchAttempt: string;
    enterpriseDomainManager: string;
    isAffiliated: boolean;
    lastCloudReportSentTimestamp: string;
    timeSinceLastCloudReportSent: string;
    policiesPushAvailable: boolean;
    error: boolean;
}
export declare class StatusBoxElement extends CustomElement {
    static get template(): string | TrustedHTML;
    /**
     * Sets the text of a particular named label element in the status box
     * and updates the visibility if needed.
     */
    private setLabelAndShow;
    /**
     * Sets the text of a particular named label element in the status box
     * and updates the visibility if needed.
     */
    private setLabelInnerHtmlAndShow;
    /**
     * Populate the box with the given cloud policy status. The policy scope,
     * either "device", "machine", "user", or "updater".
     */
    initialize(scope: string, status: Status): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'status-box': StatusBoxElement;
    }
}
