// components/persistent_cache/mojom/persistent_cache.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PERSISTENT_CACHE_MOJOM_PERSISTENT_CACHE_MOJOM_SHARED_H_
#define COMPONENTS_PERSISTENT_CACHE_MOJOM_PERSISTENT_CACHE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/persistent_cache/mojom/persistent_cache.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/persistent_cache/mojom/persistent_cache.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::persistent_cache::mojom::ReadWriteBackendParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::persistent_cache::mojom::ReadWriteBackendParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::persistent_cache::mojom::internal::ReadWriteBackendParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::db_file(input)) in_db_file = Traits::db_file(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->db_file)::BaseType> db_file_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
      in_db_file,
      db_file_fragment);

    fragment->db_file.Set(
        db_file_fragment.is_null() ? nullptr : db_file_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->db_file.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null db_file in ReadWriteBackendParams struct");

    decltype(Traits::journal_file(input)) in_journal_file = Traits::journal_file(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->journal_file)::BaseType> journal_file_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
      in_journal_file,
      journal_file_fragment);

    fragment->journal_file.Set(
        journal_file_fragment.is_null() ? nullptr : journal_file_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->journal_file.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null journal_file in ReadWriteBackendParams struct");

    decltype(Traits::shared_lock(input)) in_shared_lock = Traits::shared_lock(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shared_lock)::BaseType> shared_lock_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
      in_shared_lock,
      shared_lock_fragment);

    fragment->shared_lock.Set(
        shared_lock_fragment.is_null() ? nullptr : shared_lock_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->shared_lock.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shared_lock in ReadWriteBackendParams struct");
  }

  static bool Deserialize(::persistent_cache::mojom::internal::ReadWriteBackendParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::persistent_cache::mojom::ReadWriteBackendParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace persistent_cache::mojom {

inline void ReadWriteBackendParamsDataView::GetDbFileDataView(
    ::mojo_base::mojom::FileDataView* output) {
  auto pointer = data_->db_file.Get();
  *output = ::mojo_base::mojom::FileDataView(pointer, message_);
}
inline void ReadWriteBackendParamsDataView::GetJournalFileDataView(
    ::mojo_base::mojom::FileDataView* output) {
  auto pointer = data_->journal_file.Get();
  *output = ::mojo_base::mojom::FileDataView(pointer, message_);
}
inline void ReadWriteBackendParamsDataView::GetSharedLockDataView(
    ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView* output) {
  auto pointer = data_->shared_lock.Get();
  *output = ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView(pointer, message_);
}



}  // persistent_cache::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // COMPONENTS_PERSISTENT_CACHE_MOJOM_PERSISTENT_CACHE_MOJOM_SHARED_H_