// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// vector_icons.cc.template is used to generate vector_icons.cc. Edit the former
// rather than the latter.

#include "components/permissions/vector_icons/vector_icons.h"

#include "components/vector_icons/cc_macros.h"
#include "ui/gfx/animation/tween.h"
#include "ui/gfx/vector_icon_types.h"

#define DECLARE_VECTOR_COMMAND(x) using gfx::x;
DECLARE_VECTOR_COMMANDS

namespace permissions {

VECTOR_ICON_REP_TEMPLATE(kAccessibilityPath, CANVAS_DIMENSIONS, 32,
MOVE_TO, 16, 11.44,
R_CUBIC_TO, -3.5, 0, -7.2, -0.62, -10.27, -1.44,
LINE_TO, 5, 12.16,
R_CUBIC_TO, 2.27, 0.77, 5.56, 1.05, 8, 1.34,
V_LINE_TO, 28,
R_H_LINE_TO, 2,
R_V_LINE_TO, -7,
R_H_LINE_TO, 2,
R_V_LINE_TO, 7,
R_H_LINE_TO, 2,
V_LINE_TO, 13.5,
R_CUBIC_TO, 2.44, -0.29, 5.73, -0.57, 8, -1.34,
LINE_TO, 26.27, 10,
R_CUBIC_TO, -3.07, 0.82, -6.77, 1.44, -10.27, 1.44,
CLOSE,
R_MOVE_TO, 0, -1.94,
R_ARC_TO, 2.5, 2.5, 0, 1, 0, 0, -5,
R_ARC_TO, 2.5, 2.5, 0, 0, 0, 0, 5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kAccessibilityRepList, kAccessibilityIcon, {kAccessibilityPath})

}  // namespace permissions
