// components/performance_manager/public/mojom/coordination_unit.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/performance_manager/public/mojom/coordination_unit.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/performance_manager/public/mojom/coordination_unit.mojom-params-data.h"
namespace performance_manager {
namespace mojom {

NOINLINE static const char* CoordinationUnitTypeToStringHelper(CoordinationUnitType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CoordinationUnitType::kFrame:
      return "kFrame";
    case CoordinationUnitType::kPage:
      return "kPage";
    case CoordinationUnitType::kProcess:
      return "kProcess";
    case CoordinationUnitType::kSystem:
      return "kSystem";
    default:
      return nullptr;
  }
}

std::string CoordinationUnitTypeToString(CoordinationUnitType value) {
  const char *str = CoordinationUnitTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CoordinationUnitType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CoordinationUnitType value) {
  return os << CoordinationUnitTypeToString(value);
}

namespace internal {


// static
bool DocumentCoordinationUnit_SetNetworkAlmostIdle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DocumentCoordinationUnit_SetNetworkAlmostIdle_Params_Data* object =
      static_cast<const DocumentCoordinationUnit_SetNetworkAlmostIdle_Params_Data*>(data);

  return true;
}

DocumentCoordinationUnit_SetNetworkAlmostIdle_Params_Data::DocumentCoordinationUnit_SetNetworkAlmostIdle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DocumentCoordinationUnit_SetLifecycleState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DocumentCoordinationUnit_SetLifecycleState_Params_Data* object =
      static_cast<const DocumentCoordinationUnit_SetLifecycleState_Params_Data*>(data);


  if (!::performance_manager::mojom::internal::LifecycleState_Data
        ::Validate(object->state, validation_context))
    return false;

  return true;
}

DocumentCoordinationUnit_SetLifecycleState_Params_Data::DocumentCoordinationUnit_SetLifecycleState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Params_Data* object =
      static_cast<const DocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Params_Data*>(data);

  return true;
}

DocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Params_Data::DocumentCoordinationUnit_SetHasNonEmptyBeforeUnload_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DocumentCoordinationUnit_SetHadFormInteraction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DocumentCoordinationUnit_SetHadFormInteraction_Params_Data* object =
      static_cast<const DocumentCoordinationUnit_SetHadFormInteraction_Params_Data*>(data);

  return true;
}

DocumentCoordinationUnit_SetHadFormInteraction_Params_Data::DocumentCoordinationUnit_SetHadFormInteraction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DocumentCoordinationUnit_SetHadUserEdits_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DocumentCoordinationUnit_SetHadUserEdits_Params_Data* object =
      static_cast<const DocumentCoordinationUnit_SetHadUserEdits_Params_Data*>(data);

  return true;
}

DocumentCoordinationUnit_SetHadUserEdits_Params_Data::DocumentCoordinationUnit_SetHadUserEdits_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DocumentCoordinationUnit_OnStartedUsingWebRTC_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DocumentCoordinationUnit_OnStartedUsingWebRTC_Params_Data* object =
      static_cast<const DocumentCoordinationUnit_OnStartedUsingWebRTC_Params_Data*>(data);

  return true;
}

DocumentCoordinationUnit_OnStartedUsingWebRTC_Params_Data::DocumentCoordinationUnit_OnStartedUsingWebRTC_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DocumentCoordinationUnit_OnStoppedUsingWebRTC_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DocumentCoordinationUnit_OnStoppedUsingWebRTC_Params_Data* object =
      static_cast<const DocumentCoordinationUnit_OnStoppedUsingWebRTC_Params_Data*>(data);

  return true;
}

DocumentCoordinationUnit_OnStoppedUsingWebRTC_Params_Data::DocumentCoordinationUnit_OnStoppedUsingWebRTC_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DocumentCoordinationUnit_SetIsAdFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DocumentCoordinationUnit_SetIsAdFrame_Params_Data* object =
      static_cast<const DocumentCoordinationUnit_SetIsAdFrame_Params_Data*>(data);

  return true;
}

DocumentCoordinationUnit_SetIsAdFrame_Params_Data::DocumentCoordinationUnit_SetIsAdFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DocumentCoordinationUnit_OnNonPersistentNotificationCreated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DocumentCoordinationUnit_OnNonPersistentNotificationCreated_Params_Data* object =
      static_cast<const DocumentCoordinationUnit_OnNonPersistentNotificationCreated_Params_Data*>(data);

  return true;
}

DocumentCoordinationUnit_OnNonPersistentNotificationCreated_Params_Data::DocumentCoordinationUnit_OnNonPersistentNotificationCreated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DocumentCoordinationUnit_OnFirstContentfulPaint_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DocumentCoordinationUnit_OnFirstContentfulPaint_Params_Data* object =
      static_cast<const DocumentCoordinationUnit_OnFirstContentfulPaint_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time_since_navigation_start, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time_since_navigation_start, validation_context))
    return false;

  return true;
}

DocumentCoordinationUnit_OnFirstContentfulPaint_Params_Data::DocumentCoordinationUnit_OnFirstContentfulPaint_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_Params_Data* object =
      static_cast<const DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_Params_Data*>(data);


  if (!::performance_manager::mojom::internal::WebMemoryMeasurement_Mode_Data
        ::Validate(object->mode, validation_context))
    return false;

  return true;
}

DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_Params_Data::DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ResponseParams_Data* object =
      static_cast<const DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->measurement, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->measurement, validation_context))
    return false;

  return true;
}

DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ResponseParams_Data::DocumentCoordinationUnit_OnWebMemoryMeasurementRequested_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DocumentCoordinationUnit_OnFreezingOriginTrialOptOut_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DocumentCoordinationUnit_OnFreezingOriginTrialOptOut_Params_Data* object =
      static_cast<const DocumentCoordinationUnit_OnFreezingOriginTrialOptOut_Params_Data*>(data);

  return true;
}

DocumentCoordinationUnit_OnFreezingOriginTrialOptOut_Params_Data::DocumentCoordinationUnit_OnFreezingOriginTrialOptOut_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Params_Data* object =
      static_cast<const ProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Params_Data*>(data);

  return true;
}

ProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Params_Data::ProcessCoordinationUnit_SetMainThreadTaskLoadIsLow_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProcessCoordinationUnit_OnV8ContextCreated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProcessCoordinationUnit_OnV8ContextCreated_Params_Data* object =
      static_cast<const ProcessCoordinationUnit_OnV8ContextCreated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->description, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->iframe_attribution_data, validation_context))
    return false;

  return true;
}

ProcessCoordinationUnit_OnV8ContextCreated_Params_Data::ProcessCoordinationUnit_OnV8ContextCreated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProcessCoordinationUnit_OnV8ContextDetached_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProcessCoordinationUnit_OnV8ContextDetached_Params_Data* object =
      static_cast<const ProcessCoordinationUnit_OnV8ContextDetached_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->v8_context_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->v8_context_token, validation_context))
    return false;

  return true;
}

ProcessCoordinationUnit_OnV8ContextDetached_Params_Data::ProcessCoordinationUnit_OnV8ContextDetached_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProcessCoordinationUnit_OnV8ContextDestroyed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProcessCoordinationUnit_OnV8ContextDestroyed_Params_Data* object =
      static_cast<const ProcessCoordinationUnit_OnV8ContextDestroyed_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->v8_context_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->v8_context_token, validation_context))
    return false;

  return true;
}

ProcessCoordinationUnit_OnV8ContextDestroyed_Params_Data::ProcessCoordinationUnit_OnV8ContextDestroyed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProcessCoordinationUnit_OnRemoteIframeAttached_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProcessCoordinationUnit_OnRemoteIframeAttached_Params_Data* object =
      static_cast<const ProcessCoordinationUnit_OnRemoteIframeAttached_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parent_frame_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->parent_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->remote_frame_token, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->remote_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->iframe_attribution_data, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->iframe_attribution_data, validation_context))
    return false;

  return true;
}

ProcessCoordinationUnit_OnRemoteIframeAttached_Params_Data::ProcessCoordinationUnit_OnRemoteIframeAttached_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProcessCoordinationUnit_OnRemoteIframeDetached_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProcessCoordinationUnit_OnRemoteIframeDetached_Params_Data* object =
      static_cast<const ProcessCoordinationUnit_OnRemoteIframeDetached_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parent_frame_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->parent_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->remote_frame_token, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->remote_frame_token, validation_context))
    return false;

  return true;
}

ProcessCoordinationUnit_OnRemoteIframeDetached_Params_Data::ProcessCoordinationUnit_OnRemoteIframeDetached_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChildProcessCoordinationUnit_InitializeChildProcessCoordination_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChildProcessCoordinationUnit_InitializeChildProcessCoordination_Params_Data* object =
      static_cast<const ChildProcessCoordinationUnit_InitializeChildProcessCoordination_Params_Data*>(data);

  return true;
}

ChildProcessCoordinationUnit_InitializeChildProcessCoordination_Params_Data::ChildProcessCoordinationUnit_InitializeChildProcessCoordination_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChildProcessCoordinationUnit_InitializeChildProcessCoordination_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChildProcessCoordinationUnit_InitializeChildProcessCoordination_ResponseParams_Data* object =
      static_cast<const ChildProcessCoordinationUnit_InitializeChildProcessCoordination_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->global_region, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->process_region, validation_context))
    return false;

  return true;
}

ChildProcessCoordinationUnit_InitializeChildProcessCoordination_ResponseParams_Data::ChildProcessCoordinationUnit_InitializeChildProcessCoordination_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace performance_manager

namespace perfetto {

// static
void TraceFormatTraits<::performance_manager::mojom::CoordinationUnitType>::WriteIntoTrace(
   perfetto::TracedValue context, ::performance_manager::mojom::CoordinationUnitType value) {
  return std::move(context).WriteString(::performance_manager::mojom::CoordinationUnitTypeToString(value));
}

} // namespace perfetto