// components/os_crypt/async/common/algorithm.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/os_crypt/async/common/algorithm.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/os_crypt/async/common/algorithm.mojom-params-data.h"
namespace os_crypt_async {
namespace mojom {

NOINLINE static const char* AlgorithmToStringHelper(Algorithm value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Algorithm::kAES256GCM:
      return "kAES256GCM";
    case Algorithm::kAES128CBC:
      return "kAES128CBC";
    default:
      return nullptr;
  }
}

std::string AlgorithmToString(Algorithm value) {
  const char *str = AlgorithmToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Algorithm value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Algorithm value) {
  return os << AlgorithmToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace os_crypt_async

namespace perfetto {

// static
void TraceFormatTraits<::os_crypt_async::mojom::Algorithm>::WriteIntoTrace(
   perfetto::TracedValue context, ::os_crypt_async::mojom::Algorithm value) {
  return std::move(context).WriteString(::os_crypt_async::mojom::AlgorithmToString(value));
}

} // namespace perfetto