// components/optimization_guide/public/mojom/model_broker.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_OPTIMIZATION_GUIDE_PUBLIC_MOJOM_MODEL_BROKER_MOJOM_H_
#define COMPONENTS_OPTIMIZATION_GUIDE_PUBLIC_MOJOM_MODEL_BROKER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/optimization_guide/public/mojom/model_broker.mojom-features.h"  // IWYU pragma: export
#include "components/optimization_guide/public/mojom/model_broker.mojom-shared.h"  // IWYU pragma: export
#include "components/optimization_guide/public/mojom/model_broker.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/proto_wrapper.mojom.h"
#include "services/on_device_model/public/mojom/on_device_model.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace optimization_guide::mojom {

class ModelSolutionProxy;

template <typename ImplRefTraits>
class ModelSolutionStub;

class ModelSolutionRequestValidator;


class ModelSolution
    : public ModelSolutionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "optimization_guide.mojom.ModelSolution";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ModelSolutionInterfaceBase;
  using Proxy_ = ModelSolutionProxy;

  template <typename ImplRefTraits>
  using Stub_ = ModelSolutionStub<ImplRefTraits>;

  using RequestValidator_ = ModelSolutionRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateSessionMinVersion = 0,
    kCreateTextSafetySessionMinVersion = 0,
    kReportHealthyCompletionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateTextSafetySession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReportHealthyCompletion_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ModelSolution() = default;

  virtual void CreateSession(::mojo::PendingReceiver<::on_device_model::mojom::Session> session, ::on_device_model::mojom::SessionParamsPtr params) = 0;

  virtual void CreateTextSafetySession(::mojo::PendingReceiver<::on_device_model::mojom::TextSafetySession> session) = 0;

  virtual void ReportHealthyCompletion() = 0;
};

class ModelSubscriberProxy;

template <typename ImplRefTraits>
class ModelSubscriberStub;

class ModelSubscriberRequestValidator;


class ModelSubscriber
    : public ModelSubscriberInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "optimization_guide.mojom.ModelSubscriber";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ModelSubscriberInterfaceBase;
  using Proxy_ = ModelSubscriberProxy;

  template <typename ImplRefTraits>
  using Stub_ = ModelSubscriberStub<ImplRefTraits>;

  using RequestValidator_ = ModelSubscriberRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kUnavailableMinVersion = 0,
    kAvailableMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Unavailable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Available_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ModelSubscriber() = default;

  virtual void Unavailable(ModelUnavailableReason reason) = 0;

  virtual void Available(ModelSolutionConfigPtr config, ::mojo::PendingRemote<ModelSolution> capability) = 0;
};

class ModelBrokerProxy;

template <typename ImplRefTraits>
class ModelBrokerStub;

class ModelBrokerRequestValidator;


class ModelBroker
    : public ModelBrokerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "optimization_guide.mojom.ModelBroker";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ModelBrokerInterfaceBase;
  using Proxy_ = ModelBrokerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ModelBrokerStub<ImplRefTraits>;

  using RequestValidator_ = ModelBrokerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSubscribeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Subscribe_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ModelBroker() = default;

  virtual void Subscribe(ModelSubscriptionOptionsPtr opts, ::mojo::PendingRemote<ModelSubscriber> client) = 0;
};



class  ModelSolutionProxy
    : public ModelSolution {
 public:
  using InterfaceType = ModelSolution;

  explicit ModelSolutionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateSession(::mojo::PendingReceiver<::on_device_model::mojom::Session> session, ::on_device_model::mojom::SessionParamsPtr params) final;
  
  void CreateTextSafetySession(::mojo::PendingReceiver<::on_device_model::mojom::TextSafetySession> session) final;
  
  void ReportHealthyCompletion() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ModelSubscriberProxy
    : public ModelSubscriber {
 public:
  using InterfaceType = ModelSubscriber;

  explicit ModelSubscriberProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Unavailable(ModelUnavailableReason reason) final;
  
  void Available(ModelSolutionConfigPtr config, ::mojo::PendingRemote<ModelSolution> capability) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ModelBrokerProxy
    : public ModelBroker {
 public:
  using InterfaceType = ModelBroker;

  explicit ModelBrokerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Subscribe(ModelSubscriptionOptionsPtr opts, ::mojo::PendingRemote<ModelSubscriber> client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ModelSolutionStubDispatch {
 public:
  static bool Accept(ModelSolution* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ModelSolution* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ModelSolution>>
class ModelSolutionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ModelSolutionStub() = default;
  ~ModelSolutionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ModelSolutionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ModelSolutionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ModelSubscriberStubDispatch {
 public:
  static bool Accept(ModelSubscriber* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ModelSubscriber* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ModelSubscriber>>
class ModelSubscriberStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ModelSubscriberStub() = default;
  ~ModelSubscriberStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ModelSubscriberStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ModelSubscriberStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ModelBrokerStubDispatch {
 public:
  static bool Accept(ModelBroker* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ModelBroker* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ModelBroker>>
class ModelBrokerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ModelBrokerStub() = default;
  ~ModelBrokerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ModelBrokerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ModelBrokerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ModelSolutionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ModelSubscriberRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ModelBrokerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class  ModelSubscriptionOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ModelSubscriptionOptions, T>::value>;
  using DataView = ModelSubscriptionOptionsDataView;
  using Data_ = internal::ModelSubscriptionOptions_Data;

  template <typename... Args>
  static ModelSubscriptionOptionsPtr New(Args&&... args) {
    return ModelSubscriptionOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ModelSubscriptionOptionsPtr From(const U& u) {
    return mojo::TypeConverter<ModelSubscriptionOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ModelSubscriptionOptions>::Convert(*this);
  }


  ModelSubscriptionOptions();

  ModelSubscriptionOptions(
      ModelBasedCapabilityKey id,
      bool mark_used);


  ~ModelSubscriptionOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ModelSubscriptionOptionsPtr>
  ModelSubscriptionOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ModelSubscriptionOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ModelSubscriptionOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ModelSubscriptionOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ModelSubscriptionOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ModelSubscriptionOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ModelSubscriptionOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ModelSubscriptionOptions_UnserializedMessageContext<
            UserType, ModelSubscriptionOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ModelSubscriptionOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ModelSubscriptionOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ModelSubscriptionOptions_UnserializedMessageContext<
            UserType, ModelSubscriptionOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ModelSubscriptionOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ModelBasedCapabilityKey id;
  
  bool mark_used;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ModelSubscriptionOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ModelSubscriptionOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ModelSubscriptionOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ModelSubscriptionOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  ModelSolutionConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ModelSolutionConfig, T>::value>;
  using DataView = ModelSolutionConfigDataView;
  using Data_ = internal::ModelSolutionConfig_Data;

  template <typename... Args>
  static ModelSolutionConfigPtr New(Args&&... args) {
    return ModelSolutionConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ModelSolutionConfigPtr From(const U& u) {
    return mojo::TypeConverter<ModelSolutionConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ModelSolutionConfig>::Convert(*this);
  }


  ModelSolutionConfig();

  ModelSolutionConfig(
      ::mojo_base::ProtoWrapper feature_config,
      ::mojo_base::ProtoWrapper text_safety_config,
      ::mojo_base::ProtoWrapper model_versions,
      int32_t max_tokens);

ModelSolutionConfig(const ModelSolutionConfig&) = delete;
ModelSolutionConfig& operator=(const ModelSolutionConfig&) = delete;

  ~ModelSolutionConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ModelSolutionConfigPtr>
  ModelSolutionConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ModelSolutionConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ModelSolutionConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ModelSolutionConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ModelSolutionConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ModelSolutionConfig_UnserializedMessageContext<
            UserType, ModelSolutionConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ModelSolutionConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ModelSolutionConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ModelSolutionConfig_UnserializedMessageContext<
            UserType, ModelSolutionConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ModelSolutionConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo_base::ProtoWrapper feature_config;
  
  ::mojo_base::ProtoWrapper text_safety_config;
  
  ::mojo_base::ProtoWrapper model_versions;
  
  int32_t max_tokens;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ModelSolutionConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ModelSolutionConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ModelSolutionConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ModelSolutionConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
ModelSolutionConfigPtr ModelSolutionConfig::Clone() const {
  return New(
      mojo::Clone(feature_config),
      mojo::Clone(text_safety_config),
      mojo::Clone(model_versions),
      mojo::Clone(max_tokens)
  );
}

template <typename T, ModelSolutionConfig::EnableIfSame<T>*>
bool ModelSolutionConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->feature_config, other_struct.feature_config))
    return false;
  if (!mojo::Equals(this->text_safety_config, other_struct.text_safety_config))
    return false;
  if (!mojo::Equals(this->model_versions, other_struct.model_versions))
    return false;
  if (!mojo::Equals(this->max_tokens, other_struct.max_tokens))
    return false;
  return true;
}

template <typename T, ModelSolutionConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.feature_config < rhs.feature_config)
    return true;
  if (rhs.feature_config < lhs.feature_config)
    return false;
  if (lhs.text_safety_config < rhs.text_safety_config)
    return true;
  if (rhs.text_safety_config < lhs.text_safety_config)
    return false;
  if (lhs.model_versions < rhs.model_versions)
    return true;
  if (rhs.model_versions < lhs.model_versions)
    return false;
  if (lhs.max_tokens < rhs.max_tokens)
    return true;
  if (rhs.max_tokens < lhs.max_tokens)
    return false;
  return false;
}
template <typename StructPtrType>
ModelSubscriptionOptionsPtr ModelSubscriptionOptions::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(mark_used)
  );
}

template <typename T, ModelSubscriptionOptions::EnableIfSame<T>*>
bool ModelSubscriptionOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->mark_used, other_struct.mark_used))
    return false;
  return true;
}

template <typename T, ModelSubscriptionOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.mark_used < rhs.mark_used)
    return true;
  if (rhs.mark_used < lhs.mark_used)
    return false;
  return false;
}


}  // optimization_guide::mojom

namespace mojo {


template <>
struct  StructTraits<::optimization_guide::mojom::ModelSolutionConfig::DataView,
                                         ::optimization_guide::mojom::ModelSolutionConfigPtr> {
  static bool IsNull(const ::optimization_guide::mojom::ModelSolutionConfigPtr& input) { return !input; }
  static void SetToNull(::optimization_guide::mojom::ModelSolutionConfigPtr* output) { output->reset(); }

  static  decltype(::optimization_guide::mojom::ModelSolutionConfig::feature_config)& feature_config(
       ::optimization_guide::mojom::ModelSolutionConfigPtr& input) {
    return input->feature_config;
  }

  static  decltype(::optimization_guide::mojom::ModelSolutionConfig::text_safety_config)& text_safety_config(
       ::optimization_guide::mojom::ModelSolutionConfigPtr& input) {
    return input->text_safety_config;
  }

  static  decltype(::optimization_guide::mojom::ModelSolutionConfig::model_versions)& model_versions(
       ::optimization_guide::mojom::ModelSolutionConfigPtr& input) {
    return input->model_versions;
  }

  static decltype(::optimization_guide::mojom::ModelSolutionConfig::max_tokens) max_tokens(
      const ::optimization_guide::mojom::ModelSolutionConfigPtr& input) {
    return input->max_tokens;
  }

  static bool Read(::optimization_guide::mojom::ModelSolutionConfig::DataView input, ::optimization_guide::mojom::ModelSolutionConfigPtr* output);
};


template <>
struct  StructTraits<::optimization_guide::mojom::ModelSubscriptionOptions::DataView,
                                         ::optimization_guide::mojom::ModelSubscriptionOptionsPtr> {
  static bool IsNull(const ::optimization_guide::mojom::ModelSubscriptionOptionsPtr& input) { return !input; }
  static void SetToNull(::optimization_guide::mojom::ModelSubscriptionOptionsPtr* output) { output->reset(); }

  static decltype(::optimization_guide::mojom::ModelSubscriptionOptions::id) id(
      const ::optimization_guide::mojom::ModelSubscriptionOptionsPtr& input) {
    return input->id;
  }

  static decltype(::optimization_guide::mojom::ModelSubscriptionOptions::mark_used) mark_used(
      const ::optimization_guide::mojom::ModelSubscriptionOptionsPtr& input) {
    return input->mark_used;
  }

  static bool Read(::optimization_guide::mojom::ModelSubscriptionOptions::DataView input, ::optimization_guide::mojom::ModelSubscriptionOptionsPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_OPTIMIZATION_GUIDE_PUBLIC_MOJOM_MODEL_BROKER_MOJOM_H_