// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{addWebUiListener}from"chrome://resources/js/cr.js";import{$}from"chrome://resources/js/util.js";function onLoad(){const view=NetExportView.getInstance();view.initialize()}document.addEventListener("DOMContentLoaded",onLoad);const kIdStateDivUninitialized="state-uninitialized";const kIdStateDivInitial="state-initial";const kIdStateDivLogging="state-logging";const kIdStateDivStopped="state-stopped";const kIdStartLoggingButton="start-logging";const kIdStopLoggingButton="stop-logging";const kIdEmailLogButton="mobile-email";const kIdShowFileButton="show-file";const kIdCaptureModeLogging="capture-mode-logging";const kIdFilePathLogging="file-path-logging";const kIdCaptureModeStopped="capture-mode-stopped";const kIdFilePathStoppedLogging="file-path-stopped";const kIdStartOverButton="startover";const kIdPrivacyReadMoreLink="privacy-read-more-link";const kIdPrivacyReadMoreDiv="privacy-read-more";const kIdTooBigReadMoreLink="toobig-read-more-link";const kIdTooBigReadMoreDiv="toobig-read-more";const kIdLogMaxFileSizeInput="log-max-filesize";class NetExportView{constructor(){this.infoForLoggedFile_=null}initialize(){addWebUiListener("net-log-info-changed",(info=>this.onExportNetLogInfoChanged_(info)));chrome.send("enableNotifyUIWithState")}onStartLogging_(){const logMode=document.querySelector('input[name="log-mode"]:checked').value;let maxLogFileSizeBytes=-1;const fileSizeString=$(kIdLogMaxFileSizeInput).value;const numMegabytes=parseFloat(fileSizeString);if(!isNaN(numMegabytes)){maxLogFileSizeBytes=Math.round(numMegabytes*1024*1024)}chrome.send("startNetLog",[logMode,maxLogFileSizeBytes])}onStopLogging_(){chrome.send("stopNetLog")}onSendEmail_(){chrome.send("sendNetLog")}onShowFile_(){chrome.send("showFile")}onStartOver_(){this.infoForLoggedFile_=null;this.renderInitial_()}onExportNetLogInfoChanged_(info){switch(info.state){case"UNINITIALIZED":case"INITIALIZING":this.renderUninitialized_();break;case"NOT_LOGGING":if(this.infoForLoggedFile_){this.renderStoppedLogging_(this.infoForLoggedFile_)}else if(info.logExists){this.renderStoppedLogging_(info)}else{this.renderInitial_()}break;case"STARTING_LOG":this.renderInitial_();break;case"LOGGING":this.infoForLoggedFile_=info;this.renderLogging_(info);break;case"STOPPING_LOG":this.renderLogging_(info);break}}renderUninitialized_(){this.showStateDiv_(kIdStateDivUninitialized)}renderInitial_(){this.showStateDiv_(kIdStateDivInitial);$(kIdStartLoggingButton).onclick=this.onStartLogging_.bind(this)}renderLogging_(info){this.showStateDiv_(kIdStateDivLogging);this.setFavicon_('data:image/svg+xml,<svg version="1.1" '+'xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32">'+'<circle cx="16" cy="16" r="14" fill="red" stroke="black" /></svg>');$(kIdStopLoggingButton).onclick=this.onStopLogging_.bind(this);$(kIdCaptureModeLogging).textContent=this.getCaptureModeText_(info);$(kIdFilePathLogging).textContent=info.file}renderStoppedLogging_(info){this.setFavicon_("data:image/x-icon;base64,");this.showStateDiv_(kIdStateDivStopped);if($(kIdEmailLogButton)){$(kIdEmailLogButton).onclick=this.onSendEmail_.bind(this)}if($(kIdShowFileButton)){$(kIdShowFileButton).onclick=this.onShowFile_.bind(this)}$(kIdStartOverButton).onclick=this.onStartOver_.bind(this);$(kIdFilePathStoppedLogging).textContent=info.file;$(kIdCaptureModeStopped).textContent=this.getCaptureModeText_(info);$(kIdPrivacyReadMoreLink).onclick=this.showPrivacyReadMore_.bind(this,true);this.showPrivacyReadMore_(false);$(kIdTooBigReadMoreLink).onclick=this.showTooBigReadMore_.bind(this,true);this.showTooBigReadMore_(false)}getCaptureModeText_(info){if(!info.logCaptureModeKnown){return"Unknown"}const radioButton=document.querySelector('input[name="log-mode"][value="'+info.captureMode+'"]');if(!radioButton){return"Unknown"}return radioButton.parentElement.textContent}showPrivacyReadMore_(show){$(kIdPrivacyReadMoreDiv).hidden=!show;$(kIdPrivacyReadMoreLink).hidden=show}showTooBigReadMore_(show){$(kIdTooBigReadMoreDiv).hidden=!show;$(kIdTooBigReadMoreLink).hidden=show}showStateDiv_(divId){const kAllDivIds=[kIdStateDivUninitialized,kIdStateDivInitial,kIdStateDivLogging,kIdStateDivStopped];for(const curDivId of kAllDivIds){$(curDivId).hidden=divId!==curDivId}}setFavicon_(dataUrl){document.getElementById("fav-icon").href=dataUrl}static getInstance(){return instance||(instance=new NetExportView)}}let instance=null;