// components/media_router/common/mojom/media_status.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/media_router/common/mojom/media_status.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/media_router/common/mojom/media_status.mojom-params-data.h"
#include "components/media_router/common/mojom/media_status.mojom-shared-message-ids.h"

#include "components/media_router/common/mojom/media_status.mojom-import-headers.h"
#include "components/media_router/common/mojom/media_status.mojom-test-utils.h"


namespace media_router::mojom {
MediaImage::MediaImage()
    : url(),
      size() {}

MediaImage::MediaImage(
    const ::GURL& url_in,
    const std::optional<::gfx::Size>& size_in)
    : url(std::move(url_in)),
      size(std::move(size_in)) {}

MediaImage::~MediaImage() = default;

void MediaImage::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Size>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MediaImage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MediaStatus::MediaStatus()
    : title(),
      secondary_title(),
      can_play_pause(),
      can_mute(),
      can_set_volume(),
      can_seek(),
      can_skip_to_next_track(),
      can_skip_to_previous_track(),
      play_state(),
      is_muted(),
      volume(),
      duration(),
      current_time(),
      images() {}

MediaStatus::MediaStatus(
    const std::string& title_in,
    const std::string& secondary_title_in,
    bool can_play_pause_in,
    bool can_mute_in,
    bool can_set_volume_in,
    bool can_seek_in,
    bool can_skip_to_next_track_in,
    bool can_skip_to_previous_track_in,
    MediaStatus::PlayState play_state_in,
    bool is_muted_in,
    float volume_in,
    ::base::TimeDelta duration_in,
    ::base::TimeDelta current_time_in,
    std::vector<MediaImagePtr> images_in)
    : title(std::move(title_in)),
      secondary_title(std::move(secondary_title_in)),
      can_play_pause(std::move(can_play_pause_in)),
      can_mute(std::move(can_mute_in)),
      can_set_volume(std::move(can_set_volume_in)),
      can_seek(std::move(can_seek_in)),
      can_skip_to_next_track(std::move(can_skip_to_next_track_in)),
      can_skip_to_previous_track(std::move(can_skip_to_previous_track_in)),
      play_state(std::move(play_state_in)),
      is_muted(std::move(is_muted_in)),
      volume(std::move(volume_in)),
      duration(std::move(duration_in)),
      current_time(std::move(current_time_in)),
      images(std::move(images_in)) {}

MediaStatus::~MediaStatus() = default;

void MediaStatus::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "secondary_title"), this->secondary_title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_play_pause"), this->can_play_pause,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_mute"), this->can_mute,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_set_volume"), this->can_set_volume,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_seek"), this->can_seek,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_skip_to_next_track"), this->can_skip_to_next_track,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_skip_to_previous_track"), this->can_skip_to_previous_track,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "play_state"), this->play_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type MediaStatus::PlayState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_muted"), this->is_muted,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "volume"), this->volume,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duration"), this->duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "current_time"), this->current_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "images"), this->images,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<MediaImagePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MediaStatus::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

MediaStatusObserver::IPCStableHashFunction MediaStatusObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaStatusObserver>(message.name())) {
    case messages::MediaStatusObserver::kOnMediaStatusUpdated: {
      return &MediaStatusObserver::OnMediaStatusUpdated_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaStatusObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaStatusObserver>(message.name())) {
      case messages::MediaStatusObserver::kOnMediaStatusUpdated:
            return "Receive media_router::mojom::MediaStatusObserver::OnMediaStatusUpdated";
    }
  } else {
    switch (static_cast<messages::MediaStatusObserver>(message.name())) {
      case messages::MediaStatusObserver::kOnMediaStatusUpdated:
            return "Receive reply media_router::mojom::MediaStatusObserver::OnMediaStatusUpdated";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaStatusObserver::OnMediaStatusUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6f8cb443;  // IPCStableHash for media_router::mojom::MediaStatusObserver::OnMediaStatusUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MediaStatusObserverProxy::MediaStatusObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaStatusObserverProxy::OnMediaStatusUpdated(
    MediaStatusPtr in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::MediaStatusObserver::OnMediaStatusUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type MediaStatusPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStatusObserver::kOnMediaStatusUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaStatusObserver_OnMediaStatusUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  
  mojo::internal::Serialize<::media_router::mojom::MediaStatusDataView>(
    in_status,
    status_fragment);

  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->status.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null status in MediaStatusObserver.OnMediaStatusUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStatusObserver::Name_);
  message.set_method_name("OnMediaStatusUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MediaStatusObserverStubDispatch::Accept(
    MediaStatusObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaStatusObserver>(message->header()->name)) {
    case messages::MediaStatusObserver::kOnMediaStatusUpdated: {
      DCHECK(message->is_serialized());
      internal::MediaStatusObserver_OnMediaStatusUpdated_Params_Data* params =
          reinterpret_cast<internal::MediaStatusObserver_OnMediaStatusUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaStatusObserver.0
      bool success = true;
      MediaStatusPtr p_status{};
      MediaStatusObserver_OnMediaStatusUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStatusObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMediaStatusUpdated(        
        std::move(p_status));
      return true;
    }
  }
  return false;
}

// static
bool MediaStatusObserverStubDispatch::AcceptWithResponder(
    MediaStatusObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaStatusObserver>(message->header()->name)) {
    case messages::MediaStatusObserver::kOnMediaStatusUpdated: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMediaStatusObserverValidationInfo[] = {
    { &internal::MediaStatusObserver_OnMediaStatusUpdated_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaStatusObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media_router::mojom::MediaStatusObserver::Name_,
    kMediaStatusObserverValidationInfo);
}



}  // media_router::mojom


namespace mojo {


// static
bool StructTraits<::media_router::mojom::MediaImage::DataView, ::media_router::mojom::MediaImagePtr>::Read(
    ::media_router::mojom::MediaImage::DataView input,
    ::media_router::mojom::MediaImagePtr* output) {
  bool success = true;
  ::media_router::mojom::MediaImagePtr result(::media_router::mojom::MediaImage::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadSize(&result->size))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media_router::mojom::MediaStatus::DataView, ::media_router::mojom::MediaStatusPtr>::Read(
    ::media_router::mojom::MediaStatus::DataView input,
    ::media_router::mojom::MediaStatusPtr* output) {
  bool success = true;
  ::media_router::mojom::MediaStatusPtr result(::media_router::mojom::MediaStatus::New());
  
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadSecondaryTitle(&result->secondary_title))
        success = false;
      if (success)
        result->can_play_pause = input.can_play_pause();
      if (success)
        result->can_mute = input.can_mute();
      if (success)
        result->can_set_volume = input.can_set_volume();
      if (success)
        result->can_seek = input.can_seek();
      if (success)
        result->can_skip_to_next_track = input.can_skip_to_next_track();
      if (success)
        result->can_skip_to_previous_track = input.can_skip_to_previous_track();
      if (success && !input.ReadPlayState(&result->play_state))
        success = false;
      if (success)
        result->is_muted = input.is_muted();
      if (success)
        result->volume = input.volume();
      if (success && !input.ReadDuration(&result->duration))
        success = false;
      if (success && !input.ReadCurrentTime(&result->current_time))
        success = false;
      if (success && !input.ReadImages(&result->images))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media_router::mojom {


void MediaStatusObserverInterceptorForTesting::OnMediaStatusUpdated(MediaStatusPtr status) {
  GetForwardingInterface()->OnMediaStatusUpdated(
    std::move(status)
    );
}
MediaStatusObserverAsyncWaiter::MediaStatusObserverAsyncWaiter(
    MediaStatusObserver* proxy) : proxy_(proxy) {}

MediaStatusObserverAsyncWaiter::~MediaStatusObserverAsyncWaiter() = default;







}  // media_router::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif