// components/media_router/common/mojom/media_status.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_STATUS_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_STATUS_MOJOM_SEND_VALIDATION_H_

#include "components/media_router/common/mojom/media_status.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "components/media_router/common/mojom/media_status.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media_router::mojom::MediaImageDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_router::mojom::MediaImageDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_router::mojom::internal::MediaImage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in MediaImage struct");

      decltype(Traits::size(input)) in_size = Traits::size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->size)::BaseType> size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_size,
        size_fragment);

      fragment->size.Set(
          size_fragment.is_null() ? nullptr : size_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media_router::mojom::MediaStatusDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_router::mojom::MediaStatusDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_router::mojom::internal::MediaStatus_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in MediaStatus struct");

      decltype(Traits::secondary_title(input)) in_secondary_title = Traits::secondary_title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->secondary_title)::BaseType> secondary_title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_secondary_title,
        secondary_title_fragment);

      fragment->secondary_title.Set(
          secondary_title_fragment.is_null() ? nullptr : secondary_title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->secondary_title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null secondary_title in MediaStatus struct");

      fragment->can_play_pause = Traits::can_play_pause(input);

      fragment->can_mute = Traits::can_mute(input);

      fragment->can_set_volume = Traits::can_set_volume(input);

      fragment->can_seek = Traits::can_seek(input);

      fragment->can_skip_to_next_track = Traits::can_skip_to_next_track(input);

      fragment->can_skip_to_previous_track = Traits::can_skip_to_previous_track(input);

      
      mojo::internal::Serialize<::media_router::mojom::MediaStatus_PlayState>(
        Traits::play_state(input),
        &fragment->play_state);

      fragment->is_muted = Traits::is_muted(input);

      fragment->volume = Traits::volume(input);

      decltype(Traits::duration(input)) in_duration = Traits::duration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->duration)::BaseType> duration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_duration,
        duration_fragment);

      fragment->duration.Set(
          duration_fragment.is_null() ? nullptr : duration_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->duration.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null duration in MediaStatus struct");

      decltype(Traits::current_time(input)) in_current_time = Traits::current_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->current_time)::BaseType> current_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_current_time,
        current_time_fragment);

      fragment->current_time.Set(
          current_time_fragment.is_null() ? nullptr : current_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->current_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null current_time in MediaStatus struct");

      decltype(Traits::images(input)) in_images = Traits::images(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->images)::BaseType>
          images_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& images_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media_router::mojom::MediaImageDataView>, send_validation>(
        in_images,
        images_fragment,
        &images_validate_params);

      fragment->images.Set(
          images_fragment.is_null() ? nullptr : images_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->images.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null images in MediaStatus struct");
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_STATUS_MOJOM_SEND_VALIDATION_H_