// components/media_router/common/mojom/media_router.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_ROUTER_MOJOM_DATA_VIEW_H_
#define COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_ROUTER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/media_router/common/mojom/media_router.mojom-shared-internal.h"
#include "components/media_router/common/mojom/logger.mojom-shared.h"
#include "components/media_router/common/mojom/debugger.mojom-shared.h"
#include "components/media_router/common/mojom/media_controller.mojom-shared.h"
#include "components/media_router/common/mojom/media_route_provider_id.mojom-shared.h"
#include "components/media_router/common/mojom/media_status.mojom-shared.h"
#include "components/media_router/common/mojom/route_request_result_code.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "third_party/blink/public/mojom/presentation/presentation.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace media_router::mojom {
class MediaSinkDataView;

class DialMediaSinkDataView;

class CastMediaSinkDataView;

class MediaRouteDataView;

class IssueDataView;

class RouteMessageDataView;

class RoutePresentationConnectionDataView;

class CastSessionStateDataView;

class CastProviderStateDataView;

class MediaSinkExtraDataDataView;
class ProviderStateDataView;


}  // media_router::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media_router::mojom::MediaSinkDataView> {
  using Data = ::media_router::mojom::internal::MediaSink_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media_router::mojom::DialMediaSinkDataView> {
  using Data = ::media_router::mojom::internal::DialMediaSink_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media_router::mojom::CastMediaSinkDataView> {
  using Data = ::media_router::mojom::internal::CastMediaSink_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media_router::mojom::MediaRouteDataView> {
  using Data = ::media_router::mojom::internal::MediaRoute_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media_router::mojom::IssueDataView> {
  using Data = ::media_router::mojom::internal::Issue_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media_router::mojom::RouteMessageDataView> {
  using Data = ::media_router::mojom::internal::RouteMessage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media_router::mojom::RoutePresentationConnectionDataView> {
  using Data = ::media_router::mojom::internal::RoutePresentationConnection_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media_router::mojom::CastSessionStateDataView> {
  using Data = ::media_router::mojom::internal::CastSessionState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media_router::mojom::CastProviderStateDataView> {
  using Data = ::media_router::mojom::internal::CastProviderState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media_router::mojom::MediaSinkExtraDataDataView> {
  using Data = ::media_router::mojom::internal::MediaSinkExtraData_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::media_router::mojom::ProviderStateDataView> {
  using Data = ::media_router::mojom::internal::ProviderState_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace media_router::mojom {


enum class SinkIconType : int32_t {
  
  CAST = 0,
  
  CAST_AUDIO_GROUP = 1,
  
  CAST_AUDIO = 2,
  
  WIRED_DISPLAY = 6,
  
  GENERIC = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

 std::ostream& operator<<(std::ostream& os, SinkIconType value);
inline bool IsKnownEnumValue(SinkIconType value) {
  return internal::SinkIconType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class RouteControllerType : int32_t {
  
  kNone = 0,
  
  kGeneric = 1,
  
  kMirroring = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, RouteControllerType value);
inline bool IsKnownEnumValue(RouteControllerType value) {
  return internal::RouteControllerType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Issue_Severity : int32_t {
  
  WARNING = 0,
  
  NOTIFICATION = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, Issue_Severity value);
inline bool IsKnownEnumValue(Issue_Severity value) {
  return internal::Issue_Severity_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class RouteMessage_Type : int32_t {
  
  TEXT = 0,
  
  BINARY = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, RouteMessage_Type value);
inline bool IsKnownEnumValue(RouteMessage_Type value) {
  return internal::RouteMessage_Type_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class MediaRouteProviderInterfaceBase {};

using MediaRouteProviderPtrDataView =
    mojo::InterfacePtrDataView<MediaRouteProviderInterfaceBase>;
using MediaRouteProviderRequestDataView =
    mojo::InterfaceRequestDataView<MediaRouteProviderInterfaceBase>;
using MediaRouteProviderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MediaRouteProviderInterfaceBase>;
using MediaRouteProviderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MediaRouteProviderInterfaceBase>;
class MediaRouterInterfaceBase {};

using MediaRouterPtrDataView =
    mojo::InterfacePtrDataView<MediaRouterInterfaceBase>;
using MediaRouterRequestDataView =
    mojo::InterfaceRequestDataView<MediaRouterInterfaceBase>;
using MediaRouterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MediaRouterInterfaceBase>;
using MediaRouterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MediaRouterInterfaceBase>;


class MediaSinkDataView {
 public:
  MediaSinkDataView() = default;

  MediaSinkDataView(
      internal::MediaSink_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSinkIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSinkId(UserType* output) {
    
    auto* pointer = data_->sink_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadIconType(UserType* output) const {
    auto data_value = data_->icon_type;
    return mojo::internal::Deserialize<::media_router::mojom::SinkIconType>(
        data_value, output);
  }
  SinkIconType icon_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_router::mojom::SinkIconType>(data_->icon_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadProviderId(UserType* output) const {
    auto data_value = data_->provider_id;
    return mojo::internal::Deserialize<::media_router::mojom::MediaRouteProviderId>(
        data_value, output);
  }
  ::media_router::mojom::MediaRouteProviderId provider_id() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_router::mojom::MediaRouteProviderId>(data_->provider_id));
  }
  inline void GetExtraDataDataView(
      MediaSinkExtraDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtraData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media_router::mojom::MediaSinkExtraDataDataView, UserType>(),
    "Attempting to read the optional `extra_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadExtraData` instead "
    "of `ReadExtraData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->extra_data.is_null() ? &data_->extra_data : nullptr;
    return mojo::internal::Deserialize<::media_router::mojom::MediaSinkExtraDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaSink_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DialMediaSinkDataView {
 public:
  DialMediaSinkDataView() = default;

  DialMediaSinkDataView(
      internal::DialMediaSink_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIpAddressDataView(
      ::network::mojom::IPAddressDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIpAddress(UserType* output) {
    
    auto* pointer = data_->ip_address.Get();
    return mojo::internal::Deserialize<::network::mojom::IPAddressDataView>(
        pointer, output, message_);
  }
  inline void GetModelNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModelName(UserType* output) {
    
    auto* pointer = data_->model_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAppUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAppUrl(UserType* output) {
    
    auto* pointer = data_->app_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::DialMediaSink_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CastMediaSinkDataView {
 public:
  CastMediaSinkDataView() = default;

  CastMediaSinkDataView(
      internal::CastMediaSink_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIpEndpointDataView(
      ::network::mojom::IPEndPointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIpEndpoint(UserType* output) {
    
    auto* pointer = data_->ip_endpoint.Get();
    return mojo::internal::Deserialize<::network::mojom::IPEndPointDataView>(
        pointer, output, message_);
  }
  inline void GetModelNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModelName(UserType* output) {
    
    auto* pointer = data_->model_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint64_t capabilities() const {
    return data_->capabilities;
  }
  int32_t cast_channel_id() const {
    return data_->cast_channel_id;
  }
 private:
  internal::CastMediaSink_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaRouteDataView {
 public:
  MediaRouteDataView() = default;

  MediaRouteDataView(
      internal::MediaRoute_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMediaRouteIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMediaRouteId(UserType* output) {
    
    auto* pointer = data_->media_route_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPresentationIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPresentationId(UserType* output) {
    
    auto* pointer = data_->presentation_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetMediaSourceDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMediaSource(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `media_source` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMediaSource` instead "
    "of `ReadMediaSource if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->media_source.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetMediaSinkIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMediaSinkId(UserType* output) {
    
    auto* pointer = data_->media_sink_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetMediaSinkNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMediaSinkName(UserType* output) {
    
    auto* pointer = data_->media_sink_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDescriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_local() const {
    return data_->is_local;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadControllerType(UserType* output) const {
    auto data_value = data_->controller_type;
    return mojo::internal::Deserialize<::media_router::mojom::RouteControllerType>(
        data_value, output);
  }
  RouteControllerType controller_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_router::mojom::RouteControllerType>(data_->controller_type));
  }
  bool is_local_presentation() const {
    return data_->is_local_presentation;
  }
  bool is_connecting() const {
    return data_->is_connecting;
  }
 private:
  internal::MediaRoute_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IssueDataView {
 public:
  IssueDataView() = default;

  IssueDataView(
      internal::Issue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRouteIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRouteId(UserType* output) {
    
    auto* pointer = data_->route_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSinkIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSinkId(UserType* output) {
    
    auto* pointer = data_->sink_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSeverity(UserType* output) const {
    auto data_value = data_->severity;
    return mojo::internal::Deserialize<::media_router::mojom::Issue_Severity>(
        data_value, output);
  }
  Issue_Severity severity() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_router::mojom::Issue_Severity>(data_->severity));
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `message` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMessage` instead "
    "of `ReadMessage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Issue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RouteMessageDataView {
 public:
  RouteMessageDataView() = default;

  RouteMessageDataView(
      internal::RouteMessage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::media_router::mojom::RouteMessage_Type>(
        data_value, output);
  }
  RouteMessage_Type type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_router::mojom::RouteMessage_Type>(data_->type));
  }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `message` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMessage` instead "
    "of `ReadMessage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadData` instead "
    "of `ReadData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::RouteMessage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RoutePresentationConnectionDataView {
 public:
  RoutePresentationConnectionDataView() = default;

  RoutePresentationConnectionDataView(
      internal::RoutePresentationConnection_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeConnectionRemote() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::PresentationConnectionInterfaceBase>>(
            &data_->connection_remote, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeConnectionReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::blink::mojom::PresentationConnectionInterfaceBase>>(
            &data_->connection_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::RoutePresentationConnection_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CastSessionStateDataView {
 public:
  CastSessionStateDataView() = default;

  CastSessionStateDataView(
      internal::CastSessionState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSinkIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSinkId(UserType* output) {
    
    auto* pointer = data_->sink_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAppIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAppId(UserType* output) {
    
    auto* pointer = data_->app_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSessionIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionId(UserType* output) {
    
    auto* pointer = data_->session_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRouteDescriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRouteDescription(UserType* output) {
    
    auto* pointer = data_->route_description.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::CastSessionState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CastProviderStateDataView {
 public:
  CastProviderStateDataView() = default;

  CastProviderStateDataView(
      internal::CastProviderState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSessionStateDataView(
      mojo::ArrayDataView<CastSessionStateDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionState(UserType* output) {
    
    auto* pointer = data_->session_state.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media_router::mojom::CastSessionStateDataView>>(
        pointer, output, message_);
  }
 private:
  internal::CastProviderState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaSinkExtraDataDataView {
 public:
  using Tag = internal::MediaSinkExtraData_Data::MediaSinkExtraData_Tag;

  MediaSinkExtraDataDataView() = default;

  MediaSinkExtraDataDataView(
      internal::MediaSinkExtraData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_dial_media_sink() const { return data_->tag == Tag::kDialMediaSink; }
  inline void GetDialMediaSinkDataView(
      DialMediaSinkDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadDialMediaSink(UserType* output) const {
    
    CHECK(is_dial_media_sink());
    return mojo::internal::Deserialize<::media_router::mojom::DialMediaSinkDataView>(
        data_->data.f_dial_media_sink.Get(), output, message_);
  }
  bool is_cast_media_sink() const { return data_->tag == Tag::kCastMediaSink; }
  inline void GetCastMediaSinkDataView(
      CastMediaSinkDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCastMediaSink(UserType* output) const {
    
    CHECK(is_cast_media_sink());
    return mojo::internal::Deserialize<::media_router::mojom::CastMediaSinkDataView>(
        data_->data.f_cast_media_sink.Get(), output, message_);
  }

 private:
  internal::MediaSinkExtraData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class ProviderStateDataView {
 public:
  using Tag = internal::ProviderState_Data::ProviderState_Tag;

  ProviderStateDataView() = default;

  ProviderStateDataView(
      internal::ProviderState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_cast_provider_state() const { return data_->tag == Tag::kCastProviderState; }
  inline void GetCastProviderStateDataView(
      CastProviderStateDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCastProviderState(UserType* output) const {
    
    CHECK(is_cast_provider_state());
    return mojo::internal::Deserialize<::media_router::mojom::CastProviderStateDataView>(
        data_->data.f_cast_provider_state.Get(), output, message_);
  }

 private:
  internal::ProviderState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // media_router::mojom

#endif  // COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_ROUTER_MOJOM_DATA_VIEW_H_