// components/lens/lens_metadata.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/lens/lens_metadata.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/lens/lens_metadata.mojom-params-data.h"
#include "components/lens/lens_metadata.mojom-shared-message-ids.h"

#include "components/lens/lens_metadata.mojom-import-headers.h"
#include "components/lens/lens_metadata.mojom-test-utils.h"


namespace lens::mojom {
LatencyLog::LatencyLog()
    : phase(),
      original_size(),
      downscaled_size(),
      image_format(),
      time(),
      encoded_bytes_size() {}

LatencyLog::LatencyLog(
    Phase phase_in,
    const ::gfx::Size& original_size_in,
    const ::gfx::Size& downscaled_size_in,
    ImageFormat image_format_in,
    ::base::Time time_in,
    uint32_t encoded_bytes_size_in)
    : phase(std::move(phase_in)),
      original_size(std::move(original_size_in)),
      downscaled_size(std::move(downscaled_size_in)),
      image_format(std::move(image_format_in)),
      time(std::move(time_in)),
      encoded_bytes_size(std::move(encoded_bytes_size_in)) {}

LatencyLog::~LatencyLog() = default;

void LatencyLog::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "phase"), this->phase,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type Phase>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "original_size"), this->original_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "downscaled_size"), this->downscaled_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_format"), this->image_format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ImageFormat>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "time"), this->time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encoded_bytes_size"), this->encoded_bytes_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LatencyLog::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // lens::mojom


namespace mojo {


// static
bool StructTraits<::lens::mojom::LatencyLog::DataView, ::lens::mojom::LatencyLogPtr>::Read(
    ::lens::mojom::LatencyLog::DataView input,
    ::lens::mojom::LatencyLogPtr* output) {
  bool success = true;
  ::lens::mojom::LatencyLogPtr result(::lens::mojom::LatencyLog::New());
  
      if (success && !input.ReadPhase(&result->phase))
        success = false;
      if (success && !input.ReadOriginalSize(&result->original_size))
        success = false;
      if (success && !input.ReadDownscaledSize(&result->downscaled_size))
        success = false;
      if (success && !input.ReadImageFormat(&result->image_format))
        success = false;
      if (success && !input.ReadTime(&result->time))
        success = false;
      if (success)
        result->encoded_bytes_size = input.encoded_bytes_size();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace lens::mojom {




}  // lens::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif