// components/lens/lens_metadata.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_LENS_LENS_METADATA_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_LENS_LENS_METADATA_MOJOM_SEND_VALIDATION_H_

#include "components/lens/lens_metadata.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"

#include "components/lens/lens_metadata.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::lens::mojom::ImageFormat, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::lens::mojom::Phase, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::lens::mojom::LatencyLogDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::LatencyLogDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::LatencyLog_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::lens::mojom::Phase>(
        Traits::phase(input),
        &fragment->phase);

      decltype(Traits::original_size(input)) in_original_size = Traits::original_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->original_size)::BaseType> original_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_original_size,
        original_size_fragment);

      fragment->original_size.Set(
          original_size_fragment.is_null() ? nullptr : original_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->original_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null original_size in LatencyLog struct");

      decltype(Traits::downscaled_size(input)) in_downscaled_size = Traits::downscaled_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->downscaled_size)::BaseType> downscaled_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_downscaled_size,
        downscaled_size_fragment);

      fragment->downscaled_size.Set(
          downscaled_size_fragment.is_null() ? nullptr : downscaled_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->downscaled_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null downscaled_size in LatencyLog struct");

      
      mojo::internal::Serialize<::lens::mojom::ImageFormat>(
        Traits::image_format(input),
        &fragment->image_format);

      decltype(Traits::time(input)) in_time = Traits::time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->time)::BaseType> time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_time,
        time_fragment);

      fragment->time.Set(
          time_fragment.is_null() ? nullptr : time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null time in LatencyLog struct");

      fragment->encoded_bytes_size = Traits::encoded_bytes_size(input);
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_LENS_LENS_METADATA_MOJOM_SEND_VALIDATION_H_